/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.utils.queryextensions;

import com.querydsl.core.annotations.QueryDelegate;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.NumberPath;
import java.math.BigDecimal;
import java.util.Date;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.utils.queryextensions.CustomOperator;
import org.cyclos.model.EntityModel;
import org.cyclos.server.utils.FieldHelper;

public class AccountQueryExtensions {
    @QueryDelegate(value=Account.class)
    public static NumberExpression<BigDecimal> balance(EntityPath<Account> entityPath) {
        NumberPath numberPath = (NumberPath)FieldHelper.get(entityPath, (String)EntityModel.ID.getName());
        return Expressions.numberOperation(BigDecimal.class, (Operator)CustomOperator.ACCOUNT_BALANCE1, (Expression[])new Expression[]{numberPath});
    }

    @QueryDelegate(value=Account.class)
    public static NumberExpression<BigDecimal> balance(EntityPath<Account> entityPath, Expression<Date> expression) {
        NumberPath numberPath = (NumberPath)FieldHelper.get(entityPath, (String)EntityModel.ID.getName());
        return Expressions.numberOperation(BigDecimal.class, (Operator)CustomOperator.ACCOUNT_BALANCE2, (Expression[])new Expression[]{numberPath, expression});
    }

    @QueryDelegate(value=Account.class)
    public static NumberExpression<BigDecimal> balanceSum(EntityPath<Account> entityPath, Expression<BigDecimal> expression, Expression<String> expression2, Expression<Boolean> expression3, Expression<BigDecimal> expression4) {
        NumberPath numberPath = (NumberPath)FieldHelper.get(entityPath, (String)EntityModel.ID.getName());
        return Expressions.numberOperation(BigDecimal.class, (Operator)CustomOperator.BALANCE_SUM, (Expression[])new Expression[]{numberPath, expression, expression2, expression3, expression4});
    }
}

