/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.utils;

import java.util.function.BiFunction;
import org.cyclos.entities.access.AccessClient;
import org.cyclos.entities.access.BuiltinPrincipalTypeResolver;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.access.Token;
import org.cyclos.entities.access.TrustedDevice;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserCustomFieldValue;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.model.access.principaltypes.ExistingBuiltInPrincipalType;

public class UserPrincipals {
    public static BiFunction<User, UserAccountType, UserAccount> accountLoader;

    public static UserAccount account(User user, UserAccountType userAccountType) {
        if (accountLoader == null) {
            throw new IllegalStateException("accountLoader not initialized");
        }
        return accountLoader.apply(user, userAccountType);
    }

    public static UserPrincipal email(BasicUser basicUser) {
        String string = basicUser.getEmail();
        return string == null ? null : new SimpleUserPrincipal(basicUser, BuiltinPrincipalTypeResolver.resolve(ExistingBuiltInPrincipalType.EMAIL), string);
    }

    public static void inializeAccountLoader(BiFunction<User, UserAccountType, UserAccount> biFunction) {
        accountLoader = biFunction;
    }

    public static UserPrincipal username(BasicUser basicUser) {
        String string = basicUser.getUsername();
        return string == null ? null : new SimpleUserPrincipal(basicUser, BuiltinPrincipalTypeResolver.resolve(ExistingBuiltInPrincipalType.USERNAME), string);
    }

    protected static class SimpleUserPrincipal
    implements UserPrincipal {
        private BasicUser basicUser;
        private PrincipalType principalType;
        private String principal;

        public SimpleUserPrincipal(BasicUser basicUser, PrincipalType principalType, String string) {
            this.basicUser = basicUser;
            this.principalType = principalType;
            this.principal = string;
        }

        protected SimpleUserPrincipal() {
        }

        @Override
        public AccessClient getAccessClient() {
            return null;
        }

        @Override
        public UserAccountType getAccountType() {
            return null;
        }

        @Override
        public BasicUser getBasicUser() {
            return this.basicUser;
        }

        @Override
        public UserCustomFieldValue getCustomFieldValue() {
            return null;
        }

        @Override
        public MobilePhone getMobilePhone() {
            return null;
        }

        @Override
        public String getPrincipal() {
            return this.principal;
        }

        @Override
        public PrincipalType getPrincipalType() {
            return this.principalType;
        }

        @Override
        public Token getToken() {
            return null;
        }

        @Override
        public TrustedDevice getTrustedDevice() {
            return null;
        }

        protected void setBasicUser(BasicUser basicUser) {
            this.basicUser = basicUser;
        }

        protected void setPrincipal(String string) {
            this.principal = string;
        }

        protected void setPrincipalType(PrincipalType principalType) {
            this.principalType = principalType;
        }
    }
}

