/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.users;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.access.CustomFieldPrincipalType;
import org.cyclos.entities.system.ConfigurationGuestProfileField;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.DefinesNetwork;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.ChangeFieldValueBulkAction;
import org.cyclos.entities.users.ProductMyProfileField;
import org.cyclos.entities.users.ProductOperatorProfileField;
import org.cyclos.entities.users.ProductUserProfileField;
import org.cyclos.entities.users.UserCustomFieldPossibleValue;
import org.cyclos.entities.users.UserCustomFieldPossibleValueCategory;
import org.cyclos.entities.users.UserCustomFieldValue;
import org.cyclos.entities.users.UserSection;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.cyclos.model.system.fields.CustomFieldNature;
import org.cyclos.model.system.scripts.CustomScriptUsedInType;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.utils.FieldVisibility;
import org.cyclos.utils.CollectionHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Cacheable(value=true)
@Table(name="user_custom_fields")
public class UserCustomField
extends CustomField<UserCustomField, UserCustomFieldPossibleValueCategory, UserCustomFieldPossibleValue>
implements DefinesNetwork,
ProfileField,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="network_id", nullable=false)
    private Network network;
    @OneToMany(mappedBy="field", cascade={CascadeType.REMOVE})
    @OrderBy(value="order")
    private List<UserCustomFieldPossibleValueCategory> possibleValueCategories;
    @OneToMany(mappedBy="field", cascade={CascadeType.REMOVE})
    @OrderBy(value="category.order, order")
    private List<UserCustomFieldPossibleValue> possibleValues;
    @Basic
    @Column(name="purge_values")
    private Boolean purgeValues;
    @Basic
    @Column(name="include_in_export")
    private Boolean includeInExport = true;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="default_visibility", nullable=false)
    private FieldVisibility defaultVisibility = FieldVisibility.VISIBLE;
    @Basic
    @Column(name="oidc_claim")
    private String oidcClaim;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="section_id")
    private UserSection section;
    @OneToMany(mappedBy="field", cascade={CascadeType.REMOVE})
    private Set<UserCustomFieldValue> values;
    @OneToMany(mappedBy="customField", cascade={CascadeType.REMOVE})
    private Set<ChangeFieldValueBulkAction> changeFieldValueBulkActions;
    @OneToMany(mappedBy="customField", cascade={CascadeType.REMOVE})
    private Set<ProductOperatorProfileField> productsOperatorCustomFields;
    @OneToMany(mappedBy="customField", cascade={CascadeType.REMOVE})
    private Set<CustomFieldPrincipalType> principalTypes;
    @OneToMany(mappedBy="customField", cascade={CascadeType.REMOVE})
    private Set<ProductMyProfileField> productsMyCustomField;
    @OneToMany(mappedBy="customField", cascade={CascadeType.REMOVE})
    private Set<ProductUserProfileField> productsUserCustomField;
    @OneToMany(mappedBy="customField", cascade={CascadeType.ALL})
    private Set<ConfigurationGuestProfileField> configurations = new HashSet<ConfigurationGuestProfileField>();
    static final long serialVersionUID = 4302773484256395649L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_section_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_network_vh;

    @Override
    public int compareTo(NamedEntity namedEntity) {
        if (namedEntity instanceof UserCustomField) {
            UserCustomField userCustomField = (UserCustomField)namedEntity;
            if (this.getSection() == null && userCustomField.getSection() != null) {
                return -1;
            }
            if (this.getSection() != null && userCustomField.getSection() == null) {
                return 1;
            }
            if (!Objects.equals(this.getSection(), userCustomField.getSection())) {
                return this.getSection().compareTo(userCustomField.getSection());
            }
        }
        return super.compareTo(namedEntity);
    }

    @Override
    public DataTranslationType getDataTranslationType() {
        return DataTranslationType.PROFILE_FIELDS;
    }

    public FieldVisibility getDefaultVisibility() {
        return this._persistence_get_defaultVisibility();
    }

    @Override
    public CustomFieldNature getNature() {
        return CustomFieldNature.USER;
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_network();
    }

    public String getOidcClaim() {
        return this._persistence_get_oidcClaim();
    }

    @Override
    public List<UserCustomFieldPossibleValueCategory> getPossibleValueCategories() {
        return this._persistence_get_possibleValueCategories();
    }

    @Override
    public Class<UserCustomFieldPossibleValueCategory> getPossibleValueCategoryClass() {
        return UserCustomFieldPossibleValueCategory.class;
    }

    @Override
    public Class<UserCustomFieldPossibleValue> getPossibleValueClass() {
        return UserCustomFieldPossibleValue.class;
    }

    @Override
    public List<UserCustomFieldPossibleValue> getPossibleValues() {
        return this._persistence_get_possibleValues();
    }

    public CustomFieldPrincipalType getPrincipalType() {
        return (CustomFieldPrincipalType)CollectionHelper.first((Iterable)this._persistence_get_principalTypes());
    }

    public CustomScriptUsedInType getScriptUsedInType() {
        return CustomScriptUsedInType.USER_FIELD;
    }

    public UserSection getSection() {
        return this._persistence_get_section();
    }

    public boolean isIncludeInExport() {
        return Boolean.TRUE.equals(this._persistence_get_includeInExport());
    }

    public boolean isPurgeValues() {
        return Boolean.TRUE.equals(this._persistence_get_purgeValues());
    }

    public void setDefaultVisibility(FieldVisibility fieldVisibility) {
        this._persistence_set_defaultVisibility(fieldVisibility);
    }

    public void setIncludeInExport(boolean bl) {
        this._persistence_set_includeInExport(bl);
    }

    @Override
    public void setNetwork(Network network) {
        this._persistence_set_network(network);
    }

    public void setOidcClaim(String string) {
        this._persistence_set_oidcClaim(string);
    }

    public void setPurgeValues(boolean bl) {
        this._persistence_set_purgeValues(bl);
    }

    public void setSection(UserSection userSection) {
        this._persistence_set_section(userSection);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_section_vh != null) {
            this._persistence_section_vh = (WeavedAttributeValueHolderInterface)this._persistence_section_vh.clone();
        }
        if (this._persistence_loadValuesScript_vh != null) {
            this._persistence_loadValuesScript_vh = (WeavedAttributeValueHolderInterface)this._persistence_loadValuesScript_vh.clone();
        }
        if (this._persistence_validationScript_vh != null) {
            this._persistence_validationScript_vh = (WeavedAttributeValueHolderInterface)this._persistence_validationScript_vh.clone();
        }
        if (this._persistence_network_vh != null) {
            this._persistence_network_vh = (WeavedAttributeValueHolderInterface)this._persistence_network_vh.clone();
        }
        if (this._persistence_linkedEntityRecordType_vh != null) {
            this._persistence_linkedEntityRecordType_vh = (WeavedAttributeValueHolderInterface)this._persistence_linkedEntityRecordType_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new UserCustomField();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "productsOperatorCustomFields") {
            return this.productsOperatorCustomFields;
        }
        if (string == "configurations") {
            return this.configurations;
        }
        if (string == "section") {
            return this.section;
        }
        if (string == "possibleValues") {
            return this.possibleValues;
        }
        if (string == "oidcClaim") {
            return this.oidcClaim;
        }
        if (string == "possibleValueCategories") {
            return this.possibleValueCategories;
        }
        if (string == "principalTypes") {
            return this.principalTypes;
        }
        if (string == "values") {
            return this.values;
        }
        if (string == "includeInExport") {
            return this.includeInExport;
        }
        if (string == "network") {
            return this.network;
        }
        if (string == "productsUserCustomField") {
            return this.productsUserCustomField;
        }
        if (string == "productsMyCustomField") {
            return this.productsMyCustomField;
        }
        if (string == "defaultVisibility") {
            return this.defaultVisibility;
        }
        if (string == "changeFieldValueBulkActions") {
            return this.changeFieldValueBulkActions;
        }
        if (string == "purgeValues") {
            return this.purgeValues;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "productsOperatorCustomFields") {
            this.productsOperatorCustomFields = (Set)object;
            return;
        }
        if (string == "configurations") {
            this.configurations = (Set)object;
            return;
        }
        if (string == "section") {
            this.section = (UserSection)object;
            return;
        }
        if (string == "possibleValues") {
            this.possibleValues = (List)object;
            return;
        }
        if (string == "oidcClaim") {
            this.oidcClaim = (String)object;
            return;
        }
        if (string == "possibleValueCategories") {
            this.possibleValueCategories = (List)object;
            return;
        }
        if (string == "principalTypes") {
            this.principalTypes = (Set)object;
            return;
        }
        if (string == "values") {
            this.values = (Set)object;
            return;
        }
        if (string == "includeInExport") {
            this.includeInExport = (Boolean)object;
            return;
        }
        if (string == "network") {
            this.network = (Network)object;
            return;
        }
        if (string == "productsUserCustomField") {
            this.productsUserCustomField = (Set)object;
            return;
        }
        if (string == "productsMyCustomField") {
            this.productsMyCustomField = (Set)object;
            return;
        }
        if (string == "defaultVisibility") {
            this.defaultVisibility = (FieldVisibility)object;
            return;
        }
        if (string == "changeFieldValueBulkActions") {
            this.changeFieldValueBulkActions = (Set)object;
            return;
        }
        if (string == "purgeValues") {
            this.purgeValues = (Boolean)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Set _persistence_get_productsOperatorCustomFields() {
        this._persistence_checkFetched("productsOperatorCustomFields");
        return this.productsOperatorCustomFields;
    }

    public void _persistence_set_productsOperatorCustomFields(Set set) {
        this._persistence_checkFetchedForSet("productsOperatorCustomFields");
        this._persistence_propertyChange("productsOperatorCustomFields", this.productsOperatorCustomFields, set);
        this.productsOperatorCustomFields = set;
    }

    public Set _persistence_get_configurations() {
        this._persistence_checkFetched("configurations");
        return this.configurations;
    }

    public void _persistence_set_configurations(Set set) {
        this._persistence_checkFetchedForSet("configurations");
        this._persistence_propertyChange("configurations", this.configurations, set);
        this.configurations = set;
    }

    protected void _persistence_initialize_section_vh() {
        if (this._persistence_section_vh == null) {
            this._persistence_section_vh = new ValueHolder((Object)this.section);
            this._persistence_section_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_section_vh() {
        UserSection userSection;
        this._persistence_initialize_section_vh();
        if ((this._persistence_section_vh.isCoordinatedWithProperty() || this._persistence_section_vh.isNewlyWeavedValueHolder()) && (userSection = this._persistence_get_section()) != this._persistence_section_vh.getValue()) {
            this._persistence_set_section(userSection);
        }
        return this._persistence_section_vh;
    }

    public void _persistence_set_section_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_section_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            UserSection userSection = this._persistence_get_section();
            if (userSection != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_section((UserSection)object);
            }
        } else {
            this.section = null;
        }
    }

    public UserSection _persistence_get_section() {
        this._persistence_checkFetched("section");
        this._persistence_initialize_section_vh();
        this.section = (UserSection)this._persistence_section_vh.getValue();
        return this.section;
    }

    public void _persistence_set_section(UserSection userSection) {
        this._persistence_checkFetchedForSet("section");
        this._persistence_initialize_section_vh();
        this.section = (UserSection)this._persistence_section_vh.getValue();
        this._persistence_propertyChange("section", this.section, userSection);
        this.section = userSection;
        this._persistence_section_vh.setValue((Object)userSection);
    }

    public List _persistence_get_possibleValues() {
        this._persistence_checkFetched("possibleValues");
        return this.possibleValues;
    }

    public void _persistence_set_possibleValues(List list) {
        this._persistence_checkFetchedForSet("possibleValues");
        this._persistence_propertyChange("possibleValues", this.possibleValues, list);
        this.possibleValues = list;
    }

    public String _persistence_get_oidcClaim() {
        this._persistence_checkFetched("oidcClaim");
        return this.oidcClaim;
    }

    public void _persistence_set_oidcClaim(String string) {
        this._persistence_checkFetchedForSet("oidcClaim");
        this._persistence_propertyChange("oidcClaim", this.oidcClaim, string);
        this.oidcClaim = string;
    }

    public List _persistence_get_possibleValueCategories() {
        this._persistence_checkFetched("possibleValueCategories");
        return this.possibleValueCategories;
    }

    public void _persistence_set_possibleValueCategories(List list) {
        this._persistence_checkFetchedForSet("possibleValueCategories");
        this._persistence_propertyChange("possibleValueCategories", this.possibleValueCategories, list);
        this.possibleValueCategories = list;
    }

    public Set _persistence_get_principalTypes() {
        this._persistence_checkFetched("principalTypes");
        return this.principalTypes;
    }

    public void _persistence_set_principalTypes(Set set) {
        this._persistence_checkFetchedForSet("principalTypes");
        this._persistence_propertyChange("principalTypes", this.principalTypes, set);
        this.principalTypes = set;
    }

    public Set _persistence_get_values() {
        this._persistence_checkFetched("values");
        return this.values;
    }

    public void _persistence_set_values(Set set) {
        this._persistence_checkFetchedForSet("values");
        this._persistence_propertyChange("values", this.values, set);
        this.values = set;
    }

    public Boolean _persistence_get_includeInExport() {
        this._persistence_checkFetched("includeInExport");
        return this.includeInExport;
    }

    public void _persistence_set_includeInExport(Boolean bl) {
        this._persistence_checkFetchedForSet("includeInExport");
        this._persistence_propertyChange("includeInExport", this.includeInExport, bl);
        this.includeInExport = bl;
    }

    protected void _persistence_initialize_network_vh() {
        if (this._persistence_network_vh == null) {
            this._persistence_network_vh = new ValueHolder((Object)this.network);
            this._persistence_network_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_network_vh() {
        Network network;
        this._persistence_initialize_network_vh();
        if ((this._persistence_network_vh.isCoordinatedWithProperty() || this._persistence_network_vh.isNewlyWeavedValueHolder()) && (network = this._persistence_get_network()) != this._persistence_network_vh.getValue()) {
            this._persistence_set_network(network);
        }
        return this._persistence_network_vh;
    }

    public void _persistence_set_network_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_network_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Network network = this._persistence_get_network();
            if (network != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_network((Network)object);
            }
        } else {
            this.network = null;
        }
    }

    public Network _persistence_get_network() {
        this._persistence_checkFetched("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        return this.network;
    }

    public void _persistence_set_network(Network network) {
        this._persistence_checkFetchedForSet("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        this._persistence_propertyChange("network", this.network, network);
        this.network = network;
        this._persistence_network_vh.setValue((Object)network);
    }

    public Set _persistence_get_productsUserCustomField() {
        this._persistence_checkFetched("productsUserCustomField");
        return this.productsUserCustomField;
    }

    public void _persistence_set_productsUserCustomField(Set set) {
        this._persistence_checkFetchedForSet("productsUserCustomField");
        this._persistence_propertyChange("productsUserCustomField", this.productsUserCustomField, set);
        this.productsUserCustomField = set;
    }

    public Set _persistence_get_productsMyCustomField() {
        this._persistence_checkFetched("productsMyCustomField");
        return this.productsMyCustomField;
    }

    public void _persistence_set_productsMyCustomField(Set set) {
        this._persistence_checkFetchedForSet("productsMyCustomField");
        this._persistence_propertyChange("productsMyCustomField", this.productsMyCustomField, set);
        this.productsMyCustomField = set;
    }

    public FieldVisibility _persistence_get_defaultVisibility() {
        this._persistence_checkFetched("defaultVisibility");
        return this.defaultVisibility;
    }

    public void _persistence_set_defaultVisibility(FieldVisibility fieldVisibility) {
        this._persistence_checkFetchedForSet("defaultVisibility");
        this._persistence_propertyChange("defaultVisibility", this.defaultVisibility, fieldVisibility);
        this.defaultVisibility = fieldVisibility;
    }

    public Set _persistence_get_changeFieldValueBulkActions() {
        this._persistence_checkFetched("changeFieldValueBulkActions");
        return this.changeFieldValueBulkActions;
    }

    public void _persistence_set_changeFieldValueBulkActions(Set set) {
        this._persistence_checkFetchedForSet("changeFieldValueBulkActions");
        this._persistence_propertyChange("changeFieldValueBulkActions", this.changeFieldValueBulkActions, set);
        this.changeFieldValueBulkActions = set;
    }

    public Boolean _persistence_get_purgeValues() {
        this._persistence_checkFetched("purgeValues");
        return this.purgeValues;
    }

    public void _persistence_set_purgeValues(Boolean bl) {
        this._persistence_checkFetchedForSet("purgeValues");
        this._persistence_propertyChange("purgeValues", this.purgeValues, bl);
        this.purgeValues = bl;
    }
}

