/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.users;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.OwnerEntity;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.AddressContactInfo;
import org.cyclos.entities.users.ContactInfo;
import org.cyclos.entities.users.GeoLocatedAddress;
import org.cyclos.entities.users.User;
import org.cyclos.model.users.addresses.AddressNature;
import org.cyclos.utils.CollectionHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@DiscriminatorValue(value="USER")
public class UserAddress
extends GeoLocatedAddress
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @OwnerEntity
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id", updatable=false)
    @ReadOnlyFromDTO(onInsert=false)
    private User user;
    @Basic
    @Column(name="default_address")
    private Boolean defaultAddress;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="last_modified")
    private Date lastModified;
    @Basic
    @Column(name="hidden")
    private Boolean hidden;
    @ManyToMany(mappedBy="addresses")
    private Set<BasicAd> ads;
    @OneToMany(mappedBy="address")
    private Set<ContactInfo> contactInfos = new HashSet<ContactInfo>();
    @OneToMany(mappedBy="address", cascade={CascadeType.ALL})
    private Set<AddressContactInfo> contactInfo;
    static final long serialVersionUID = -2076109728215432467L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_user_vh;

    public boolean addContactInfo(ContactInfo contactInfo) {
        return this._persistence_get_contactInfos().add(contactInfo);
    }

    public AddressContactInfo getContactInfo() {
        return (AddressContactInfo)CollectionHelper.first((Iterable)this._persistence_get_contactInfo());
    }

    public Set<ContactInfo> getContactInfos() {
        return this._persistence_get_contactInfos();
    }

    public Date getLastModified() {
        return this._persistence_get_lastModified();
    }

    @Override
    public AddressNature getNature() {
        return AddressNature.USER;
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_user().getNetwork();
    }

    public User getUser() {
        return this._persistence_get_user();
    }

    public boolean isDefaultAddress() {
        return Boolean.TRUE.equals(this._persistence_get_defaultAddress());
    }

    public boolean isHidden() {
        return Boolean.TRUE.equals(this._persistence_get_hidden());
    }

    public void removeContactInfo(ContactInfo contactInfo) {
        this._persistence_get_contactInfos().remove(contactInfo);
    }

    public void setContactInfo(AddressContactInfo addressContactInfo) {
        this._persistence_set_contactInfo(CollectionHelper.asSet((Object[])new AddressContactInfo[]{addressContactInfo}));
    }

    public void setDefaultAddress(boolean bl) {
        this._persistence_set_defaultAddress(bl);
    }

    public void setHidden(boolean bl) {
        this._persistence_set_hidden(bl);
    }

    public void setLastModified(Date date) {
        this._persistence_set_lastModified(date);
    }

    public void setUser(User user) {
        this._persistence_set_user(user);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_user_vh != null) {
            this._persistence_user_vh = (WeavedAttributeValueHolderInterface)this._persistence_user_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new UserAddress();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "ads") {
            return this.ads;
        }
        if (string == "hidden") {
            return this.hidden;
        }
        if (string == "contactInfo") {
            return this.contactInfo;
        }
        if (string == "contactInfos") {
            return this.contactInfos;
        }
        if (string == "lastModified") {
            return this.lastModified;
        }
        if (string == "user") {
            return this.user;
        }
        if (string == "defaultAddress") {
            return this.defaultAddress;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "ads") {
            this.ads = (Set)object;
            return;
        }
        if (string == "hidden") {
            this.hidden = (Boolean)object;
            return;
        }
        if (string == "contactInfo") {
            this.contactInfo = (Set)object;
            return;
        }
        if (string == "contactInfos") {
            this.contactInfos = (Set)object;
            return;
        }
        if (string == "lastModified") {
            this.lastModified = (Date)object;
            return;
        }
        if (string == "user") {
            this.user = (User)object;
            return;
        }
        if (string == "defaultAddress") {
            this.defaultAddress = (Boolean)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Set _persistence_get_ads() {
        this._persistence_checkFetched("ads");
        return this.ads;
    }

    public void _persistence_set_ads(Set set) {
        this._persistence_checkFetchedForSet("ads");
        this._persistence_propertyChange("ads", this.ads, set);
        this.ads = set;
    }

    public Boolean _persistence_get_hidden() {
        this._persistence_checkFetched("hidden");
        return this.hidden;
    }

    public void _persistence_set_hidden(Boolean bl) {
        this._persistence_checkFetchedForSet("hidden");
        this._persistence_propertyChange("hidden", this.hidden, bl);
        this.hidden = bl;
    }

    public Set _persistence_get_contactInfo() {
        this._persistence_checkFetched("contactInfo");
        return this.contactInfo;
    }

    public void _persistence_set_contactInfo(Set set) {
        this._persistence_checkFetchedForSet("contactInfo");
        this._persistence_propertyChange("contactInfo", this.contactInfo, set);
        this.contactInfo = set;
    }

    public Set _persistence_get_contactInfos() {
        this._persistence_checkFetched("contactInfos");
        return this.contactInfos;
    }

    public void _persistence_set_contactInfos(Set set) {
        this._persistence_checkFetchedForSet("contactInfos");
        this._persistence_propertyChange("contactInfos", this.contactInfos, set);
        this.contactInfos = set;
    }

    public Date _persistence_get_lastModified() {
        this._persistence_checkFetched("lastModified");
        return this.lastModified;
    }

    public void _persistence_set_lastModified(Date date) {
        this._persistence_checkFetchedForSet("lastModified");
        this._persistence_propertyChange("lastModified", this.lastModified, date);
        this.lastModified = date;
    }

    protected void _persistence_initialize_user_vh() {
        if (this._persistence_user_vh == null) {
            this._persistence_user_vh = new ValueHolder((Object)this.user);
            this._persistence_user_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_user_vh() {
        User user;
        this._persistence_initialize_user_vh();
        if ((this._persistence_user_vh.isCoordinatedWithProperty() || this._persistence_user_vh.isNewlyWeavedValueHolder()) && (user = this._persistence_get_user()) != this._persistence_user_vh.getValue()) {
            this._persistence_set_user(user);
        }
        return this._persistence_user_vh;
    }

    public void _persistence_set_user_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_user_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            User user = this._persistence_get_user();
            if (user != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_user((User)object);
            }
        } else {
            this.user = null;
        }
    }

    public User _persistence_get_user() {
        this._persistence_checkFetched("user");
        this._persistence_initialize_user_vh();
        this.user = (User)this._persistence_user_vh.getValue();
        return this.user;
    }

    public void _persistence_set_user(User user) {
        this._persistence_checkFetchedForSet("user");
        this._persistence_initialize_user_vh();
        this.user = (User)this._persistence_user_vh.getValue();
        this._persistence_propertyChange("user", this.user, user);
        this.user = user;
        this._persistence_user_vh.setValue((Object)user);
    }

    public Boolean _persistence_get_defaultAddress() {
        this._persistence_checkFetched("defaultAddress");
        return this.defaultAddress;
    }

    public void _persistence_set_defaultAddress(Boolean bl) {
        this._persistence_checkFetchedForSet("defaultAddress");
        this._persistence_propertyChange("defaultAddress", this.defaultAddress, bl);
        this.defaultAddress = bl;
    }
}

