/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.users;

import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.OwnerEntity;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.OperatorGroup;
import org.cyclos.entities.users.OperatorGroupLog;
import org.cyclos.entities.users.User;
import org.cyclos.model.access.Role;
import org.cyclos.model.users.users.UserNature;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@DiscriminatorValue(value="OPERATOR")
public class Operator
extends BasicUser
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @OwnerEntity
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="operator_user_id")
    @ReadOnlyFromDTO(onInsert=false)
    private User user;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="operator_group_id")
    private OperatorGroup group;
    @OneToMany(mappedBy="operator", cascade={CascadeType.REMOVE})
    private Set<OperatorGroupLog> groupLogs;
    static final long serialVersionUID = -8484258425212449756L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_user_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_group_vh;

    public Operator() {
    }

    public Operator(User user) {
        this.user = user;
        if (user != null) {
            this.setNetwork(user.getNetwork());
        }
    }

    public OperatorGroup getGroup() {
        return this._persistence_get_group();
    }

    @Override
    public Role getMainRole() {
        return Role.OPERATOR;
    }

    @Override
    public UserNature getNature() {
        return UserNature.OPERATOR;
    }

    @Override
    public User getUser() {
        return this._persistence_get_user();
    }

    @Override
    public boolean isAliasOperator() {
        return this._persistence_get_group() == null;
    }

    @Override
    public boolean isBroker() {
        if (this._persistence_get_group() == null) {
            return this._persistence_get_user().isBroker();
        }
        return this._persistence_get_user().isBroker() && this._persistence_get_group().isBrokering();
    }

    @Override
    public boolean isMember() {
        return true;
    }

    @Override
    public boolean isOperator() {
        return true;
    }

    public boolean isRestricted() {
        return this.getGroup() != null;
    }

    @Override
    public boolean isRestrictedOperator() {
        return this._persistence_get_group() != null;
    }

    public void setGroup(OperatorGroup operatorGroup) {
        this._persistence_set_group(operatorGroup);
    }

    public void setUser(User user) {
        this._persistence_set_user(user);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_user_vh != null) {
            this._persistence_user_vh = (WeavedAttributeValueHolderInterface)this._persistence_user_vh.clone();
        }
        if (this._persistence_group_vh != null) {
            this._persistence_group_vh = (WeavedAttributeValueHolderInterface)this._persistence_group_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Operator();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "groupLogs") {
            return this.groupLogs;
        }
        if (string == "user") {
            return this.user;
        }
        if (string == "group") {
            return this.group;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "groupLogs") {
            this.groupLogs = (Set)object;
            return;
        }
        if (string == "user") {
            this.user = (User)object;
            return;
        }
        if (string == "group") {
            this.group = (OperatorGroup)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Set _persistence_get_groupLogs() {
        this._persistence_checkFetched("groupLogs");
        return this.groupLogs;
    }

    public void _persistence_set_groupLogs(Set set) {
        this._persistence_checkFetchedForSet("groupLogs");
        this._persistence_propertyChange("groupLogs", this.groupLogs, set);
        this.groupLogs = set;
    }

    protected void _persistence_initialize_user_vh() {
        if (this._persistence_user_vh == null) {
            this._persistence_user_vh = new ValueHolder((Object)this.user);
            this._persistence_user_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_user_vh() {
        User user;
        this._persistence_initialize_user_vh();
        if ((this._persistence_user_vh.isCoordinatedWithProperty() || this._persistence_user_vh.isNewlyWeavedValueHolder()) && (user = this._persistence_get_user()) != this._persistence_user_vh.getValue()) {
            this._persistence_set_user(user);
        }
        return this._persistence_user_vh;
    }

    public void _persistence_set_user_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_user_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            User user = this._persistence_get_user();
            if (user != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_user((User)object);
            }
        } else {
            this.user = null;
        }
    }

    public User _persistence_get_user() {
        this._persistence_checkFetched("user");
        this._persistence_initialize_user_vh();
        this.user = (User)this._persistence_user_vh.getValue();
        return this.user;
    }

    public void _persistence_set_user(User user) {
        this._persistence_checkFetchedForSet("user");
        this._persistence_initialize_user_vh();
        this.user = (User)this._persistence_user_vh.getValue();
        this._persistence_propertyChange("user", this.user, user);
        this.user = user;
        this._persistence_user_vh.setValue((Object)user);
    }

    protected void _persistence_initialize_group_vh() {
        if (this._persistence_group_vh == null) {
            this._persistence_group_vh = new ValueHolder((Object)this.group);
            this._persistence_group_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_group_vh() {
        OperatorGroup operatorGroup;
        this._persistence_initialize_group_vh();
        if ((this._persistence_group_vh.isCoordinatedWithProperty() || this._persistence_group_vh.isNewlyWeavedValueHolder()) && (operatorGroup = this._persistence_get_group()) != this._persistence_group_vh.getValue()) {
            this._persistence_set_group(operatorGroup);
        }
        return this._persistence_group_vh;
    }

    public void _persistence_set_group_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_group_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            OperatorGroup operatorGroup = this._persistence_get_group();
            if (operatorGroup != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_group((OperatorGroup)object);
            }
        } else {
            this.group = null;
        }
    }

    public OperatorGroup _persistence_get_group() {
        this._persistence_checkFetched("group");
        this._persistence_initialize_group_vh();
        this.group = (OperatorGroup)this._persistence_group_vh.getValue();
        return this.group;
    }

    public void _persistence_set_group(OperatorGroup operatorGroup) {
        this._persistence_checkFetchedForSet("group");
        this._persistence_initialize_group_vh();
        this.group = (OperatorGroup)this._persistence_group_vh.getValue();
        this._persistence_propertyChange("group", this.group, operatorGroup);
        this.group = operatorGroup;
        this._persistence_group_vh.setValue((Object)operatorGroup);
    }
}

