/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.users;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.CurrencyScale;
import org.cyclos.entities.access.TokenPrincipalType;
import org.cyclos.entities.banking.AccountFee;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.GeneratedTransferType;
import org.cyclos.entities.banking.HasCurrency;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.TransferFilter;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.messaging.MessageCategory;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.ContactInfoField;
import org.cyclos.entities.users.IMemberOrBrokerProduct;
import org.cyclos.entities.users.MemberProductCustomOperation;
import org.cyclos.entities.users.MemberProductCustomWizard;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.ProductMemberVoucher;
import org.cyclos.entities.users.ProductMyAdField;
import org.cyclos.entities.users.ProductMyTokenType;
import org.cyclos.entities.users.ProductOperatorProfileField;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.entities.users.UserProductNotification;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.model.banking.transfertypes.TransferTypeDirection;
import org.cyclos.model.users.products.AccountAccessibility;
import org.cyclos.model.users.products.AccountProfileVisibility;
import org.cyclos.model.users.products.AccountVisibility;
import org.cyclos.model.users.products.BrokerVisibility;
import org.cyclos.model.users.products.MyMessagesForwardOperation;
import org.cyclos.model.users.products.ProductNature;
import org.cyclos.model.users.products.UserGroupAccessibility;
import org.cyclos.model.users.products.UserProfileActivity;
import org.cyclos.model.users.users.GroupFilterDefault;
import org.cyclos.model.users.users.GroupVisibility;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@DiscriminatorValue(value="MEMBER")
public class MemberProduct
extends Product
implements HasCurrency,
IMemberOrBrokerProduct,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="member_account_accessibility")
    private AccountAccessibility accountAccessibility;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="member_account_visibility")
    private AccountVisibility accountVisibility;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="member_show_account_in_profile")
    private AccountProfileVisibility showAccountInProfile;
    @Basic
    @Column(name="member_ads_require_authorization")
    private Boolean adsRequireAuthorization;
    @Basic
    @Column(name="member_web_shop_ads_require_authorization")
    private Boolean webShopAdsRequireAuthorization;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="search_users_on_groups")
    private UserGroupAccessibility searchUsersOnGroups = UserGroupAccessibility.NONE;
    @ManyToMany
    @JoinTable(name="products_groups_user_search", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="group_id")})
    private Set<BasicGroup> groupsForUserSearch = new HashSet<BasicGroup>();
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="view_profile_on_groups")
    private UserGroupAccessibility viewProfileOnGroups = UserGroupAccessibility.NONE;
    @ManyToMany
    @JoinTable(name="products_groups_view_profile", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="group_id")})
    private Set<BasicGroup> groupsForViewProfile = new HashSet<BasicGroup>();
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="group_filter_default")
    private GroupFilterDefault groupFilterDefault;
    @ManyToMany
    @JoinTable(name="products_default_filter_groups", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="group_id")})
    private Set<BasicGroup> defaultFilterGroups = new HashSet<BasicGroup>();
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="group_visibility")
    private GroupVisibility groupVisibility;
    @OneToMany(mappedBy="product", cascade={CascadeType.ALL})
    private Set<ProductMyTokenType> myTokenTypes = new HashSet<ProductMyTokenType>();
    @OneToMany(mappedBy="product", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<ProductMyAdField> myAdFields = new HashSet<ProductMyAdField>();
    @ManyToMany
    @JoinTable(name="products_activate_user_token_types", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="token_type_id")})
    private Set<TokenPrincipalType> activateUserTokenTypes = new HashSet<TokenPrincipalType>();
    @OneToMany(mappedBy="product", cascade={CascadeType.ALL})
    private Set<ProductMemberVoucher> vouchers = new HashSet<ProductMemberVoucher>();
    @Basic
    @Column(name="show_brokers")
    @Enumerated(value=EnumType.STRING)
    private BrokerVisibility showBrokers;
    @ElementCollection
    @CollectionTable(name="show_activities_in_profile", joinColumns={@JoinColumn(name="product_id")})
    @Column(name="field")
    @Enumerated(value=EnumType.STRING)
    private Set<UserProfileActivity> showActivitiesInProfile;
    @Basic
    @Column(name="member_initial_credit")
    @CurrencyScale
    private BigDecimal initialCredit;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="member_initial_credit_type_id")
    private GeneratedTransferType initialCreditType;
    @Basic
    @Column(name="member_default_credit_limit")
    @CurrencyScale
    private BigDecimal defaultCreditLimit;
    @Basic
    @Column(name="member_individual_credit_limit")
    @CurrencyScale
    private BigDecimal individualCreditLimit;
    @Basic
    @Column(name="member_default_upper_limit")
    @CurrencyScale
    private BigDecimal defaultUpperCreditLimit;
    @Basic
    @Column(name="default_payment_amount_limit")
    @CurrencyScale
    private BigDecimal defaultPaymentAmountLimit;
    @Basic
    @Column(name="default_payment_amount_per_day_limit")
    @CurrencyScale
    private BigDecimal defaultPaymentAmountPerDayLimit;
    @Basic
    @Column(name="default_payment_amount_per_week_limit")
    @CurrencyScale
    private BigDecimal defaultPaymentAmountPerWeekLimit;
    @Basic
    @Column(name="default_payment_amount_per_month_limit")
    @CurrencyScale
    private BigDecimal defaultPaymentAmountPerMonthLimit;
    @Basic
    @Column(name="default_payment_amount_per_year_limit")
    @CurrencyScale
    private BigDecimal defaultPaymentAmountPerYearLimit;
    @ManyToMany
    @JoinTable(name="products_user_external_payment_types", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="payment_type_id")})
    private Set<PaymentTransferType> myExternalPaymentTypes = new HashSet<PaymentTransferType>();
    @ManyToMany
    @JoinTable(name="products_user_payment_types", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="payment_type_id")})
    private Set<PaymentTransferType> myPaymentTypes = new HashSet<PaymentTransferType>();
    @ManyToMany
    @JoinTable(name="products_user_request_payment_types", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="payment_type_id")})
    private Set<PaymentTransferType> myPaymentRequestTypes = new HashSet<PaymentTransferType>();
    @ManyToMany
    @JoinTable(name="products_user_create_ticket_payment_types", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="payment_type_id")})
    private Set<PaymentTransferType> myCreateTicketPaymentTypes = new HashSet<PaymentTransferType>();
    @ManyToMany
    @JoinTable(name="products_user_approve_ticket_payment_types", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="payment_type_id")})
    private Set<PaymentTransferType> myApproveTicketPaymentTypes = new HashSet<PaymentTransferType>();
    @ManyToMany
    @JoinTable(name="products_user_receive_request_types", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="payment_type_id")})
    private Set<PaymentTransferType> receivePaymentRequestTypes = new HashSet<PaymentTransferType>();
    @ManyToMany
    @JoinTable(name="products_user_make_pos_types", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="payment_type_id")})
    private Set<PaymentTransferType> makePosPaymentTypes = new HashSet<PaymentTransferType>();
    @ManyToMany
    @JoinTable(name="products_user_receive_pos_types", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="payment_type_id")})
    private Set<PaymentTransferType> receivePosPaymentTypes = new HashSet<PaymentTransferType>();
    @ManyToMany
    @JoinTable(name="products_user_chargeback_payment_types", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="payment_type_id")})
    private Set<TransferType> chargebackPaymentTypes = new HashSet<TransferType>();
    @ManyToMany
    @JoinTable(name="products_account_fees", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="account_fee_id")})
    private Set<AccountFee> accountFees = new HashSet<AccountFee>();
    @ManyToMany
    @JoinTable(name="products_my_transfer_filters", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="transfer_filter_id")})
    private Set<TransferFilter> myTransferFilters = new HashSet<TransferFilter>();
    @OneToMany(mappedBy="product", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<ProductOperatorProfileField> operatorProfileFields = new HashSet<ProductOperatorProfileField>();
    @Basic
    @Column(name="member_max_ads")
    private Integer maxAds;
    @Basic
    @Column(name="member_max_categories_per_ad")
    private Integer maxCategoriesPerAd = 1;
    @Basic
    @Column(name="member_max_contact_infos")
    private Integer maxContactInfos;
    @ManyToMany
    @JoinTable(name="products_contact_info_fields", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="field_id")})
    private Set<ContactInfoField> contactInfoFields = new HashSet<ContactInfoField>();
    @Basic
    @Column(name="member_max_addresses_per_ad")
    private Integer maxAddressesPerAd;
    @Basic
    @Column(name="member_max_operators")
    private Integer maxOperators;
    @Basic
    @Column(name="member_max_ad_description_size")
    private Integer maxAdDescriptionSize;
    @Basic
    @Column(name="member_max_ad_images")
    private Integer maxAdImages;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="amount", column=@Column(name="member_default_ad_publication_amount")), @AttributeOverride(name="field", column=@Column(name="member_default_ad_publication_field"))})
    private TimeInterval defaultAdPublicationTime;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="amount", column=@Column(name="member_max_ad_publication_amount")), @AttributeOverride(name="field", column=@Column(name="member_max_ad_publication_field"))})
    private TimeInterval maxAdPublicationTime;
    @OneToMany(mappedBy="product", cascade={CascadeType.ALL})
    private Set<MemberProductCustomOperation> customOperations = new HashSet<MemberProductCustomOperation>();
    @OneToMany(mappedBy="product", cascade={CascadeType.ALL})
    private Set<MemberProductCustomWizard> wizards = new HashSet<MemberProductCustomWizard>();
    @OneToMany(mappedBy="product", cascade={CascadeType.ALL})
    private Set<UserProductNotification> notifications = new HashSet<UserProductNotification>();
    @ManyToMany
    @JoinTable(name="products_send_messages_to_admin", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="message_category_id")})
    private Set<MessageCategory> sendMessagesToAdmin = new HashSet<MessageCategory>();
    @Basic
    @Column(name="member_fwd_message_to_email")
    @Enumerated(value=EnumType.STRING)
    private MyMessagesForwardOperation fwdMessageToEmail;
    @Basic
    @Column(name="show_ad_publication_date")
    private Boolean showAdPublicationDate;
    @Basic
    @Column(name="show_ad_expiration_date")
    private Boolean showAdExpirationDate;
    @ManyToMany
    @JoinTable(name="products_registration_groups", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="group_id")})
    private Set<UserGroup> userRegistrationGroups = new HashSet<UserGroup>();
    @ManyToMany
    @JoinTable(name="products_view_ads_in_other_currencies", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="currency_id")})
    private Set<Currency> viewAdsInOtherCurrencies = new HashSet<Currency>();
    static final long serialVersionUID = 6856207414331803192L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_initialCreditType_vh;

    public AccountAccessibility getAccountAccessibility() {
        return this._persistence_get_accountAccessibility();
    }

    public Set<AccountFee> getAccountFees() {
        return this._persistence_get_accountFees();
    }

    public AccountVisibility getAccountVisibility() {
        return this._persistence_get_accountVisibility();
    }

    public Set<TokenPrincipalType> getActivateUserTokenTypes() {
        return this._persistence_get_activateUserTokenTypes();
    }

    public Set<TransferType> getChargebackPaymentTypes() {
        return this._persistence_get_chargebackPaymentTypes();
    }

    public Set<ContactInfoField> getContactInfoFields() {
        return this._persistence_get_contactInfoFields();
    }

    @Override
    public Currency getCurrency() {
        return this._persistence_get_userAccount() == null ? null : this._persistence_get_userAccount().getCurrency();
    }

    public Set<MemberProductCustomOperation> getCustomOperations() {
        return this._persistence_get_customOperations();
    }

    public TimeInterval getDefaultAdPublicationTime() {
        return this._persistence_get_defaultAdPublicationTime();
    }

    public BigDecimal getDefaultCreditLimit() {
        return this._persistence_get_defaultCreditLimit();
    }

    public Set<BasicGroup> getDefaultFilterGroups() {
        return this._persistence_get_defaultFilterGroups();
    }

    public BigDecimal getDefaultPaymentAmountLimit() {
        return this._persistence_get_defaultPaymentAmountLimit();
    }

    public BigDecimal getDefaultPaymentAmountPerDayLimit() {
        return this._persistence_get_defaultPaymentAmountPerDayLimit();
    }

    public BigDecimal getDefaultPaymentAmountPerMonthLimit() {
        return this._persistence_get_defaultPaymentAmountPerMonthLimit();
    }

    public BigDecimal getDefaultPaymentAmountPerWeekLimit() {
        return this._persistence_get_defaultPaymentAmountPerWeekLimit();
    }

    public BigDecimal getDefaultPaymentAmountPerYearLimit() {
        return this._persistence_get_defaultPaymentAmountPerYearLimit();
    }

    public BigDecimal getDefaultUpperCreditLimit() {
        return this._persistence_get_defaultUpperCreditLimit();
    }

    public MyMessagesForwardOperation getFwdMessageToEmail() {
        return this._persistence_get_fwdMessageToEmail();
    }

    public GroupFilterDefault getGroupFilterDefault() {
        return this._persistence_get_groupFilterDefault();
    }

    public Set<BasicGroup> getGroupsForUserSearch() {
        return this._persistence_get_groupsForUserSearch();
    }

    public Set<BasicGroup> getGroupsForViewProfile() {
        return this._persistence_get_groupsForViewProfile();
    }

    public GroupVisibility getGroupVisibility() {
        return this._persistence_get_groupVisibility();
    }

    public BigDecimal getIndividualCreditLimit() {
        return this._persistence_get_individualCreditLimit();
    }

    public BigDecimal getInitialCredit() {
        return this._persistence_get_initialCredit();
    }

    public GeneratedTransferType getInitialCreditType() {
        return this._persistence_get_initialCreditType();
    }

    public Set<PaymentTransferType> getMakePosPaymentTypes() {
        return this._persistence_get_makePosPaymentTypes();
    }

    public Integer getMaxAdDescriptionSize() {
        return this._persistence_get_maxAdDescriptionSize();
    }

    public Integer getMaxAddressesPerAd() {
        return this._persistence_get_maxAddressesPerAd();
    }

    public Integer getMaxAdImages() {
        return this._persistence_get_maxAdImages();
    }

    public TimeInterval getMaxAdPublicationTime() {
        return this._persistence_get_maxAdPublicationTime();
    }

    public Integer getMaxAds() {
        return this._persistence_get_maxAds();
    }

    public Integer getMaxCategoriesPerAd() {
        return this._persistence_get_maxCategoriesPerAd();
    }

    public Integer getMaxContactInfos() {
        return this._persistence_get_maxContactInfos();
    }

    @Override
    public Integer getMaxOperators() {
        return this._persistence_get_maxOperators();
    }

    public Set<ProductMyAdField> getMyAdFields() {
        return this._persistence_get_myAdFields();
    }

    public Set<PaymentTransferType> getMyApproveTicketPaymentTypes() {
        return this._persistence_get_myApproveTicketPaymentTypes();
    }

    public Set<PaymentTransferType> getMyCreateTicketPaymentTypes() {
        return this._persistence_get_myCreateTicketPaymentTypes();
    }

    public Set<PaymentTransferType> getMyExternalPaymentTypes() {
        return this._persistence_get_myExternalPaymentTypes();
    }

    public Set<PaymentTransferType> getMyPaymentRequestsSendToSystem() {
        return this.filterPaymentTypes(this._persistence_get_myPaymentRequestTypes(), TransferTypeDirection.SYSTEM_TO_USER);
    }

    public Set<PaymentTransferType> getMyPaymentRequestsSendToUser() {
        return this.filterPaymentTypes(this._persistence_get_myPaymentRequestTypes(), TransferTypeDirection.USER_TO_USER);
    }

    public Set<PaymentTransferType> getMyPaymentRequestTypes() {
        return this._persistence_get_myPaymentRequestTypes();
    }

    public Set<PaymentTransferType> getMyPaymentTypes() {
        return this._persistence_get_myPaymentTypes();
    }

    public Set<ProductMyTokenType> getMyTokenTypes() {
        return this._persistence_get_myTokenTypes();
    }

    public Set<TransferFilter> getMyTransferFilters() {
        return this._persistence_get_myTransferFilters();
    }

    @Override
    public ProductNature getNature() {
        return ProductNature.MEMBER;
    }

    @Override
    public Set<UserProductNotification> getNotifications() {
        return this._persistence_get_notifications();
    }

    @Override
    public Set<ProductOperatorProfileField> getOperatorProfileFields() {
        return this._persistence_get_operatorProfileFields();
    }

    public Set<PaymentTransferType> getReceivePaymentRequestTypes() {
        return this._persistence_get_receivePaymentRequestTypes();
    }

    public Set<PaymentTransferType> getReceivePosPaymentTypes() {
        return this._persistence_get_receivePosPaymentTypes();
    }

    public UserGroupAccessibility getSearchUsersOnGroups() {
        return this._persistence_get_searchUsersOnGroups();
    }

    public Set<PaymentTransferType> getSelfPayments() {
        return this.filterPaymentTypes(this._persistence_get_myPaymentTypes(), TransferTypeDirection.USER_TO_SELF);
    }

    public Set<MessageCategory> getSendMessagesToAdmin() {
        return this._persistence_get_sendMessagesToAdmin();
    }

    public AccountProfileVisibility getShowAccountInProfile() {
        return this._persistence_get_showAccountInProfile();
    }

    public Set<UserProfileActivity> getShowActivitiesInProfile() {
        return this._persistence_get_showActivitiesInProfile();
    }

    public BrokerVisibility getShowBrokers() {
        return this._persistence_get_showBrokers();
    }

    public Set<PaymentTransferType> getSystemPayments() {
        return this.filterPaymentTypes(this._persistence_get_myPaymentTypes(), TransferTypeDirection.USER_TO_SYSTEM);
    }

    public UserAccountType getUserAccount() {
        return this._persistence_get_userAccount();
    }

    public Set<PaymentTransferType> getUserPayments() {
        return this.filterPaymentTypes(this._persistence_get_myPaymentTypes(), TransferTypeDirection.USER_TO_USER);
    }

    public Set<UserGroup> getUserRegistrationGroups() {
        return this._persistence_get_userRegistrationGroups();
    }

    public Set<Currency> getViewAdsInOtherCurrencies() {
        return this._persistence_get_viewAdsInOtherCurrencies();
    }

    public UserGroupAccessibility getViewProfileOnGroups() {
        return this._persistence_get_viewProfileOnGroups();
    }

    public Set<ProductMemberVoucher> getVouchers() {
        return this._persistence_get_vouchers();
    }

    public Set<MemberProductCustomWizard> getWizards() {
        return this._persistence_get_wizards();
    }

    public boolean isAdsRequireAuthorization() {
        return this._persistence_get_adsRequireAuthorization() == null ? false : this._persistence_get_adsRequireAuthorization();
    }

    public boolean isShowAdExpirationDate() {
        return Boolean.TRUE.equals(this._persistence_get_showAdExpirationDate());
    }

    public boolean isShowAdPublicationDate() {
        return Boolean.TRUE.equals(this._persistence_get_showAdPublicationDate());
    }

    public boolean isWebShopAdsRequireAuthorization() {
        return this._persistence_get_webShopAdsRequireAuthorization() == null ? false : this._persistence_get_webShopAdsRequireAuthorization();
    }

    public void setAccountAccessibility(AccountAccessibility accountAccessibility) {
        this._persistence_set_accountAccessibility(accountAccessibility);
    }

    public void setAccountFees(Set<AccountFee> set) {
        this._persistence_set_accountFees(set);
    }

    public void setAccountVisibility(AccountVisibility accountVisibility) {
        this._persistence_set_accountVisibility(accountVisibility);
    }

    public void setActivateUserTokenTypes(Set<TokenPrincipalType> set) {
        this._persistence_set_activateUserTokenTypes(set);
    }

    public void setAdsRequireAuthorization(boolean bl) {
        this._persistence_set_adsRequireAuthorization(bl);
    }

    public void setChargebackPaymentTypes(Set<TransferType> set) {
        this._persistence_set_chargebackPaymentTypes(set);
    }

    public void setContactInfoFields(Set<ContactInfoField> set) {
        this._persistence_set_contactInfoFields(set);
    }

    public void setCustomOperations(Set<MemberProductCustomOperation> set) {
        this._persistence_set_customOperations(set);
    }

    public void setDefaultAdPublicationTime(TimeInterval timeInterval) {
        this._persistence_set_defaultAdPublicationTime(timeInterval);
    }

    public void setDefaultCreditLimit(BigDecimal bigDecimal) {
        this._persistence_set_defaultCreditLimit(bigDecimal);
    }

    public void setDefaultFilterGroups(Set<BasicGroup> set) {
        this._persistence_set_defaultFilterGroups(set);
    }

    public void setDefaultPaymentAmountLimit(BigDecimal bigDecimal) {
        this._persistence_set_defaultPaymentAmountLimit(bigDecimal);
    }

    public void setDefaultPaymentAmountPerDayLimit(BigDecimal bigDecimal) {
        this._persistence_set_defaultPaymentAmountPerDayLimit(bigDecimal);
    }

    public void setDefaultPaymentAmountPerMonthLimit(BigDecimal bigDecimal) {
        this._persistence_set_defaultPaymentAmountPerMonthLimit(bigDecimal);
    }

    public void setDefaultPaymentAmountPerWeekLimit(BigDecimal bigDecimal) {
        this._persistence_set_defaultPaymentAmountPerWeekLimit(bigDecimal);
    }

    public void setDefaultPaymentAmountPerYearLimit(BigDecimal bigDecimal) {
        this._persistence_set_defaultPaymentAmountPerYearLimit(bigDecimal);
    }

    public void setDefaultUpperCreditLimit(BigDecimal bigDecimal) {
        this._persistence_set_defaultUpperCreditLimit(bigDecimal);
    }

    public void setFwdMessageToEmail(MyMessagesForwardOperation myMessagesForwardOperation) {
        this._persistence_set_fwdMessageToEmail(myMessagesForwardOperation);
    }

    public void setGroupFilterDefault(GroupFilterDefault groupFilterDefault) {
        this._persistence_set_groupFilterDefault(groupFilterDefault);
    }

    public void setGroupsForUserSearch(Set<BasicGroup> set) {
        this._persistence_set_groupsForUserSearch(set);
    }

    public void setGroupsForViewProfile(Set<BasicGroup> set) {
        this._persistence_set_groupsForViewProfile(set);
    }

    public void setGroupVisibility(GroupVisibility groupVisibility) {
        this._persistence_set_groupVisibility(groupVisibility);
    }

    public void setIndividualCreditLimit(BigDecimal bigDecimal) {
        this._persistence_set_individualCreditLimit(bigDecimal);
    }

    public void setInitialCredit(BigDecimal bigDecimal) {
        this._persistence_set_initialCredit(bigDecimal);
    }

    public void setInitialCreditType(GeneratedTransferType generatedTransferType) {
        this._persistence_set_initialCreditType(generatedTransferType);
    }

    public void setMakePosPaymentTypes(Set<PaymentTransferType> set) {
        this._persistence_set_makePosPaymentTypes(set);
    }

    public void setMaxAdDescriptionSize(Integer n) {
        this._persistence_set_maxAdDescriptionSize(n);
    }

    public void setMaxAddressesPerAd(Integer n) {
        this._persistence_set_maxAddressesPerAd(n);
    }

    public void setMaxAdImages(Integer n) {
        this._persistence_set_maxAdImages(n);
    }

    public void setMaxAdPublicationTime(TimeInterval timeInterval) {
        this._persistence_set_maxAdPublicationTime(timeInterval);
    }

    public void setMaxAds(Integer n) {
        this._persistence_set_maxAds(n);
    }

    public void setMaxCategoriesPerAd(Integer n) {
        this._persistence_set_maxCategoriesPerAd(n);
    }

    public void setMaxContactInfos(Integer n) {
        this._persistence_set_maxContactInfos(n);
    }

    @Override
    public void setMaxOperators(Integer n) {
        this._persistence_set_maxOperators(n);
    }

    public void setMyAdFields(Set<ProductMyAdField> set) {
        this._persistence_set_myAdFields(set);
    }

    public void setMyApproveTicketPaymentTypes(Set<PaymentTransferType> set) {
        this._persistence_set_myApproveTicketPaymentTypes(set);
    }

    public void setMyCreateTicketPaymentTypes(Set<PaymentTransferType> set) {
        this._persistence_set_myCreateTicketPaymentTypes(set);
    }

    public void setMyExternalPaymentTypes(Set<PaymentTransferType> set) {
        this._persistence_set_myExternalPaymentTypes(set);
    }

    public void setMyPaymentRequestTypes(Set<PaymentTransferType> set) {
        this._persistence_set_myPaymentRequestTypes(set);
    }

    public void setMyPaymentTypes(Set<PaymentTransferType> set) {
        this._persistence_set_myPaymentTypes(set);
    }

    public void setMyTokenTypes(Set<ProductMyTokenType> set) {
        this._persistence_set_myTokenTypes(set);
    }

    public void setMyTransferFilters(Set<TransferFilter> set) {
        this._persistence_set_myTransferFilters(set);
    }

    @Override
    public void setNotifications(Set<UserProductNotification> set) {
        this._persistence_set_notifications(set);
    }

    @Override
    public void setOperatorProfileFields(Set<ProductOperatorProfileField> set) {
        this._persistence_set_operatorProfileFields(set);
    }

    public void setReceivePaymentRequestTypes(Set<PaymentTransferType> set) {
        this._persistence_set_receivePaymentRequestTypes(set);
    }

    public void setReceivePosPaymentTypes(Set<PaymentTransferType> set) {
        this._persistence_set_receivePosPaymentTypes(set);
    }

    public void setSearchUsersOnGroups(UserGroupAccessibility userGroupAccessibility) {
        this._persistence_set_searchUsersOnGroups(userGroupAccessibility);
    }

    public void setSendMessagesToAdmin(Set<MessageCategory> set) {
        this._persistence_set_sendMessagesToAdmin(set);
    }

    public void setShowAccountInProfile(AccountProfileVisibility accountProfileVisibility) {
        this._persistence_set_showAccountInProfile(accountProfileVisibility);
    }

    public void setShowActivitiesInProfile(Set<UserProfileActivity> set) {
        this._persistence_set_showActivitiesInProfile(set);
    }

    public void setShowAdExpirationDate(Boolean bl) {
        this._persistence_set_showAdExpirationDate(bl);
    }

    public void setShowAdPublicationDate(Boolean bl) {
        this._persistence_set_showAdPublicationDate(bl);
    }

    public void setShowBrokers(BrokerVisibility brokerVisibility) {
        this._persistence_set_showBrokers(brokerVisibility);
    }

    public void setUserAccount(UserAccountType userAccountType) {
        this._persistence_set_userAccount(userAccountType);
    }

    public void setUserRegistrationGroups(Set<UserGroup> set) {
        this._persistence_set_userRegistrationGroups(set);
    }

    public void setViewAdsInOtherCurrencies(Set<Currency> set) {
        this._persistence_set_viewAdsInOtherCurrencies(set);
    }

    public void setViewProfileOnGroups(UserGroupAccessibility userGroupAccessibility) {
        this._persistence_set_viewProfileOnGroups(userGroupAccessibility);
    }

    public void setVouchers(Set<ProductMemberVoucher> set) {
        this._persistence_set_vouchers(set);
    }

    public void setWebShopAdsRequireAuthorization(boolean bl) {
        this._persistence_set_webShopAdsRequireAuthorization(bl);
    }

    public void setWizards(Set<MemberProductCustomWizard> set) {
        this._persistence_set_wizards(set);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_initialCreditType_vh != null) {
            this._persistence_initialCreditType_vh = (WeavedAttributeValueHolderInterface)this._persistence_initialCreditType_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new MemberProduct();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "groupFilterDefault") {
            return this.groupFilterDefault;
        }
        if (string == "adsRequireAuthorization") {
            return this.adsRequireAuthorization;
        }
        if (string == "viewProfileOnGroups") {
            return this.viewProfileOnGroups;
        }
        if (string == "accountAccessibility") {
            return this.accountAccessibility;
        }
        if (string == "operatorProfileFields") {
            return this.operatorProfileFields;
        }
        if (string == "groupsForUserSearch") {
            return this.groupsForUserSearch;
        }
        if (string == "defaultPaymentAmountPerMonthLimit") {
            return this.defaultPaymentAmountPerMonthLimit;
        }
        if (string == "maxOperators") {
            return this.maxOperators;
        }
        if (string == "myApproveTicketPaymentTypes") {
            return this.myApproveTicketPaymentTypes;
        }
        if (string == "defaultAdPublicationTime") {
            return this.defaultAdPublicationTime;
        }
        if (string == "customOperations") {
            return this.customOperations;
        }
        if (string == "searchUsersOnGroups") {
            return this.searchUsersOnGroups;
        }
        if (string == "maxAddressesPerAd") {
            return this.maxAddressesPerAd;
        }
        if (string == "groupsForViewProfile") {
            return this.groupsForViewProfile;
        }
        if (string == "chargebackPaymentTypes") {
            return this.chargebackPaymentTypes;
        }
        if (string == "myCreateTicketPaymentTypes") {
            return this.myCreateTicketPaymentTypes;
        }
        if (string == "showAdPublicationDate") {
            return this.showAdPublicationDate;
        }
        if (string == "maxAds") {
            return this.maxAds;
        }
        if (string == "myPaymentRequestTypes") {
            return this.myPaymentRequestTypes;
        }
        if (string == "fwdMessageToEmail") {
            return this.fwdMessageToEmail;
        }
        if (string == "showActivitiesInProfile") {
            return this.showActivitiesInProfile;
        }
        if (string == "receivePosPaymentTypes") {
            return this.receivePosPaymentTypes;
        }
        if (string == "initialCredit") {
            return this.initialCredit;
        }
        if (string == "myAdFields") {
            return this.myAdFields;
        }
        if (string == "webShopAdsRequireAuthorization") {
            return this.webShopAdsRequireAuthorization;
        }
        if (string == "myPaymentTypes") {
            return this.myPaymentTypes;
        }
        if (string == "myExternalPaymentTypes") {
            return this.myExternalPaymentTypes;
        }
        if (string == "makePosPaymentTypes") {
            return this.makePosPaymentTypes;
        }
        if (string == "accountVisibility") {
            return this.accountVisibility;
        }
        if (string == "initialCreditType") {
            return this.initialCreditType;
        }
        if (string == "contactInfoFields") {
            return this.contactInfoFields;
        }
        if (string == "maxAdDescriptionSize") {
            return this.maxAdDescriptionSize;
        }
        if (string == "notifications") {
            return this.notifications;
        }
        if (string == "maxCategoriesPerAd") {
            return this.maxCategoriesPerAd;
        }
        if (string == "maxAdPublicationTime") {
            return this.maxAdPublicationTime;
        }
        if (string == "sendMessagesToAdmin") {
            return this.sendMessagesToAdmin;
        }
        if (string == "myTokenTypes") {
            return this.myTokenTypes;
        }
        if (string == "receivePaymentRequestTypes") {
            return this.receivePaymentRequestTypes;
        }
        if (string == "userRegistrationGroups") {
            return this.userRegistrationGroups;
        }
        if (string == "groupVisibility") {
            return this.groupVisibility;
        }
        if (string == "individualCreditLimit") {
            return this.individualCreditLimit;
        }
        if (string == "myTransferFilters") {
            return this.myTransferFilters;
        }
        if (string == "defaultPaymentAmountPerYearLimit") {
            return this.defaultPaymentAmountPerYearLimit;
        }
        if (string == "showAccountInProfile") {
            return this.showAccountInProfile;
        }
        if (string == "maxContactInfos") {
            return this.maxContactInfos;
        }
        if (string == "showAdExpirationDate") {
            return this.showAdExpirationDate;
        }
        if (string == "viewAdsInOtherCurrencies") {
            return this.viewAdsInOtherCurrencies;
        }
        if (string == "maxAdImages") {
            return this.maxAdImages;
        }
        if (string == "accountFees") {
            return this.accountFees;
        }
        if (string == "showBrokers") {
            return this.showBrokers;
        }
        if (string == "defaultPaymentAmountPerWeekLimit") {
            return this.defaultPaymentAmountPerWeekLimit;
        }
        if (string == "defaultPaymentAmountPerDayLimit") {
            return this.defaultPaymentAmountPerDayLimit;
        }
        if (string == "defaultFilterGroups") {
            return this.defaultFilterGroups;
        }
        if (string == "defaultPaymentAmountLimit") {
            return this.defaultPaymentAmountLimit;
        }
        if (string == "defaultCreditLimit") {
            return this.defaultCreditLimit;
        }
        if (string == "vouchers") {
            return this.vouchers;
        }
        if (string == "defaultUpperCreditLimit") {
            return this.defaultUpperCreditLimit;
        }
        if (string == "activateUserTokenTypes") {
            return this.activateUserTokenTypes;
        }
        if (string == "wizards") {
            return this.wizards;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "groupFilterDefault") {
            this.groupFilterDefault = (GroupFilterDefault)object;
            return;
        }
        if (string == "adsRequireAuthorization") {
            this.adsRequireAuthorization = (Boolean)object;
            return;
        }
        if (string == "viewProfileOnGroups") {
            this.viewProfileOnGroups = (UserGroupAccessibility)object;
            return;
        }
        if (string == "accountAccessibility") {
            this.accountAccessibility = (AccountAccessibility)object;
            return;
        }
        if (string == "operatorProfileFields") {
            this.operatorProfileFields = (Set)object;
            return;
        }
        if (string == "groupsForUserSearch") {
            this.groupsForUserSearch = (Set)object;
            return;
        }
        if (string == "defaultPaymentAmountPerMonthLimit") {
            this.defaultPaymentAmountPerMonthLimit = (BigDecimal)object;
            return;
        }
        if (string == "maxOperators") {
            this.maxOperators = (Integer)object;
            return;
        }
        if (string == "myApproveTicketPaymentTypes") {
            this.myApproveTicketPaymentTypes = (Set)object;
            return;
        }
        if (string == "defaultAdPublicationTime") {
            this.defaultAdPublicationTime = (TimeInterval)object;
            return;
        }
        if (string == "customOperations") {
            this.customOperations = (Set)object;
            return;
        }
        if (string == "searchUsersOnGroups") {
            this.searchUsersOnGroups = (UserGroupAccessibility)object;
            return;
        }
        if (string == "maxAddressesPerAd") {
            this.maxAddressesPerAd = (Integer)object;
            return;
        }
        if (string == "groupsForViewProfile") {
            this.groupsForViewProfile = (Set)object;
            return;
        }
        if (string == "chargebackPaymentTypes") {
            this.chargebackPaymentTypes = (Set)object;
            return;
        }
        if (string == "myCreateTicketPaymentTypes") {
            this.myCreateTicketPaymentTypes = (Set)object;
            return;
        }
        if (string == "showAdPublicationDate") {
            this.showAdPublicationDate = (Boolean)object;
            return;
        }
        if (string == "maxAds") {
            this.maxAds = (Integer)object;
            return;
        }
        if (string == "myPaymentRequestTypes") {
            this.myPaymentRequestTypes = (Set)object;
            return;
        }
        if (string == "fwdMessageToEmail") {
            this.fwdMessageToEmail = (MyMessagesForwardOperation)object;
            return;
        }
        if (string == "showActivitiesInProfile") {
            this.showActivitiesInProfile = (Set)object;
            return;
        }
        if (string == "receivePosPaymentTypes") {
            this.receivePosPaymentTypes = (Set)object;
            return;
        }
        if (string == "initialCredit") {
            this.initialCredit = (BigDecimal)object;
            return;
        }
        if (string == "myAdFields") {
            this.myAdFields = (Set)object;
            return;
        }
        if (string == "webShopAdsRequireAuthorization") {
            this.webShopAdsRequireAuthorization = (Boolean)object;
            return;
        }
        if (string == "myPaymentTypes") {
            this.myPaymentTypes = (Set)object;
            return;
        }
        if (string == "myExternalPaymentTypes") {
            this.myExternalPaymentTypes = (Set)object;
            return;
        }
        if (string == "makePosPaymentTypes") {
            this.makePosPaymentTypes = (Set)object;
            return;
        }
        if (string == "accountVisibility") {
            this.accountVisibility = (AccountVisibility)object;
            return;
        }
        if (string == "initialCreditType") {
            this.initialCreditType = (GeneratedTransferType)object;
            return;
        }
        if (string == "contactInfoFields") {
            this.contactInfoFields = (Set)object;
            return;
        }
        if (string == "maxAdDescriptionSize") {
            this.maxAdDescriptionSize = (Integer)object;
            return;
        }
        if (string == "notifications") {
            this.notifications = (Set)object;
            return;
        }
        if (string == "maxCategoriesPerAd") {
            this.maxCategoriesPerAd = (Integer)object;
            return;
        }
        if (string == "maxAdPublicationTime") {
            this.maxAdPublicationTime = (TimeInterval)object;
            return;
        }
        if (string == "sendMessagesToAdmin") {
            this.sendMessagesToAdmin = (Set)object;
            return;
        }
        if (string == "myTokenTypes") {
            this.myTokenTypes = (Set)object;
            return;
        }
        if (string == "receivePaymentRequestTypes") {
            this.receivePaymentRequestTypes = (Set)object;
            return;
        }
        if (string == "userRegistrationGroups") {
            this.userRegistrationGroups = (Set)object;
            return;
        }
        if (string == "groupVisibility") {
            this.groupVisibility = (GroupVisibility)object;
            return;
        }
        if (string == "individualCreditLimit") {
            this.individualCreditLimit = (BigDecimal)object;
            return;
        }
        if (string == "myTransferFilters") {
            this.myTransferFilters = (Set)object;
            return;
        }
        if (string == "defaultPaymentAmountPerYearLimit") {
            this.defaultPaymentAmountPerYearLimit = (BigDecimal)object;
            return;
        }
        if (string == "showAccountInProfile") {
            this.showAccountInProfile = (AccountProfileVisibility)object;
            return;
        }
        if (string == "maxContactInfos") {
            this.maxContactInfos = (Integer)object;
            return;
        }
        if (string == "showAdExpirationDate") {
            this.showAdExpirationDate = (Boolean)object;
            return;
        }
        if (string == "viewAdsInOtherCurrencies") {
            this.viewAdsInOtherCurrencies = (Set)object;
            return;
        }
        if (string == "maxAdImages") {
            this.maxAdImages = (Integer)object;
            return;
        }
        if (string == "accountFees") {
            this.accountFees = (Set)object;
            return;
        }
        if (string == "showBrokers") {
            this.showBrokers = (BrokerVisibility)object;
            return;
        }
        if (string == "defaultPaymentAmountPerWeekLimit") {
            this.defaultPaymentAmountPerWeekLimit = (BigDecimal)object;
            return;
        }
        if (string == "defaultPaymentAmountPerDayLimit") {
            this.defaultPaymentAmountPerDayLimit = (BigDecimal)object;
            return;
        }
        if (string == "defaultFilterGroups") {
            this.defaultFilterGroups = (Set)object;
            return;
        }
        if (string == "defaultPaymentAmountLimit") {
            this.defaultPaymentAmountLimit = (BigDecimal)object;
            return;
        }
        if (string == "defaultCreditLimit") {
            this.defaultCreditLimit = (BigDecimal)object;
            return;
        }
        if (string == "vouchers") {
            this.vouchers = (Set)object;
            return;
        }
        if (string == "defaultUpperCreditLimit") {
            this.defaultUpperCreditLimit = (BigDecimal)object;
            return;
        }
        if (string == "activateUserTokenTypes") {
            this.activateUserTokenTypes = (Set)object;
            return;
        }
        if (string == "wizards") {
            this.wizards = (Set)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public GroupFilterDefault _persistence_get_groupFilterDefault() {
        this._persistence_checkFetched("groupFilterDefault");
        return this.groupFilterDefault;
    }

    public void _persistence_set_groupFilterDefault(GroupFilterDefault groupFilterDefault) {
        this._persistence_checkFetchedForSet("groupFilterDefault");
        this._persistence_propertyChange("groupFilterDefault", this.groupFilterDefault, groupFilterDefault);
        this.groupFilterDefault = groupFilterDefault;
    }

    public Boolean _persistence_get_adsRequireAuthorization() {
        this._persistence_checkFetched("adsRequireAuthorization");
        return this.adsRequireAuthorization;
    }

    public void _persistence_set_adsRequireAuthorization(Boolean bl) {
        this._persistence_checkFetchedForSet("adsRequireAuthorization");
        this._persistence_propertyChange("adsRequireAuthorization", this.adsRequireAuthorization, bl);
        this.adsRequireAuthorization = bl;
    }

    public UserGroupAccessibility _persistence_get_viewProfileOnGroups() {
        this._persistence_checkFetched("viewProfileOnGroups");
        return this.viewProfileOnGroups;
    }

    public void _persistence_set_viewProfileOnGroups(UserGroupAccessibility userGroupAccessibility) {
        this._persistence_checkFetchedForSet("viewProfileOnGroups");
        this._persistence_propertyChange("viewProfileOnGroups", this.viewProfileOnGroups, userGroupAccessibility);
        this.viewProfileOnGroups = userGroupAccessibility;
    }

    public AccountAccessibility _persistence_get_accountAccessibility() {
        this._persistence_checkFetched("accountAccessibility");
        return this.accountAccessibility;
    }

    public void _persistence_set_accountAccessibility(AccountAccessibility accountAccessibility) {
        this._persistence_checkFetchedForSet("accountAccessibility");
        this._persistence_propertyChange("accountAccessibility", this.accountAccessibility, accountAccessibility);
        this.accountAccessibility = accountAccessibility;
    }

    public Set _persistence_get_operatorProfileFields() {
        this._persistence_checkFetched("operatorProfileFields");
        return this.operatorProfileFields;
    }

    public void _persistence_set_operatorProfileFields(Set set) {
        this._persistence_checkFetchedForSet("operatorProfileFields");
        this._persistence_propertyChange("operatorProfileFields", this.operatorProfileFields, set);
        this.operatorProfileFields = set;
    }

    public Set _persistence_get_groupsForUserSearch() {
        this._persistence_checkFetched("groupsForUserSearch");
        return this.groupsForUserSearch;
    }

    public void _persistence_set_groupsForUserSearch(Set set) {
        this._persistence_checkFetchedForSet("groupsForUserSearch");
        this._persistence_propertyChange("groupsForUserSearch", this.groupsForUserSearch, set);
        this.groupsForUserSearch = set;
    }

    public BigDecimal _persistence_get_defaultPaymentAmountPerMonthLimit() {
        this._persistence_checkFetched("defaultPaymentAmountPerMonthLimit");
        return this.defaultPaymentAmountPerMonthLimit;
    }

    public void _persistence_set_defaultPaymentAmountPerMonthLimit(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("defaultPaymentAmountPerMonthLimit");
        this._persistence_propertyChange("defaultPaymentAmountPerMonthLimit", this.defaultPaymentAmountPerMonthLimit, bigDecimal);
        this.defaultPaymentAmountPerMonthLimit = bigDecimal;
    }

    public Integer _persistence_get_maxOperators() {
        this._persistence_checkFetched("maxOperators");
        return this.maxOperators;
    }

    public void _persistence_set_maxOperators(Integer n) {
        this._persistence_checkFetchedForSet("maxOperators");
        this._persistence_propertyChange("maxOperators", this.maxOperators, n);
        this.maxOperators = n;
    }

    public Set _persistence_get_myApproveTicketPaymentTypes() {
        this._persistence_checkFetched("myApproveTicketPaymentTypes");
        return this.myApproveTicketPaymentTypes;
    }

    public void _persistence_set_myApproveTicketPaymentTypes(Set set) {
        this._persistence_checkFetchedForSet("myApproveTicketPaymentTypes");
        this._persistence_propertyChange("myApproveTicketPaymentTypes", this.myApproveTicketPaymentTypes, set);
        this.myApproveTicketPaymentTypes = set;
    }

    public TimeInterval _persistence_get_defaultAdPublicationTime() {
        this._persistence_checkFetched("defaultAdPublicationTime");
        return this.defaultAdPublicationTime;
    }

    public void _persistence_set_defaultAdPublicationTime(TimeInterval timeInterval) {
        this._persistence_checkFetchedForSet("defaultAdPublicationTime");
        this._persistence_propertyChange("defaultAdPublicationTime", this.defaultAdPublicationTime, timeInterval);
        this.defaultAdPublicationTime = timeInterval;
    }

    public Set _persistence_get_customOperations() {
        this._persistence_checkFetched("customOperations");
        return this.customOperations;
    }

    public void _persistence_set_customOperations(Set set) {
        this._persistence_checkFetchedForSet("customOperations");
        this._persistence_propertyChange("customOperations", this.customOperations, set);
        this.customOperations = set;
    }

    public UserGroupAccessibility _persistence_get_searchUsersOnGroups() {
        this._persistence_checkFetched("searchUsersOnGroups");
        return this.searchUsersOnGroups;
    }

    public void _persistence_set_searchUsersOnGroups(UserGroupAccessibility userGroupAccessibility) {
        this._persistence_checkFetchedForSet("searchUsersOnGroups");
        this._persistence_propertyChange("searchUsersOnGroups", this.searchUsersOnGroups, userGroupAccessibility);
        this.searchUsersOnGroups = userGroupAccessibility;
    }

    public Integer _persistence_get_maxAddressesPerAd() {
        this._persistence_checkFetched("maxAddressesPerAd");
        return this.maxAddressesPerAd;
    }

    public void _persistence_set_maxAddressesPerAd(Integer n) {
        this._persistence_checkFetchedForSet("maxAddressesPerAd");
        this._persistence_propertyChange("maxAddressesPerAd", this.maxAddressesPerAd, n);
        this.maxAddressesPerAd = n;
    }

    public Set _persistence_get_groupsForViewProfile() {
        this._persistence_checkFetched("groupsForViewProfile");
        return this.groupsForViewProfile;
    }

    public void _persistence_set_groupsForViewProfile(Set set) {
        this._persistence_checkFetchedForSet("groupsForViewProfile");
        this._persistence_propertyChange("groupsForViewProfile", this.groupsForViewProfile, set);
        this.groupsForViewProfile = set;
    }

    public Set _persistence_get_chargebackPaymentTypes() {
        this._persistence_checkFetched("chargebackPaymentTypes");
        return this.chargebackPaymentTypes;
    }

    public void _persistence_set_chargebackPaymentTypes(Set set) {
        this._persistence_checkFetchedForSet("chargebackPaymentTypes");
        this._persistence_propertyChange("chargebackPaymentTypes", this.chargebackPaymentTypes, set);
        this.chargebackPaymentTypes = set;
    }

    public Set _persistence_get_myCreateTicketPaymentTypes() {
        this._persistence_checkFetched("myCreateTicketPaymentTypes");
        return this.myCreateTicketPaymentTypes;
    }

    public void _persistence_set_myCreateTicketPaymentTypes(Set set) {
        this._persistence_checkFetchedForSet("myCreateTicketPaymentTypes");
        this._persistence_propertyChange("myCreateTicketPaymentTypes", this.myCreateTicketPaymentTypes, set);
        this.myCreateTicketPaymentTypes = set;
    }

    public Boolean _persistence_get_showAdPublicationDate() {
        this._persistence_checkFetched("showAdPublicationDate");
        return this.showAdPublicationDate;
    }

    public void _persistence_set_showAdPublicationDate(Boolean bl) {
        this._persistence_checkFetchedForSet("showAdPublicationDate");
        this._persistence_propertyChange("showAdPublicationDate", this.showAdPublicationDate, bl);
        this.showAdPublicationDate = bl;
    }

    public Integer _persistence_get_maxAds() {
        this._persistence_checkFetched("maxAds");
        return this.maxAds;
    }

    public void _persistence_set_maxAds(Integer n) {
        this._persistence_checkFetchedForSet("maxAds");
        this._persistence_propertyChange("maxAds", this.maxAds, n);
        this.maxAds = n;
    }

    public Set _persistence_get_myPaymentRequestTypes() {
        this._persistence_checkFetched("myPaymentRequestTypes");
        return this.myPaymentRequestTypes;
    }

    public void _persistence_set_myPaymentRequestTypes(Set set) {
        this._persistence_checkFetchedForSet("myPaymentRequestTypes");
        this._persistence_propertyChange("myPaymentRequestTypes", this.myPaymentRequestTypes, set);
        this.myPaymentRequestTypes = set;
    }

    public MyMessagesForwardOperation _persistence_get_fwdMessageToEmail() {
        this._persistence_checkFetched("fwdMessageToEmail");
        return this.fwdMessageToEmail;
    }

    public void _persistence_set_fwdMessageToEmail(MyMessagesForwardOperation myMessagesForwardOperation) {
        this._persistence_checkFetchedForSet("fwdMessageToEmail");
        this._persistence_propertyChange("fwdMessageToEmail", this.fwdMessageToEmail, myMessagesForwardOperation);
        this.fwdMessageToEmail = myMessagesForwardOperation;
    }

    public Set _persistence_get_showActivitiesInProfile() {
        this._persistence_checkFetched("showActivitiesInProfile");
        return this.showActivitiesInProfile;
    }

    public void _persistence_set_showActivitiesInProfile(Set set) {
        this._persistence_checkFetchedForSet("showActivitiesInProfile");
        this._persistence_propertyChange("showActivitiesInProfile", this.showActivitiesInProfile, set);
        this.showActivitiesInProfile = set;
    }

    public Set _persistence_get_receivePosPaymentTypes() {
        this._persistence_checkFetched("receivePosPaymentTypes");
        return this.receivePosPaymentTypes;
    }

    public void _persistence_set_receivePosPaymentTypes(Set set) {
        this._persistence_checkFetchedForSet("receivePosPaymentTypes");
        this._persistence_propertyChange("receivePosPaymentTypes", this.receivePosPaymentTypes, set);
        this.receivePosPaymentTypes = set;
    }

    public BigDecimal _persistence_get_initialCredit() {
        this._persistence_checkFetched("initialCredit");
        return this.initialCredit;
    }

    public void _persistence_set_initialCredit(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("initialCredit");
        this._persistence_propertyChange("initialCredit", this.initialCredit, bigDecimal);
        this.initialCredit = bigDecimal;
    }

    public Set _persistence_get_myAdFields() {
        this._persistence_checkFetched("myAdFields");
        return this.myAdFields;
    }

    public void _persistence_set_myAdFields(Set set) {
        this._persistence_checkFetchedForSet("myAdFields");
        this._persistence_propertyChange("myAdFields", this.myAdFields, set);
        this.myAdFields = set;
    }

    public Boolean _persistence_get_webShopAdsRequireAuthorization() {
        this._persistence_checkFetched("webShopAdsRequireAuthorization");
        return this.webShopAdsRequireAuthorization;
    }

    public void _persistence_set_webShopAdsRequireAuthorization(Boolean bl) {
        this._persistence_checkFetchedForSet("webShopAdsRequireAuthorization");
        this._persistence_propertyChange("webShopAdsRequireAuthorization", this.webShopAdsRequireAuthorization, bl);
        this.webShopAdsRequireAuthorization = bl;
    }

    public Set _persistence_get_myPaymentTypes() {
        this._persistence_checkFetched("myPaymentTypes");
        return this.myPaymentTypes;
    }

    public void _persistence_set_myPaymentTypes(Set set) {
        this._persistence_checkFetchedForSet("myPaymentTypes");
        this._persistence_propertyChange("myPaymentTypes", this.myPaymentTypes, set);
        this.myPaymentTypes = set;
    }

    public Set _persistence_get_myExternalPaymentTypes() {
        this._persistence_checkFetched("myExternalPaymentTypes");
        return this.myExternalPaymentTypes;
    }

    public void _persistence_set_myExternalPaymentTypes(Set set) {
        this._persistence_checkFetchedForSet("myExternalPaymentTypes");
        this._persistence_propertyChange("myExternalPaymentTypes", this.myExternalPaymentTypes, set);
        this.myExternalPaymentTypes = set;
    }

    public Set _persistence_get_makePosPaymentTypes() {
        this._persistence_checkFetched("makePosPaymentTypes");
        return this.makePosPaymentTypes;
    }

    public void _persistence_set_makePosPaymentTypes(Set set) {
        this._persistence_checkFetchedForSet("makePosPaymentTypes");
        this._persistence_propertyChange("makePosPaymentTypes", this.makePosPaymentTypes, set);
        this.makePosPaymentTypes = set;
    }

    public AccountVisibility _persistence_get_accountVisibility() {
        this._persistence_checkFetched("accountVisibility");
        return this.accountVisibility;
    }

    public void _persistence_set_accountVisibility(AccountVisibility accountVisibility) {
        this._persistence_checkFetchedForSet("accountVisibility");
        this._persistence_propertyChange("accountVisibility", this.accountVisibility, accountVisibility);
        this.accountVisibility = accountVisibility;
    }

    protected void _persistence_initialize_initialCreditType_vh() {
        if (this._persistence_initialCreditType_vh == null) {
            this._persistence_initialCreditType_vh = new ValueHolder((Object)this.initialCreditType);
            this._persistence_initialCreditType_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_initialCreditType_vh() {
        GeneratedTransferType generatedTransferType;
        this._persistence_initialize_initialCreditType_vh();
        if ((this._persistence_initialCreditType_vh.isCoordinatedWithProperty() || this._persistence_initialCreditType_vh.isNewlyWeavedValueHolder()) && (generatedTransferType = this._persistence_get_initialCreditType()) != this._persistence_initialCreditType_vh.getValue()) {
            this._persistence_set_initialCreditType(generatedTransferType);
        }
        return this._persistence_initialCreditType_vh;
    }

    public void _persistence_set_initialCreditType_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_initialCreditType_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            GeneratedTransferType generatedTransferType = this._persistence_get_initialCreditType();
            if (generatedTransferType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_initialCreditType((GeneratedTransferType)object);
            }
        } else {
            this.initialCreditType = null;
        }
    }

    public GeneratedTransferType _persistence_get_initialCreditType() {
        this._persistence_checkFetched("initialCreditType");
        this._persistence_initialize_initialCreditType_vh();
        this.initialCreditType = (GeneratedTransferType)this._persistence_initialCreditType_vh.getValue();
        return this.initialCreditType;
    }

    public void _persistence_set_initialCreditType(GeneratedTransferType generatedTransferType) {
        this._persistence_checkFetchedForSet("initialCreditType");
        this._persistence_initialize_initialCreditType_vh();
        this.initialCreditType = (GeneratedTransferType)this._persistence_initialCreditType_vh.getValue();
        this._persistence_propertyChange("initialCreditType", this.initialCreditType, generatedTransferType);
        this.initialCreditType = generatedTransferType;
        this._persistence_initialCreditType_vh.setValue((Object)generatedTransferType);
    }

    public Set _persistence_get_contactInfoFields() {
        this._persistence_checkFetched("contactInfoFields");
        return this.contactInfoFields;
    }

    public void _persistence_set_contactInfoFields(Set set) {
        this._persistence_checkFetchedForSet("contactInfoFields");
        this._persistence_propertyChange("contactInfoFields", this.contactInfoFields, set);
        this.contactInfoFields = set;
    }

    public Integer _persistence_get_maxAdDescriptionSize() {
        this._persistence_checkFetched("maxAdDescriptionSize");
        return this.maxAdDescriptionSize;
    }

    public void _persistence_set_maxAdDescriptionSize(Integer n) {
        this._persistence_checkFetchedForSet("maxAdDescriptionSize");
        this._persistence_propertyChange("maxAdDescriptionSize", this.maxAdDescriptionSize, n);
        this.maxAdDescriptionSize = n;
    }

    public Set _persistence_get_notifications() {
        this._persistence_checkFetched("notifications");
        return this.notifications;
    }

    public void _persistence_set_notifications(Set set) {
        this._persistence_checkFetchedForSet("notifications");
        this._persistence_propertyChange("notifications", this.notifications, set);
        this.notifications = set;
    }

    public Integer _persistence_get_maxCategoriesPerAd() {
        this._persistence_checkFetched("maxCategoriesPerAd");
        return this.maxCategoriesPerAd;
    }

    public void _persistence_set_maxCategoriesPerAd(Integer n) {
        this._persistence_checkFetchedForSet("maxCategoriesPerAd");
        this._persistence_propertyChange("maxCategoriesPerAd", this.maxCategoriesPerAd, n);
        this.maxCategoriesPerAd = n;
    }

    public TimeInterval _persistence_get_maxAdPublicationTime() {
        this._persistence_checkFetched("maxAdPublicationTime");
        return this.maxAdPublicationTime;
    }

    public void _persistence_set_maxAdPublicationTime(TimeInterval timeInterval) {
        this._persistence_checkFetchedForSet("maxAdPublicationTime");
        this._persistence_propertyChange("maxAdPublicationTime", this.maxAdPublicationTime, timeInterval);
        this.maxAdPublicationTime = timeInterval;
    }

    public Set _persistence_get_sendMessagesToAdmin() {
        this._persistence_checkFetched("sendMessagesToAdmin");
        return this.sendMessagesToAdmin;
    }

    public void _persistence_set_sendMessagesToAdmin(Set set) {
        this._persistence_checkFetchedForSet("sendMessagesToAdmin");
        this._persistence_propertyChange("sendMessagesToAdmin", this.sendMessagesToAdmin, set);
        this.sendMessagesToAdmin = set;
    }

    public Set _persistence_get_myTokenTypes() {
        this._persistence_checkFetched("myTokenTypes");
        return this.myTokenTypes;
    }

    public void _persistence_set_myTokenTypes(Set set) {
        this._persistence_checkFetchedForSet("myTokenTypes");
        this._persistence_propertyChange("myTokenTypes", this.myTokenTypes, set);
        this.myTokenTypes = set;
    }

    public Set _persistence_get_receivePaymentRequestTypes() {
        this._persistence_checkFetched("receivePaymentRequestTypes");
        return this.receivePaymentRequestTypes;
    }

    public void _persistence_set_receivePaymentRequestTypes(Set set) {
        this._persistence_checkFetchedForSet("receivePaymentRequestTypes");
        this._persistence_propertyChange("receivePaymentRequestTypes", this.receivePaymentRequestTypes, set);
        this.receivePaymentRequestTypes = set;
    }

    public Set _persistence_get_userRegistrationGroups() {
        this._persistence_checkFetched("userRegistrationGroups");
        return this.userRegistrationGroups;
    }

    public void _persistence_set_userRegistrationGroups(Set set) {
        this._persistence_checkFetchedForSet("userRegistrationGroups");
        this._persistence_propertyChange("userRegistrationGroups", this.userRegistrationGroups, set);
        this.userRegistrationGroups = set;
    }

    public GroupVisibility _persistence_get_groupVisibility() {
        this._persistence_checkFetched("groupVisibility");
        return this.groupVisibility;
    }

    public void _persistence_set_groupVisibility(GroupVisibility groupVisibility) {
        this._persistence_checkFetchedForSet("groupVisibility");
        this._persistence_propertyChange("groupVisibility", this.groupVisibility, groupVisibility);
        this.groupVisibility = groupVisibility;
    }

    public BigDecimal _persistence_get_individualCreditLimit() {
        this._persistence_checkFetched("individualCreditLimit");
        return this.individualCreditLimit;
    }

    public void _persistence_set_individualCreditLimit(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("individualCreditLimit");
        this._persistence_propertyChange("individualCreditLimit", this.individualCreditLimit, bigDecimal);
        this.individualCreditLimit = bigDecimal;
    }

    public Set _persistence_get_myTransferFilters() {
        this._persistence_checkFetched("myTransferFilters");
        return this.myTransferFilters;
    }

    public void _persistence_set_myTransferFilters(Set set) {
        this._persistence_checkFetchedForSet("myTransferFilters");
        this._persistence_propertyChange("myTransferFilters", this.myTransferFilters, set);
        this.myTransferFilters = set;
    }

    public BigDecimal _persistence_get_defaultPaymentAmountPerYearLimit() {
        this._persistence_checkFetched("defaultPaymentAmountPerYearLimit");
        return this.defaultPaymentAmountPerYearLimit;
    }

    public void _persistence_set_defaultPaymentAmountPerYearLimit(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("defaultPaymentAmountPerYearLimit");
        this._persistence_propertyChange("defaultPaymentAmountPerYearLimit", this.defaultPaymentAmountPerYearLimit, bigDecimal);
        this.defaultPaymentAmountPerYearLimit = bigDecimal;
    }

    public AccountProfileVisibility _persistence_get_showAccountInProfile() {
        this._persistence_checkFetched("showAccountInProfile");
        return this.showAccountInProfile;
    }

    public void _persistence_set_showAccountInProfile(AccountProfileVisibility accountProfileVisibility) {
        this._persistence_checkFetchedForSet("showAccountInProfile");
        this._persistence_propertyChange("showAccountInProfile", this.showAccountInProfile, accountProfileVisibility);
        this.showAccountInProfile = accountProfileVisibility;
    }

    public Integer _persistence_get_maxContactInfos() {
        this._persistence_checkFetched("maxContactInfos");
        return this.maxContactInfos;
    }

    public void _persistence_set_maxContactInfos(Integer n) {
        this._persistence_checkFetchedForSet("maxContactInfos");
        this._persistence_propertyChange("maxContactInfos", this.maxContactInfos, n);
        this.maxContactInfos = n;
    }

    public Boolean _persistence_get_showAdExpirationDate() {
        this._persistence_checkFetched("showAdExpirationDate");
        return this.showAdExpirationDate;
    }

    public void _persistence_set_showAdExpirationDate(Boolean bl) {
        this._persistence_checkFetchedForSet("showAdExpirationDate");
        this._persistence_propertyChange("showAdExpirationDate", this.showAdExpirationDate, bl);
        this.showAdExpirationDate = bl;
    }

    public Set _persistence_get_viewAdsInOtherCurrencies() {
        this._persistence_checkFetched("viewAdsInOtherCurrencies");
        return this.viewAdsInOtherCurrencies;
    }

    public void _persistence_set_viewAdsInOtherCurrencies(Set set) {
        this._persistence_checkFetchedForSet("viewAdsInOtherCurrencies");
        this._persistence_propertyChange("viewAdsInOtherCurrencies", this.viewAdsInOtherCurrencies, set);
        this.viewAdsInOtherCurrencies = set;
    }

    public Integer _persistence_get_maxAdImages() {
        this._persistence_checkFetched("maxAdImages");
        return this.maxAdImages;
    }

    public void _persistence_set_maxAdImages(Integer n) {
        this._persistence_checkFetchedForSet("maxAdImages");
        this._persistence_propertyChange("maxAdImages", this.maxAdImages, n);
        this.maxAdImages = n;
    }

    public Set _persistence_get_accountFees() {
        this._persistence_checkFetched("accountFees");
        return this.accountFees;
    }

    public void _persistence_set_accountFees(Set set) {
        this._persistence_checkFetchedForSet("accountFees");
        this._persistence_propertyChange("accountFees", this.accountFees, set);
        this.accountFees = set;
    }

    public BrokerVisibility _persistence_get_showBrokers() {
        this._persistence_checkFetched("showBrokers");
        return this.showBrokers;
    }

    public void _persistence_set_showBrokers(BrokerVisibility brokerVisibility) {
        this._persistence_checkFetchedForSet("showBrokers");
        this._persistence_propertyChange("showBrokers", this.showBrokers, brokerVisibility);
        this.showBrokers = brokerVisibility;
    }

    public BigDecimal _persistence_get_defaultPaymentAmountPerWeekLimit() {
        this._persistence_checkFetched("defaultPaymentAmountPerWeekLimit");
        return this.defaultPaymentAmountPerWeekLimit;
    }

    public void _persistence_set_defaultPaymentAmountPerWeekLimit(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("defaultPaymentAmountPerWeekLimit");
        this._persistence_propertyChange("defaultPaymentAmountPerWeekLimit", this.defaultPaymentAmountPerWeekLimit, bigDecimal);
        this.defaultPaymentAmountPerWeekLimit = bigDecimal;
    }

    public BigDecimal _persistence_get_defaultPaymentAmountPerDayLimit() {
        this._persistence_checkFetched("defaultPaymentAmountPerDayLimit");
        return this.defaultPaymentAmountPerDayLimit;
    }

    public void _persistence_set_defaultPaymentAmountPerDayLimit(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("defaultPaymentAmountPerDayLimit");
        this._persistence_propertyChange("defaultPaymentAmountPerDayLimit", this.defaultPaymentAmountPerDayLimit, bigDecimal);
        this.defaultPaymentAmountPerDayLimit = bigDecimal;
    }

    public Set _persistence_get_defaultFilterGroups() {
        this._persistence_checkFetched("defaultFilterGroups");
        return this.defaultFilterGroups;
    }

    public void _persistence_set_defaultFilterGroups(Set set) {
        this._persistence_checkFetchedForSet("defaultFilterGroups");
        this._persistence_propertyChange("defaultFilterGroups", this.defaultFilterGroups, set);
        this.defaultFilterGroups = set;
    }

    public BigDecimal _persistence_get_defaultPaymentAmountLimit() {
        this._persistence_checkFetched("defaultPaymentAmountLimit");
        return this.defaultPaymentAmountLimit;
    }

    public void _persistence_set_defaultPaymentAmountLimit(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("defaultPaymentAmountLimit");
        this._persistence_propertyChange("defaultPaymentAmountLimit", this.defaultPaymentAmountLimit, bigDecimal);
        this.defaultPaymentAmountLimit = bigDecimal;
    }

    public BigDecimal _persistence_get_defaultCreditLimit() {
        this._persistence_checkFetched("defaultCreditLimit");
        return this.defaultCreditLimit;
    }

    public void _persistence_set_defaultCreditLimit(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("defaultCreditLimit");
        this._persistence_propertyChange("defaultCreditLimit", this.defaultCreditLimit, bigDecimal);
        this.defaultCreditLimit = bigDecimal;
    }

    public Set _persistence_get_vouchers() {
        this._persistence_checkFetched("vouchers");
        return this.vouchers;
    }

    public void _persistence_set_vouchers(Set set) {
        this._persistence_checkFetchedForSet("vouchers");
        this._persistence_propertyChange("vouchers", this.vouchers, set);
        this.vouchers = set;
    }

    public BigDecimal _persistence_get_defaultUpperCreditLimit() {
        this._persistence_checkFetched("defaultUpperCreditLimit");
        return this.defaultUpperCreditLimit;
    }

    public void _persistence_set_defaultUpperCreditLimit(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("defaultUpperCreditLimit");
        this._persistence_propertyChange("defaultUpperCreditLimit", this.defaultUpperCreditLimit, bigDecimal);
        this.defaultUpperCreditLimit = bigDecimal;
    }

    public Set _persistence_get_activateUserTokenTypes() {
        this._persistence_checkFetched("activateUserTokenTypes");
        return this.activateUserTokenTypes;
    }

    public void _persistence_set_activateUserTokenTypes(Set set) {
        this._persistence_checkFetchedForSet("activateUserTokenTypes");
        this._persistence_propertyChange("activateUserTokenTypes", this.activateUserTokenTypes, set);
        this.activateUserTokenTypes = set;
    }

    public Set _persistence_get_wizards() {
        this._persistence_checkFetched("wizards");
        return this.wizards;
    }

    public void _persistence_set_wizards(Set set) {
        this._persistence_checkFetchedForSet("wizards");
        this._persistence_propertyChange("wizards", this.wizards, set);
        this.wizards = set;
    }
}

