/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.users;

import org.cyclos.entities.access.BuiltInPrincipalType;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.entities.utils.UserPrincipals;

public interface DelegatingUserPrincipal
extends UserPrincipal {
    default public UserPrincipal getDelegate() {
        PrincipalType principalType = this.getPrincipalType();
        BasicUser basicUser = this.getBasicUser();
        if (principalType == null || basicUser == null) {
            return null;
        }
        switch (principalType.getNature()) {
            case ACCESS_CLIENT: {
                return this.getAccessClient();
            }
            case BUILT_IN: {
                switch (((BuiltInPrincipalType)principalType).getBuiltInType()) {
                    case USERNAME: {
                        return UserPrincipals.username(basicUser);
                    }
                    case EMAIL: {
                        return UserPrincipals.email(basicUser);
                    }
                    case MOBILE_PHONE: {
                        return this.getMobilePhone();
                    }
                    case ACCOUNT_NUMBER: {
                        UserAccountType userAccountType = this.getAccountType();
                        if (userAccountType != null) {
                            return UserPrincipals.account(basicUser.getUser(), userAccountType);
                        }
                    }
                    case TRUSTED_DEVICE: {
                        return this.getTrustedDevice();
                    }
                }
                break;
            }
            case CUSTOM_FIELD: {
                return this.getCustomFieldValue();
            }
            case NFC_TOKEN: 
            case TOKEN: {
                return this.getToken();
            }
        }
        return null;
    }

    @Override
    default public String getPrincipal() {
        UserPrincipal userPrincipal = this.getDelegate();
        return userPrincipal == null ? null : userPrincipal.getPrincipal();
    }
}

