/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.users;

import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.system.BulkActionFile;
import org.cyclos.entities.system.BulkActionImage;
import org.cyclos.entities.system.DefinesNetwork;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.BulkActionUser;
import org.cyclos.model.users.bulkactions.BulkActionNature;
import org.cyclos.model.users.bulkactions.BulkActionStatus;
import org.cyclos.utils.ObjectHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="bulk_actions")
@DiscriminatorColumn(name="subclass")
public abstract class BulkAction
extends BaseEntity
implements DefinesNetwork,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="subclass", insertable=false, updatable=false)
    private BulkActionNature nature;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="network_id")
    private Network network;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="status", nullable=false)
    @ReadOnlyFromDTO
    private BulkActionStatus status;
    @Basic
    @Column(name="archived")
    @ReadOnlyFromDTO
    private Boolean archived;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="creation_date", nullable=false)
    @ReadOnlyFromDTO
    private Date creationDate;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="finish_date")
    @ReadOnlyFromDTO
    private Date finishDate;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="by_id")
    @ReadOnlyFromDTO
    private BasicUser by;
    @Basic
    @Column(name="success_users")
    private Integer successUsers;
    @Basic
    @Column(name="skipped_users")
    private Integer skippedUsers;
    @Basic
    @Column(name="error_users")
    private Integer errorUsers;
    @Basic
    @Column(name="pending_users")
    private Integer pendingUsers;
    @Basic
    @Column(name="canceled_users")
    private Integer canceledUsers;
    @OneToMany(mappedBy="bulkAction", cascade={CascadeType.REMOVE})
    private Set<BulkActionUser> users;
    @Basic
    @Lob
    @Column(name="query")
    @ReadOnlyFromDTO
    private String query;
    @OneToMany(mappedBy="bulkAction", cascade={CascadeType.REMOVE})
    @OrderBy(value="order")
    protected List<BulkActionImage> images;
    @OneToMany(mappedBy="bulkAction", cascade={CascadeType.REMOVE})
    @OrderBy(value="order")
    protected List<BulkActionFile> files;
    static final long serialVersionUID = 1529268579654887413L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_network_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_by_vh;

    public BasicUser getBy() {
        return this._persistence_get_by();
    }

    public Integer getCanceledUsers() {
        return this._persistence_get_canceledUsers();
    }

    public Date getCreationDate() {
        return this._persistence_get_creationDate();
    }

    public Integer getErrorUsers() {
        return this._persistence_get_errorUsers();
    }

    public Date getFinishDate() {
        return this._persistence_get_finishDate();
    }

    public abstract BulkActionNature getNature();

    @Override
    public Network getNetwork() {
        return this._persistence_get_network();
    }

    public Integer getPendingUsers() {
        return this._persistence_get_pendingUsers();
    }

    public String getQuery() {
        return this._persistence_get_query();
    }

    public Integer getSkippedUsers() {
        return this._persistence_get_skippedUsers();
    }

    public BulkActionStatus getStatus() {
        return this._persistence_get_status();
    }

    public Integer getSuccessUsers() {
        return this._persistence_get_successUsers();
    }

    public Integer getTotalUsers() {
        if (this._persistence_get_successUsers() == null) {
            return null;
        }
        return (Integer)ObjectHelper.defaultValue((Object)this._persistence_get_successUsers(), (Object)0) + (Integer)ObjectHelper.defaultValue((Object)this._persistence_get_skippedUsers(), (Object)0) + (Integer)ObjectHelper.defaultValue((Object)this._persistence_get_errorUsers(), (Object)0) + (Integer)ObjectHelper.defaultValue((Object)this._persistence_get_pendingUsers(), (Object)0) + (Integer)ObjectHelper.defaultValue((Object)this._persistence_get_canceledUsers(), (Object)0);
    }

    public boolean isArchived() {
        return Boolean.TRUE.equals(this._persistence_get_archived());
    }

    public void setArchived(boolean bl) {
        this._persistence_set_archived(bl);
    }

    public void setBy(BasicUser basicUser) {
        this._persistence_set_by(basicUser);
    }

    public void setCanceledUsers(Integer n) {
        this._persistence_set_canceledUsers(n);
    }

    public void setCreationDate(Date date) {
        this._persistence_set_creationDate(date);
    }

    public void setErrorUsers(Integer n) {
        this._persistence_set_errorUsers(n);
    }

    public void setFinishDate(Date date) {
        this._persistence_set_finishDate(date);
    }

    @Override
    public void setNetwork(Network network) {
        this._persistence_set_network(network);
    }

    public void setPendingUsers(Integer n) {
        this._persistence_set_pendingUsers(n);
    }

    public void setQuery(String string) {
        this._persistence_set_query(string);
    }

    public void setSkippedUsers(Integer n) {
        this._persistence_set_skippedUsers(n);
    }

    public void setStatus(BulkActionStatus bulkActionStatus) {
        this._persistence_set_status(bulkActionStatus);
    }

    public void setSuccessUsers(Integer n) {
        this._persistence_set_successUsers(n);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_network_vh != null) {
            this._persistence_network_vh = (WeavedAttributeValueHolderInterface)this._persistence_network_vh.clone();
        }
        if (this._persistence_by_vh != null) {
            this._persistence_by_vh = (WeavedAttributeValueHolderInterface)this._persistence_by_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new BulkAction();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "images") {
            return this.images;
        }
        if (string == "nature") {
            return this.nature;
        }
        if (string == "query") {
            return this.query;
        }
        if (string == "creationDate") {
            return this.creationDate;
        }
        if (string == "canceledUsers") {
            return this.canceledUsers;
        }
        if (string == "skippedUsers") {
            return this.skippedUsers;
        }
        if (string == "users") {
            return this.users;
        }
        if (string == "network") {
            return this.network;
        }
        if (string == "archived") {
            return this.archived;
        }
        if (string == "successUsers") {
            return this.successUsers;
        }
        if (string == "by") {
            return this.by;
        }
        if (string == "errorUsers") {
            return this.errorUsers;
        }
        if (string == "files") {
            return this.files;
        }
        if (string == "finishDate") {
            return this.finishDate;
        }
        if (string == "pendingUsers") {
            return this.pendingUsers;
        }
        if (string == "status") {
            return this.status;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "images") {
            this.images = (List)object;
            return;
        }
        if (string == "nature") {
            this.nature = (BulkActionNature)object;
            return;
        }
        if (string == "query") {
            this.query = (String)object;
            return;
        }
        if (string == "creationDate") {
            this.creationDate = (Date)object;
            return;
        }
        if (string == "canceledUsers") {
            this.canceledUsers = (Integer)object;
            return;
        }
        if (string == "skippedUsers") {
            this.skippedUsers = (Integer)object;
            return;
        }
        if (string == "users") {
            this.users = (Set)object;
            return;
        }
        if (string == "network") {
            this.network = (Network)object;
            return;
        }
        if (string == "archived") {
            this.archived = (Boolean)object;
            return;
        }
        if (string == "successUsers") {
            this.successUsers = (Integer)object;
            return;
        }
        if (string == "by") {
            this.by = (BasicUser)object;
            return;
        }
        if (string == "errorUsers") {
            this.errorUsers = (Integer)object;
            return;
        }
        if (string == "files") {
            this.files = (List)object;
            return;
        }
        if (string == "finishDate") {
            this.finishDate = (Date)object;
            return;
        }
        if (string == "pendingUsers") {
            this.pendingUsers = (Integer)object;
            return;
        }
        if (string == "status") {
            this.status = (BulkActionStatus)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public List _persistence_get_images() {
        this._persistence_checkFetched("images");
        return this.images;
    }

    public void _persistence_set_images(List list) {
        this._persistence_checkFetchedForSet("images");
        this._persistence_propertyChange("images", this.images, list);
        this.images = list;
    }

    public BulkActionNature _persistence_get_nature() {
        this._persistence_checkFetched("nature");
        return this.nature;
    }

    public void _persistence_set_nature(BulkActionNature bulkActionNature) {
        this._persistence_checkFetchedForSet("nature");
        this._persistence_propertyChange("nature", this.nature, bulkActionNature);
        this.nature = bulkActionNature;
    }

    public String _persistence_get_query() {
        this._persistence_checkFetched("query");
        return this.query;
    }

    public void _persistence_set_query(String string) {
        this._persistence_checkFetchedForSet("query");
        this._persistence_propertyChange("query", this.query, string);
        this.query = string;
    }

    public Date _persistence_get_creationDate() {
        this._persistence_checkFetched("creationDate");
        return this.creationDate;
    }

    public void _persistence_set_creationDate(Date date) {
        this._persistence_checkFetchedForSet("creationDate");
        this._persistence_propertyChange("creationDate", this.creationDate, date);
        this.creationDate = date;
    }

    public Integer _persistence_get_canceledUsers() {
        this._persistence_checkFetched("canceledUsers");
        return this.canceledUsers;
    }

    public void _persistence_set_canceledUsers(Integer n) {
        this._persistence_checkFetchedForSet("canceledUsers");
        this._persistence_propertyChange("canceledUsers", this.canceledUsers, n);
        this.canceledUsers = n;
    }

    public Integer _persistence_get_skippedUsers() {
        this._persistence_checkFetched("skippedUsers");
        return this.skippedUsers;
    }

    public void _persistence_set_skippedUsers(Integer n) {
        this._persistence_checkFetchedForSet("skippedUsers");
        this._persistence_propertyChange("skippedUsers", this.skippedUsers, n);
        this.skippedUsers = n;
    }

    public Set _persistence_get_users() {
        this._persistence_checkFetched("users");
        return this.users;
    }

    public void _persistence_set_users(Set set) {
        this._persistence_checkFetchedForSet("users");
        this._persistence_propertyChange("users", this.users, set);
        this.users = set;
    }

    protected void _persistence_initialize_network_vh() {
        if (this._persistence_network_vh == null) {
            this._persistence_network_vh = new ValueHolder((Object)this.network);
            this._persistence_network_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_network_vh() {
        Network network;
        this._persistence_initialize_network_vh();
        if ((this._persistence_network_vh.isCoordinatedWithProperty() || this._persistence_network_vh.isNewlyWeavedValueHolder()) && (network = this._persistence_get_network()) != this._persistence_network_vh.getValue()) {
            this._persistence_set_network(network);
        }
        return this._persistence_network_vh;
    }

    public void _persistence_set_network_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_network_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Network network = this._persistence_get_network();
            if (network != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_network((Network)object);
            }
        } else {
            this.network = null;
        }
    }

    public Network _persistence_get_network() {
        this._persistence_checkFetched("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        return this.network;
    }

    public void _persistence_set_network(Network network) {
        this._persistence_checkFetchedForSet("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        this._persistence_propertyChange("network", this.network, network);
        this.network = network;
        this._persistence_network_vh.setValue((Object)network);
    }

    public Boolean _persistence_get_archived() {
        this._persistence_checkFetched("archived");
        return this.archived;
    }

    public void _persistence_set_archived(Boolean bl) {
        this._persistence_checkFetchedForSet("archived");
        this._persistence_propertyChange("archived", this.archived, bl);
        this.archived = bl;
    }

    public Integer _persistence_get_successUsers() {
        this._persistence_checkFetched("successUsers");
        return this.successUsers;
    }

    public void _persistence_set_successUsers(Integer n) {
        this._persistence_checkFetchedForSet("successUsers");
        this._persistence_propertyChange("successUsers", this.successUsers, n);
        this.successUsers = n;
    }

    protected void _persistence_initialize_by_vh() {
        if (this._persistence_by_vh == null) {
            this._persistence_by_vh = new ValueHolder((Object)this.by);
            this._persistence_by_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_by_vh() {
        BasicUser basicUser;
        this._persistence_initialize_by_vh();
        if ((this._persistence_by_vh.isCoordinatedWithProperty() || this._persistence_by_vh.isNewlyWeavedValueHolder()) && (basicUser = this._persistence_get_by()) != this._persistence_by_vh.getValue()) {
            this._persistence_set_by(basicUser);
        }
        return this._persistence_by_vh;
    }

    public void _persistence_set_by_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_by_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            BasicUser basicUser = this._persistence_get_by();
            if (basicUser != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_by((BasicUser)object);
            }
        } else {
            this.by = null;
        }
    }

    public BasicUser _persistence_get_by() {
        this._persistence_checkFetched("by");
        this._persistence_initialize_by_vh();
        this.by = (BasicUser)this._persistence_by_vh.getValue();
        return this.by;
    }

    public void _persistence_set_by(BasicUser basicUser) {
        this._persistence_checkFetchedForSet("by");
        this._persistence_initialize_by_vh();
        this.by = (BasicUser)this._persistence_by_vh.getValue();
        this._persistence_propertyChange("by", this.by, basicUser);
        this.by = basicUser;
        this._persistence_by_vh.setValue((Object)basicUser);
    }

    public Integer _persistence_get_errorUsers() {
        this._persistence_checkFetched("errorUsers");
        return this.errorUsers;
    }

    public void _persistence_set_errorUsers(Integer n) {
        this._persistence_checkFetchedForSet("errorUsers");
        this._persistence_propertyChange("errorUsers", this.errorUsers, n);
        this.errorUsers = n;
    }

    public List _persistence_get_files() {
        this._persistence_checkFetched("files");
        return this.files;
    }

    public void _persistence_set_files(List list) {
        this._persistence_checkFetchedForSet("files");
        this._persistence_propertyChange("files", this.files, list);
        this.files = list;
    }

    public Date _persistence_get_finishDate() {
        this._persistence_checkFetched("finishDate");
        return this.finishDate;
    }

    public void _persistence_set_finishDate(Date date) {
        this._persistence_checkFetchedForSet("finishDate");
        this._persistence_propertyChange("finishDate", this.finishDate, date);
        this.finishDate = date;
    }

    public Integer _persistence_get_pendingUsers() {
        this._persistence_checkFetched("pendingUsers");
        return this.pendingUsers;
    }

    public void _persistence_set_pendingUsers(Integer n) {
        this._persistence_checkFetchedForSet("pendingUsers");
        this._persistence_propertyChange("pendingUsers", this.pendingUsers, n);
        this.pendingUsers = n;
    }

    public BulkActionStatus _persistence_get_status() {
        this._persistence_checkFetched("status");
        return this.status;
    }

    public void _persistence_set_status(BulkActionStatus bulkActionStatus) {
        this._persistence_checkFetchedForSet("status");
        this._persistence_propertyChange("status", this.status, bulkActionStatus);
        this.status = bulkActionStatus;
    }
}

