/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.users;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.access.Otp;
import org.cyclos.entities.access.OtpOwner;
import org.cyclos.entities.access.Password;
import org.cyclos.entities.access.Pin;
import org.cyclos.entities.access.Token;
import org.cyclos.entities.access.TotpSecret;
import org.cyclos.entities.access.UserAgent;
import org.cyclos.entities.access.UserFailedActionLog;
import org.cyclos.entities.access.UserIdentityProvider;
import org.cyclos.entities.banking.UserAccountVisibilitySettings;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.entities.messaging.Notification;
import org.cyclos.entities.messaging.NotificationSettings;
import org.cyclos.entities.messaging.OutboundSms;
import org.cyclos.entities.system.DefinesNetwork;
import org.cyclos.entities.system.EntityWithCustomValues;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.AccessLog;
import org.cyclos.entities.users.LandLinePhone;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.Phone;
import org.cyclos.entities.users.RoleContainer;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserActivity;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.users.UserCustomFieldPossibleValue;
import org.cyclos.entities.users.UserCustomFieldPossibleValueCategory;
import org.cyclos.entities.users.UserCustomFieldValue;
import org.cyclos.entities.users.UserFcmToken;
import org.cyclos.entities.users.UserImage;
import org.cyclos.entities.users.UserStatusLog;
import org.cyclos.entities.users.ValidationKeyType;
import org.cyclos.model.INamedEntity;
import org.cyclos.model.access.Role;
import org.cyclos.model.access.SecurityQuestion;
import org.cyclos.model.system.configurations.Frontend;
import org.cyclos.model.users.users.IUser;
import org.cyclos.model.users.users.UserNature;
import org.cyclos.model.users.users.UserRegistration;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="users", indexes={@Index(name="ix_users_name", columnList="lower(cy_immutable_unaccent(name))"), @Index(name="ix_users_username", columnList="lower(username)"), @Index(name="ix_users_status", columnList="status"), @Index(name="ix_users_email", columnList="lower(email)"), @Index(name="ix_users_new_email", columnList="lower(new_email)"), @Index(name="ix_users_creation_date", columnList="creation_date")})
@DiscriminatorColumn(name="subclass")
public abstract class BasicUser
extends BaseEntity
implements IUser,
INamedEntity,
DefinesNetwork,
RoleContainer,
OtpOwner,
EntityWithCustomValues<UserCustomField, UserCustomFieldPossibleValueCategory, UserCustomFieldPossibleValue, UserCustomFieldValue>,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @Basic
    @Column(name="send_activation_email", nullable=false)
    private boolean sendActivationEmail;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="subclass", insertable=false, updatable=false)
    private UserNature nature;
    @Basic
    @Column(name="username", nullable=false)
    private String username;
    @Basic
    @Column(name="name", length=200)
    private String name;
    @Basic
    @Column(name="display_for_managers")
    private String displayForManagers;
    @Basic
    @Column(name="display_for_others")
    private String displayForOthers;
    @Column(name="operator_user_id", insertable=false, updatable=false)
    private Long operatorUserId;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="image_id")
    protected UserImage image;
    @Basic
    @Lob
    @Column(name="broker_ids")
    protected String brokerIds;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="creation_date", nullable=false)
    private Date creationDate;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="validation_key_type")
    private ValidationKeyType validationKeyType;
    @Basic
    @Column(name="validation_key")
    private String validationKey;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="validation_key_date")
    private Date validationKeyDate;
    @Transient
    private String identityProviderRequestId;
    @Basic
    @Column(name="email")
    private String email;
    @Basic
    @Column(name="email_verified")
    private Boolean emailVerified;
    @Basic
    @Column(name="new_email")
    private String newEmail;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="security_question")
    private SecurityQuestion securityQuestion;
    @Basic
    @Lob
    @Column(name="security_answer")
    private String securityAnswer;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="status")
    private UserStatus status;
    @Basic
    @Column(name="registration_confirmation_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date registrationConfirmationDate;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="registration_type")
    private UserRegistration registrationType;
    @Basic
    @Lob
    @Column(name="password_statuses")
    private String passwordStatuses;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="registered_by_id")
    private BasicUser registeredBy;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="network_id")
    private Network network;
    @Basic
    @Column(name="locale")
    private String locale;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="frontend")
    private Frontend frontend;
    @OneToMany(mappedBy="basicUser", cascade={CascadeType.REMOVE})
    private Set<UserIdentityProvider> identityProviders;
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE})
    private Set<Token> tokens = new HashSet<Token>();
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE})
    private Set<TotpSecret> totpSecrets;
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE})
    private Set<UserStatusLog> statusLogs = new HashSet<UserStatusLog>();
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE})
    private Set<AccessLog> loginHistory = new HashSet<AccessLog>();
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE})
    private Set<Password> passwords = new HashSet<Password>();
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE})
    private Set<Phone> phones = new HashSet<Phone>();
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE})
    private Set<OutboundSms> outboundSms = new HashSet<OutboundSms>();
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE})
    private Set<UserAgent> userAgents = new HashSet<UserAgent>();
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE})
    private Set<UserFailedActionLog> failedActionLogs = new HashSet<UserFailedActionLog>();
    @ManyToMany
    @JoinTable(name="users_favorite_ads", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="ad_id")})
    private Set<BasicAd> favoriteAds;
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE})
    private Set<NotificationSettings> notificationSettings;
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE})
    private Set<Notification> userNotifications;
    @OneToMany(mappedBy="owner", cascade={CascadeType.ALL})
    private Set<UserCustomFieldValue> customValues = new HashSet<UserCustomFieldValue>();
    @OneToMany(mappedBy="basicUser", cascade={CascadeType.REMOVE})
    private Set<UserActivity> activities;
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE})
    private Set<Pin> pins;
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE})
    private Set<UserAccountVisibilitySettings> visibilitySettings;
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE})
    private Set<UserFcmToken> fcmTokens = new HashSet<UserFcmToken>();
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE})
    private Set<Otp> otps = new HashSet<Otp>();
    static final long serialVersionUID = 8228806603546689531L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_registeredBy_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_network_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_image_vh;

    public void addFcmToken(UserFcmToken userFcmToken) {
        userFcmToken.setUser(this);
        this._persistence_get_fcmTokens().add(userFcmToken);
    }

    public UserActivity getActivity() {
        return (UserActivity)CollectionHelper.first((Iterable)this._persistence_get_activities());
    }

    public Date getCreationDate() {
        return this._persistence_get_creationDate();
    }

    @Override
    public Class<UserCustomField> getCustomFieldClass() {
        return UserCustomField.class;
    }

    @Override
    public Class<UserCustomFieldValue> getCustomFieldValueClass() {
        return UserCustomFieldValue.class;
    }

    @Override
    public Set<UserCustomFieldValue> getCustomValues() {
        return this._persistence_get_customValues();
    }

    public String getDisplayForManagers() {
        return this._persistence_get_displayForManagers();
    }

    public String getDisplayForOthers() {
        return this._persistence_get_displayForOthers();
    }

    public String getEmail() {
        return this._persistence_get_email();
    }

    public Set<BasicAd> getFavoriteAds() {
        return this._persistence_get_favoriteAds();
    }

    public Set<UserFcmToken> getFcmTokens() {
        return this._persistence_get_fcmTokens();
    }

    public Frontend getFrontend() {
        return this._persistence_get_frontend();
    }

    public String getIdentityProviderRequestId() {
        return this.identityProviderRequestId;
    }

    public List<LandLinePhone> getLandLinePhones() {
        return this.getPhones(LandLinePhone.class);
    }

    public String getLocale() {
        return this._persistence_get_locale();
    }

    public abstract Role getMainRole();

    public Date getMessagesLastViewDate() {
        UserActivity userActivity = this.getActivity();
        return userActivity == null ? null : userActivity.getMessageAlert();
    }

    public List<MobilePhone> getMobilePhones() {
        return this.getPhones(MobilePhone.class);
    }

    public String getName() {
        return this._persistence_get_name();
    }

    public abstract UserNature getNature();

    @Override
    public Network getNetwork() {
        return this._persistence_get_network();
    }

    public String getNewEmail() {
        return this._persistence_get_newEmail();
    }

    public Date getNotificationsLastViewDate() {
        UserActivity userActivity = this.getActivity();
        return userActivity == null ? null : userActivity.getNotificationAlert();
    }

    @Override
    public String getOtpOwnerPathName() {
        return "user";
    }

    @Override
    public Set<Otp> getOtps() {
        return this._persistence_get_otps();
    }

    @Override
    public BasicUser getOtpUser() {
        return this;
    }

    public Set<Password> getPasswords() {
        return this._persistence_get_passwords();
    }

    public String getPasswordStatuses() {
        return this._persistence_get_passwordStatuses();
    }

    public Set<Phone> getPhones() {
        return this._persistence_get_phones();
    }

    public LandLinePhone getPreferredLandLinePhone() {
        for (Phone phone : this.getPhones()) {
            if (!(phone instanceof LandLinePhone)) continue;
            return (LandLinePhone)phone;
        }
        return null;
    }

    public MobilePhone getPreferredMobilePhone() {
        MobilePhone mobilePhone = null;
        for (Phone phone : this.getPhones()) {
            if (!(phone instanceof MobilePhone)) continue;
            MobilePhone mobilePhone2 = (MobilePhone)phone;
            if (mobilePhone2.isVerified()) {
                return mobilePhone2;
            }
            if (mobilePhone != null) continue;
            mobilePhone = mobilePhone2;
        }
        return mobilePhone;
    }

    public Phone getPreferredPhone() {
        MobilePhone mobilePhone = this.getPreferredMobilePhone();
        if (mobilePhone != null) {
            return mobilePhone;
        }
        return (Phone)CollectionHelper.first(this.getPhones());
    }

    public BasicUser getRegisteredBy() {
        return this._persistence_get_registeredBy();
    }

    public Date getRegistrationConfirmationDate() {
        return this._persistence_get_registrationConfirmationDate();
    }

    public UserRegistration getRegistrationType() {
        return this._persistence_get_registrationType();
    }

    public String getSecurityAnswer() {
        return this._persistence_get_securityAnswer();
    }

    public SecurityQuestion getSecurityQuestion() {
        return this._persistence_get_securityQuestion();
    }

    public UserStatus getStatus() {
        return this._persistence_get_status();
    }

    public TotpSecret getTotpSecret() {
        return (TotpSecret)CollectionHelper.first((Iterable)this._persistence_get_totpSecrets());
    }

    public abstract User getUser();

    public String getUsername() {
        return this._persistence_get_username();
    }

    public String getValidationKey() {
        return this._persistence_get_validationKey();
    }

    public Date getValidationKeyDate() {
        return this._persistence_get_validationKeyDate();
    }

    public ValidationKeyType getValidationKeyType() {
        return this._persistence_get_validationKeyType();
    }

    public boolean hasMobileEnabledForSMS() {
        for (Phone phone : this.getPhones()) {
            MobilePhone mobilePhone;
            if (!(phone instanceof MobilePhone) || !(mobilePhone = (MobilePhone)phone).isEnabledForSms()) continue;
            return true;
        }
        return false;
    }

    public boolean hasVerifiedMobilePhone() {
        MobilePhone mobilePhone = this.getPreferredMobilePhone();
        return mobilePhone != null && mobilePhone.isVerified();
    }

    public boolean isActive() {
        return this._persistence_get_status() == UserStatus.ACTIVE;
    }

    @Override
    public boolean isAdmin() {
        return false;
    }

    @Override
    public boolean isAliasOperator() {
        return false;
    }

    public boolean isBlocked() {
        return this._persistence_get_status() == UserStatus.BLOCKED;
    }

    @Override
    public boolean isBroker() {
        return false;
    }

    public boolean isEmailVerified() {
        return Boolean.TRUE.equals(this._persistence_get_emailVerified());
    }

    @Override
    public boolean isGlobalAdmin() {
        return false;
    }

    public boolean isInactive() {
        return this._persistence_get_status() == UserStatus.DISABLED;
    }

    @Override
    public boolean isMember() {
        return false;
    }

    @Override
    public boolean isNetworkAdmin() {
        return false;
    }

    @Override
    public boolean isOperator() {
        return false;
    }

    public boolean isPendingNewEmailValidation() {
        return StringHelper.isNotBlank((Object)this.getNewEmail());
    }

    public boolean isPendingValidation() {
        return this._persistence_get_status() == UserStatus.PENDING;
    }

    public boolean isPurged() {
        return this._persistence_get_status() == UserStatus.PURGED;
    }

    public boolean isRemoved() {
        return this._persistence_get_status() == UserStatus.REMOVED || this._persistence_get_status() == UserStatus.PURGED;
    }

    @Override
    public boolean isRestrictedOperator() {
        return false;
    }

    public boolean isSendActivationEmail() {
        return this._persistence_get_sendActivationEmail();
    }

    @Override
    public boolean isUserManager() {
        return this.isAdmin() || this.isBroker();
    }

    public void removeFcmToken(UserFcmToken userFcmToken) {
        userFcmToken.setUser(null);
        this._persistence_get_fcmTokens().remove(userFcmToken);
    }

    public void setActivity(UserActivity userActivity) {
        this._persistence_set_activities(CollectionHelper.asSet((Object[])new UserActivity[]{userActivity}));
    }

    @Override
    public void setAsOwnerFor(Otp otp) {
        otp.setUser(this);
    }

    public void setCreationDate(Date date) {
        this._persistence_set_creationDate(date);
    }

    public void setCustomValues(Set<UserCustomFieldValue> set) {
        this._persistence_set_customValues(set);
    }

    public void setDisplayForManagers(String string) {
        this._persistence_set_displayForManagers(string);
    }

    public void setDisplayForOthers(String string) {
        this._persistence_set_displayForOthers(string);
    }

    public void setEmail(String string) {
        this._persistence_set_email(string);
    }

    public void setEmailVerified(boolean bl) {
        this._persistence_set_emailVerified(bl);
    }

    public void setFavoriteAds(Set<BasicAd> set) {
        this._persistence_set_favoriteAds(set);
    }

    public void setFcmTokens(Set<UserFcmToken> set) {
        this._persistence_set_fcmTokens(set);
    }

    public void setFrontend(Frontend frontend) {
        this._persistence_set_frontend(frontend);
    }

    public void setIdentityProviderRequestId(String string) {
        this.identityProviderRequestId = string;
    }

    public void setLocale(String string) {
        this._persistence_set_locale(string);
    }

    public void setName(String string) {
        this._persistence_set_name(string);
    }

    @Override
    public void setNetwork(Network network) {
        this._persistence_set_network(network);
    }

    public void setNewEmail(String string) {
        this._persistence_set_newEmail(string);
    }

    public void setPasswords(Set<Password> set) {
        this._persistence_set_passwords(set);
    }

    public void setPasswordStatuses(String string) {
        this._persistence_set_passwordStatuses(string);
    }

    public void setPhones(Set<Phone> set) {
        this._persistence_set_phones(set);
    }

    public void setRegisteredBy(BasicUser basicUser) {
        this._persistence_set_registeredBy(basicUser);
    }

    public void setRegistrationConfirmationDate(Date date) {
        this._persistence_set_registrationConfirmationDate(date);
    }

    public void setRegistrationType(UserRegistration userRegistration) {
        this._persistence_set_registrationType(userRegistration);
    }

    public void setSecurityAnswer(String string) {
        this._persistence_set_securityAnswer(string);
    }

    public void setSecurityQuestion(SecurityQuestion securityQuestion) {
        this._persistence_set_securityQuestion(securityQuestion);
    }

    public void setSendActivationEmail(boolean bl) {
        this._persistence_set_sendActivationEmail(bl);
    }

    public void setStatus(UserStatus userStatus) {
        this._persistence_set_status(userStatus);
    }

    public void setTotpSecret(TotpSecret totpSecret) {
        this._persistence_set_totpSecrets(CollectionHelper.asSet((Object[])new TotpSecret[]{totpSecret}));
    }

    public void setUsername(String string) {
        this._persistence_set_username(string);
    }

    public void setValidationKey(String string) {
        this._persistence_set_validationKey(string);
    }

    public void setValidationKeyDate(Date date) {
        this._persistence_set_validationKeyDate(date);
    }

    public void setValidationKeyType(ValidationKeyType validationKeyType) {
        this._persistence_set_validationKeyType(validationKeyType);
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this._persistence_get_name();
    }

    private <P extends Phone> List<P> getPhones(Class<P> clazz) {
        return this.getPhones().stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_registeredBy_vh != null) {
            this._persistence_registeredBy_vh = (WeavedAttributeValueHolderInterface)this._persistence_registeredBy_vh.clone();
        }
        if (this._persistence_network_vh != null) {
            this._persistence_network_vh = (WeavedAttributeValueHolderInterface)this._persistence_network_vh.clone();
        }
        if (this._persistence_image_vh != null) {
            this._persistence_image_vh = (WeavedAttributeValueHolderInterface)this._persistence_image_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new BasicUser();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "registeredBy") {
            return this.registeredBy;
        }
        if (string == "displayForManagers") {
            return this.displayForManagers;
        }
        if (string == "securityAnswer") {
            return this.securityAnswer;
        }
        if (string == "statusLogs") {
            return this.statusLogs;
        }
        if (string == "visibilitySettings") {
            return this.visibilitySettings;
        }
        if (string == "userAgents") {
            return this.userAgents;
        }
        if (string == "passwordStatuses") {
            return this.passwordStatuses;
        }
        if (string == "phones") {
            return this.phones;
        }
        if (string == "pins") {
            return this.pins;
        }
        if (string == "locale") {
            return this.locale;
        }
        if (string == "validationKey") {
            return this.validationKey;
        }
        if (string == "network") {
            return this.network;
        }
        if (string == "notificationSettings") {
            return this.notificationSettings;
        }
        if (string == "fcmTokens") {
            return this.fcmTokens;
        }
        if (string == "favoriteAds") {
            return this.favoriteAds;
        }
        if (string == "sendActivationEmail") {
            return this.sendActivationEmail;
        }
        if (string == "displayForOthers") {
            return this.displayForOthers;
        }
        if (string == "passwords") {
            return this.passwords;
        }
        if (string == "loginHistory") {
            return this.loginHistory;
        }
        if (string == "tokens") {
            return this.tokens;
        }
        if (string == "otps") {
            return this.otps;
        }
        if (string == "email") {
            return this.email;
        }
        if (string == "customValues") {
            return this.customValues;
        }
        if (string == "registrationConfirmationDate") {
            return this.registrationConfirmationDate;
        }
        if (string == "image") {
            return this.image;
        }
        if (string == "identityProviders") {
            return this.identityProviders;
        }
        if (string == "validationKeyType") {
            return this.validationKeyType;
        }
        if (string == "nature") {
            return this.nature;
        }
        if (string == "securityQuestion") {
            return this.securityQuestion;
        }
        if (string == "validationKeyDate") {
            return this.validationKeyDate;
        }
        if (string == "totpSecrets") {
            return this.totpSecrets;
        }
        if (string == "creationDate") {
            return this.creationDate;
        }
        if (string == "outboundSms") {
            return this.outboundSms;
        }
        if (string == "userNotifications") {
            return this.userNotifications;
        }
        if (string == "operatorUserId") {
            return this.operatorUserId;
        }
        if (string == "emailVerified") {
            return this.emailVerified;
        }
        if (string == "registrationType") {
            return this.registrationType;
        }
        if (string == "activities") {
            return this.activities;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "brokerIds") {
            return this.brokerIds;
        }
        if (string == "failedActionLogs") {
            return this.failedActionLogs;
        }
        if (string == "newEmail") {
            return this.newEmail;
        }
        if (string == "frontend") {
            return this.frontend;
        }
        if (string == "username") {
            return this.username;
        }
        if (string == "status") {
            return this.status;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "registeredBy") {
            this.registeredBy = (BasicUser)object;
            return;
        }
        if (string == "displayForManagers") {
            this.displayForManagers = (String)object;
            return;
        }
        if (string == "securityAnswer") {
            this.securityAnswer = (String)object;
            return;
        }
        if (string == "statusLogs") {
            this.statusLogs = (Set)object;
            return;
        }
        if (string == "visibilitySettings") {
            this.visibilitySettings = (Set)object;
            return;
        }
        if (string == "userAgents") {
            this.userAgents = (Set)object;
            return;
        }
        if (string == "passwordStatuses") {
            this.passwordStatuses = (String)object;
            return;
        }
        if (string == "phones") {
            this.phones = (Set)object;
            return;
        }
        if (string == "pins") {
            this.pins = (Set)object;
            return;
        }
        if (string == "locale") {
            this.locale = (String)object;
            return;
        }
        if (string == "validationKey") {
            this.validationKey = (String)object;
            return;
        }
        if (string == "network") {
            this.network = (Network)object;
            return;
        }
        if (string == "notificationSettings") {
            this.notificationSettings = (Set)object;
            return;
        }
        if (string == "fcmTokens") {
            this.fcmTokens = (Set)object;
            return;
        }
        if (string == "favoriteAds") {
            this.favoriteAds = (Set)object;
            return;
        }
        if (string == "sendActivationEmail") {
            this.sendActivationEmail = (Boolean)object;
            return;
        }
        if (string == "displayForOthers") {
            this.displayForOthers = (String)object;
            return;
        }
        if (string == "passwords") {
            this.passwords = (Set)object;
            return;
        }
        if (string == "loginHistory") {
            this.loginHistory = (Set)object;
            return;
        }
        if (string == "tokens") {
            this.tokens = (Set)object;
            return;
        }
        if (string == "otps") {
            this.otps = (Set)object;
            return;
        }
        if (string == "email") {
            this.email = (String)object;
            return;
        }
        if (string == "customValues") {
            this.customValues = (Set)object;
            return;
        }
        if (string == "registrationConfirmationDate") {
            this.registrationConfirmationDate = (Date)object;
            return;
        }
        if (string == "image") {
            this.image = (UserImage)object;
            return;
        }
        if (string == "identityProviders") {
            this.identityProviders = (Set)object;
            return;
        }
        if (string == "validationKeyType") {
            this.validationKeyType = (ValidationKeyType)((Object)object);
            return;
        }
        if (string == "nature") {
            this.nature = (UserNature)object;
            return;
        }
        if (string == "securityQuestion") {
            this.securityQuestion = (SecurityQuestion)object;
            return;
        }
        if (string == "validationKeyDate") {
            this.validationKeyDate = (Date)object;
            return;
        }
        if (string == "totpSecrets") {
            this.totpSecrets = (Set)object;
            return;
        }
        if (string == "creationDate") {
            this.creationDate = (Date)object;
            return;
        }
        if (string == "outboundSms") {
            this.outboundSms = (Set)object;
            return;
        }
        if (string == "userNotifications") {
            this.userNotifications = (Set)object;
            return;
        }
        if (string == "operatorUserId") {
            this.operatorUserId = (Long)object;
            return;
        }
        if (string == "emailVerified") {
            this.emailVerified = (Boolean)object;
            return;
        }
        if (string == "registrationType") {
            this.registrationType = (UserRegistration)object;
            return;
        }
        if (string == "activities") {
            this.activities = (Set)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "brokerIds") {
            this.brokerIds = (String)object;
            return;
        }
        if (string == "failedActionLogs") {
            this.failedActionLogs = (Set)object;
            return;
        }
        if (string == "newEmail") {
            this.newEmail = (String)object;
            return;
        }
        if (string == "frontend") {
            this.frontend = (Frontend)object;
            return;
        }
        if (string == "username") {
            this.username = (String)object;
            return;
        }
        if (string == "status") {
            this.status = (UserStatus)object;
            return;
        }
        super._persistence_set(string, object);
    }

    protected void _persistence_initialize_registeredBy_vh() {
        if (this._persistence_registeredBy_vh == null) {
            this._persistence_registeredBy_vh = new ValueHolder((Object)this.registeredBy);
            this._persistence_registeredBy_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_registeredBy_vh() {
        BasicUser basicUser;
        this._persistence_initialize_registeredBy_vh();
        if ((this._persistence_registeredBy_vh.isCoordinatedWithProperty() || this._persistence_registeredBy_vh.isNewlyWeavedValueHolder()) && (basicUser = this._persistence_get_registeredBy()) != this._persistence_registeredBy_vh.getValue()) {
            this._persistence_set_registeredBy(basicUser);
        }
        return this._persistence_registeredBy_vh;
    }

    public void _persistence_set_registeredBy_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_registeredBy_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            BasicUser basicUser = this._persistence_get_registeredBy();
            if (basicUser != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_registeredBy((BasicUser)object);
            }
        } else {
            this.registeredBy = null;
        }
    }

    public BasicUser _persistence_get_registeredBy() {
        this._persistence_checkFetched("registeredBy");
        this._persistence_initialize_registeredBy_vh();
        this.registeredBy = (BasicUser)this._persistence_registeredBy_vh.getValue();
        return this.registeredBy;
    }

    public void _persistence_set_registeredBy(BasicUser basicUser) {
        this._persistence_checkFetchedForSet("registeredBy");
        this._persistence_initialize_registeredBy_vh();
        this.registeredBy = (BasicUser)this._persistence_registeredBy_vh.getValue();
        this._persistence_propertyChange("registeredBy", this.registeredBy, basicUser);
        this.registeredBy = basicUser;
        this._persistence_registeredBy_vh.setValue((Object)basicUser);
    }

    public String _persistence_get_displayForManagers() {
        this._persistence_checkFetched("displayForManagers");
        return this.displayForManagers;
    }

    public void _persistence_set_displayForManagers(String string) {
        this._persistence_checkFetchedForSet("displayForManagers");
        this._persistence_propertyChange("displayForManagers", this.displayForManagers, string);
        this.displayForManagers = string;
    }

    public String _persistence_get_securityAnswer() {
        this._persistence_checkFetched("securityAnswer");
        return this.securityAnswer;
    }

    public void _persistence_set_securityAnswer(String string) {
        this._persistence_checkFetchedForSet("securityAnswer");
        this._persistence_propertyChange("securityAnswer", this.securityAnswer, string);
        this.securityAnswer = string;
    }

    public Set _persistence_get_statusLogs() {
        this._persistence_checkFetched("statusLogs");
        return this.statusLogs;
    }

    public void _persistence_set_statusLogs(Set set) {
        this._persistence_checkFetchedForSet("statusLogs");
        this._persistence_propertyChange("statusLogs", this.statusLogs, set);
        this.statusLogs = set;
    }

    public Set _persistence_get_visibilitySettings() {
        this._persistence_checkFetched("visibilitySettings");
        return this.visibilitySettings;
    }

    public void _persistence_set_visibilitySettings(Set set) {
        this._persistence_checkFetchedForSet("visibilitySettings");
        this._persistence_propertyChange("visibilitySettings", this.visibilitySettings, set);
        this.visibilitySettings = set;
    }

    public Set _persistence_get_userAgents() {
        this._persistence_checkFetched("userAgents");
        return this.userAgents;
    }

    public void _persistence_set_userAgents(Set set) {
        this._persistence_checkFetchedForSet("userAgents");
        this._persistence_propertyChange("userAgents", this.userAgents, set);
        this.userAgents = set;
    }

    public String _persistence_get_passwordStatuses() {
        this._persistence_checkFetched("passwordStatuses");
        return this.passwordStatuses;
    }

    public void _persistence_set_passwordStatuses(String string) {
        this._persistence_checkFetchedForSet("passwordStatuses");
        this._persistence_propertyChange("passwordStatuses", this.passwordStatuses, string);
        this.passwordStatuses = string;
    }

    public Set _persistence_get_phones() {
        this._persistence_checkFetched("phones");
        return this.phones;
    }

    public void _persistence_set_phones(Set set) {
        this._persistence_checkFetchedForSet("phones");
        this._persistence_propertyChange("phones", this.phones, set);
        this.phones = set;
    }

    public Set _persistence_get_pins() {
        this._persistence_checkFetched("pins");
        return this.pins;
    }

    public void _persistence_set_pins(Set set) {
        this._persistence_checkFetchedForSet("pins");
        this._persistence_propertyChange("pins", this.pins, set);
        this.pins = set;
    }

    public String _persistence_get_locale() {
        this._persistence_checkFetched("locale");
        return this.locale;
    }

    public void _persistence_set_locale(String string) {
        this._persistence_checkFetchedForSet("locale");
        this._persistence_propertyChange("locale", this.locale, string);
        this.locale = string;
    }

    public String _persistence_get_validationKey() {
        this._persistence_checkFetched("validationKey");
        return this.validationKey;
    }

    public void _persistence_set_validationKey(String string) {
        this._persistence_checkFetchedForSet("validationKey");
        this._persistence_propertyChange("validationKey", this.validationKey, string);
        this.validationKey = string;
    }

    protected void _persistence_initialize_network_vh() {
        if (this._persistence_network_vh == null) {
            this._persistence_network_vh = new ValueHolder((Object)this.network);
            this._persistence_network_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_network_vh() {
        Network network;
        this._persistence_initialize_network_vh();
        if ((this._persistence_network_vh.isCoordinatedWithProperty() || this._persistence_network_vh.isNewlyWeavedValueHolder()) && (network = this._persistence_get_network()) != this._persistence_network_vh.getValue()) {
            this._persistence_set_network(network);
        }
        return this._persistence_network_vh;
    }

    public void _persistence_set_network_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_network_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Network network = this._persistence_get_network();
            if (network != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_network((Network)object);
            }
        } else {
            this.network = null;
        }
    }

    public Network _persistence_get_network() {
        this._persistence_checkFetched("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        return this.network;
    }

    public void _persistence_set_network(Network network) {
        this._persistence_checkFetchedForSet("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        this._persistence_propertyChange("network", this.network, network);
        this.network = network;
        this._persistence_network_vh.setValue((Object)network);
    }

    public Set _persistence_get_notificationSettings() {
        this._persistence_checkFetched("notificationSettings");
        return this.notificationSettings;
    }

    public void _persistence_set_notificationSettings(Set set) {
        this._persistence_checkFetchedForSet("notificationSettings");
        this._persistence_propertyChange("notificationSettings", this.notificationSettings, set);
        this.notificationSettings = set;
    }

    public Set _persistence_get_fcmTokens() {
        this._persistence_checkFetched("fcmTokens");
        return this.fcmTokens;
    }

    public void _persistence_set_fcmTokens(Set set) {
        this._persistence_checkFetchedForSet("fcmTokens");
        this._persistence_propertyChange("fcmTokens", this.fcmTokens, set);
        this.fcmTokens = set;
    }

    public Set _persistence_get_favoriteAds() {
        this._persistence_checkFetched("favoriteAds");
        return this.favoriteAds;
    }

    public void _persistence_set_favoriteAds(Set set) {
        this._persistence_checkFetchedForSet("favoriteAds");
        this._persistence_propertyChange("favoriteAds", this.favoriteAds, set);
        this.favoriteAds = set;
    }

    public boolean _persistence_get_sendActivationEmail() {
        this._persistence_checkFetched("sendActivationEmail");
        return this.sendActivationEmail;
    }

    public void _persistence_set_sendActivationEmail(boolean bl) {
        this._persistence_checkFetchedForSet("sendActivationEmail");
        this._persistence_propertyChange("sendActivationEmail", new Boolean(this.sendActivationEmail), new Boolean(bl));
        this.sendActivationEmail = bl;
    }

    public String _persistence_get_displayForOthers() {
        this._persistence_checkFetched("displayForOthers");
        return this.displayForOthers;
    }

    public void _persistence_set_displayForOthers(String string) {
        this._persistence_checkFetchedForSet("displayForOthers");
        this._persistence_propertyChange("displayForOthers", this.displayForOthers, string);
        this.displayForOthers = string;
    }

    public Set _persistence_get_passwords() {
        this._persistence_checkFetched("passwords");
        return this.passwords;
    }

    public void _persistence_set_passwords(Set set) {
        this._persistence_checkFetchedForSet("passwords");
        this._persistence_propertyChange("passwords", this.passwords, set);
        this.passwords = set;
    }

    public Set _persistence_get_loginHistory() {
        this._persistence_checkFetched("loginHistory");
        return this.loginHistory;
    }

    public void _persistence_set_loginHistory(Set set) {
        this._persistence_checkFetchedForSet("loginHistory");
        this._persistence_propertyChange("loginHistory", this.loginHistory, set);
        this.loginHistory = set;
    }

    public Set _persistence_get_tokens() {
        this._persistence_checkFetched("tokens");
        return this.tokens;
    }

    public void _persistence_set_tokens(Set set) {
        this._persistence_checkFetchedForSet("tokens");
        this._persistence_propertyChange("tokens", this.tokens, set);
        this.tokens = set;
    }

    public Set _persistence_get_otps() {
        this._persistence_checkFetched("otps");
        return this.otps;
    }

    public void _persistence_set_otps(Set set) {
        this._persistence_checkFetchedForSet("otps");
        this._persistence_propertyChange("otps", this.otps, set);
        this.otps = set;
    }

    public String _persistence_get_email() {
        this._persistence_checkFetched("email");
        return this.email;
    }

    public void _persistence_set_email(String string) {
        this._persistence_checkFetchedForSet("email");
        this._persistence_propertyChange("email", this.email, string);
        this.email = string;
    }

    public Set _persistence_get_customValues() {
        this._persistence_checkFetched("customValues");
        return this.customValues;
    }

    public void _persistence_set_customValues(Set set) {
        this._persistence_checkFetchedForSet("customValues");
        this._persistence_propertyChange("customValues", this.customValues, set);
        this.customValues = set;
    }

    public Date _persistence_get_registrationConfirmationDate() {
        this._persistence_checkFetched("registrationConfirmationDate");
        return this.registrationConfirmationDate;
    }

    public void _persistence_set_registrationConfirmationDate(Date date) {
        this._persistence_checkFetchedForSet("registrationConfirmationDate");
        this._persistence_propertyChange("registrationConfirmationDate", this.registrationConfirmationDate, date);
        this.registrationConfirmationDate = date;
    }

    protected void _persistence_initialize_image_vh() {
        if (this._persistence_image_vh == null) {
            this._persistence_image_vh = new ValueHolder((Object)this.image);
            this._persistence_image_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_image_vh() {
        UserImage userImage;
        this._persistence_initialize_image_vh();
        if ((this._persistence_image_vh.isCoordinatedWithProperty() || this._persistence_image_vh.isNewlyWeavedValueHolder()) && (userImage = this._persistence_get_image()) != this._persistence_image_vh.getValue()) {
            this._persistence_set_image(userImage);
        }
        return this._persistence_image_vh;
    }

    public void _persistence_set_image_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_image_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            UserImage userImage = this._persistence_get_image();
            if (userImage != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_image((UserImage)object);
            }
        } else {
            this.image = null;
        }
    }

    public UserImage _persistence_get_image() {
        this._persistence_checkFetched("image");
        this._persistence_initialize_image_vh();
        this.image = (UserImage)this._persistence_image_vh.getValue();
        return this.image;
    }

    public void _persistence_set_image(UserImage userImage) {
        this._persistence_checkFetchedForSet("image");
        this._persistence_initialize_image_vh();
        this.image = (UserImage)this._persistence_image_vh.getValue();
        this._persistence_propertyChange("image", this.image, userImage);
        this.image = userImage;
        this._persistence_image_vh.setValue((Object)userImage);
    }

    public Set _persistence_get_identityProviders() {
        this._persistence_checkFetched("identityProviders");
        return this.identityProviders;
    }

    public void _persistence_set_identityProviders(Set set) {
        this._persistence_checkFetchedForSet("identityProviders");
        this._persistence_propertyChange("identityProviders", this.identityProviders, set);
        this.identityProviders = set;
    }

    public ValidationKeyType _persistence_get_validationKeyType() {
        this._persistence_checkFetched("validationKeyType");
        return this.validationKeyType;
    }

    public void _persistence_set_validationKeyType(ValidationKeyType validationKeyType) {
        this._persistence_checkFetchedForSet("validationKeyType");
        this._persistence_propertyChange("validationKeyType", (Object)this.validationKeyType, (Object)validationKeyType);
        this.validationKeyType = validationKeyType;
    }

    public UserNature _persistence_get_nature() {
        this._persistence_checkFetched("nature");
        return this.nature;
    }

    public void _persistence_set_nature(UserNature userNature) {
        this._persistence_checkFetchedForSet("nature");
        this._persistence_propertyChange("nature", this.nature, userNature);
        this.nature = userNature;
    }

    public SecurityQuestion _persistence_get_securityQuestion() {
        this._persistence_checkFetched("securityQuestion");
        return this.securityQuestion;
    }

    public void _persistence_set_securityQuestion(SecurityQuestion securityQuestion) {
        this._persistence_checkFetchedForSet("securityQuestion");
        this._persistence_propertyChange("securityQuestion", this.securityQuestion, securityQuestion);
        this.securityQuestion = securityQuestion;
    }

    public Date _persistence_get_validationKeyDate() {
        this._persistence_checkFetched("validationKeyDate");
        return this.validationKeyDate;
    }

    public void _persistence_set_validationKeyDate(Date date) {
        this._persistence_checkFetchedForSet("validationKeyDate");
        this._persistence_propertyChange("validationKeyDate", this.validationKeyDate, date);
        this.validationKeyDate = date;
    }

    public Set _persistence_get_totpSecrets() {
        this._persistence_checkFetched("totpSecrets");
        return this.totpSecrets;
    }

    public void _persistence_set_totpSecrets(Set set) {
        this._persistence_checkFetchedForSet("totpSecrets");
        this._persistence_propertyChange("totpSecrets", this.totpSecrets, set);
        this.totpSecrets = set;
    }

    public Date _persistence_get_creationDate() {
        this._persistence_checkFetched("creationDate");
        return this.creationDate;
    }

    public void _persistence_set_creationDate(Date date) {
        this._persistence_checkFetchedForSet("creationDate");
        this._persistence_propertyChange("creationDate", this.creationDate, date);
        this.creationDate = date;
    }

    public Set _persistence_get_outboundSms() {
        this._persistence_checkFetched("outboundSms");
        return this.outboundSms;
    }

    public void _persistence_set_outboundSms(Set set) {
        this._persistence_checkFetchedForSet("outboundSms");
        this._persistence_propertyChange("outboundSms", this.outboundSms, set);
        this.outboundSms = set;
    }

    public Set _persistence_get_userNotifications() {
        this._persistence_checkFetched("userNotifications");
        return this.userNotifications;
    }

    public void _persistence_set_userNotifications(Set set) {
        this._persistence_checkFetchedForSet("userNotifications");
        this._persistence_propertyChange("userNotifications", this.userNotifications, set);
        this.userNotifications = set;
    }

    public Long _persistence_get_operatorUserId() {
        this._persistence_checkFetched("operatorUserId");
        return this.operatorUserId;
    }

    public void _persistence_set_operatorUserId(Long l) {
        this._persistence_checkFetchedForSet("operatorUserId");
        this._persistence_propertyChange("operatorUserId", this.operatorUserId, l);
        this.operatorUserId = l;
    }

    public Boolean _persistence_get_emailVerified() {
        this._persistence_checkFetched("emailVerified");
        return this.emailVerified;
    }

    public void _persistence_set_emailVerified(Boolean bl) {
        this._persistence_checkFetchedForSet("emailVerified");
        this._persistence_propertyChange("emailVerified", this.emailVerified, bl);
        this.emailVerified = bl;
    }

    public UserRegistration _persistence_get_registrationType() {
        this._persistence_checkFetched("registrationType");
        return this.registrationType;
    }

    public void _persistence_set_registrationType(UserRegistration userRegistration) {
        this._persistence_checkFetchedForSet("registrationType");
        this._persistence_propertyChange("registrationType", this.registrationType, userRegistration);
        this.registrationType = userRegistration;
    }

    public Set _persistence_get_activities() {
        this._persistence_checkFetched("activities");
        return this.activities;
    }

    public void _persistence_set_activities(Set set) {
        this._persistence_checkFetchedForSet("activities");
        this._persistence_propertyChange("activities", this.activities, set);
        this.activities = set;
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this._persistence_propertyChange("name", this.name, string);
        this.name = string;
    }

    public String _persistence_get_brokerIds() {
        this._persistence_checkFetched("brokerIds");
        return this.brokerIds;
    }

    public void _persistence_set_brokerIds(String string) {
        this._persistence_checkFetchedForSet("brokerIds");
        this._persistence_propertyChange("brokerIds", this.brokerIds, string);
        this.brokerIds = string;
    }

    public Set _persistence_get_failedActionLogs() {
        this._persistence_checkFetched("failedActionLogs");
        return this.failedActionLogs;
    }

    public void _persistence_set_failedActionLogs(Set set) {
        this._persistence_checkFetchedForSet("failedActionLogs");
        this._persistence_propertyChange("failedActionLogs", this.failedActionLogs, set);
        this.failedActionLogs = set;
    }

    public String _persistence_get_newEmail() {
        this._persistence_checkFetched("newEmail");
        return this.newEmail;
    }

    public void _persistence_set_newEmail(String string) {
        this._persistence_checkFetchedForSet("newEmail");
        this._persistence_propertyChange("newEmail", this.newEmail, string);
        this.newEmail = string;
    }

    public Frontend _persistence_get_frontend() {
        this._persistence_checkFetched("frontend");
        return this.frontend;
    }

    public void _persistence_set_frontend(Frontend frontend) {
        this._persistence_checkFetchedForSet("frontend");
        this._persistence_propertyChange("frontend", this.frontend, frontend);
        this.frontend = frontend;
    }

    public String _persistence_get_username() {
        this._persistence_checkFetched("username");
        return this.username;
    }

    public void _persistence_set_username(String string) {
        this._persistence_checkFetchedForSet("username");
        this._persistence_propertyChange("username", this.username, string);
        this.username = string;
    }

    public UserStatus _persistence_get_status() {
        this._persistence_checkFetched("status");
        return this.status;
    }

    public void _persistence_set_status(UserStatus userStatus) {
        this._persistence_checkFetchedForSet("status");
        this._persistence_propertyChange("status", this.status, userStatus);
        this.status = userStatus;
    }
}

