/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.users;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.AdminProduct;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.Product;
import org.cyclos.model.access.Role;
import org.cyclos.model.users.groups.AdminGroupType;
import org.cyclos.model.users.groups.BasicGroupNature;
import org.cyclos.utils.CollectionHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@DiscriminatorValue(value="ADMIN_GROUP")
public class AdminGroup
extends Group
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @OneToOne(optional=false, cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    @ReadOnlyFromDTO
    @JoinColumn(name="admin_product_id", updatable=false, nullable=true)
    private AdminProduct adminProduct;
    @ManyToMany
    @JoinTable(name="admin_groups_networks", joinColumns={@JoinColumn(name="group_id")}, inverseJoinColumns={@JoinColumn(name="network_id")})
    private Set<Network> managedNetworks = new HashSet<Network>();
    @ManyToMany
    @JoinTable(name="admin_possible_parent_configurations", joinColumns={@JoinColumn(name="group_id")}, inverseJoinColumns={@JoinColumn(name="configuration_id")})
    private Set<Configuration> possibleParentConfigurations = new HashSet<Configuration>();
    @Basic
    @Column(name="manage_scripts")
    private Boolean manageScripts;
    @Basic
    @Column(name="admin_max_registered_networks")
    private Integer maxManagedNetworks;
    @Transient
    private boolean canRegisterNetworks;
    @Transient
    private boolean copySystemAdminProfileFields;
    static final long serialVersionUID = -8794152212846153960L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_adminProduct_vh;

    public AdminProduct getAdminProduct() {
        return this._persistence_get_adminProduct();
    }

    public AdminGroupType getAdminType() {
        return this._persistence_get_adminType();
    }

    public Set<Network> getManagedNetworks() {
        return this._persistence_get_managedNetworks();
    }

    public Integer getMaxManagedNetworks() {
        return this._persistence_get_maxManagedNetworks();
    }

    @Override
    public BasicGroupNature getNature() {
        return BasicGroupNature.ADMIN_GROUP;
    }

    public Set<Configuration> getPossibleParentConfigurations() {
        return this._persistence_get_possibleParentConfigurations();
    }

    @Override
    public SortedSet<Long> getProductIds() {
        SortedSet<Long> sortedSet = super.getProductIds();
        sortedSet.add(AdminGroup.id(this._persistence_get_adminProduct()));
        return sortedSet;
    }

    @Override
    public Set<Product> getProducts() {
        if (CollectionHelper.isEmpty((Iterable)this._persistence_get_products())) {
            return Collections.singleton(this._persistence_get_adminProduct());
        }
        HashSet<Product> hashSet = new HashSet<Product>(this._persistence_get_products());
        hashSet.add(this._persistence_get_adminProduct());
        return hashSet;
    }

    @Override
    public Role getRole() {
        return Role.ADMIN;
    }

    public boolean isCanRegisterNetworks() {
        return this.canRegisterNetworks;
    }

    public boolean isCopySystemAdminProfileFields() {
        return this.copySystemAdminProfileFields;
    }

    public boolean isLimitMaxManagedNetworks() {
        return this._persistence_get_maxManagedNetworks() != null;
    }

    public boolean isManageScripts() {
        return Boolean.TRUE.equals(this._persistence_get_manageScripts());
    }

    public void setAdminProduct(AdminProduct adminProduct) {
        this._persistence_set_adminProduct(adminProduct);
    }

    public void setAdminType(AdminGroupType adminGroupType) {
        this._persistence_set_adminType(adminGroupType);
    }

    public void setCanRegisterNetworks(boolean bl) {
        this.canRegisterNetworks = bl;
    }

    public void setCopySystemAdminProfileFields(boolean bl) {
        this.copySystemAdminProfileFields = bl;
    }

    public void setManagedNetworks(Set<Network> set) {
        this._persistence_set_managedNetworks(set);
    }

    public void setManageScripts(Boolean bl) {
        this._persistence_set_manageScripts(bl);
    }

    public void setMaxManagedNetworks(Integer n) {
        this._persistence_set_maxManagedNetworks(n);
    }

    public void setPossibleParentConfigurations(Set<Configuration> set) {
        this._persistence_set_possibleParentConfigurations(set);
    }

    @Override
    public void updateProductIds(SortedSet<Long> sortedSet) {
        super.updateProductIds(CollectionHelper.orEmpty(sortedSet).stream().filter(l -> !l.equals(SimpleEntity.id(this._persistence_get_adminProduct()))).collect(Collectors.toCollection(TreeSet::new)));
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_adminProduct_vh != null) {
            this._persistence_adminProduct_vh = (WeavedAttributeValueHolderInterface)this._persistence_adminProduct_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new AdminGroup();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "possibleParentConfigurations") {
            return this.possibleParentConfigurations;
        }
        if (string == "adminProduct") {
            return this.adminProduct;
        }
        if (string == "managedNetworks") {
            return this.managedNetworks;
        }
        if (string == "maxManagedNetworks") {
            return this.maxManagedNetworks;
        }
        if (string == "manageScripts") {
            return this.manageScripts;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "possibleParentConfigurations") {
            this.possibleParentConfigurations = (Set)object;
            return;
        }
        if (string == "adminProduct") {
            this.adminProduct = (AdminProduct)object;
            return;
        }
        if (string == "managedNetworks") {
            this.managedNetworks = (Set)object;
            return;
        }
        if (string == "maxManagedNetworks") {
            this.maxManagedNetworks = (Integer)object;
            return;
        }
        if (string == "manageScripts") {
            this.manageScripts = (Boolean)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Set _persistence_get_possibleParentConfigurations() {
        this._persistence_checkFetched("possibleParentConfigurations");
        return this.possibleParentConfigurations;
    }

    public void _persistence_set_possibleParentConfigurations(Set set) {
        this._persistence_checkFetchedForSet("possibleParentConfigurations");
        this._persistence_propertyChange("possibleParentConfigurations", this.possibleParentConfigurations, set);
        this.possibleParentConfigurations = set;
    }

    protected void _persistence_initialize_adminProduct_vh() {
        if (this._persistence_adminProduct_vh == null) {
            this._persistence_adminProduct_vh = new ValueHolder((Object)this.adminProduct);
            this._persistence_adminProduct_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_adminProduct_vh() {
        AdminProduct adminProduct;
        this._persistence_initialize_adminProduct_vh();
        if ((this._persistence_adminProduct_vh.isCoordinatedWithProperty() || this._persistence_adminProduct_vh.isNewlyWeavedValueHolder()) && (adminProduct = this._persistence_get_adminProduct()) != this._persistence_adminProduct_vh.getValue()) {
            this._persistence_set_adminProduct(adminProduct);
        }
        return this._persistence_adminProduct_vh;
    }

    public void _persistence_set_adminProduct_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_adminProduct_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            AdminProduct adminProduct = this._persistence_get_adminProduct();
            if (adminProduct != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_adminProduct((AdminProduct)object);
            }
        } else {
            this.adminProduct = null;
        }
    }

    public AdminProduct _persistence_get_adminProduct() {
        this._persistence_checkFetched("adminProduct");
        this._persistence_initialize_adminProduct_vh();
        this.adminProduct = (AdminProduct)this._persistence_adminProduct_vh.getValue();
        return this.adminProduct;
    }

    public void _persistence_set_adminProduct(AdminProduct adminProduct) {
        this._persistence_checkFetchedForSet("adminProduct");
        this._persistence_initialize_adminProduct_vh();
        this.adminProduct = (AdminProduct)this._persistence_adminProduct_vh.getValue();
        this._persistence_propertyChange("adminProduct", this.adminProduct, adminProduct);
        this.adminProduct = adminProduct;
        this._persistence_adminProduct_vh.setValue((Object)adminProduct);
    }

    public Set _persistence_get_managedNetworks() {
        this._persistence_checkFetched("managedNetworks");
        return this.managedNetworks;
    }

    public void _persistence_set_managedNetworks(Set set) {
        this._persistence_checkFetchedForSet("managedNetworks");
        this._persistence_propertyChange("managedNetworks", this.managedNetworks, set);
        this.managedNetworks = set;
    }

    public Integer _persistence_get_maxManagedNetworks() {
        this._persistence_checkFetched("maxManagedNetworks");
        return this.maxManagedNetworks;
    }

    public void _persistence_set_maxManagedNetworks(Integer n) {
        this._persistence_checkFetchedForSet("maxManagedNetworks");
        this._persistence_propertyChange("maxManagedNetworks", this.maxManagedNetworks, n);
        this.maxManagedNetworks = n;
    }

    public Boolean _persistence_get_manageScripts() {
        this._persistence_checkFetched("manageScripts");
        return this.manageScripts;
    }

    public void _persistence_set_manageScripts(Boolean bl) {
        this._persistence_checkFetchedForSet("manageScripts");
        this._persistence_propertyChange("manageScripts", this.manageScripts, bl);
        this.manageScripts = bl;
    }
}

