/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.system;

import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.entities.users.Record;
import org.cyclos.entities.users.User;
import org.cyclos.model.Bean;
import org.cyclos.model.EntityVO;
import org.cyclos.model.Property;
import org.cyclos.model.banking.transactions.TransactionVO;
import org.cyclos.model.banking.transfers.TransferVO;
import org.cyclos.model.marketplace.advertisements.BasicAdVO;
import org.cyclos.model.system.fields.LinkedAdVO;
import org.cyclos.model.system.fields.LinkedEntityType;
import org.cyclos.model.system.fields.LinkedEntityVO;
import org.cyclos.model.system.fields.LinkedRecordVO;
import org.cyclos.model.system.fields.LinkedTransactionVO;
import org.cyclos.model.system.fields.LinkedTransferVO;
import org.cyclos.model.system.fields.LinkedUserVO;
import org.cyclos.model.users.records.RecordVO;
import org.cyclos.model.users.users.UserLocatorVO;

public class LinkedEntityTypeMapping {
    private static final BidiMap<LinkedEntityType, Class<? extends SimpleEntity>> ENTITY;
    private static final BidiMap<LinkedEntityType, Class<? extends EntityVO>> VO;
    private static final BidiMap<LinkedEntityType, Class<? extends LinkedEntityVO>> LINKED;
    private static final BidiMap<LinkedEntityType, Property<? extends Bean, ? extends LinkedEntityVO>> LINKED_PROP;

    public static Class<? extends SimpleEntity> getEntityType(LinkedEntityType linkedEntityType) {
        return (Class)ENTITY.get((Object)linkedEntityType);
    }

    public static Property<? extends Bean, ? extends LinkedEntityVO> getLinkedEntityVOProperty(LinkedEntityType linkedEntityType) {
        return (Property)LINKED_PROP.get((Object)linkedEntityType);
    }

    public static Class<? extends LinkedEntityVO> getLinkedEntityVOType(LinkedEntityType linkedEntityType) {
        return (Class)LINKED.get((Object)linkedEntityType);
    }

    public static Class<? extends EntityVO> getVoType(LinkedEntityType linkedEntityType) {
        return (Class)VO.get((Object)linkedEntityType);
    }

    static {
        VO = new DualHashBidiMap();
        VO.put((Object)LinkedEntityType.USER, UserLocatorVO.class);
        VO.put((Object)LinkedEntityType.TRANSACTION, TransactionVO.class);
        VO.put((Object)LinkedEntityType.TRANSFER, TransferVO.class);
        VO.put((Object)LinkedEntityType.RECORD, RecordVO.class);
        VO.put((Object)LinkedEntityType.ADVERTISEMENT, BasicAdVO.class);
        for (LinkedEntityType linkedEntityType : LinkedEntityType.values()) {
            if (VO.containsKey((Object)linkedEntityType)) continue;
            throw new IllegalStateException("No default vo type mapping for " + String.valueOf(linkedEntityType));
        }
        ENTITY = new DualHashBidiMap();
        ENTITY.put((Object)LinkedEntityType.USER, User.class);
        ENTITY.put((Object)LinkedEntityType.TRANSACTION, Transaction.class);
        ENTITY.put((Object)LinkedEntityType.TRANSFER, Transfer.class);
        ENTITY.put((Object)LinkedEntityType.RECORD, Record.class);
        ENTITY.put((Object)LinkedEntityType.ADVERTISEMENT, BasicAd.class);
        for (LinkedEntityType linkedEntityType : LinkedEntityType.values()) {
            if (ENTITY.containsKey((Object)linkedEntityType)) continue;
            throw new IllegalStateException("No entity type mapping for " + String.valueOf(linkedEntityType));
        }
        LINKED = new DualHashBidiMap();
        LINKED.put((Object)LinkedEntityType.USER, LinkedUserVO.class);
        LINKED.put((Object)LinkedEntityType.TRANSACTION, LinkedTransactionVO.class);
        LINKED.put((Object)LinkedEntityType.TRANSFER, LinkedTransferVO.class);
        LINKED.put((Object)LinkedEntityType.RECORD, LinkedRecordVO.class);
        LINKED.put((Object)LinkedEntityType.ADVERTISEMENT, LinkedAdVO.class);
        for (LinkedEntityType linkedEntityType : LinkedEntityType.values()) {
            if (LINKED.containsKey((Object)linkedEntityType)) continue;
            throw new IllegalStateException("No LinkedEntityVO subclass mapping for " + String.valueOf(linkedEntityType));
        }
        LINKED_PROP = new DualHashBidiMap();
        LINKED_PROP.put((Object)LinkedEntityType.USER, (Object)LinkedUserVO.USER);
        LINKED_PROP.put((Object)LinkedEntityType.TRANSACTION, (Object)LinkedTransactionVO.TRANSACTION);
        LINKED_PROP.put((Object)LinkedEntityType.TRANSFER, (Object)LinkedTransferVO.TRANSFER);
        LINKED_PROP.put((Object)LinkedEntityType.RECORD, (Object)LinkedRecordVO.RECORD);
        LINKED_PROP.put((Object)LinkedEntityType.ADVERTISEMENT, (Object)LinkedAdVO.AD);
        for (LinkedEntityType linkedEntityType : LinkedEntityType.values()) {
            if (LINKED_PROP.containsKey((Object)linkedEntityType)) continue;
            throw new IllegalStateException("No LinkedEntityVO property mapping for " + String.valueOf(linkedEntityType));
        }
    }
}

