/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.system;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.ConfigurationEntity;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.contentmanagement.DataTranslation;
import org.cyclos.entities.contentmanagement.TranslationMessage;
import org.cyclos.entities.system.DefinesNetwork;
import org.cyclos.entities.system.Network;
import org.cyclos.model.system.languages.BuiltinLanguage;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Cacheable(value=true)
@Table(name="languages")
public class Language
extends ConfigurationEntity
implements DefinesNetwork,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="network_id", nullable=true)
    private Network network;
    @Enumerated(value=EnumType.STRING)
    @Column(name="template", nullable=false, updatable=false)
    @ReadOnlyFromDTO
    private BuiltinLanguage template;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="parent_id", updatable=false)
    @ReadOnlyFromDTO(onInsert=false)
    private Language parent;
    @Basic
    @Column(name="last_modified")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastModified;
    @OneToMany(mappedBy="language", cascade={CascadeType.REMOVE})
    private Set<TranslationMessage> translationMessages;
    @OneToMany(mappedBy="language", cascade={CascadeType.REMOVE})
    private Set<DataTranslation> dataTranslations;
    @OneToMany(mappedBy="parent", cascade={CascadeType.REMOVE})
    private Set<Language> children = new HashSet<Language>();
    static final long serialVersionUID = 5274317898972064499L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_parent_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_network_vh;

    public Set<Language> getChildren() {
        return this._persistence_get_children();
    }

    public Date getLastModified() {
        return this._persistence_get_lastModified();
    }

    public String getLastModifiedInMillis() {
        return this._persistence_get_lastModified() == null ? null : String.valueOf(this._persistence_get_lastModified().getTime());
    }

    public int getLevel() {
        if (this._persistence_get_parent() == null) {
            return 0;
        }
        return this._persistence_get_parent().getLevel() + 1;
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_network();
    }

    public Language getParent() {
        return this._persistence_get_parent();
    }

    public BuiltinLanguage getTemplate() {
        return this._persistence_get_template();
    }

    public void setLastModified(Date date) {
        this._persistence_set_lastModified(date);
    }

    @Override
    public void setNetwork(Network network) {
        this._persistence_set_network(network);
    }

    public void setParent(Language language) {
        this._persistence_set_parent(language);
    }

    public void setTemplate(BuiltinLanguage builtinLanguage) {
        this._persistence_set_template(builtinLanguage);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_parent_vh != null) {
            this._persistence_parent_vh = (WeavedAttributeValueHolderInterface)this._persistence_parent_vh.clone();
        }
        if (this._persistence_network_vh != null) {
            this._persistence_network_vh = (WeavedAttributeValueHolderInterface)this._persistence_network_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Language();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "template") {
            return this.template;
        }
        if (string == "parent") {
            return this.parent;
        }
        if (string == "translationMessages") {
            return this.translationMessages;
        }
        if (string == "children") {
            return this.children;
        }
        if (string == "lastModified") {
            return this.lastModified;
        }
        if (string == "dataTranslations") {
            return this.dataTranslations;
        }
        if (string == "network") {
            return this.network;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "template") {
            this.template = (BuiltinLanguage)object;
            return;
        }
        if (string == "parent") {
            this.parent = (Language)object;
            return;
        }
        if (string == "translationMessages") {
            this.translationMessages = (Set)object;
            return;
        }
        if (string == "children") {
            this.children = (Set)object;
            return;
        }
        if (string == "lastModified") {
            this.lastModified = (Date)object;
            return;
        }
        if (string == "dataTranslations") {
            this.dataTranslations = (Set)object;
            return;
        }
        if (string == "network") {
            this.network = (Network)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public BuiltinLanguage _persistence_get_template() {
        this._persistence_checkFetched("template");
        return this.template;
    }

    public void _persistence_set_template(BuiltinLanguage builtinLanguage) {
        this._persistence_checkFetchedForSet("template");
        this._persistence_propertyChange("template", this.template, builtinLanguage);
        this.template = builtinLanguage;
    }

    protected void _persistence_initialize_parent_vh() {
        if (this._persistence_parent_vh == null) {
            this._persistence_parent_vh = new ValueHolder((Object)this.parent);
            this._persistence_parent_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_parent_vh() {
        Language language;
        this._persistence_initialize_parent_vh();
        if ((this._persistence_parent_vh.isCoordinatedWithProperty() || this._persistence_parent_vh.isNewlyWeavedValueHolder()) && (language = this._persistence_get_parent()) != this._persistence_parent_vh.getValue()) {
            this._persistence_set_parent(language);
        }
        return this._persistence_parent_vh;
    }

    public void _persistence_set_parent_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_parent_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Language language = this._persistence_get_parent();
            if (language != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_parent((Language)object);
            }
        } else {
            this.parent = null;
        }
    }

    public Language _persistence_get_parent() {
        this._persistence_checkFetched("parent");
        this._persistence_initialize_parent_vh();
        this.parent = (Language)this._persistence_parent_vh.getValue();
        return this.parent;
    }

    public void _persistence_set_parent(Language language) {
        this._persistence_checkFetchedForSet("parent");
        this._persistence_initialize_parent_vh();
        this.parent = (Language)this._persistence_parent_vh.getValue();
        this._persistence_propertyChange("parent", this.parent, language);
        this.parent = language;
        this._persistence_parent_vh.setValue((Object)language);
    }

    public Set _persistence_get_translationMessages() {
        this._persistence_checkFetched("translationMessages");
        return this.translationMessages;
    }

    public void _persistence_set_translationMessages(Set set) {
        this._persistence_checkFetchedForSet("translationMessages");
        this._persistence_propertyChange("translationMessages", this.translationMessages, set);
        this.translationMessages = set;
    }

    public Set _persistence_get_children() {
        this._persistence_checkFetched("children");
        return this.children;
    }

    public void _persistence_set_children(Set set) {
        this._persistence_checkFetchedForSet("children");
        this._persistence_propertyChange("children", this.children, set);
        this.children = set;
    }

    public Date _persistence_get_lastModified() {
        this._persistence_checkFetched("lastModified");
        return this.lastModified;
    }

    public void _persistence_set_lastModified(Date date) {
        this._persistence_checkFetchedForSet("lastModified");
        this._persistence_propertyChange("lastModified", this.lastModified, date);
        this.lastModified = date;
    }

    public Set _persistence_get_dataTranslations() {
        this._persistence_checkFetched("dataTranslations");
        return this.dataTranslations;
    }

    public void _persistence_set_dataTranslations(Set set) {
        this._persistence_checkFetchedForSet("dataTranslations");
        this._persistence_propertyChange("dataTranslations", this.dataTranslations, set);
        this.dataTranslations = set;
    }

    protected void _persistence_initialize_network_vh() {
        if (this._persistence_network_vh == null) {
            this._persistence_network_vh = new ValueHolder((Object)this.network);
            this._persistence_network_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_network_vh() {
        Network network;
        this._persistence_initialize_network_vh();
        if ((this._persistence_network_vh.isCoordinatedWithProperty() || this._persistence_network_vh.isNewlyWeavedValueHolder()) && (network = this._persistence_get_network()) != this._persistence_network_vh.getValue()) {
            this._persistence_set_network(network);
        }
        return this._persistence_network_vh;
    }

    public void _persistence_set_network_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_network_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Network network = this._persistence_get_network();
            if (network != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_network((Network)object);
            }
        } else {
            this.network = null;
        }
    }

    public Network _persistence_get_network() {
        this._persistence_checkFetched("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        return this.network;
    }

    public void _persistence_set_network(Network network) {
        this._persistence_checkFetchedForSet("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        this._persistence_propertyChange("network", this.network, network);
        this.network = network;
        this._persistence_network_vh.setValue((Object)network);
    }
}

