/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.system;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.system.ImportedField;
import org.cyclos.entities.system.ImportedFile;
import org.cyclos.entities.system.ImportedLineValue;
import org.cyclos.entities.system.Network;
import org.cyclos.model.system.imports.ImportField;
import org.cyclos.model.system.imports.ImportedLineStatus;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="imported_lines")
public class ImportedLine
extends BaseEntity
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @Basic
    @Column(name="line_number")
    @ReadOnlyFromDTO
    private Integer lineNumber;
    @Basic
    @Lob
    @Column(name="error_message")
    @ReadOnlyFromDTO
    private String errorMessage;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="imported_file_id", updatable=false, nullable=false)
    @ReadOnlyFromDTO
    private ImportedFile importedFile;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="status")
    @ReadOnlyFromDTO
    private ImportedLineStatus status;
    @OneToMany(mappedBy="importedLine", cascade={CascadeType.ALL})
    @OrderBy(value="id")
    private List<ImportedLineValue> values = new ArrayList<ImportedLineValue>();
    @Basic
    @Column(name="imported_entity_id")
    @ReadOnlyFromDTO
    private Long importedEntityId;
    static final long serialVersionUID = -6007539836085246243L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_importedFile_vh;

    public String getErrorMessage() {
        return this._persistence_get_errorMessage();
    }

    public List<ImportedField> getFields() {
        return this.getImportedFile().getFields();
    }

    public ImportedFile getFile() {
        return this.getImportedFile();
    }

    public Long getImportedEntityId() {
        return this._persistence_get_importedEntityId();
    }

    public ImportedFile getImportedFile() {
        return this._persistence_get_importedFile();
    }

    public ImportedLineValue getImportedValue(ImportedField importedField) {
        return this._persistence_get_values().stream().filter(importedLineValue -> importedLineValue.getImportedField().equals(importedField)).findFirst().orElse(null);
    }

    public Integer getLineNumber() {
        return this._persistence_get_lineNumber();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_importedFile().getNetwork();
    }

    public ImportedLineStatus getStatus() {
        return this._persistence_get_status();
    }

    public String getValue(ImportedField importedField) {
        ImportedLineValue importedLineValue = this.getImportedValue(importedField);
        return importedLineValue == null ? null : importedLineValue.getValue();
    }

    public String getValue(ImportField importField) {
        return this.getValue(importField, null);
    }

    public String getValue(ImportField importField, String string) {
        ImportedField importedField = this._persistence_get_importedFile().getField(importField, string);
        return importedField == null ? null : this.getValue(importedField);
    }

    public String getValue(String string) {
        return this.getValue(string, null);
    }

    public String getValue(String string, String string2) {
        ImportedField importedField = this._persistence_get_importedFile().getField(string, string2);
        return importedField == null ? null : this.getValue(importedField);
    }

    public List<ImportedLineValue> getValues() {
        return this._persistence_get_values();
    }

    public void setErrorMessage(String string) {
        this._persistence_set_errorMessage(string);
    }

    public void setImportedEntityId(Long l) {
        this._persistence_set_importedEntityId(l);
    }

    public void setImportedFile(ImportedFile importedFile) {
        this._persistence_set_importedFile(importedFile);
    }

    public void setLineNumber(Integer n) {
        this._persistence_set_lineNumber(n);
    }

    public void setStatus(ImportedLineStatus importedLineStatus) {
        this._persistence_set_status(importedLineStatus);
    }

    public void setValues(List<ImportedLineValue> list) {
        this._persistence_set_values(list);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_importedFile_vh != null) {
            this._persistence_importedFile_vh = (WeavedAttributeValueHolderInterface)this._persistence_importedFile_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ImportedLine();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "values") {
            return this.values;
        }
        if (string == "errorMessage") {
            return this.errorMessage;
        }
        if (string == "importedEntityId") {
            return this.importedEntityId;
        }
        if (string == "lineNumber") {
            return this.lineNumber;
        }
        if (string == "status") {
            return this.status;
        }
        if (string == "importedFile") {
            return this.importedFile;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "values") {
            this.values = (List)object;
            return;
        }
        if (string == "errorMessage") {
            this.errorMessage = (String)object;
            return;
        }
        if (string == "importedEntityId") {
            this.importedEntityId = (Long)object;
            return;
        }
        if (string == "lineNumber") {
            this.lineNumber = (Integer)object;
            return;
        }
        if (string == "status") {
            this.status = (ImportedLineStatus)object;
            return;
        }
        if (string == "importedFile") {
            this.importedFile = (ImportedFile)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public List _persistence_get_values() {
        this._persistence_checkFetched("values");
        return this.values;
    }

    public void _persistence_set_values(List list) {
        this._persistence_checkFetchedForSet("values");
        this._persistence_propertyChange("values", this.values, list);
        this.values = list;
    }

    public String _persistence_get_errorMessage() {
        this._persistence_checkFetched("errorMessage");
        return this.errorMessage;
    }

    public void _persistence_set_errorMessage(String string) {
        this._persistence_checkFetchedForSet("errorMessage");
        this._persistence_propertyChange("errorMessage", this.errorMessage, string);
        this.errorMessage = string;
    }

    public Long _persistence_get_importedEntityId() {
        this._persistence_checkFetched("importedEntityId");
        return this.importedEntityId;
    }

    public void _persistence_set_importedEntityId(Long l) {
        this._persistence_checkFetchedForSet("importedEntityId");
        this._persistence_propertyChange("importedEntityId", this.importedEntityId, l);
        this.importedEntityId = l;
    }

    public Integer _persistence_get_lineNumber() {
        this._persistence_checkFetched("lineNumber");
        return this.lineNumber;
    }

    public void _persistence_set_lineNumber(Integer n) {
        this._persistence_checkFetchedForSet("lineNumber");
        this._persistence_propertyChange("lineNumber", this.lineNumber, n);
        this.lineNumber = n;
    }

    public ImportedLineStatus _persistence_get_status() {
        this._persistence_checkFetched("status");
        return this.status;
    }

    public void _persistence_set_status(ImportedLineStatus importedLineStatus) {
        this._persistence_checkFetchedForSet("status");
        this._persistence_propertyChange("status", this.status, importedLineStatus);
        this.status = importedLineStatus;
    }

    protected void _persistence_initialize_importedFile_vh() {
        if (this._persistence_importedFile_vh == null) {
            this._persistence_importedFile_vh = new ValueHolder((Object)this.importedFile);
            this._persistence_importedFile_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_importedFile_vh() {
        ImportedFile importedFile;
        this._persistence_initialize_importedFile_vh();
        if ((this._persistence_importedFile_vh.isCoordinatedWithProperty() || this._persistence_importedFile_vh.isNewlyWeavedValueHolder()) && (importedFile = this._persistence_get_importedFile()) != this._persistence_importedFile_vh.getValue()) {
            this._persistence_set_importedFile(importedFile);
        }
        return this._persistence_importedFile_vh;
    }

    public void _persistence_set_importedFile_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_importedFile_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            ImportedFile importedFile = this._persistence_get_importedFile();
            if (importedFile != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_importedFile((ImportedFile)object);
            }
        } else {
            this.importedFile = null;
        }
    }

    public ImportedFile _persistence_get_importedFile() {
        this._persistence_checkFetched("importedFile");
        this._persistence_initialize_importedFile_vh();
        this.importedFile = (ImportedFile)this._persistence_importedFile_vh.getValue();
        return this.importedFile;
    }

    public void _persistence_set_importedFile(ImportedFile importedFile) {
        this._persistence_checkFetchedForSet("importedFile");
        this._persistence_initialize_importedFile_vh();
        this.importedFile = (ImportedFile)this._persistence_importedFile_vh.getValue();
        this._persistence_propertyChange("importedFile", this.importedFile, importedFile);
        this.importedFile = importedFile;
        this._persistence_importedFile_vh.setValue((Object)importedFile);
    }
}

