/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.system;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.ConfigurationEntity;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.system.DefinesNetwork;
import org.cyclos.entities.system.Network;
import org.cyclos.model.system.exportformats.BuiltInExportFormat;
import org.cyclos.model.system.exportformats.ExportFormatContext;
import org.cyclos.model.system.scripts.CustomScriptUsedInType;
import org.cyclos.model.system.scripts.UsesScript;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Cacheable(value=true)
@Table(name="export_formats", indexes={@Index(name="ix_export_formats_internal_name", columnList="internal_name")})
public class ExportFormat
extends ConfigurationEntity
implements DefinesNetwork,
UsesScript,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="network_id", nullable=true)
    private Network network;
    @Basic
    @Column(name="content_type", nullable=false)
    private String contentType;
    @Basic
    @Column(name="file_extension", nullable=false)
    private String fileExtension;
    @Basic
    @Column(name="is_binary")
    private Boolean binary;
    @Basic
    @Column(name="encoding")
    private String encoding;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="script_id")
    private CustomScript script;
    @Basic
    @Lob
    @Column(name="script_parameters")
    private String scriptParameters;
    @Basic
    @Column(name="enabled")
    private Boolean enabled;
    @ElementCollection
    @Column(name="context")
    @Enumerated(value=EnumType.STRING)
    @CollectionTable(name="export_format_contexts", joinColumns={@JoinColumn(name="export_format_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"export_format_id", "context"})})
    private Set<ExportFormatContext> contexts = new HashSet<ExportFormatContext>();
    static final long serialVersionUID = -5467153994065539649L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_script_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_network_vh;

    public String getContentType() {
        return this._persistence_get_contentType();
    }

    public Set<ExportFormatContext> getContexts() {
        BuiltInExportFormat builtInExportFormat = BuiltInExportFormat.getByInternalName((String)this.getInternalName());
        if (builtInExportFormat != null) {
            return builtInExportFormat.getContexts();
        }
        return this._persistence_get_contexts();
    }

    public String getEncoding() {
        return this._persistence_get_encoding();
    }

    public String getFileExtension() {
        return this._persistence_get_fileExtension();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_network();
    }

    public CustomScript getScript() {
        return this._persistence_get_script();
    }

    public String getScriptParameters() {
        return this._persistence_get_scriptParameters();
    }

    public CustomScriptUsedInType getScriptUsedInType() {
        return CustomScriptUsedInType.EXPORT_FORMAT;
    }

    public boolean isBinary() {
        return Boolean.TRUE.equals(this._persistence_get_binary());
    }

    public boolean isCustom() {
        return BuiltInExportFormat.getByInternalName((String)this.getInternalName()) == null;
    }

    public boolean isEnabled() {
        return Boolean.TRUE.equals(this._persistence_get_enabled());
    }

    public void setBinary(boolean bl) {
        this._persistence_set_binary(bl);
    }

    public void setContentType(String string) {
        this._persistence_set_contentType(string);
    }

    public void setContexts(Set<ExportFormatContext> set) {
        BuiltInExportFormat builtInExportFormat = BuiltInExportFormat.getByInternalName((String)this.getInternalName());
        if (builtInExportFormat != null) {
            return;
        }
        this._persistence_set_contexts(set);
    }

    public void setEnabled(boolean bl) {
        this._persistence_set_enabled(bl);
    }

    public void setEncoding(String string) {
        this._persistence_set_encoding(string);
    }

    public void setFileExtension(String string) {
        this._persistence_set_fileExtension(string);
    }

    @Override
    public void setNetwork(Network network) {
        this._persistence_set_network(network);
    }

    public void setScript(CustomScript customScript) {
        this._persistence_set_script(customScript);
    }

    public void setScriptParameters(String string) {
        this._persistence_set_scriptParameters(string);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_script_vh != null) {
            this._persistence_script_vh = (WeavedAttributeValueHolderInterface)this._persistence_script_vh.clone();
        }
        if (this._persistence_network_vh != null) {
            this._persistence_network_vh = (WeavedAttributeValueHolderInterface)this._persistence_network_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ExportFormat();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "contexts") {
            return this.contexts;
        }
        if (string == "encoding") {
            return this.encoding;
        }
        if (string == "enabled") {
            return this.enabled;
        }
        if (string == "script") {
            return this.script;
        }
        if (string == "network") {
            return this.network;
        }
        if (string == "scriptParameters") {
            return this.scriptParameters;
        }
        if (string == "fileExtension") {
            return this.fileExtension;
        }
        if (string == "binary") {
            return this.binary;
        }
        if (string == "contentType") {
            return this.contentType;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "contexts") {
            this.contexts = (Set)object;
            return;
        }
        if (string == "encoding") {
            this.encoding = (String)object;
            return;
        }
        if (string == "enabled") {
            this.enabled = (Boolean)object;
            return;
        }
        if (string == "script") {
            this.script = (CustomScript)object;
            return;
        }
        if (string == "network") {
            this.network = (Network)object;
            return;
        }
        if (string == "scriptParameters") {
            this.scriptParameters = (String)object;
            return;
        }
        if (string == "fileExtension") {
            this.fileExtension = (String)object;
            return;
        }
        if (string == "binary") {
            this.binary = (Boolean)object;
            return;
        }
        if (string == "contentType") {
            this.contentType = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Set _persistence_get_contexts() {
        this._persistence_checkFetched("contexts");
        return this.contexts;
    }

    public void _persistence_set_contexts(Set set) {
        this._persistence_checkFetchedForSet("contexts");
        this._persistence_propertyChange("contexts", this.contexts, set);
        this.contexts = set;
    }

    public String _persistence_get_encoding() {
        this._persistence_checkFetched("encoding");
        return this.encoding;
    }

    public void _persistence_set_encoding(String string) {
        this._persistence_checkFetchedForSet("encoding");
        this._persistence_propertyChange("encoding", this.encoding, string);
        this.encoding = string;
    }

    public Boolean _persistence_get_enabled() {
        this._persistence_checkFetched("enabled");
        return this.enabled;
    }

    public void _persistence_set_enabled(Boolean bl) {
        this._persistence_checkFetchedForSet("enabled");
        this._persistence_propertyChange("enabled", this.enabled, bl);
        this.enabled = bl;
    }

    protected void _persistence_initialize_script_vh() {
        if (this._persistence_script_vh == null) {
            this._persistence_script_vh = new ValueHolder((Object)this.script);
            this._persistence_script_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_script_vh() {
        CustomScript customScript;
        this._persistence_initialize_script_vh();
        if ((this._persistence_script_vh.isCoordinatedWithProperty() || this._persistence_script_vh.isNewlyWeavedValueHolder()) && (customScript = this._persistence_get_script()) != this._persistence_script_vh.getValue()) {
            this._persistence_set_script(customScript);
        }
        return this._persistence_script_vh;
    }

    public void _persistence_set_script_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_script_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            CustomScript customScript = this._persistence_get_script();
            if (customScript != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_script((CustomScript)object);
            }
        } else {
            this.script = null;
        }
    }

    public CustomScript _persistence_get_script() {
        this._persistence_checkFetched("script");
        this._persistence_initialize_script_vh();
        this.script = (CustomScript)this._persistence_script_vh.getValue();
        return this.script;
    }

    public void _persistence_set_script(CustomScript customScript) {
        this._persistence_checkFetchedForSet("script");
        this._persistence_initialize_script_vh();
        this.script = (CustomScript)this._persistence_script_vh.getValue();
        this._persistence_propertyChange("script", this.script, customScript);
        this.script = customScript;
        this._persistence_script_vh.setValue((Object)customScript);
    }

    protected void _persistence_initialize_network_vh() {
        if (this._persistence_network_vh == null) {
            this._persistence_network_vh = new ValueHolder((Object)this.network);
            this._persistence_network_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_network_vh() {
        Network network;
        this._persistence_initialize_network_vh();
        if ((this._persistence_network_vh.isCoordinatedWithProperty() || this._persistence_network_vh.isNewlyWeavedValueHolder()) && (network = this._persistence_get_network()) != this._persistence_network_vh.getValue()) {
            this._persistence_set_network(network);
        }
        return this._persistence_network_vh;
    }

    public void _persistence_set_network_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_network_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Network network = this._persistence_get_network();
            if (network != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_network((Network)object);
            }
        } else {
            this.network = null;
        }
    }

    public Network _persistence_get_network() {
        this._persistence_checkFetched("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        return this.network;
    }

    public void _persistence_set_network(Network network) {
        this._persistence_checkFetchedForSet("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        this._persistence_propertyChange("network", this.network, network);
        this.network = network;
        this._persistence_network_vh.setValue((Object)network);
    }

    public String _persistence_get_scriptParameters() {
        this._persistence_checkFetched("scriptParameters");
        return this.scriptParameters;
    }

    public void _persistence_set_scriptParameters(String string) {
        this._persistence_checkFetchedForSet("scriptParameters");
        this._persistence_propertyChange("scriptParameters", this.scriptParameters, string);
        this.scriptParameters = string;
    }

    public String _persistence_get_fileExtension() {
        this._persistence_checkFetched("fileExtension");
        return this.fileExtension;
    }

    public void _persistence_set_fileExtension(String string) {
        this._persistence_checkFetchedForSet("fileExtension");
        this._persistence_propertyChange("fileExtension", this.fileExtension, string);
        this.fileExtension = string;
    }

    public Boolean _persistence_get_binary() {
        this._persistence_checkFetched("binary");
        return this.binary;
    }

    public void _persistence_set_binary(Boolean bl) {
        this._persistence_checkFetchedForSet("binary");
        this._persistence_propertyChange("binary", this.binary, bl);
        this.binary = bl;
    }

    public String _persistence_get_contentType() {
        this._persistence_checkFetched("contentType");
        return this.contentType;
    }

    public void _persistence_set_contentType(String string) {
        this._persistence_checkFetchedForSet("contentType");
        this._persistence_propertyChange("contentType", this.contentType, string);
        this.contentType = string;
    }
}

