/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.system;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.HasOrder;
import org.cyclos.entities.system.CustomOperation;
import org.cyclos.entities.system.CustomOperationActionParameter;
import org.cyclos.entities.system.Network;
import org.cyclos.model.system.operations.CustomOperationActionVisibility;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Cacheable(value=true)
@Table(name="custom_operation_actions", uniqueConstraints={@UniqueConstraint(name="uk_owner_operation_action", columnNames={"owner_operation_id", "action_operation_id"})})
public class CustomOperationAction
extends BaseEntity
implements Comparable<CustomOperationAction>,
HasOrder,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="owner_operation_id", nullable=false)
    private CustomOperation ownerOperation;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="action_operation_id", nullable=false)
    private CustomOperation actionOperation;
    @OneToMany(mappedBy="action", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<CustomOperationActionParameter> parameters = new HashSet<CustomOperationActionParameter>();
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="visibility", nullable=false)
    private CustomOperationActionVisibility visibility;
    @Basic
    @Column(name="primary_action")
    private Boolean primary;
    @Basic
    @Column(name="order_index", nullable=false)
    private Integer order = 0;
    static final long serialVersionUID = 2893901344213853960L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_ownerOperation_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_actionOperation_vh;

    @Override
    public int compareTo(CustomOperationAction customOperationAction) {
        int n = this._persistence_get_actionOperation().compareTo(customOperationAction._persistence_get_actionOperation());
        return n == 0 ? Integer.compare(this._persistence_get_order(), customOperationAction._persistence_get_order()) : n;
    }

    public CustomOperation getActionOperation() {
        return this._persistence_get_actionOperation();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_ownerOperation().getNetwork();
    }

    @Override
    public Integer getOrder() {
        return this._persistence_get_order();
    }

    public CustomOperation getOwnerOperation() {
        return this._persistence_get_ownerOperation();
    }

    public Set<CustomOperationActionParameter> getParameters() {
        return this._persistence_get_parameters();
    }

    public CustomOperationActionVisibility getVisibility() {
        return this._persistence_get_visibility();
    }

    public boolean isPrimary() {
        return Boolean.TRUE.equals(this._persistence_get_primary());
    }

    public void setActionOperation(CustomOperation customOperation) {
        this._persistence_set_actionOperation(customOperation);
    }

    @Override
    public void setOrder(Integer n) {
        this._persistence_set_order(n);
    }

    public void setOwnerOperation(CustomOperation customOperation) {
        this._persistence_set_ownerOperation(customOperation);
    }

    public void setParameters(Set<CustomOperationActionParameter> set) {
        this._persistence_set_parameters(set);
    }

    public void setPrimary(boolean bl) {
        this._persistence_set_primary(bl);
    }

    public void setVisibility(CustomOperationActionVisibility customOperationActionVisibility) {
        this._persistence_set_visibility(customOperationActionVisibility);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_ownerOperation_vh != null) {
            this._persistence_ownerOperation_vh = (WeavedAttributeValueHolderInterface)this._persistence_ownerOperation_vh.clone();
        }
        if (this._persistence_actionOperation_vh != null) {
            this._persistence_actionOperation_vh = (WeavedAttributeValueHolderInterface)this._persistence_actionOperation_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new CustomOperationAction();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "visibility") {
            return this.visibility;
        }
        if (string == "ownerOperation") {
            return this.ownerOperation;
        }
        if (string == "actionOperation") {
            return this.actionOperation;
        }
        if (string == "parameters") {
            return this.parameters;
        }
        if (string == "primary") {
            return this.primary;
        }
        if (string == "order") {
            return this.order;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "visibility") {
            this.visibility = (CustomOperationActionVisibility)object;
            return;
        }
        if (string == "ownerOperation") {
            this.ownerOperation = (CustomOperation)object;
            return;
        }
        if (string == "actionOperation") {
            this.actionOperation = (CustomOperation)object;
            return;
        }
        if (string == "parameters") {
            this.parameters = (Set)object;
            return;
        }
        if (string == "primary") {
            this.primary = (Boolean)object;
            return;
        }
        if (string == "order") {
            this.order = (Integer)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public CustomOperationActionVisibility _persistence_get_visibility() {
        this._persistence_checkFetched("visibility");
        return this.visibility;
    }

    public void _persistence_set_visibility(CustomOperationActionVisibility customOperationActionVisibility) {
        this._persistence_checkFetchedForSet("visibility");
        this._persistence_propertyChange("visibility", this.visibility, customOperationActionVisibility);
        this.visibility = customOperationActionVisibility;
    }

    protected void _persistence_initialize_ownerOperation_vh() {
        if (this._persistence_ownerOperation_vh == null) {
            this._persistence_ownerOperation_vh = new ValueHolder((Object)this.ownerOperation);
            this._persistence_ownerOperation_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_ownerOperation_vh() {
        CustomOperation customOperation;
        this._persistence_initialize_ownerOperation_vh();
        if ((this._persistence_ownerOperation_vh.isCoordinatedWithProperty() || this._persistence_ownerOperation_vh.isNewlyWeavedValueHolder()) && (customOperation = this._persistence_get_ownerOperation()) != this._persistence_ownerOperation_vh.getValue()) {
            this._persistence_set_ownerOperation(customOperation);
        }
        return this._persistence_ownerOperation_vh;
    }

    public void _persistence_set_ownerOperation_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_ownerOperation_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            CustomOperation customOperation = this._persistence_get_ownerOperation();
            if (customOperation != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_ownerOperation((CustomOperation)object);
            }
        } else {
            this.ownerOperation = null;
        }
    }

    public CustomOperation _persistence_get_ownerOperation() {
        this._persistence_checkFetched("ownerOperation");
        this._persistence_initialize_ownerOperation_vh();
        this.ownerOperation = (CustomOperation)this._persistence_ownerOperation_vh.getValue();
        return this.ownerOperation;
    }

    public void _persistence_set_ownerOperation(CustomOperation customOperation) {
        this._persistence_checkFetchedForSet("ownerOperation");
        this._persistence_initialize_ownerOperation_vh();
        this.ownerOperation = (CustomOperation)this._persistence_ownerOperation_vh.getValue();
        this._persistence_propertyChange("ownerOperation", this.ownerOperation, customOperation);
        this.ownerOperation = customOperation;
        this._persistence_ownerOperation_vh.setValue((Object)customOperation);
    }

    protected void _persistence_initialize_actionOperation_vh() {
        if (this._persistence_actionOperation_vh == null) {
            this._persistence_actionOperation_vh = new ValueHolder((Object)this.actionOperation);
            this._persistence_actionOperation_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_actionOperation_vh() {
        CustomOperation customOperation;
        this._persistence_initialize_actionOperation_vh();
        if ((this._persistence_actionOperation_vh.isCoordinatedWithProperty() || this._persistence_actionOperation_vh.isNewlyWeavedValueHolder()) && (customOperation = this._persistence_get_actionOperation()) != this._persistence_actionOperation_vh.getValue()) {
            this._persistence_set_actionOperation(customOperation);
        }
        return this._persistence_actionOperation_vh;
    }

    public void _persistence_set_actionOperation_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_actionOperation_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            CustomOperation customOperation = this._persistence_get_actionOperation();
            if (customOperation != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_actionOperation((CustomOperation)object);
            }
        } else {
            this.actionOperation = null;
        }
    }

    public CustomOperation _persistence_get_actionOperation() {
        this._persistence_checkFetched("actionOperation");
        this._persistence_initialize_actionOperation_vh();
        this.actionOperation = (CustomOperation)this._persistence_actionOperation_vh.getValue();
        return this.actionOperation;
    }

    public void _persistence_set_actionOperation(CustomOperation customOperation) {
        this._persistence_checkFetchedForSet("actionOperation");
        this._persistence_initialize_actionOperation_vh();
        this.actionOperation = (CustomOperation)this._persistence_actionOperation_vh.getValue();
        this._persistence_propertyChange("actionOperation", this.actionOperation, customOperation);
        this.actionOperation = customOperation;
        this._persistence_actionOperation_vh.setValue((Object)customOperation);
    }

    public Set _persistence_get_parameters() {
        this._persistence_checkFetched("parameters");
        return this.parameters;
    }

    public void _persistence_set_parameters(Set set) {
        this._persistence_checkFetchedForSet("parameters");
        this._persistence_propertyChange("parameters", this.parameters, set);
        this.parameters = set;
    }

    public Boolean _persistence_get_primary() {
        this._persistence_checkFetched("primary");
        return this.primary;
    }

    public void _persistence_set_primary(Boolean bl) {
        this._persistence_checkFetchedForSet("primary");
        this._persistence_propertyChange("primary", this.primary, bl);
        this.primary = bl;
    }

    public Integer _persistence_get_order() {
        this._persistence_checkFetched("order");
        return this.order;
    }

    public void _persistence_set_order(Integer n) {
        this._persistence_checkFetchedForSet("order");
        this._persistence_propertyChange("order", this.order, n);
        this.order = n;
    }
}

