/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.system;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Lob;
import javax.persistence.MappedSuperclass;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.MaxScale;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.CustomFieldPossibleValue;
import org.cyclos.entities.system.CustomFieldPossibleValueCategory;
import org.cyclos.entities.system.CustomFieldValueFile;
import org.cyclos.entities.system.CustomFieldValueImage;
import org.cyclos.entities.system.DynamicFieldValue;
import org.cyclos.entities.system.Image;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.utils.RawFile;
import org.cyclos.entities.utils.StoredFile;
import org.cyclos.model.EntityVO;
import org.cyclos.model.system.fields.CustomFieldType;
import org.cyclos.model.system.fields.ICustomFieldValueWithSet;
import org.cyclos.model.system.fields.LinkedEntityVO;
import org.cyclos.model.utils.DateWrapper;
import org.cyclos.utils.IDate;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@MappedSuperclass
public abstract class CustomFieldValue<CF extends CustomField<CF, C, PV>, C extends CustomFieldPossibleValueCategory<CF, C, PV>, PV extends CustomFieldPossibleValue<CF, C, PV>, O extends SimpleEntity>
extends BaseEntity
implements ICustomFieldValueWithSet<PV, DynamicFieldValue, C, CustomFieldValueFile, CustomFieldValueImage>,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @Basic
    @Column(name="boolean_value")
    private Boolean booleanValue;
    @Basic
    @Column(name="date_value")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateValue;
    @Basic
    @Column(name="decimal_value")
    @MaxScale
    private BigDecimal decimalValue;
    @Basic
    @Column(name="integer_value")
    private Integer integerValue;
    @Basic
    @Column(name="string_value", length=4000)
    private String stringValue;
    @Basic
    @Lob
    @Column(name="text_value")
    private String textValue;
    @Basic
    @Lob
    @Column(name="rich_text_value")
    private String richTextValue;
    @Basic
    @Column(name="linked_entity_id")
    private Long linkedEntityId;
    @Transient
    private List<RawFile> rawFiles;
    @Transient
    private List<Image> rawImages;
    @Transient
    private Object previousValue;
    @Transient
    private boolean skipRawData;
    static final long serialVersionUID = -9157721597429075216L;

    public Boolean getBooleanValue() {
        return this._persistence_get_booleanValue();
    }

    public abstract Class<CF> getCustomFieldClass();

    public IDate getDateValue() {
        return DateWrapper.instance((Date)this._persistence_get_dateValue());
    }

    public BigDecimal getDecimalValue() {
        return this._persistence_get_decimalValue();
    }

    public abstract PV getEnumeratedValue();

    public abstract Set<PV> getEnumeratedValues();

    public abstract CF getField();

    public abstract List<CustomFieldValueFile> getFileValues();

    public abstract List<CustomFieldValueImage> getImageValues();

    public Integer getIntegerValue() {
        return this._persistence_get_integerValue();
    }

    public Long getLinkedEntityId() {
        return this._persistence_get_linkedEntityId();
    }

    public LinkedEntityVO getLinkedEntityValue() {
        if (this._persistence_get_linkedEntityId() == null) {
            return null;
        }
        LinkedEntityVO linkedEntityVO = new LinkedEntityVO();
        linkedEntityVO.setId(this._persistence_get_linkedEntityId());
        return linkedEntityVO;
    }

    @Override
    public Network getNetwork() {
        return this.getField().getNetwork();
    }

    public abstract O getOwner();

    public abstract Class<PV> getPossibleValueClass();

    public Object getPreviousValue() {
        return this.previousValue;
    }

    public List<RawFile> getRawFiles() {
        return this.rawFiles;
    }

    public List<Image> getRawImages() {
        return this.rawImages;
    }

    public String getRichTextValue() {
        return this._persistence_get_richTextValue();
    }

    public final List<? extends StoredFile> getStoredFiles() {
        CustomFieldType customFieldType = this.getField().getType();
        if (customFieldType == CustomFieldType.FILE) {
            return this.getFileValues();
        }
        if (customFieldType == CustomFieldType.IMAGE) {
            return this.getImageValues();
        }
        return null;
    }

    public String getStringValue() {
        return this._persistence_get_stringValue();
    }

    public String getTextValue() {
        return this._persistence_get_textValue();
    }

    public boolean isSkipRawData() {
        return this.skipRawData;
    }

    public void setBooleanValue(Boolean bl) {
        this._persistence_set_booleanValue(bl);
    }

    public void setDateValue(IDate iDate) {
        this._persistence_set_dateValue(iDate == null ? null : ((DateWrapper)iDate).getDate());
    }

    public void setDecimalValue(BigDecimal bigDecimal) {
        this._persistence_set_decimalValue(bigDecimal);
    }

    public abstract void setEnumeratedValue(PV var1);

    public abstract void setEnumeratedValues(Set<PV> var1);

    public abstract void setField(CF var1);

    public abstract void setFileValues(List<CustomFieldValueFile> var1);

    public abstract void setImageValues(List<CustomFieldValueImage> var1);

    public void setIntegerValue(Integer n) {
        this._persistence_set_integerValue(n);
    }

    public void setLinkedEntityId(Long l) {
        this._persistence_set_linkedEntityId(l);
    }

    public void setLinkedEntityValue(LinkedEntityVO linkedEntityVO) {
        this._persistence_set_linkedEntityId(EntityVO.id((EntityVO)linkedEntityVO));
    }

    public abstract void setOwner(O var1);

    public void setPreviousValue(Object object) {
        this.previousValue = object;
    }

    public void setRawFiles(List<RawFile> list) {
        this.rawFiles = list;
    }

    public void setRawImages(List<Image> list) {
        this.rawImages = list;
    }

    public void setRichTextValue(String string) {
        this._persistence_set_richTextValue(string);
    }

    public void setSkipRawData(boolean bl) {
        this.skipRawData = bl;
    }

    public void setStringValue(String string) {
        this._persistence_set_stringValue(string);
    }

    public void setTextValue(String string) {
        this._persistence_set_textValue(string);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new CustomFieldValue<CF, C, PV, O>();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "dateValue") {
            return this.dateValue;
        }
        if (string == "stringValue") {
            return this.stringValue;
        }
        if (string == "textValue") {
            return this.textValue;
        }
        if (string == "richTextValue") {
            return this.richTextValue;
        }
        if (string == "decimalValue") {
            return this.decimalValue;
        }
        if (string == "linkedEntityId") {
            return this.linkedEntityId;
        }
        if (string == "booleanValue") {
            return this.booleanValue;
        }
        if (string == "integerValue") {
            return this.integerValue;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "dateValue") {
            this.dateValue = (Date)object;
            return;
        }
        if (string == "stringValue") {
            this.stringValue = (String)object;
            return;
        }
        if (string == "textValue") {
            this.textValue = (String)object;
            return;
        }
        if (string == "richTextValue") {
            this.richTextValue = (String)object;
            return;
        }
        if (string == "decimalValue") {
            this.decimalValue = (BigDecimal)object;
            return;
        }
        if (string == "linkedEntityId") {
            this.linkedEntityId = (Long)object;
            return;
        }
        if (string == "booleanValue") {
            this.booleanValue = (Boolean)object;
            return;
        }
        if (string == "integerValue") {
            this.integerValue = (Integer)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Date _persistence_get_dateValue() {
        this._persistence_checkFetched("dateValue");
        return this.dateValue;
    }

    public void _persistence_set_dateValue(Date date) {
        this._persistence_checkFetchedForSet("dateValue");
        this._persistence_propertyChange("dateValue", this.dateValue, date);
        this.dateValue = date;
    }

    public String _persistence_get_stringValue() {
        this._persistence_checkFetched("stringValue");
        return this.stringValue;
    }

    public void _persistence_set_stringValue(String string) {
        this._persistence_checkFetchedForSet("stringValue");
        this._persistence_propertyChange("stringValue", this.stringValue, string);
        this.stringValue = string;
    }

    public String _persistence_get_textValue() {
        this._persistence_checkFetched("textValue");
        return this.textValue;
    }

    public void _persistence_set_textValue(String string) {
        this._persistence_checkFetchedForSet("textValue");
        this._persistence_propertyChange("textValue", this.textValue, string);
        this.textValue = string;
    }

    public String _persistence_get_richTextValue() {
        this._persistence_checkFetched("richTextValue");
        return this.richTextValue;
    }

    public void _persistence_set_richTextValue(String string) {
        this._persistence_checkFetchedForSet("richTextValue");
        this._persistence_propertyChange("richTextValue", this.richTextValue, string);
        this.richTextValue = string;
    }

    public BigDecimal _persistence_get_decimalValue() {
        this._persistence_checkFetched("decimalValue");
        return this.decimalValue;
    }

    public void _persistence_set_decimalValue(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("decimalValue");
        this._persistence_propertyChange("decimalValue", this.decimalValue, bigDecimal);
        this.decimalValue = bigDecimal;
    }

    public Long _persistence_get_linkedEntityId() {
        this._persistence_checkFetched("linkedEntityId");
        return this.linkedEntityId;
    }

    public void _persistence_set_linkedEntityId(Long l) {
        this._persistence_checkFetchedForSet("linkedEntityId");
        this._persistence_propertyChange("linkedEntityId", this.linkedEntityId, l);
        this.linkedEntityId = l;
    }

    public Boolean _persistence_get_booleanValue() {
        this._persistence_checkFetched("booleanValue");
        return this.booleanValue;
    }

    public void _persistence_set_booleanValue(Boolean bl) {
        this._persistence_checkFetchedForSet("booleanValue");
        this._persistence_propertyChange("booleanValue", this.booleanValue, bl);
        this.booleanValue = bl;
    }

    public Integer _persistence_get_integerValue() {
        this._persistence_checkFetched("integerValue");
        return this.integerValue;
    }

    public void _persistence_set_integerValue(Integer n) {
        this._persistence_checkFetchedForSet("integerValue");
        this._persistence_propertyChange("integerValue", this.integerValue, n);
        this.integerValue = n;
    }
}

