/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.system;

import java.util.Set;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.IdentityProvider;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.system.CredentialsConfiguration;
import org.cyclos.entities.system.InternetAddressList;
import org.cyclos.entities.system.PinChannelConfiguration;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.system.channelconfigurations.RegistrationWithIdentityProviders;
import org.cyclos.model.system.channelconfigurations.UserChannelAccess;

public interface ChannelAccessAccessor {
    public PasswordType getAccessPassword();

    public Channel getChannel();

    public CredentialsConfiguration getConfirmation();

    default public CredentialsConfiguration getCredentials(CredentialUsage credentialUsage) {
        switch (credentialUsage) {
            case ACCESS: {
                return new CredentialsConfiguration(this.getAccessPassword());
            }
            case LOGIN_CONFIRMATION: {
                return this.getLoginConfirmation();
            }
            case CONFIRMATION: {
                return this.getConfirmation();
            }
        }
        return null;
    }

    public PrincipalType getDefaultPrincipalType();

    public Set<IdentityProvider> getIdentityProviders();

    public CredentialsConfiguration getLoginConfirmation();

    public PinChannelConfiguration getPinConfiguration();

    public Set<PrincipalType> getPrincipalTypes();

    public RegistrationWithIdentityProviders getRegistrationWithIdentityProviders();

    public TimeInterval getSessionTimeout();

    public Integer getTrustedDeviceOnStartup();

    public UserChannelAccess getUserAccess();

    public InternetAddressList getWhitelist();

    public boolean isConfirmationOncePerSession();

    public boolean isRequireAuthenticationForDeviceConfirmation();

    public boolean isRequireTrustedDeviceForLogin();

    public boolean isSkipConfirmationForTrustedDevices();

    public boolean isUseIpWhitelist();
}

