/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.messaging;

import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.model.messaging.notifications.INotificationType;
import org.cyclos.model.utils.Location;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="notifications")
@DiscriminatorColumn(name="subclass")
public abstract class Notification
extends NetworkedEntity
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @Basic
    @Column(name="date", updatable=false, nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date date;
    @Basic
    @Column(name="is_read")
    private Boolean read;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="location")
    private Location location;
    @Basic
    @Column(name="entity_id")
    private Long entityId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id", nullable=false)
    private BasicUser user;
    @Basic
    @Lob
    @Column(name="sms", nullable=false)
    private String sms;
    @Basic
    @Lob
    @Column(name="html_text", nullable=false)
    private String htmlText;
    @Basic
    @Lob
    @Column(name="mail_subject", nullable=false)
    private String mailSubject;
    @Basic
    @Lob
    @Column(name="fcm_configuration")
    private String fcmConfiguration;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="related_user_id")
    private BasicUser relatedUser;
    @Basic
    @Column(name="skip_email")
    private Boolean skipEmail;
    @Basic
    @Column(name="skip_sms")
    private Boolean skipSms;
    static final long serialVersionUID = 148993041158199997L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_relatedUser_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_user_vh;

    public Date getDate() {
        return this._persistence_get_date();
    }

    public Long getEntityId() {
        return this._persistence_get_entityId();
    }

    public String getFcmConfiguration() {
        return this._persistence_get_fcmConfiguration();
    }

    public String getHtmlText() {
        return this._persistence_get_htmlText();
    }

    public Location getLocation() {
        return this._persistence_get_location();
    }

    public String getMailSubject() {
        return this._persistence_get_mailSubject();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_user().getNetwork();
    }

    public BasicUser getRelatedUser() {
        return this._persistence_get_relatedUser();
    }

    public String getSms() {
        return this._persistence_get_sms();
    }

    public abstract INotificationType getType();

    public BasicUser getUser() {
        return this._persistence_get_user();
    }

    public boolean isRead() {
        return Boolean.TRUE.equals(this._persistence_get_read());
    }

    public boolean isSkipEmail() {
        return Boolean.TRUE.equals(this._persistence_get_skipEmail());
    }

    public boolean isSkipSms() {
        return Boolean.TRUE.equals(this._persistence_get_skipSms());
    }

    public void setDate(Date date) {
        this._persistence_set_date(date);
    }

    public void setEntityId(Long l) {
        this._persistence_set_entityId(l);
    }

    public void setFcmConfiguration(String string) {
        this._persistence_set_fcmConfiguration(string);
    }

    public void setHtmlText(String string) {
        this._persistence_set_htmlText(string);
    }

    public void setLocation(Location location) {
        this._persistence_set_location(location);
    }

    public void setMailSubject(String string) {
        this._persistence_set_mailSubject(string);
    }

    public void setRead(boolean bl) {
        this._persistence_set_read(bl);
    }

    public void setRelatedUser(BasicUser basicUser) {
        this._persistence_set_relatedUser(basicUser);
    }

    public void setSkipEmail(boolean bl) {
        this._persistence_set_skipEmail(bl);
    }

    public void setSkipSms(boolean bl) {
        this._persistence_set_skipSms(bl);
    }

    public void setSms(String string) {
        this._persistence_set_sms(string);
    }

    public void setUser(BasicUser basicUser) {
        this._persistence_set_user(basicUser);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_relatedUser_vh != null) {
            this._persistence_relatedUser_vh = (WeavedAttributeValueHolderInterface)this._persistence_relatedUser_vh.clone();
        }
        if (this._persistence_user_vh != null) {
            this._persistence_user_vh = (WeavedAttributeValueHolderInterface)this._persistence_user_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Notification();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "date") {
            return this.date;
        }
        if (string == "relatedUser") {
            return this.relatedUser;
        }
        if (string == "read") {
            return this.read;
        }
        if (string == "skipSms") {
            return this.skipSms;
        }
        if (string == "entityId") {
            return this.entityId;
        }
        if (string == "mailSubject") {
            return this.mailSubject;
        }
        if (string == "skipEmail") {
            return this.skipEmail;
        }
        if (string == "sms") {
            return this.sms;
        }
        if (string == "location") {
            return this.location;
        }
        if (string == "user") {
            return this.user;
        }
        if (string == "htmlText") {
            return this.htmlText;
        }
        if (string == "fcmConfiguration") {
            return this.fcmConfiguration;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "date") {
            this.date = (Date)object;
            return;
        }
        if (string == "relatedUser") {
            this.relatedUser = (BasicUser)object;
            return;
        }
        if (string == "read") {
            this.read = (Boolean)object;
            return;
        }
        if (string == "skipSms") {
            this.skipSms = (Boolean)object;
            return;
        }
        if (string == "entityId") {
            this.entityId = (Long)object;
            return;
        }
        if (string == "mailSubject") {
            this.mailSubject = (String)object;
            return;
        }
        if (string == "skipEmail") {
            this.skipEmail = (Boolean)object;
            return;
        }
        if (string == "sms") {
            this.sms = (String)object;
            return;
        }
        if (string == "location") {
            this.location = (Location)object;
            return;
        }
        if (string == "user") {
            this.user = (BasicUser)object;
            return;
        }
        if (string == "htmlText") {
            this.htmlText = (String)object;
            return;
        }
        if (string == "fcmConfiguration") {
            this.fcmConfiguration = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Date _persistence_get_date() {
        this._persistence_checkFetched("date");
        return this.date;
    }

    public void _persistence_set_date(Date date) {
        this._persistence_checkFetchedForSet("date");
        this._persistence_propertyChange("date", this.date, date);
        this.date = date;
    }

    protected void _persistence_initialize_relatedUser_vh() {
        if (this._persistence_relatedUser_vh == null) {
            this._persistence_relatedUser_vh = new ValueHolder((Object)this.relatedUser);
            this._persistence_relatedUser_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_relatedUser_vh() {
        BasicUser basicUser;
        this._persistence_initialize_relatedUser_vh();
        if ((this._persistence_relatedUser_vh.isCoordinatedWithProperty() || this._persistence_relatedUser_vh.isNewlyWeavedValueHolder()) && (basicUser = this._persistence_get_relatedUser()) != this._persistence_relatedUser_vh.getValue()) {
            this._persistence_set_relatedUser(basicUser);
        }
        return this._persistence_relatedUser_vh;
    }

    public void _persistence_set_relatedUser_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_relatedUser_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            BasicUser basicUser = this._persistence_get_relatedUser();
            if (basicUser != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_relatedUser((BasicUser)object);
            }
        } else {
            this.relatedUser = null;
        }
    }

    public BasicUser _persistence_get_relatedUser() {
        this._persistence_checkFetched("relatedUser");
        this._persistence_initialize_relatedUser_vh();
        this.relatedUser = (BasicUser)this._persistence_relatedUser_vh.getValue();
        return this.relatedUser;
    }

    public void _persistence_set_relatedUser(BasicUser basicUser) {
        this._persistence_checkFetchedForSet("relatedUser");
        this._persistence_initialize_relatedUser_vh();
        this.relatedUser = (BasicUser)this._persistence_relatedUser_vh.getValue();
        this._persistence_propertyChange("relatedUser", this.relatedUser, basicUser);
        this.relatedUser = basicUser;
        this._persistence_relatedUser_vh.setValue((Object)basicUser);
    }

    public Boolean _persistence_get_read() {
        this._persistence_checkFetched("read");
        return this.read;
    }

    public void _persistence_set_read(Boolean bl) {
        this._persistence_checkFetchedForSet("read");
        this._persistence_propertyChange("read", this.read, bl);
        this.read = bl;
    }

    public Boolean _persistence_get_skipSms() {
        this._persistence_checkFetched("skipSms");
        return this.skipSms;
    }

    public void _persistence_set_skipSms(Boolean bl) {
        this._persistence_checkFetchedForSet("skipSms");
        this._persistence_propertyChange("skipSms", this.skipSms, bl);
        this.skipSms = bl;
    }

    public Long _persistence_get_entityId() {
        this._persistence_checkFetched("entityId");
        return this.entityId;
    }

    public void _persistence_set_entityId(Long l) {
        this._persistence_checkFetchedForSet("entityId");
        this._persistence_propertyChange("entityId", this.entityId, l);
        this.entityId = l;
    }

    public String _persistence_get_mailSubject() {
        this._persistence_checkFetched("mailSubject");
        return this.mailSubject;
    }

    public void _persistence_set_mailSubject(String string) {
        this._persistence_checkFetchedForSet("mailSubject");
        this._persistence_propertyChange("mailSubject", this.mailSubject, string);
        this.mailSubject = string;
    }

    public Boolean _persistence_get_skipEmail() {
        this._persistence_checkFetched("skipEmail");
        return this.skipEmail;
    }

    public void _persistence_set_skipEmail(Boolean bl) {
        this._persistence_checkFetchedForSet("skipEmail");
        this._persistence_propertyChange("skipEmail", this.skipEmail, bl);
        this.skipEmail = bl;
    }

    public String _persistence_get_sms() {
        this._persistence_checkFetched("sms");
        return this.sms;
    }

    public void _persistence_set_sms(String string) {
        this._persistence_checkFetchedForSet("sms");
        this._persistence_propertyChange("sms", this.sms, string);
        this.sms = string;
    }

    public Location _persistence_get_location() {
        this._persistence_checkFetched("location");
        return this.location;
    }

    public void _persistence_set_location(Location location) {
        this._persistence_checkFetchedForSet("location");
        this._persistence_propertyChange("location", this.location, location);
        this.location = location;
    }

    protected void _persistence_initialize_user_vh() {
        if (this._persistence_user_vh == null) {
            this._persistence_user_vh = new ValueHolder((Object)this.user);
            this._persistence_user_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_user_vh() {
        BasicUser basicUser;
        this._persistence_initialize_user_vh();
        if ((this._persistence_user_vh.isCoordinatedWithProperty() || this._persistence_user_vh.isNewlyWeavedValueHolder()) && (basicUser = this._persistence_get_user()) != this._persistence_user_vh.getValue()) {
            this._persistence_set_user(basicUser);
        }
        return this._persistence_user_vh;
    }

    public void _persistence_set_user_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_user_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            BasicUser basicUser = this._persistence_get_user();
            if (basicUser != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_user((BasicUser)object);
            }
        } else {
            this.user = null;
        }
    }

    public BasicUser _persistence_get_user() {
        this._persistence_checkFetched("user");
        this._persistence_initialize_user_vh();
        this.user = (BasicUser)this._persistence_user_vh.getValue();
        return this.user;
    }

    public void _persistence_set_user(BasicUser basicUser) {
        this._persistence_checkFetchedForSet("user");
        this._persistence_initialize_user_vh();
        this.user = (BasicUser)this._persistence_user_vh.getValue();
        this._persistence_propertyChange("user", this.user, basicUser);
        this.user = basicUser;
        this._persistence_user_vh.setValue((Object)basicUser);
    }

    public String _persistence_get_htmlText() {
        this._persistence_checkFetched("htmlText");
        return this.htmlText;
    }

    public void _persistence_set_htmlText(String string) {
        this._persistence_checkFetchedForSet("htmlText");
        this._persistence_propertyChange("htmlText", this.htmlText, string);
        this.htmlText = string;
    }

    public String _persistence_get_fcmConfiguration() {
        this._persistence_checkFetched("fcmConfiguration");
        return this.fcmConfiguration;
    }

    public void _persistence_set_fcmConfiguration(String string) {
        this._persistence_checkFetchedForSet("fcmConfiguration");
        this._persistence_propertyChange("fcmConfiguration", this.fcmConfiguration, string);
        this.fcmConfiguration = string;
    }
}

