/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.messaging;

import org.cyclos.entities.messaging.MailContextPriority;
import org.cyclos.model.messaging.notificationsettings.EmailUnsubscribeType;

public enum MailContext {
    NOTIFICATION(MailContextPriority.IMMEDIATE),
    CUSTOM_NOTIFICATION(MailContextPriority.IMMEDIATE),
    FORWARD_INTERNAL_MESSAGE(MailContextPriority.BACKGROUND),
    NEW_EMAIL_VALIDATION(MailContextPriority.CONCURRENT),
    WIZARD_EMAIL_VALIDATION(MailContextPriority.SAME_TRANSACTION),
    EMAIL_CHANGE(MailContextPriority.CONCURRENT),
    NEW_MOBILE_PHONE(MailContextPriority.CONCURRENT),
    LOGIN_ON_NEW_DEVICE(MailContextPriority.CONCURRENT),
    PASSWORD_RESET(MailContextPriority.SAME_TRANSACTION),
    OTP(MailContextPriority.SAME_TRANSACTION),
    REGISTRATION_ACTIVATION(MailContextPriority.CONCURRENT),
    REGISTRATION_VALIDATION(MailContextPriority.CONCURRENT),
    PENDING_ACTIVATION(MailContextPriority.CONCURRENT),
    FORGOT_PASSWORD(MailContextPriority.SAME_TRANSACTION),
    TRUSTED_DEVICE_ACTIVATION(MailContextPriority.SAME_TRANSACTION),
    TOTP_ACTIVATION(MailContextPriority.SAME_TRANSACTION),
    MAILING_LIST(MailContextPriority.SAME_TRANSACTION),
    ACCESS_CLIENT_ACTIVATION(MailContextPriority.SAME_TRANSACTION);

    private final MailContextPriority priority;

    private MailContext(MailContextPriority mailContextPriority) {
        this.priority = mailContextPriority;
    }

    public MailContextPriority getPriority() {
        return this.priority;
    }

    public EmailUnsubscribeType unsubscribeType() {
        switch (this.ordinal()) {
            case 0: {
                return EmailUnsubscribeType.NOTIFICATION;
            }
            case 2: {
                return EmailUnsubscribeType.MESSAGE;
            }
            case 16: {
                return EmailUnsubscribeType.MAILING;
            }
        }
        return null;
    }
}

