/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.marketplace;

import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.marketplace.Order;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.model.marketplace.webshoporders.OrderStatus;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="ad_order_logs")
public class OrderLog
extends NetworkedEntity
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @Basic
    @Column(name="date", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date date;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id")
    private BasicUser by;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="order_status")
    private OrderStatus status;
    @Basic
    @Column(name="pending_by_admin", nullable=true)
    private Boolean pendingByAdmin;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="order_id", nullable=false)
    private Order order;
    @Basic
    @Lob
    @Column(name="remarks")
    private String remarks;
    static final long serialVersionUID = -3014355708484509761L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_by_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_order_vh;

    public BasicUser getBy() {
        return this._persistence_get_by();
    }

    public Date getDate() {
        return this._persistence_get_date();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_order().getNetwork();
    }

    public Order getOrder() {
        return this._persistence_get_order();
    }

    public boolean isPendingByAdmin() {
        return Boolean.TRUE.equals(this._persistence_get_pendingByAdmin());
    }

    public String getRemarks() {
        return this._persistence_get_remarks();
    }

    public OrderStatus getStatus() {
        return this._persistence_get_status();
    }

    public void setBy(BasicUser basicUser) {
        this._persistence_set_by(basicUser);
    }

    public void setDate(Date date) {
        this._persistence_set_date(date);
    }

    public void setOrder(Order order) {
        this._persistence_set_order(order);
    }

    public void setPendingByAdmin(boolean bl) {
        this._persistence_set_pendingByAdmin(bl);
    }

    public void setRemarks(String string) {
        this._persistence_set_remarks(string);
    }

    public void setStatus(OrderStatus orderStatus) {
        this._persistence_set_status(orderStatus);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_by_vh != null) {
            this._persistence_by_vh = (WeavedAttributeValueHolderInterface)this._persistence_by_vh.clone();
        }
        if (this._persistence_order_vh != null) {
            this._persistence_order_vh = (WeavedAttributeValueHolderInterface)this._persistence_order_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new OrderLog();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "date") {
            return this.date;
        }
        if (string == "by") {
            return this.by;
        }
        if (string == "pendingByAdmin") {
            return this.pendingByAdmin;
        }
        if (string == "remarks") {
            return this.remarks;
        }
        if (string == "status") {
            return this.status;
        }
        if (string == "order") {
            return this.order;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "date") {
            this.date = (Date)object;
            return;
        }
        if (string == "by") {
            this.by = (BasicUser)object;
            return;
        }
        if (string == "pendingByAdmin") {
            this.pendingByAdmin = (Boolean)object;
            return;
        }
        if (string == "remarks") {
            this.remarks = (String)object;
            return;
        }
        if (string == "status") {
            this.status = (OrderStatus)object;
            return;
        }
        if (string == "order") {
            this.order = (Order)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Date _persistence_get_date() {
        this._persistence_checkFetched("date");
        return this.date;
    }

    public void _persistence_set_date(Date date) {
        this._persistence_checkFetchedForSet("date");
        this._persistence_propertyChange("date", this.date, date);
        this.date = date;
    }

    protected void _persistence_initialize_by_vh() {
        if (this._persistence_by_vh == null) {
            this._persistence_by_vh = new ValueHolder((Object)this.by);
            this._persistence_by_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_by_vh() {
        BasicUser basicUser;
        this._persistence_initialize_by_vh();
        if ((this._persistence_by_vh.isCoordinatedWithProperty() || this._persistence_by_vh.isNewlyWeavedValueHolder()) && (basicUser = this._persistence_get_by()) != this._persistence_by_vh.getValue()) {
            this._persistence_set_by(basicUser);
        }
        return this._persistence_by_vh;
    }

    public void _persistence_set_by_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_by_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            BasicUser basicUser = this._persistence_get_by();
            if (basicUser != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_by((BasicUser)object);
            }
        } else {
            this.by = null;
        }
    }

    public BasicUser _persistence_get_by() {
        this._persistence_checkFetched("by");
        this._persistence_initialize_by_vh();
        this.by = (BasicUser)this._persistence_by_vh.getValue();
        return this.by;
    }

    public void _persistence_set_by(BasicUser basicUser) {
        this._persistence_checkFetchedForSet("by");
        this._persistence_initialize_by_vh();
        this.by = (BasicUser)this._persistence_by_vh.getValue();
        this._persistence_propertyChange("by", this.by, basicUser);
        this.by = basicUser;
        this._persistence_by_vh.setValue((Object)basicUser);
    }

    public Boolean _persistence_get_pendingByAdmin() {
        this._persistence_checkFetched("pendingByAdmin");
        return this.pendingByAdmin;
    }

    public void _persistence_set_pendingByAdmin(Boolean bl) {
        this._persistence_checkFetchedForSet("pendingByAdmin");
        this._persistence_propertyChange("pendingByAdmin", this.pendingByAdmin, bl);
        this.pendingByAdmin = bl;
    }

    public String _persistence_get_remarks() {
        this._persistence_checkFetched("remarks");
        return this.remarks;
    }

    public void _persistence_set_remarks(String string) {
        this._persistence_checkFetchedForSet("remarks");
        this._persistence_propertyChange("remarks", this.remarks, string);
        this.remarks = string;
    }

    public OrderStatus _persistence_get_status() {
        this._persistence_checkFetched("status");
        return this.status;
    }

    public void _persistence_set_status(OrderStatus orderStatus) {
        this._persistence_checkFetchedForSet("status");
        this._persistence_propertyChange("status", this.status, orderStatus);
        this.status = orderStatus;
    }

    protected void _persistence_initialize_order_vh() {
        if (this._persistence_order_vh == null) {
            this._persistence_order_vh = new ValueHolder((Object)this.order);
            this._persistence_order_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_order_vh() {
        Order order;
        this._persistence_initialize_order_vh();
        if ((this._persistence_order_vh.isCoordinatedWithProperty() || this._persistence_order_vh.isNewlyWeavedValueHolder()) && (order = this._persistence_get_order()) != this._persistence_order_vh.getValue()) {
            this._persistence_set_order(order);
        }
        return this._persistence_order_vh;
    }

    public void _persistence_set_order_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_order_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Order order = this._persistence_get_order();
            if (order != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_order((Order)object);
            }
        } else {
            this.order = null;
        }
    }

    public Order _persistence_get_order() {
        this._persistence_checkFetched("order");
        this._persistence_initialize_order_vh();
        this.order = (Order)this._persistence_order_vh.getValue();
        return this.order;
    }

    public void _persistence_set_order(Order order) {
        this._persistence_checkFetchedForSet("order");
        this._persistence_initialize_order_vh();
        this.order = (Order)this._persistence_order_vh.getValue();
        this._persistence_propertyChange("order", this.order, order);
        this.order = order;
        this._persistence_order_vh.setValue((Object)order);
    }
}

