/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.marketplace;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import org.cyclos.entities.FixedScale;
import org.cyclos.entities.marketplace.AdDeliveryMethod;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.model.marketplace.advertisements.AdType;
import org.cyclos.model.marketplace.advertisements.AdWebShopStockType;
import org.cyclos.utils.BigDecimalHelper;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@DiscriminatorValue(value="WEB_SHOP")
public class AdWebShop
extends BasicAd
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @Basic
    @Column(name="min_stock_limit")
    @FixedScale(value=2)
    private BigDecimal minimumStockLimit;
    @Basic
    @Column(name="max_allowed_cart_items")
    @FixedScale(value=2)
    private BigDecimal maxAllowedInCart;
    @Basic
    @Column(name="min_allowed_cart_items")
    @FixedScale(value=2)
    private BigDecimal minAllowedInCart;
    @Basic
    @Column(name="product_number")
    private String productNumber;
    @Basic
    @Column(name="allow_decimal")
    private Boolean allowDecimal;
    @Basic
    @Column(name="low_stock_notified")
    private Boolean lowStockNotified;
    @ManyToMany
    @JoinTable(name="webshop_ads_delivery_methods", joinColumns={@JoinColumn(name="ad_id")}, inverseJoinColumns={@JoinColumn(name="delivery_method_id")})
    private Set<AdDeliveryMethod> deliveryMethods = new HashSet<AdDeliveryMethod>();
    static final long serialVersionUID = 1131250010743099182L;

    public static boolean isInStock(AdWebShopStockType adWebShopStockType, BigDecimal bigDecimal) {
        return adWebShopStockType == AdWebShopStockType.AVAILABLE || adWebShopStockType == AdWebShopStockType.QUANTITY && BigDecimalHelper.isPositive((BigDecimal)bigDecimal);
    }

    @Override
    public AdType getAdType() {
        return AdType.WEB_SHOP;
    }

    public Set<AdDeliveryMethod> getDeliveryMethods() {
        return this._persistence_get_deliveryMethods();
    }

    public Boolean getLowStockNotified() {
        return this._persistence_get_lowStockNotified();
    }

    public BigDecimal getMaxAllowedInCart() {
        return this._persistence_get_maxAllowedInCart();
    }

    public BigDecimal getMinAllowedInCart() {
        return this._persistence_get_minAllowedInCart();
    }

    public BigDecimal getMinimumStockLimit() {
        return this._persistence_get_minimumStockLimit();
    }

    public String getProductNumber() {
        return this._persistence_get_productNumber();
    }

    public BigDecimal getStockQuantity() {
        return this._persistence_get_stockQuantity();
    }

    public AdWebShopStockType getStockType() {
        return this._persistence_get_stockType();
    }

    public boolean isAllowDecimal() {
        return Boolean.TRUE.equals(this._persistence_get_allowDecimal());
    }

    @Override
    public boolean isInStock() {
        return AdWebShop.isInStock(this._persistence_get_stockType(), this._persistence_get_stockQuantity());
    }

    public void setAllowDecimal(boolean bl) {
        this._persistence_set_allowDecimal(bl);
    }

    public void setDeliveryMethods(Set<AdDeliveryMethod> set) {
        this._persistence_set_deliveryMethods(set);
    }

    public void setLowStockNotified(Boolean bl) {
        this._persistence_set_lowStockNotified(bl);
    }

    public void setMaxAllowedInCart(BigDecimal bigDecimal) {
        this._persistence_set_maxAllowedInCart(bigDecimal);
    }

    public void setMinAllowedInCart(BigDecimal bigDecimal) {
        this._persistence_set_minAllowedInCart(bigDecimal);
    }

    public void setMinimumStockLimit(BigDecimal bigDecimal) {
        this._persistence_set_minimumStockLimit(bigDecimal);
    }

    public void setProductNumber(String string) {
        this._persistence_set_productNumber(string);
    }

    public void setStockQuantity(BigDecimal bigDecimal) {
        this._persistence_set_stockQuantity(bigDecimal);
    }

    public void setStockType(AdWebShopStockType adWebShopStockType) {
        this._persistence_set_stockType(adWebShopStockType);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new AdWebShop();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "minimumStockLimit") {
            return this.minimumStockLimit;
        }
        if (string == "lowStockNotified") {
            return this.lowStockNotified;
        }
        if (string == "productNumber") {
            return this.productNumber;
        }
        if (string == "allowDecimal") {
            return this.allowDecimal;
        }
        if (string == "deliveryMethods") {
            return this.deliveryMethods;
        }
        if (string == "maxAllowedInCart") {
            return this.maxAllowedInCart;
        }
        if (string == "minAllowedInCart") {
            return this.minAllowedInCart;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "minimumStockLimit") {
            this.minimumStockLimit = (BigDecimal)object;
            return;
        }
        if (string == "lowStockNotified") {
            this.lowStockNotified = (Boolean)object;
            return;
        }
        if (string == "productNumber") {
            this.productNumber = (String)object;
            return;
        }
        if (string == "allowDecimal") {
            this.allowDecimal = (Boolean)object;
            return;
        }
        if (string == "deliveryMethods") {
            this.deliveryMethods = (Set)object;
            return;
        }
        if (string == "maxAllowedInCart") {
            this.maxAllowedInCart = (BigDecimal)object;
            return;
        }
        if (string == "minAllowedInCart") {
            this.minAllowedInCart = (BigDecimal)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public BigDecimal _persistence_get_minimumStockLimit() {
        this._persistence_checkFetched("minimumStockLimit");
        return this.minimumStockLimit;
    }

    public void _persistence_set_minimumStockLimit(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("minimumStockLimit");
        this._persistence_propertyChange("minimumStockLimit", this.minimumStockLimit, bigDecimal);
        this.minimumStockLimit = bigDecimal;
    }

    public Boolean _persistence_get_lowStockNotified() {
        this._persistence_checkFetched("lowStockNotified");
        return this.lowStockNotified;
    }

    public void _persistence_set_lowStockNotified(Boolean bl) {
        this._persistence_checkFetchedForSet("lowStockNotified");
        this._persistence_propertyChange("lowStockNotified", this.lowStockNotified, bl);
        this.lowStockNotified = bl;
    }

    public String _persistence_get_productNumber() {
        this._persistence_checkFetched("productNumber");
        return this.productNumber;
    }

    public void _persistence_set_productNumber(String string) {
        this._persistence_checkFetchedForSet("productNumber");
        this._persistence_propertyChange("productNumber", this.productNumber, string);
        this.productNumber = string;
    }

    public Boolean _persistence_get_allowDecimal() {
        this._persistence_checkFetched("allowDecimal");
        return this.allowDecimal;
    }

    public void _persistence_set_allowDecimal(Boolean bl) {
        this._persistence_checkFetchedForSet("allowDecimal");
        this._persistence_propertyChange("allowDecimal", this.allowDecimal, bl);
        this.allowDecimal = bl;
    }

    public Set _persistence_get_deliveryMethods() {
        this._persistence_checkFetched("deliveryMethods");
        return this.deliveryMethods;
    }

    public void _persistence_set_deliveryMethods(Set set) {
        this._persistence_checkFetchedForSet("deliveryMethods");
        this._persistence_propertyChange("deliveryMethods", this.deliveryMethods, set);
        this.deliveryMethods = set;
    }

    public BigDecimal _persistence_get_maxAllowedInCart() {
        this._persistence_checkFetched("maxAllowedInCart");
        return this.maxAllowedInCart;
    }

    public void _persistence_set_maxAllowedInCart(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("maxAllowedInCart");
        this._persistence_propertyChange("maxAllowedInCart", this.maxAllowedInCart, bigDecimal);
        this.maxAllowedInCart = bigDecimal;
    }

    public BigDecimal _persistence_get_minAllowedInCart() {
        this._persistence_checkFetched("minAllowedInCart");
        return this.minAllowedInCart;
    }

    public void _persistence_set_minAllowedInCart(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("minAllowedInCart");
        this._persistence_propertyChange("minAllowedInCart", this.minAllowedInCart, bigDecimal);
        this.minAllowedInCart = bigDecimal;
    }
}

