/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.marketplace;

import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.CurrencyScale;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.OwnerEntity;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.HasCurrency;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserAddress;
import org.cyclos.entities.utils.CurrencyAmount;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.model.marketplace.webshopdeliverymethods.AdDeliveryMethodChargeType;
import org.cyclos.model.marketplace.webshopdeliverymethods.AdDeliveryMethodType;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Cacheable(value=true)
@Table(name="ad_delivery_methods")
public class AdDeliveryMethod
extends NamedEntity
implements HasCurrency,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @Enumerated(value=EnumType.STRING)
    @Column(name="charge_type")
    private AdDeliveryMethodChargeType chargeType = AdDeliveryMethodChargeType.FIXED;
    @Enumerated(value=EnumType.STRING)
    @Column(name="delivery_type")
    private AdDeliveryMethodType deliveryType = AdDeliveryMethodType.DELIVER;
    @Basic
    @Column(name="amount")
    @CurrencyScale
    private BigDecimal price;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="currency_id")
    private Currency currency;
    @OwnerEntity
    @ManyToOne(fetch=FetchType.LAZY)
    @ReadOnlyFromDTO(onInsert=false)
    @JoinColumn(name="owner_id", nullable=false)
    private User owner;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="amount", column=@Column(name="min_time_amount")), @AttributeOverride(name="field", column=@Column(name="min_time_field"))})
    private TimeInterval minDeliveryTime;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="amount", column=@Column(name="max_time_amount")), @AttributeOverride(name="field", column=@Column(name="max_time_field"))})
    private TimeInterval maxDeliveryTime;
    @Basic
    @Column(name="enabled", nullable=false)
    private boolean enabled = true;
    @Basic
    @Column(name="removed_from_owner", nullable=false)
    private boolean removedFromOwner;
    @Basic
    @Lob
    @Column(name="details")
    private String details;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="creation_date")
    private Date creationDate;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="address_id")
    private UserAddress address;
    static final long serialVersionUID = 3303005905738461579L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_owner_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_address_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_currency_vh;

    public UserAddress getAddress() {
        return this._persistence_get_address();
    }

    public AdDeliveryMethodChargeType getChargeType() {
        return this._persistence_get_chargeType();
    }

    public Date getCreationDate() {
        return this._persistence_get_creationDate();
    }

    @Override
    public Currency getCurrency() {
        return this._persistence_get_currency();
    }

    public AdDeliveryMethodType getDeliveryType() {
        return this._persistence_get_deliveryType();
    }

    public String getDetails() {
        return this._persistence_get_details();
    }

    public TimeInterval getMaxDeliveryTime() {
        return this._persistence_get_maxDeliveryTime();
    }

    public TimeInterval getMinDeliveryTime() {
        return this._persistence_get_minDeliveryTime();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_owner().getNetwork();
    }

    public User getOwner() {
        return this._persistence_get_owner();
    }

    public CurrencyAmount getPrice() {
        return new CurrencyAmount(this._persistence_get_currency(), this._persistence_get_price());
    }

    public boolean isEnabled() {
        return this._persistence_get_enabled();
    }

    public boolean isRemovedFromOwner() {
        return this._persistence_get_removedFromOwner();
    }

    public void setAddress(UserAddress userAddress) {
        this._persistence_set_address(userAddress);
    }

    public void setChargeType(AdDeliveryMethodChargeType adDeliveryMethodChargeType) {
        this._persistence_set_chargeType(adDeliveryMethodChargeType);
    }

    public void setCreationDate(Date date) {
        this._persistence_set_creationDate(date);
    }

    public void setDeliveryType(AdDeliveryMethodType adDeliveryMethodType) {
        this._persistence_set_deliveryType(adDeliveryMethodType);
    }

    public void setDetails(String string) {
        this._persistence_set_details(string);
    }

    public void setEnabled(boolean bl) {
        this._persistence_set_enabled(bl);
    }

    public void setMaxDeliveryTime(TimeInterval timeInterval) {
        this._persistence_set_maxDeliveryTime(timeInterval);
    }

    public void setMinDeliveryTime(TimeInterval timeInterval) {
        this._persistence_set_minDeliveryTime(timeInterval);
    }

    public void setOwner(User user) {
        this._persistence_set_owner(user);
    }

    public void setPrice(CurrencyAmount currencyAmount) {
        this._persistence_set_price(currencyAmount == null ? null : currencyAmount.getAmount());
        this._persistence_set_currency(currencyAmount == null ? null : currencyAmount.getCurrency());
    }

    public void setRemovedFromOwner(boolean bl) {
        this._persistence_set_removedFromOwner(bl);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_owner_vh != null) {
            this._persistence_owner_vh = (WeavedAttributeValueHolderInterface)this._persistence_owner_vh.clone();
        }
        if (this._persistence_address_vh != null) {
            this._persistence_address_vh = (WeavedAttributeValueHolderInterface)this._persistence_address_vh.clone();
        }
        if (this._persistence_currency_vh != null) {
            this._persistence_currency_vh = (WeavedAttributeValueHolderInterface)this._persistence_currency_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new AdDeliveryMethod();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "owner") {
            return this.owner;
        }
        if (string == "address") {
            return this.address;
        }
        if (string == "chargeType") {
            return this.chargeType;
        }
        if (string == "deliveryType") {
            return this.deliveryType;
        }
        if (string == "creationDate") {
            return this.creationDate;
        }
        if (string == "enabled") {
            return this.enabled;
        }
        if (string == "minDeliveryTime") {
            return this.minDeliveryTime;
        }
        if (string == "maxDeliveryTime") {
            return this.maxDeliveryTime;
        }
        if (string == "price") {
            return this.price;
        }
        if (string == "details") {
            return this.details;
        }
        if (string == "currency") {
            return this.currency;
        }
        if (string == "removedFromOwner") {
            return this.removedFromOwner;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "owner") {
            this.owner = (User)object;
            return;
        }
        if (string == "address") {
            this.address = (UserAddress)object;
            return;
        }
        if (string == "chargeType") {
            this.chargeType = (AdDeliveryMethodChargeType)object;
            return;
        }
        if (string == "deliveryType") {
            this.deliveryType = (AdDeliveryMethodType)object;
            return;
        }
        if (string == "creationDate") {
            this.creationDate = (Date)object;
            return;
        }
        if (string == "enabled") {
            this.enabled = (Boolean)object;
            return;
        }
        if (string == "minDeliveryTime") {
            this.minDeliveryTime = (TimeInterval)object;
            return;
        }
        if (string == "maxDeliveryTime") {
            this.maxDeliveryTime = (TimeInterval)object;
            return;
        }
        if (string == "price") {
            this.price = (BigDecimal)object;
            return;
        }
        if (string == "details") {
            this.details = (String)object;
            return;
        }
        if (string == "currency") {
            this.currency = (Currency)object;
            return;
        }
        if (string == "removedFromOwner") {
            this.removedFromOwner = (Boolean)object;
            return;
        }
        super._persistence_set(string, object);
    }

    protected void _persistence_initialize_owner_vh() {
        if (this._persistence_owner_vh == null) {
            this._persistence_owner_vh = new ValueHolder((Object)this.owner);
            this._persistence_owner_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_owner_vh() {
        User user;
        this._persistence_initialize_owner_vh();
        if ((this._persistence_owner_vh.isCoordinatedWithProperty() || this._persistence_owner_vh.isNewlyWeavedValueHolder()) && (user = this._persistence_get_owner()) != this._persistence_owner_vh.getValue()) {
            this._persistence_set_owner(user);
        }
        return this._persistence_owner_vh;
    }

    public void _persistence_set_owner_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_owner_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            User user = this._persistence_get_owner();
            if (user != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_owner((User)object);
            }
        } else {
            this.owner = null;
        }
    }

    public User _persistence_get_owner() {
        this._persistence_checkFetched("owner");
        this._persistence_initialize_owner_vh();
        this.owner = (User)this._persistence_owner_vh.getValue();
        return this.owner;
    }

    public void _persistence_set_owner(User user) {
        this._persistence_checkFetchedForSet("owner");
        this._persistence_initialize_owner_vh();
        this.owner = (User)this._persistence_owner_vh.getValue();
        this._persistence_propertyChange("owner", this.owner, user);
        this.owner = user;
        this._persistence_owner_vh.setValue((Object)user);
    }

    protected void _persistence_initialize_address_vh() {
        if (this._persistence_address_vh == null) {
            this._persistence_address_vh = new ValueHolder((Object)this.address);
            this._persistence_address_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_address_vh() {
        UserAddress userAddress;
        this._persistence_initialize_address_vh();
        if ((this._persistence_address_vh.isCoordinatedWithProperty() || this._persistence_address_vh.isNewlyWeavedValueHolder()) && (userAddress = this._persistence_get_address()) != this._persistence_address_vh.getValue()) {
            this._persistence_set_address(userAddress);
        }
        return this._persistence_address_vh;
    }

    public void _persistence_set_address_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_address_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            UserAddress userAddress = this._persistence_get_address();
            if (userAddress != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_address((UserAddress)object);
            }
        } else {
            this.address = null;
        }
    }

    public UserAddress _persistence_get_address() {
        this._persistence_checkFetched("address");
        this._persistence_initialize_address_vh();
        this.address = (UserAddress)this._persistence_address_vh.getValue();
        return this.address;
    }

    public void _persistence_set_address(UserAddress userAddress) {
        this._persistence_checkFetchedForSet("address");
        this._persistence_initialize_address_vh();
        this.address = (UserAddress)this._persistence_address_vh.getValue();
        this._persistence_propertyChange("address", this.address, userAddress);
        this.address = userAddress;
        this._persistence_address_vh.setValue((Object)userAddress);
    }

    public AdDeliveryMethodChargeType _persistence_get_chargeType() {
        this._persistence_checkFetched("chargeType");
        return this.chargeType;
    }

    public void _persistence_set_chargeType(AdDeliveryMethodChargeType adDeliveryMethodChargeType) {
        this._persistence_checkFetchedForSet("chargeType");
        this._persistence_propertyChange("chargeType", this.chargeType, adDeliveryMethodChargeType);
        this.chargeType = adDeliveryMethodChargeType;
    }

    public AdDeliveryMethodType _persistence_get_deliveryType() {
        this._persistence_checkFetched("deliveryType");
        return this.deliveryType;
    }

    public void _persistence_set_deliveryType(AdDeliveryMethodType adDeliveryMethodType) {
        this._persistence_checkFetchedForSet("deliveryType");
        this._persistence_propertyChange("deliveryType", this.deliveryType, adDeliveryMethodType);
        this.deliveryType = adDeliveryMethodType;
    }

    public Date _persistence_get_creationDate() {
        this._persistence_checkFetched("creationDate");
        return this.creationDate;
    }

    public void _persistence_set_creationDate(Date date) {
        this._persistence_checkFetchedForSet("creationDate");
        this._persistence_propertyChange("creationDate", this.creationDate, date);
        this.creationDate = date;
    }

    public boolean _persistence_get_enabled() {
        this._persistence_checkFetched("enabled");
        return this.enabled;
    }

    public void _persistence_set_enabled(boolean bl) {
        this._persistence_checkFetchedForSet("enabled");
        this._persistence_propertyChange("enabled", new Boolean(this.enabled), new Boolean(bl));
        this.enabled = bl;
    }

    public TimeInterval _persistence_get_minDeliveryTime() {
        this._persistence_checkFetched("minDeliveryTime");
        return this.minDeliveryTime;
    }

    public void _persistence_set_minDeliveryTime(TimeInterval timeInterval) {
        this._persistence_checkFetchedForSet("minDeliveryTime");
        this._persistence_propertyChange("minDeliveryTime", this.minDeliveryTime, timeInterval);
        this.minDeliveryTime = timeInterval;
    }

    public TimeInterval _persistence_get_maxDeliveryTime() {
        this._persistence_checkFetched("maxDeliveryTime");
        return this.maxDeliveryTime;
    }

    public void _persistence_set_maxDeliveryTime(TimeInterval timeInterval) {
        this._persistence_checkFetchedForSet("maxDeliveryTime");
        this._persistence_propertyChange("maxDeliveryTime", this.maxDeliveryTime, timeInterval);
        this.maxDeliveryTime = timeInterval;
    }

    public BigDecimal _persistence_get_price() {
        this._persistence_checkFetched("price");
        return this.price;
    }

    public void _persistence_set_price(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("price");
        this._persistence_propertyChange("price", this.price, bigDecimal);
        this.price = bigDecimal;
    }

    public String _persistence_get_details() {
        this._persistence_checkFetched("details");
        return this.details;
    }

    public void _persistence_set_details(String string) {
        this._persistence_checkFetchedForSet("details");
        this._persistence_propertyChange("details", this.details, string);
        this.details = string;
    }

    protected void _persistence_initialize_currency_vh() {
        if (this._persistence_currency_vh == null) {
            this._persistence_currency_vh = new ValueHolder((Object)this.currency);
            this._persistence_currency_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_currency_vh() {
        Currency currency;
        this._persistence_initialize_currency_vh();
        if ((this._persistence_currency_vh.isCoordinatedWithProperty() || this._persistence_currency_vh.isNewlyWeavedValueHolder()) && (currency = this._persistence_get_currency()) != this._persistence_currency_vh.getValue()) {
            this._persistence_set_currency(currency);
        }
        return this._persistence_currency_vh;
    }

    public void _persistence_set_currency_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_currency_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Currency currency = this._persistence_get_currency();
            if (currency != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_currency((Currency)object);
            }
        } else {
            this.currency = null;
        }
    }

    public Currency _persistence_get_currency() {
        this._persistence_checkFetched("currency");
        this._persistence_initialize_currency_vh();
        this.currency = (Currency)this._persistence_currency_vh.getValue();
        return this.currency;
    }

    public void _persistence_set_currency(Currency currency) {
        this._persistence_checkFetchedForSet("currency");
        this._persistence_initialize_currency_vh();
        this.currency = (Currency)this._persistence_currency_vh.getValue();
        this._persistence_propertyChange("currency", this.currency, currency);
        this.currency = currency;
        this._persistence_currency_vh.setValue((Object)currency);
    }

    public boolean _persistence_get_removedFromOwner() {
        this._persistence_checkFetched("removedFromOwner");
        return this.removedFromOwner;
    }

    public void _persistence_set_removedFromOwner(boolean bl) {
        this._persistence_checkFetchedForSet("removedFromOwner");
        this._persistence_propertyChange("removedFromOwner", new Boolean(this.removedFromOwner), new Boolean(bl));
        this.removedFromOwner = bl;
    }
}

