/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.marketplace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.ConfigurationOrderableEntity;
import org.cyclos.entities.HasSvgIcon;
import org.cyclos.entities.OwnerEntity;
import org.cyclos.entities.marketplace.AdCategoryImage;
import org.cyclos.entities.system.DefinesNetwork;
import org.cyclos.entities.system.ImageOwner;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.TempImage;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.cyclos.utils.CollectionHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Cacheable(value=true)
@Table(name="ad_categories")
public class AdCategory
extends ConfigurationOrderableEntity
implements HasSvgIcon,
DefinesNetwork,
ImageOwner<AdCategory, AdCategoryImage>,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    public static final int MAX_LEVEL = 4;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="network_id", nullable=false)
    private Network network;
    @Basic
    @Column(name="svg_icon")
    private String svgIcon;
    @Basic
    @Column(name="svg_icon_color")
    private String svgIconColor;
    @Basic
    @Column(name="count_search")
    private Integer countSearch = 0;
    @Basic
    @Column(name="count_offer")
    private Integer countOffer = 0;
    @Basic
    @Column(name="active")
    private Boolean active = true;
    @OwnerEntity
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="parent_id")
    private AdCategory parent;
    @OneToMany(mappedBy="adCategory")
    private Set<AdCategoryImage> images;
    @OneToMany(mappedBy="parent", cascade={CascadeType.REMOVE})
    @OrderBy(value="order")
    private List<AdCategory> children = new ArrayList<AdCategory>();
    @Transient
    private TempImage uploadedImage;
    static final long serialVersionUID = 8013388321644901688L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_parent_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_network_vh;

    public Boolean getActive() {
        return this._persistence_get_active();
    }

    public List<AdCategory> getChildren() {
        return this._persistence_get_children();
    }

    public Integer getChildrenCount() {
        return this.getChildren() == null || this.getChildren().isEmpty() ? 0 : this.getChildren().size();
    }

    public Integer getCountOffer() {
        return this._persistence_get_countOffer();
    }

    public Integer getCountSearch() {
        return this._persistence_get_countSearch();
    }

    @Override
    public DataTranslationType getDataTranslationType() {
        return DataTranslationType.AD_CATEGORIES;
    }

    @Override
    public AdCategoryImage getImage() {
        return (AdCategoryImage)CollectionHelper.first((Iterable)this._persistence_get_images());
    }

    public int getLevel() {
        if (this._persistence_get_parent() == null) {
            return 1;
        }
        return 1 + this._persistence_get_parent().getLevel();
    }

    public Integer getMaxLevel() {
        return 4;
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_network();
    }

    public AdCategory getParent() {
        return this._persistence_get_parent();
    }

    public List<AdCategory> getPathFromRoot() {
        ArrayList<AdCategory> arrayList = new ArrayList<AdCategory>();
        for (AdCategory adCategory = this; adCategory != null; adCategory = adCategory.getParent()) {
            arrayList.add(adCategory);
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    public AdCategory getRootCategory() {
        if (this._persistence_get_parent() == null) {
            return this;
        }
        return this._persistence_get_parent().getRootCategory();
    }

    @Override
    public String getSvgIcon() {
        return this._persistence_get_svgIcon();
    }

    public String getSvgIconColor() {
        return this._persistence_get_svgIconColor();
    }

    public TempImage getUploadedImage() {
        return this.uploadedImage;
    }

    public boolean isLeaf() {
        return CollectionHelper.isEmpty((Iterable)this._persistence_get_children());
    }

    public boolean isRoot() {
        return this._persistence_get_parent() == null;
    }

    public void setActive(Boolean bl) {
        this._persistence_set_active(bl);
    }

    public void setChildren(List<AdCategory> list) {
        this._persistence_set_children(list);
    }

    public void setCountOffer(Integer n) {
        this._persistence_set_countOffer(n == null ? 0 : n);
    }

    public void setCountSearch(Integer n) {
        this._persistence_set_countSearch(n == null ? 0 : n);
    }

    @Override
    public void setImage(AdCategoryImage adCategoryImage) {
        this._persistence_set_images(CollectionHelper.asSet((Object[])new AdCategoryImage[]{adCategoryImage}));
    }

    @Override
    public void setNetwork(Network network) {
        this._persistence_set_network(network);
    }

    public void setParent(AdCategory adCategory) {
        this._persistence_set_parent(adCategory);
    }

    @Override
    public void setSvgIcon(String string) {
        this._persistence_set_svgIcon(string);
    }

    public void setSvgIconColor(String string) {
        this._persistence_set_svgIconColor(string);
    }

    public void setUploadedImage(TempImage tempImage) {
        this.uploadedImage = tempImage;
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_parent_vh != null) {
            this._persistence_parent_vh = (WeavedAttributeValueHolderInterface)this._persistence_parent_vh.clone();
        }
        if (this._persistence_network_vh != null) {
            this._persistence_network_vh = (WeavedAttributeValueHolderInterface)this._persistence_network_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new AdCategory();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "parent") {
            return this.parent;
        }
        if (string == "images") {
            return this.images;
        }
        if (string == "countOffer") {
            return this.countOffer;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "svgIcon") {
            return this.svgIcon;
        }
        if (string == "svgIconColor") {
            return this.svgIconColor;
        }
        if (string == "network") {
            return this.network;
        }
        if (string == "countSearch") {
            return this.countSearch;
        }
        if (string == "children") {
            return this.children;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "parent") {
            this.parent = (AdCategory)object;
            return;
        }
        if (string == "images") {
            this.images = (Set)object;
            return;
        }
        if (string == "countOffer") {
            this.countOffer = (Integer)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "svgIcon") {
            this.svgIcon = (String)object;
            return;
        }
        if (string == "svgIconColor") {
            this.svgIconColor = (String)object;
            return;
        }
        if (string == "network") {
            this.network = (Network)object;
            return;
        }
        if (string == "countSearch") {
            this.countSearch = (Integer)object;
            return;
        }
        if (string == "children") {
            this.children = (List)object;
            return;
        }
        super._persistence_set(string, object);
    }

    protected void _persistence_initialize_parent_vh() {
        if (this._persistence_parent_vh == null) {
            this._persistence_parent_vh = new ValueHolder((Object)this.parent);
            this._persistence_parent_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_parent_vh() {
        AdCategory adCategory;
        this._persistence_initialize_parent_vh();
        if ((this._persistence_parent_vh.isCoordinatedWithProperty() || this._persistence_parent_vh.isNewlyWeavedValueHolder()) && (adCategory = this._persistence_get_parent()) != this._persistence_parent_vh.getValue()) {
            this._persistence_set_parent(adCategory);
        }
        return this._persistence_parent_vh;
    }

    public void _persistence_set_parent_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_parent_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            AdCategory adCategory = this._persistence_get_parent();
            if (adCategory != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_parent((AdCategory)object);
            }
        } else {
            this.parent = null;
        }
    }

    public AdCategory _persistence_get_parent() {
        this._persistence_checkFetched("parent");
        this._persistence_initialize_parent_vh();
        this.parent = (AdCategory)this._persistence_parent_vh.getValue();
        return this.parent;
    }

    public void _persistence_set_parent(AdCategory adCategory) {
        this._persistence_checkFetchedForSet("parent");
        this._persistence_initialize_parent_vh();
        this.parent = (AdCategory)this._persistence_parent_vh.getValue();
        this._persistence_propertyChange("parent", this.parent, adCategory);
        this.parent = adCategory;
        this._persistence_parent_vh.setValue((Object)adCategory);
    }

    public Set _persistence_get_images() {
        this._persistence_checkFetched("images");
        return this.images;
    }

    public void _persistence_set_images(Set set) {
        this._persistence_checkFetchedForSet("images");
        this._persistence_propertyChange("images", this.images, set);
        this.images = set;
    }

    public Integer _persistence_get_countOffer() {
        this._persistence_checkFetched("countOffer");
        return this.countOffer;
    }

    public void _persistence_set_countOffer(Integer n) {
        this._persistence_checkFetchedForSet("countOffer");
        this._persistence_propertyChange("countOffer", this.countOffer, n);
        this.countOffer = n;
    }

    public Boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(Boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this._persistence_propertyChange("active", this.active, bl);
        this.active = bl;
    }

    public String _persistence_get_svgIcon() {
        this._persistence_checkFetched("svgIcon");
        return this.svgIcon;
    }

    public void _persistence_set_svgIcon(String string) {
        this._persistence_checkFetchedForSet("svgIcon");
        this._persistence_propertyChange("svgIcon", this.svgIcon, string);
        this.svgIcon = string;
    }

    public String _persistence_get_svgIconColor() {
        this._persistence_checkFetched("svgIconColor");
        return this.svgIconColor;
    }

    public void _persistence_set_svgIconColor(String string) {
        this._persistence_checkFetchedForSet("svgIconColor");
        this._persistence_propertyChange("svgIconColor", this.svgIconColor, string);
        this.svgIconColor = string;
    }

    protected void _persistence_initialize_network_vh() {
        if (this._persistence_network_vh == null) {
            this._persistence_network_vh = new ValueHolder((Object)this.network);
            this._persistence_network_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_network_vh() {
        Network network;
        this._persistence_initialize_network_vh();
        if ((this._persistence_network_vh.isCoordinatedWithProperty() || this._persistence_network_vh.isNewlyWeavedValueHolder()) && (network = this._persistence_get_network()) != this._persistence_network_vh.getValue()) {
            this._persistence_set_network(network);
        }
        return this._persistence_network_vh;
    }

    public void _persistence_set_network_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_network_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Network network = this._persistence_get_network();
            if (network != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_network((Network)object);
            }
        } else {
            this.network = null;
        }
    }

    public Network _persistence_get_network() {
        this._persistence_checkFetched("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        return this.network;
    }

    public void _persistence_set_network(Network network) {
        this._persistence_checkFetchedForSet("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        this._persistence_propertyChange("network", this.network, network);
        this.network = network;
        this._persistence_network_vh.setValue((Object)network);
    }

    public Integer _persistence_get_countSearch() {
        this._persistence_checkFetched("countSearch");
        return this.countSearch;
    }

    public void _persistence_set_countSearch(Integer n) {
        this._persistence_checkFetchedForSet("countSearch");
        this._persistence_propertyChange("countSearch", this.countSearch, n);
        this.countSearch = n;
    }

    public List _persistence_get_children() {
        this._persistence_checkFetched("children");
        return this.children;
    }

    public void _persistence_set_children(List list) {
        this._persistence_checkFetchedForSet("children");
        this._persistence_propertyChange("children", this.children, list);
        this.children = list;
    }
}

