/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.contentmanagement;

import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.OwnerEntity;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.contentmanagement.HasContentScript;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.system.Network;
import org.cyclos.model.contentmanagement.staticcontents.StaticContentNature;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.cyclos.model.system.scripts.CustomScriptUsedInType;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Cacheable(value=true)
@Table(name="static_contents", uniqueConstraints={@UniqueConstraint(columnNames={"subclass", "configuration_id"})})
@DiscriminatorColumn(name="subclass")
public abstract class BaseStaticContent
extends BaseEntity
implements HasContentScript,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @OwnerEntity
    @ManyToOne(fetch=FetchType.LAZY)
    @ReadOnlyFromDTO(onInsert=false)
    @JoinColumn(name="configuration_id", updatable=false, nullable=false)
    private Configuration configuration;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="subclass", insertable=false, updatable=false)
    private StaticContentNature nature;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="last_modified", nullable=false)
    private Date lastModified;
    @Basic
    @Lob
    @Column(name="content")
    private String content;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="content_script_id")
    private CustomScript contentScript;
    @Basic
    @Lob
    @Column(name="content_script_parameters")
    private String contentScriptParameters;
    static final long serialVersionUID = 82352976444688369L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_configuration_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_contentScript_vh;

    public Configuration getConfiguration() {
        return this._persistence_get_configuration();
    }

    public String getContent() {
        return this._persistence_get_content();
    }

    @Override
    public CustomScript getContentScript() {
        return this._persistence_get_contentScript();
    }

    @Override
    public String getContentScriptParameters() {
        return this._persistence_get_contentScriptParameters();
    }

    @Override
    public DataTranslationType getDataTranslationType() {
        return DataTranslationType.STATIC_CONTENT;
    }

    public Date getLastModified() {
        return this._persistence_get_lastModified();
    }

    public Long getLastModifiedMillis() {
        return this._persistence_get_lastModified() == null ? null : Long.valueOf(this._persistence_get_lastModified().getTime());
    }

    public abstract StaticContentNature getNature();

    @Override
    public Network getNetwork() {
        return this._persistence_get_configuration().getNetwork();
    }

    public CustomScriptUsedInType getScriptUsedInType() {
        return CustomScriptUsedInType.STATIC_CONTENT;
    }

    public abstract boolean isCustomized();

    public void setConfiguration(Configuration configuration) {
        this._persistence_set_configuration(configuration);
    }

    public void setContent(String string) {
        this._persistence_set_content(string);
    }

    public void setContentScript(CustomScript customScript) {
        this._persistence_set_contentScript(customScript);
    }

    public void setContentScriptParameters(String string) {
        this._persistence_set_contentScriptParameters(string);
    }

    public void setLastModified(Date date) {
        this._persistence_set_lastModified(date);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_configuration_vh != null) {
            this._persistence_configuration_vh = (WeavedAttributeValueHolderInterface)this._persistence_configuration_vh.clone();
        }
        if (this._persistence_contentScript_vh != null) {
            this._persistence_contentScript_vh = (WeavedAttributeValueHolderInterface)this._persistence_contentScript_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new BaseStaticContent();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "nature") {
            return this.nature;
        }
        if (string == "configuration") {
            return this.configuration;
        }
        if (string == "contentScript") {
            return this.contentScript;
        }
        if (string == "lastModified") {
            return this.lastModified;
        }
        if (string == "contentScriptParameters") {
            return this.contentScriptParameters;
        }
        if (string == "content") {
            return this.content;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "nature") {
            this.nature = (StaticContentNature)object;
            return;
        }
        if (string == "configuration") {
            this.configuration = (Configuration)object;
            return;
        }
        if (string == "contentScript") {
            this.contentScript = (CustomScript)object;
            return;
        }
        if (string == "lastModified") {
            this.lastModified = (Date)object;
            return;
        }
        if (string == "contentScriptParameters") {
            this.contentScriptParameters = (String)object;
            return;
        }
        if (string == "content") {
            this.content = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public StaticContentNature _persistence_get_nature() {
        this._persistence_checkFetched("nature");
        return this.nature;
    }

    public void _persistence_set_nature(StaticContentNature staticContentNature) {
        this._persistence_checkFetchedForSet("nature");
        this._persistence_propertyChange("nature", this.nature, staticContentNature);
        this.nature = staticContentNature;
    }

    protected void _persistence_initialize_configuration_vh() {
        if (this._persistence_configuration_vh == null) {
            this._persistence_configuration_vh = new ValueHolder((Object)this.configuration);
            this._persistence_configuration_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_configuration_vh() {
        Configuration configuration;
        this._persistence_initialize_configuration_vh();
        if ((this._persistence_configuration_vh.isCoordinatedWithProperty() || this._persistence_configuration_vh.isNewlyWeavedValueHolder()) && (configuration = this._persistence_get_configuration()) != this._persistence_configuration_vh.getValue()) {
            this._persistence_set_configuration(configuration);
        }
        return this._persistence_configuration_vh;
    }

    public void _persistence_set_configuration_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_configuration_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Configuration configuration = this._persistence_get_configuration();
            if (configuration != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_configuration((Configuration)object);
            }
        } else {
            this.configuration = null;
        }
    }

    public Configuration _persistence_get_configuration() {
        this._persistence_checkFetched("configuration");
        this._persistence_initialize_configuration_vh();
        this.configuration = (Configuration)this._persistence_configuration_vh.getValue();
        return this.configuration;
    }

    public void _persistence_set_configuration(Configuration configuration) {
        this._persistence_checkFetchedForSet("configuration");
        this._persistence_initialize_configuration_vh();
        this.configuration = (Configuration)this._persistence_configuration_vh.getValue();
        this._persistence_propertyChange("configuration", this.configuration, configuration);
        this.configuration = configuration;
        this._persistence_configuration_vh.setValue((Object)configuration);
    }

    protected void _persistence_initialize_contentScript_vh() {
        if (this._persistence_contentScript_vh == null) {
            this._persistence_contentScript_vh = new ValueHolder((Object)this.contentScript);
            this._persistence_contentScript_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_contentScript_vh() {
        CustomScript customScript;
        this._persistence_initialize_contentScript_vh();
        if ((this._persistence_contentScript_vh.isCoordinatedWithProperty() || this._persistence_contentScript_vh.isNewlyWeavedValueHolder()) && (customScript = this._persistence_get_contentScript()) != this._persistence_contentScript_vh.getValue()) {
            this._persistence_set_contentScript(customScript);
        }
        return this._persistence_contentScript_vh;
    }

    public void _persistence_set_contentScript_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_contentScript_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            CustomScript customScript = this._persistence_get_contentScript();
            if (customScript != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_contentScript((CustomScript)object);
            }
        } else {
            this.contentScript = null;
        }
    }

    public CustomScript _persistence_get_contentScript() {
        this._persistence_checkFetched("contentScript");
        this._persistence_initialize_contentScript_vh();
        this.contentScript = (CustomScript)this._persistence_contentScript_vh.getValue();
        return this.contentScript;
    }

    public void _persistence_set_contentScript(CustomScript customScript) {
        this._persistence_checkFetchedForSet("contentScript");
        this._persistence_initialize_contentScript_vh();
        this.contentScript = (CustomScript)this._persistence_contentScript_vh.getValue();
        this._persistence_propertyChange("contentScript", this.contentScript, customScript);
        this.contentScript = customScript;
        this._persistence_contentScript_vh.setValue((Object)customScript);
    }

    public Date _persistence_get_lastModified() {
        this._persistence_checkFetched("lastModified");
        return this.lastModified;
    }

    public void _persistence_set_lastModified(Date date) {
        this._persistence_checkFetchedForSet("lastModified");
        this._persistence_propertyChange("lastModified", this.lastModified, date);
        this.lastModified = date;
    }

    public String _persistence_get_contentScriptParameters() {
        this._persistence_checkFetched("contentScriptParameters");
        return this.contentScriptParameters;
    }

    public void _persistence_set_contentScriptParameters(String string) {
        this._persistence_checkFetchedForSet("contentScriptParameters");
        this._persistence_propertyChange("contentScriptParameters", this.contentScriptParameters, string);
        this.contentScriptParameters = string;
    }

    public String _persistence_get_content() {
        this._persistence_checkFetched("content");
        return this.content;
    }

    public void _persistence_set_content(String string) {
        this._persistence_checkFetchedForSet("content");
        this._persistence_propertyChange("content", this.content, string);
        this.content = string;
    }
}

