/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.ConfigurationEntity;
import org.cyclos.entities.CurrencyScale;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.HasCurrency;
import org.cyclos.entities.banking.VoucherCategory;
import org.cyclos.entities.banking.VoucherConfiguration;
import org.cyclos.entities.banking.VoucherCustomField;
import org.cyclos.entities.banking.VoucherTemplate;
import org.cyclos.entities.banking.VoucherTypeImage;
import org.cyclos.entities.system.ImageOwner;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.TempImage;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.model.banking.vouchers.VoucherPaymentDestination;
import org.cyclos.model.banking.vouchertypes.VoucherExpirationType;
import org.cyclos.model.banking.vouchertypes.VoucherGiftOption;
import org.cyclos.model.banking.vouchertypes.VoucherRedeemRestrictTo;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.cyclos.server.utils.EnumHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.WeekDay;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="voucher_types")
@Cacheable(value=true)
public class VoucherType
extends ConfigurationEntity
implements HasCurrency,
ImageOwner<VoucherType, VoucherTypeImage>,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne(fetch=FetchType.LAZY)
    @ReadOnlyFromDTO(onInsert=false)
    @JoinColumn(name="configuration_id", nullable=false)
    private VoucherConfiguration configuration;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="category_id")
    private VoucherCategory category;
    @OneToMany(mappedBy="voucherType")
    private Set<VoucherTypeImage> images;
    @Basic
    @Column(name="enabled")
    private Boolean enabled;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="template_id", nullable=false)
    private VoucherTemplate template;
    @Basic
    @Column(name="allow_buying")
    private Boolean allowBuying;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="gift")
    private VoucherGiftOption gift;
    @Basic
    @Column(name="allow_partial_redeems")
    private Boolean allowPartialRedeems;
    @Basic
    @Column(name="hide_balance_in_redeem")
    private Boolean hideBalanceInRedeem;
    @Basic
    @Column(name="voucher_title")
    private String voucherTitle;
    @Basic
    @Lob
    @Column(name="voucher_description")
    private String voucherDescription;
    @Basic
    @Column(name="account_name")
    private String accountName;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="expiration_type", nullable=false)
    private VoucherExpirationType expirationType;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="expiration_date")
    private Date expirationDate;
    @Basic
    @Column(name="min_topup_amount")
    @CurrencyScale
    private BigDecimal minTopUpAmount;
    @Basic
    @Column(name="max_topup_amount")
    @CurrencyScale
    private BigDecimal maxTopUpAmount;
    @Basic
    @Column(name="max_balance")
    @CurrencyScale
    private BigDecimal maxBalance;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="amount", column=@Column(name="expiration_amount")), @AttributeOverride(name="field", column=@Column(name="expiration_field"))})
    private TimeInterval expirationInterval;
    @Basic
    @Column(name="max_total_open_amount")
    @CurrencyScale
    private BigDecimal maxTotalOpenAmount;
    @Basic
    @Column(name="max_total_amount")
    @CurrencyScale
    private BigDecimal maxOpenAmountPerUser;
    @Basic
    @Column(name="max_total_buy")
    private Integer maxTotalBuy;
    @Basic
    @Column(name="max_vouchers_per_buy")
    private Integer maxVouchersPerBuy;
    @Basic
    @Column(name="redeem_on_weekdays")
    private String redeemOnWeekDays;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="redeem_restrict")
    private VoucherRedeemRestrictTo redeemRestrict = VoucherRedeemRestrictTo.ALL;
    @ManyToMany
    @JoinTable(name="voucher_types_redeem_users", joinColumns={@JoinColumn(name="voucher_type_id")}, inverseJoinColumns={@JoinColumn(name="user_id")})
    private Set<User> redeemAllowedUsers = new HashSet<User>();
    @ManyToMany
    @JoinTable(name="voucher_types_redeem_groups", joinColumns={@JoinColumn(name="voucher_type_id")}, inverseJoinColumns={@JoinColumn(name="group_id")})
    private Set<BasicGroup> redeemAllowedGroups = new HashSet<BasicGroup>();
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="payment_destination", nullable=false)
    private VoucherPaymentDestination paymentDestination = VoucherPaymentDestination.REDEEMER;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="payment_destination_user_id")
    private User paymentDestinationUser;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="amount", column=@Column(name="time_to_redeem_amount")), @AttributeOverride(name="field", column=@Column(name="time_to_redeem_field"))})
    private TimeInterval minimumTimeToRedeem;
    @Basic
    @Column(name="min_buy_amount")
    @CurrencyScale
    private BigDecimal minBuyAmount;
    @Basic
    @Column(name="max_buy_amount")
    @CurrencyScale
    private BigDecimal maxBuyAmount;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="buy_until_date")
    private Date buyUntilDate;
    @Basic
    @Column(name="buy_until_date_expiration_notified")
    private Boolean buyUntilDateExpirationNotified;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="amount", column=@Column(name="max_buy_amount_period_amount")), @AttributeOverride(name="field", column=@Column(name="max_buy_amount_period_field"))})
    private TimeInterval maxBuyAmountPeriod;
    @Basic
    @Column(name="max_buy_amount_per_period")
    @CurrencyScale
    private BigDecimal maxBuyAmountPerPeriod;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="begin", column=@Column(name="max_buy_amount_actual_period_begin")), @AttributeOverride(name="end", column=@Column(name="max_buy_amount_actual_period_end"))})
    private DatePeriod maxBuyAmountActualPeriod;
    @Basic
    @Column(name="max_buy_amount_actual_sum")
    @CurrencyScale
    private BigDecimal maxBuyAmountActualSum;
    @ManyToMany
    @JoinTable(name="voucher_types_buy_groups", joinColumns={@JoinColumn(name="voucher_type_id")}, inverseJoinColumns={@JoinColumn(name="group_id")})
    private Set<BasicGroup> buyAllowedGroups = new HashSet<BasicGroup>();
    @ManyToMany
    @JoinTable(name="voucher_types_custom_fields", joinColumns={@JoinColumn(name="voucher_type_id")}, inverseJoinColumns={@JoinColumn(name="custom_field_id")})
    private Set<VoucherCustomField> customFields = new HashSet<VoucherCustomField>();
    @Transient
    private TempImage uploadedImage;
    static final long serialVersionUID = -3164782244279837590L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_template_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_configuration_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_paymentDestinationUser_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_category_vh;

    public VoucherType() {
    }

    public VoucherType(Long l) {
        this.setId(l);
    }

    public String getAccountName() {
        return this._persistence_get_accountName();
    }

    public Set<BasicGroup> getBuyAllowedGroups() {
        return this._persistence_get_buyAllowedGroups();
    }

    public Date getBuyUntilDate() {
        return this._persistence_get_buyUntilDate();
    }

    public VoucherCategory getCategory() {
        return this._persistence_get_category();
    }

    public VoucherConfiguration getConfiguration() {
        return this._persistence_get_configuration();
    }

    @Override
    public Currency getCurrency() {
        return this._persistence_get_configuration().getCurrency();
    }

    public Set<VoucherCustomField> getCustomFields() {
        return this._persistence_get_customFields();
    }

    @Override
    public DataTranslationType getDataTranslationType() {
        return DataTranslationType.VOUCHER_TYPES;
    }

    public Date getExpirationDate() {
        return this._persistence_get_expirationDate();
    }

    public TimeInterval getExpirationInterval() {
        return this._persistence_get_expirationInterval();
    }

    public VoucherExpirationType getExpirationType() {
        return this._persistence_get_expirationType();
    }

    public BigDecimal getFixedBuyAmount() {
        if (Objects.equals(this._persistence_get_minBuyAmount(), this._persistence_get_maxBuyAmount())) {
            return this._persistence_get_minBuyAmount();
        }
        return null;
    }

    public VoucherGiftOption getGift() {
        return this._persistence_get_gift();
    }

    @Override
    public VoucherTypeImage getImage() {
        return (VoucherTypeImage)CollectionHelper.first((Iterable)this._persistence_get_images());
    }

    public BigDecimal getMaxBalance() {
        return this._persistence_get_maxBalance();
    }

    public BigDecimal getMaxBuyAmount() {
        return this._persistence_get_maxBuyAmount();
    }

    public DatePeriod getMaxBuyAmountActualPeriod() {
        return this._persistence_get_maxBuyAmountActualPeriod();
    }

    public BigDecimal getMaxBuyAmountActualSum() {
        return this._persistence_get_maxBuyAmountActualSum();
    }

    public TimeInterval getMaxBuyAmountPeriod() {
        return this._persistence_get_maxBuyAmountPeriod();
    }

    public BigDecimal getMaxBuyAmountPerPeriod() {
        return this._persistence_get_maxBuyAmountPerPeriod();
    }

    public BigDecimal getMaxOpenAmountPerUser() {
        return this._persistence_get_maxOpenAmountPerUser();
    }

    public BigDecimal getMaxTopUpAmount() {
        return this._persistence_get_maxTopUpAmount();
    }

    public Integer getMaxTotalBuy() {
        return this._persistence_get_maxTotalBuy();
    }

    public BigDecimal getMaxTotalOpenAmount() {
        return this._persistence_get_maxTotalOpenAmount();
    }

    public Integer getMaxVouchersPerBuy() {
        return this._persistence_get_maxVouchersPerBuy();
    }

    public BigDecimal getMinBuyAmount() {
        return this._persistence_get_minBuyAmount();
    }

    public TimeInterval getMinimumTimeToRedeem() {
        return this._persistence_get_minimumTimeToRedeem();
    }

    public BigDecimal getMinTopUpAmount() {
        return this._persistence_get_minTopUpAmount();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_configuration().getNetwork();
    }

    public VoucherPaymentDestination getPaymentDestination() {
        return this._persistence_get_paymentDestination();
    }

    public User getPaymentDestinationUser() {
        return this._persistence_get_paymentDestinationUser();
    }

    public Set<BasicGroup> getRedeemAllowedGroups() {
        return this._persistence_get_redeemAllowedGroups();
    }

    public Set<User> getRedeemAllowedUsers() {
        return this._persistence_get_redeemAllowedUsers();
    }

    public Set<WeekDay> getRedeemOnWeekDays() {
        return EnumHelper.decodeOrdinals(WeekDay.class, (String)this._persistence_get_redeemOnWeekDays());
    }

    public VoucherRedeemRestrictTo getRedeemRestrict() {
        return this._persistence_get_redeemRestrict();
    }

    public VoucherTemplate getTemplate() {
        return this._persistence_get_template();
    }

    public TempImage getUploadedImage() {
        return this.uploadedImage;
    }

    public String getVoucherDescription() {
        return this._persistence_get_voucherDescription();
    }

    public String getVoucherTitle() {
        return this._persistence_get_voucherTitle();
    }

    public boolean isAllowBuying() {
        return Boolean.TRUE.equals(this._persistence_get_allowBuying());
    }

    public boolean isAllowPartialRedeems() {
        return Boolean.TRUE.equals(this._persistence_get_allowPartialRedeems());
    }

    public boolean isBuyUntilDateExpirationNotified() {
        return Boolean.TRUE.equals(this._persistence_get_buyUntilDateExpirationNotified());
    }

    public boolean isEnabled() {
        return Boolean.TRUE.equals(this._persistence_get_enabled());
    }

    public boolean isHideBalanceInRedeem() {
        return Boolean.TRUE.equals(this._persistence_get_hideBalanceInRedeem());
    }

    public boolean isLimitBuyAmountPerPeriod() {
        return this._persistence_get_maxBuyAmountPeriod() != null && this._persistence_get_maxBuyAmountPeriod().getField() != null && this._persistence_get_maxBuyAmountPeriod().getAmount() != null && this._persistence_get_maxBuyAmountPerPeriod() != null;
    }

    public boolean isUseFixedBuyAmount() {
        return this._persistence_get_minBuyAmount() != null && this._persistence_get_minBuyAmount().equals(this._persistence_get_maxBuyAmount());
    }

    public void setAccountName(String string) {
        this._persistence_set_accountName(string);
    }

    public void setAllowBuying(boolean bl) {
        this._persistence_set_allowBuying(bl);
    }

    public void setAllowPartialRedeems(boolean bl) {
        this._persistence_set_allowPartialRedeems(bl);
    }

    public void setBuyAllowedGroups(Set<BasicGroup> set) {
        this._persistence_set_buyAllowedGroups(set);
    }

    public void setBuyUntilDate(Date date) {
        this._persistence_set_buyUntilDate(date);
    }

    public void setBuyUntilDateExpirationNotified(boolean bl) {
        this._persistence_set_buyUntilDateExpirationNotified(bl);
    }

    public void setCategory(VoucherCategory voucherCategory) {
        this._persistence_set_category(voucherCategory);
    }

    public void setConfiguration(VoucherConfiguration voucherConfiguration) {
        this._persistence_set_configuration(voucherConfiguration);
    }

    public void setCustomFields(Set<VoucherCustomField> set) {
        this._persistence_set_customFields(set);
    }

    public void setEnabled(boolean bl) {
        this._persistence_set_enabled(bl);
    }

    public void setExpirationDate(Date date) {
        this._persistence_set_expirationDate(date);
    }

    public void setExpirationInterval(TimeInterval timeInterval) {
        this._persistence_set_expirationInterval(timeInterval);
    }

    public void setExpirationType(VoucherExpirationType voucherExpirationType) {
        this._persistence_set_expirationType(voucherExpirationType);
    }

    public void setGift(VoucherGiftOption voucherGiftOption) {
        this._persistence_set_gift(voucherGiftOption);
    }

    public void setHideBalanceInRedeem(Boolean bl) {
        this._persistence_set_hideBalanceInRedeem(bl);
    }

    @Override
    public void setImage(VoucherTypeImage voucherTypeImage) {
        this._persistence_set_images(CollectionHelper.asSet((Object[])new VoucherTypeImage[]{voucherTypeImage}));
    }

    public void setMaxBalance(BigDecimal bigDecimal) {
        this._persistence_set_maxBalance(bigDecimal);
    }

    public void setMaxBuyAmount(BigDecimal bigDecimal) {
        this._persistence_set_maxBuyAmount(bigDecimal);
    }

    public void setMaxBuyAmountActualPeriod(DatePeriod datePeriod) {
        this._persistence_set_maxBuyAmountActualPeriod(datePeriod);
    }

    public void setMaxBuyAmountActualSum(BigDecimal bigDecimal) {
        this._persistence_set_maxBuyAmountActualSum(bigDecimal);
    }

    public void setMaxBuyAmountPeriod(TimeInterval timeInterval) {
        this._persistence_set_maxBuyAmountPeriod(timeInterval);
    }

    public void setMaxBuyAmountPerPeriod(BigDecimal bigDecimal) {
        this._persistence_set_maxBuyAmountPerPeriod(bigDecimal);
    }

    public void setMaxOpenAmountPerUser(BigDecimal bigDecimal) {
        this._persistence_set_maxOpenAmountPerUser(bigDecimal);
    }

    public void setMaxTopUpAmount(BigDecimal bigDecimal) {
        this._persistence_set_maxTopUpAmount(bigDecimal);
    }

    public void setMaxTotalBuy(Integer n) {
        this._persistence_set_maxTotalBuy(n);
    }

    public void setMaxTotalOpenAmount(BigDecimal bigDecimal) {
        this._persistence_set_maxTotalOpenAmount(bigDecimal);
    }

    public void setMaxVouchersPerBuy(Integer n) {
        this._persistence_set_maxVouchersPerBuy(n);
    }

    public void setMinBuyAmount(BigDecimal bigDecimal) {
        this._persistence_set_minBuyAmount(bigDecimal);
    }

    public void setMinimumTimeToRedeem(TimeInterval timeInterval) {
        this._persistence_set_minimumTimeToRedeem(timeInterval);
    }

    public void setMinTopUpAmount(BigDecimal bigDecimal) {
        this._persistence_set_minTopUpAmount(bigDecimal);
    }

    public void setPaymentDestination(VoucherPaymentDestination voucherPaymentDestination) {
        this._persistence_set_paymentDestination(voucherPaymentDestination);
    }

    public void setPaymentDestinationUser(User user) {
        this._persistence_set_paymentDestinationUser(user);
    }

    public void setRedeemAllowedGroups(Set<BasicGroup> set) {
        this._persistence_set_redeemAllowedGroups(set);
    }

    public void setRedeemAllowedUsers(Set<User> set) {
        this._persistence_set_redeemAllowedUsers(set);
    }

    public void setRedeemOnWeekDays(Set<WeekDay> set) {
        this._persistence_set_redeemOnWeekDays(EnumHelper.encodeOrdinals(WeekDay.class, set));
    }

    public void setRedeemRestrict(VoucherRedeemRestrictTo voucherRedeemRestrictTo) {
        this._persistence_set_redeemRestrict(voucherRedeemRestrictTo);
    }

    public void setTemplate(VoucherTemplate voucherTemplate) {
        this._persistence_set_template(voucherTemplate);
    }

    public void setUploadedImage(TempImage tempImage) {
        this.uploadedImage = tempImage;
    }

    public void setVoucherDescription(String string) {
        this._persistence_set_voucherDescription(string);
    }

    public void setVoucherTitle(String string) {
        this._persistence_set_voucherTitle(string);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_template_vh != null) {
            this._persistence_template_vh = (WeavedAttributeValueHolderInterface)this._persistence_template_vh.clone();
        }
        if (this._persistence_configuration_vh != null) {
            this._persistence_configuration_vh = (WeavedAttributeValueHolderInterface)this._persistence_configuration_vh.clone();
        }
        if (this._persistence_paymentDestinationUser_vh != null) {
            this._persistence_paymentDestinationUser_vh = (WeavedAttributeValueHolderInterface)this._persistence_paymentDestinationUser_vh.clone();
        }
        if (this._persistence_category_vh != null) {
            this._persistence_category_vh = (WeavedAttributeValueHolderInterface)this._persistence_category_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new VoucherType();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "gift") {
            return this.gift;
        }
        if (string == "template") {
            return this.template;
        }
        if (string == "buyAllowedGroups") {
            return this.buyAllowedGroups;
        }
        if (string == "redeemRestrict") {
            return this.redeemRestrict;
        }
        if (string == "accountName") {
            return this.accountName;
        }
        if (string == "configuration") {
            return this.configuration;
        }
        if (string == "customFields") {
            return this.customFields;
        }
        if (string == "maxTotalOpenAmount") {
            return this.maxTotalOpenAmount;
        }
        if (string == "buyUntilDateExpirationNotified") {
            return this.buyUntilDateExpirationNotified;
        }
        if (string == "maxBuyAmount") {
            return this.maxBuyAmount;
        }
        if (string == "enabled") {
            return this.enabled;
        }
        if (string == "maxTopUpAmount") {
            return this.maxTopUpAmount;
        }
        if (string == "buyUntilDate") {
            return this.buyUntilDate;
        }
        if (string == "minimumTimeToRedeem") {
            return this.minimumTimeToRedeem;
        }
        if (string == "maxBalance") {
            return this.maxBalance;
        }
        if (string == "expirationInterval") {
            return this.expirationInterval;
        }
        if (string == "hideBalanceInRedeem") {
            return this.hideBalanceInRedeem;
        }
        if (string == "voucherDescription") {
            return this.voucherDescription;
        }
        if (string == "maxBuyAmountPerPeriod") {
            return this.maxBuyAmountPerPeriod;
        }
        if (string == "expirationDate") {
            return this.expirationDate;
        }
        if (string == "maxTotalBuy") {
            return this.maxTotalBuy;
        }
        if (string == "maxOpenAmountPerUser") {
            return this.maxOpenAmountPerUser;
        }
        if (string == "paymentDestination") {
            return this.paymentDestination;
        }
        if (string == "images") {
            return this.images;
        }
        if (string == "expirationType") {
            return this.expirationType;
        }
        if (string == "redeemAllowedUsers") {
            return this.redeemAllowedUsers;
        }
        if (string == "minTopUpAmount") {
            return this.minTopUpAmount;
        }
        if (string == "maxVouchersPerBuy") {
            return this.maxVouchersPerBuy;
        }
        if (string == "maxBuyAmountActualSum") {
            return this.maxBuyAmountActualSum;
        }
        if (string == "maxBuyAmountActualPeriod") {
            return this.maxBuyAmountActualPeriod;
        }
        if (string == "minBuyAmount") {
            return this.minBuyAmount;
        }
        if (string == "allowBuying") {
            return this.allowBuying;
        }
        if (string == "voucherTitle") {
            return this.voucherTitle;
        }
        if (string == "redeemAllowedGroups") {
            return this.redeemAllowedGroups;
        }
        if (string == "maxBuyAmountPeriod") {
            return this.maxBuyAmountPeriod;
        }
        if (string == "allowPartialRedeems") {
            return this.allowPartialRedeems;
        }
        if (string == "paymentDestinationUser") {
            return this.paymentDestinationUser;
        }
        if (string == "category") {
            return this.category;
        }
        if (string == "redeemOnWeekDays") {
            return this.redeemOnWeekDays;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "gift") {
            this.gift = (VoucherGiftOption)object;
            return;
        }
        if (string == "template") {
            this.template = (VoucherTemplate)object;
            return;
        }
        if (string == "buyAllowedGroups") {
            this.buyAllowedGroups = (Set)object;
            return;
        }
        if (string == "redeemRestrict") {
            this.redeemRestrict = (VoucherRedeemRestrictTo)object;
            return;
        }
        if (string == "accountName") {
            this.accountName = (String)object;
            return;
        }
        if (string == "configuration") {
            this.configuration = (VoucherConfiguration)object;
            return;
        }
        if (string == "customFields") {
            this.customFields = (Set)object;
            return;
        }
        if (string == "maxTotalOpenAmount") {
            this.maxTotalOpenAmount = (BigDecimal)object;
            return;
        }
        if (string == "buyUntilDateExpirationNotified") {
            this.buyUntilDateExpirationNotified = (Boolean)object;
            return;
        }
        if (string == "maxBuyAmount") {
            this.maxBuyAmount = (BigDecimal)object;
            return;
        }
        if (string == "enabled") {
            this.enabled = (Boolean)object;
            return;
        }
        if (string == "maxTopUpAmount") {
            this.maxTopUpAmount = (BigDecimal)object;
            return;
        }
        if (string == "buyUntilDate") {
            this.buyUntilDate = (Date)object;
            return;
        }
        if (string == "minimumTimeToRedeem") {
            this.minimumTimeToRedeem = (TimeInterval)object;
            return;
        }
        if (string == "maxBalance") {
            this.maxBalance = (BigDecimal)object;
            return;
        }
        if (string == "expirationInterval") {
            this.expirationInterval = (TimeInterval)object;
            return;
        }
        if (string == "hideBalanceInRedeem") {
            this.hideBalanceInRedeem = (Boolean)object;
            return;
        }
        if (string == "voucherDescription") {
            this.voucherDescription = (String)object;
            return;
        }
        if (string == "maxBuyAmountPerPeriod") {
            this.maxBuyAmountPerPeriod = (BigDecimal)object;
            return;
        }
        if (string == "expirationDate") {
            this.expirationDate = (Date)object;
            return;
        }
        if (string == "maxTotalBuy") {
            this.maxTotalBuy = (Integer)object;
            return;
        }
        if (string == "maxOpenAmountPerUser") {
            this.maxOpenAmountPerUser = (BigDecimal)object;
            return;
        }
        if (string == "paymentDestination") {
            this.paymentDestination = (VoucherPaymentDestination)object;
            return;
        }
        if (string == "images") {
            this.images = (Set)object;
            return;
        }
        if (string == "expirationType") {
            this.expirationType = (VoucherExpirationType)object;
            return;
        }
        if (string == "redeemAllowedUsers") {
            this.redeemAllowedUsers = (Set)object;
            return;
        }
        if (string == "minTopUpAmount") {
            this.minTopUpAmount = (BigDecimal)object;
            return;
        }
        if (string == "maxVouchersPerBuy") {
            this.maxVouchersPerBuy = (Integer)object;
            return;
        }
        if (string == "maxBuyAmountActualSum") {
            this.maxBuyAmountActualSum = (BigDecimal)object;
            return;
        }
        if (string == "maxBuyAmountActualPeriod") {
            this.maxBuyAmountActualPeriod = (DatePeriod)object;
            return;
        }
        if (string == "minBuyAmount") {
            this.minBuyAmount = (BigDecimal)object;
            return;
        }
        if (string == "allowBuying") {
            this.allowBuying = (Boolean)object;
            return;
        }
        if (string == "voucherTitle") {
            this.voucherTitle = (String)object;
            return;
        }
        if (string == "redeemAllowedGroups") {
            this.redeemAllowedGroups = (Set)object;
            return;
        }
        if (string == "maxBuyAmountPeriod") {
            this.maxBuyAmountPeriod = (TimeInterval)object;
            return;
        }
        if (string == "allowPartialRedeems") {
            this.allowPartialRedeems = (Boolean)object;
            return;
        }
        if (string == "paymentDestinationUser") {
            this.paymentDestinationUser = (User)object;
            return;
        }
        if (string == "category") {
            this.category = (VoucherCategory)object;
            return;
        }
        if (string == "redeemOnWeekDays") {
            this.redeemOnWeekDays = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public VoucherGiftOption _persistence_get_gift() {
        this._persistence_checkFetched("gift");
        return this.gift;
    }

    public void _persistence_set_gift(VoucherGiftOption voucherGiftOption) {
        this._persistence_checkFetchedForSet("gift");
        this._persistence_propertyChange("gift", this.gift, voucherGiftOption);
        this.gift = voucherGiftOption;
    }

    protected void _persistence_initialize_template_vh() {
        if (this._persistence_template_vh == null) {
            this._persistence_template_vh = new ValueHolder((Object)this.template);
            this._persistence_template_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_template_vh() {
        VoucherTemplate voucherTemplate;
        this._persistence_initialize_template_vh();
        if ((this._persistence_template_vh.isCoordinatedWithProperty() || this._persistence_template_vh.isNewlyWeavedValueHolder()) && (voucherTemplate = this._persistence_get_template()) != this._persistence_template_vh.getValue()) {
            this._persistence_set_template(voucherTemplate);
        }
        return this._persistence_template_vh;
    }

    public void _persistence_set_template_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_template_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            VoucherTemplate voucherTemplate = this._persistence_get_template();
            if (voucherTemplate != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_template((VoucherTemplate)object);
            }
        } else {
            this.template = null;
        }
    }

    public VoucherTemplate _persistence_get_template() {
        this._persistence_checkFetched("template");
        this._persistence_initialize_template_vh();
        this.template = (VoucherTemplate)this._persistence_template_vh.getValue();
        return this.template;
    }

    public void _persistence_set_template(VoucherTemplate voucherTemplate) {
        this._persistence_checkFetchedForSet("template");
        this._persistence_initialize_template_vh();
        this.template = (VoucherTemplate)this._persistence_template_vh.getValue();
        this._persistence_propertyChange("template", this.template, voucherTemplate);
        this.template = voucherTemplate;
        this._persistence_template_vh.setValue((Object)voucherTemplate);
    }

    public Set _persistence_get_buyAllowedGroups() {
        this._persistence_checkFetched("buyAllowedGroups");
        return this.buyAllowedGroups;
    }

    public void _persistence_set_buyAllowedGroups(Set set) {
        this._persistence_checkFetchedForSet("buyAllowedGroups");
        this._persistence_propertyChange("buyAllowedGroups", this.buyAllowedGroups, set);
        this.buyAllowedGroups = set;
    }

    public VoucherRedeemRestrictTo _persistence_get_redeemRestrict() {
        this._persistence_checkFetched("redeemRestrict");
        return this.redeemRestrict;
    }

    public void _persistence_set_redeemRestrict(VoucherRedeemRestrictTo voucherRedeemRestrictTo) {
        this._persistence_checkFetchedForSet("redeemRestrict");
        this._persistence_propertyChange("redeemRestrict", this.redeemRestrict, voucherRedeemRestrictTo);
        this.redeemRestrict = voucherRedeemRestrictTo;
    }

    public String _persistence_get_accountName() {
        this._persistence_checkFetched("accountName");
        return this.accountName;
    }

    public void _persistence_set_accountName(String string) {
        this._persistence_checkFetchedForSet("accountName");
        this._persistence_propertyChange("accountName", this.accountName, string);
        this.accountName = string;
    }

    protected void _persistence_initialize_configuration_vh() {
        if (this._persistence_configuration_vh == null) {
            this._persistence_configuration_vh = new ValueHolder((Object)this.configuration);
            this._persistence_configuration_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_configuration_vh() {
        VoucherConfiguration voucherConfiguration;
        this._persistence_initialize_configuration_vh();
        if ((this._persistence_configuration_vh.isCoordinatedWithProperty() || this._persistence_configuration_vh.isNewlyWeavedValueHolder()) && (voucherConfiguration = this._persistence_get_configuration()) != this._persistence_configuration_vh.getValue()) {
            this._persistence_set_configuration(voucherConfiguration);
        }
        return this._persistence_configuration_vh;
    }

    public void _persistence_set_configuration_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_configuration_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            VoucherConfiguration voucherConfiguration = this._persistence_get_configuration();
            if (voucherConfiguration != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_configuration((VoucherConfiguration)object);
            }
        } else {
            this.configuration = null;
        }
    }

    public VoucherConfiguration _persistence_get_configuration() {
        this._persistence_checkFetched("configuration");
        this._persistence_initialize_configuration_vh();
        this.configuration = (VoucherConfiguration)this._persistence_configuration_vh.getValue();
        return this.configuration;
    }

    public void _persistence_set_configuration(VoucherConfiguration voucherConfiguration) {
        this._persistence_checkFetchedForSet("configuration");
        this._persistence_initialize_configuration_vh();
        this.configuration = (VoucherConfiguration)this._persistence_configuration_vh.getValue();
        this._persistence_propertyChange("configuration", this.configuration, voucherConfiguration);
        this.configuration = voucherConfiguration;
        this._persistence_configuration_vh.setValue((Object)voucherConfiguration);
    }

    public Set _persistence_get_customFields() {
        this._persistence_checkFetched("customFields");
        return this.customFields;
    }

    public void _persistence_set_customFields(Set set) {
        this._persistence_checkFetchedForSet("customFields");
        this._persistence_propertyChange("customFields", this.customFields, set);
        this.customFields = set;
    }

    public BigDecimal _persistence_get_maxTotalOpenAmount() {
        this._persistence_checkFetched("maxTotalOpenAmount");
        return this.maxTotalOpenAmount;
    }

    public void _persistence_set_maxTotalOpenAmount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("maxTotalOpenAmount");
        this._persistence_propertyChange("maxTotalOpenAmount", this.maxTotalOpenAmount, bigDecimal);
        this.maxTotalOpenAmount = bigDecimal;
    }

    public Boolean _persistence_get_buyUntilDateExpirationNotified() {
        this._persistence_checkFetched("buyUntilDateExpirationNotified");
        return this.buyUntilDateExpirationNotified;
    }

    public void _persistence_set_buyUntilDateExpirationNotified(Boolean bl) {
        this._persistence_checkFetchedForSet("buyUntilDateExpirationNotified");
        this._persistence_propertyChange("buyUntilDateExpirationNotified", this.buyUntilDateExpirationNotified, bl);
        this.buyUntilDateExpirationNotified = bl;
    }

    public BigDecimal _persistence_get_maxBuyAmount() {
        this._persistence_checkFetched("maxBuyAmount");
        return this.maxBuyAmount;
    }

    public void _persistence_set_maxBuyAmount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("maxBuyAmount");
        this._persistence_propertyChange("maxBuyAmount", this.maxBuyAmount, bigDecimal);
        this.maxBuyAmount = bigDecimal;
    }

    public Boolean _persistence_get_enabled() {
        this._persistence_checkFetched("enabled");
        return this.enabled;
    }

    public void _persistence_set_enabled(Boolean bl) {
        this._persistence_checkFetchedForSet("enabled");
        this._persistence_propertyChange("enabled", this.enabled, bl);
        this.enabled = bl;
    }

    public BigDecimal _persistence_get_maxTopUpAmount() {
        this._persistence_checkFetched("maxTopUpAmount");
        return this.maxTopUpAmount;
    }

    public void _persistence_set_maxTopUpAmount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("maxTopUpAmount");
        this._persistence_propertyChange("maxTopUpAmount", this.maxTopUpAmount, bigDecimal);
        this.maxTopUpAmount = bigDecimal;
    }

    public Date _persistence_get_buyUntilDate() {
        this._persistence_checkFetched("buyUntilDate");
        return this.buyUntilDate;
    }

    public void _persistence_set_buyUntilDate(Date date) {
        this._persistence_checkFetchedForSet("buyUntilDate");
        this._persistence_propertyChange("buyUntilDate", this.buyUntilDate, date);
        this.buyUntilDate = date;
    }

    public TimeInterval _persistence_get_minimumTimeToRedeem() {
        this._persistence_checkFetched("minimumTimeToRedeem");
        return this.minimumTimeToRedeem;
    }

    public void _persistence_set_minimumTimeToRedeem(TimeInterval timeInterval) {
        this._persistence_checkFetchedForSet("minimumTimeToRedeem");
        this._persistence_propertyChange("minimumTimeToRedeem", this.minimumTimeToRedeem, timeInterval);
        this.minimumTimeToRedeem = timeInterval;
    }

    public BigDecimal _persistence_get_maxBalance() {
        this._persistence_checkFetched("maxBalance");
        return this.maxBalance;
    }

    public void _persistence_set_maxBalance(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("maxBalance");
        this._persistence_propertyChange("maxBalance", this.maxBalance, bigDecimal);
        this.maxBalance = bigDecimal;
    }

    public TimeInterval _persistence_get_expirationInterval() {
        this._persistence_checkFetched("expirationInterval");
        return this.expirationInterval;
    }

    public void _persistence_set_expirationInterval(TimeInterval timeInterval) {
        this._persistence_checkFetchedForSet("expirationInterval");
        this._persistence_propertyChange("expirationInterval", this.expirationInterval, timeInterval);
        this.expirationInterval = timeInterval;
    }

    public Boolean _persistence_get_hideBalanceInRedeem() {
        this._persistence_checkFetched("hideBalanceInRedeem");
        return this.hideBalanceInRedeem;
    }

    public void _persistence_set_hideBalanceInRedeem(Boolean bl) {
        this._persistence_checkFetchedForSet("hideBalanceInRedeem");
        this._persistence_propertyChange("hideBalanceInRedeem", this.hideBalanceInRedeem, bl);
        this.hideBalanceInRedeem = bl;
    }

    public String _persistence_get_voucherDescription() {
        this._persistence_checkFetched("voucherDescription");
        return this.voucherDescription;
    }

    public void _persistence_set_voucherDescription(String string) {
        this._persistence_checkFetchedForSet("voucherDescription");
        this._persistence_propertyChange("voucherDescription", this.voucherDescription, string);
        this.voucherDescription = string;
    }

    public BigDecimal _persistence_get_maxBuyAmountPerPeriod() {
        this._persistence_checkFetched("maxBuyAmountPerPeriod");
        return this.maxBuyAmountPerPeriod;
    }

    public void _persistence_set_maxBuyAmountPerPeriod(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("maxBuyAmountPerPeriod");
        this._persistence_propertyChange("maxBuyAmountPerPeriod", this.maxBuyAmountPerPeriod, bigDecimal);
        this.maxBuyAmountPerPeriod = bigDecimal;
    }

    public Date _persistence_get_expirationDate() {
        this._persistence_checkFetched("expirationDate");
        return this.expirationDate;
    }

    public void _persistence_set_expirationDate(Date date) {
        this._persistence_checkFetchedForSet("expirationDate");
        this._persistence_propertyChange("expirationDate", this.expirationDate, date);
        this.expirationDate = date;
    }

    public Integer _persistence_get_maxTotalBuy() {
        this._persistence_checkFetched("maxTotalBuy");
        return this.maxTotalBuy;
    }

    public void _persistence_set_maxTotalBuy(Integer n) {
        this._persistence_checkFetchedForSet("maxTotalBuy");
        this._persistence_propertyChange("maxTotalBuy", this.maxTotalBuy, n);
        this.maxTotalBuy = n;
    }

    public BigDecimal _persistence_get_maxOpenAmountPerUser() {
        this._persistence_checkFetched("maxOpenAmountPerUser");
        return this.maxOpenAmountPerUser;
    }

    public void _persistence_set_maxOpenAmountPerUser(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("maxOpenAmountPerUser");
        this._persistence_propertyChange("maxOpenAmountPerUser", this.maxOpenAmountPerUser, bigDecimal);
        this.maxOpenAmountPerUser = bigDecimal;
    }

    public VoucherPaymentDestination _persistence_get_paymentDestination() {
        this._persistence_checkFetched("paymentDestination");
        return this.paymentDestination;
    }

    public void _persistence_set_paymentDestination(VoucherPaymentDestination voucherPaymentDestination) {
        this._persistence_checkFetchedForSet("paymentDestination");
        this._persistence_propertyChange("paymentDestination", this.paymentDestination, voucherPaymentDestination);
        this.paymentDestination = voucherPaymentDestination;
    }

    public Set _persistence_get_images() {
        this._persistence_checkFetched("images");
        return this.images;
    }

    public void _persistence_set_images(Set set) {
        this._persistence_checkFetchedForSet("images");
        this._persistence_propertyChange("images", this.images, set);
        this.images = set;
    }

    public VoucherExpirationType _persistence_get_expirationType() {
        this._persistence_checkFetched("expirationType");
        return this.expirationType;
    }

    public void _persistence_set_expirationType(VoucherExpirationType voucherExpirationType) {
        this._persistence_checkFetchedForSet("expirationType");
        this._persistence_propertyChange("expirationType", this.expirationType, voucherExpirationType);
        this.expirationType = voucherExpirationType;
    }

    public Set _persistence_get_redeemAllowedUsers() {
        this._persistence_checkFetched("redeemAllowedUsers");
        return this.redeemAllowedUsers;
    }

    public void _persistence_set_redeemAllowedUsers(Set set) {
        this._persistence_checkFetchedForSet("redeemAllowedUsers");
        this._persistence_propertyChange("redeemAllowedUsers", this.redeemAllowedUsers, set);
        this.redeemAllowedUsers = set;
    }

    public BigDecimal _persistence_get_minTopUpAmount() {
        this._persistence_checkFetched("minTopUpAmount");
        return this.minTopUpAmount;
    }

    public void _persistence_set_minTopUpAmount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("minTopUpAmount");
        this._persistence_propertyChange("minTopUpAmount", this.minTopUpAmount, bigDecimal);
        this.minTopUpAmount = bigDecimal;
    }

    public Integer _persistence_get_maxVouchersPerBuy() {
        this._persistence_checkFetched("maxVouchersPerBuy");
        return this.maxVouchersPerBuy;
    }

    public void _persistence_set_maxVouchersPerBuy(Integer n) {
        this._persistence_checkFetchedForSet("maxVouchersPerBuy");
        this._persistence_propertyChange("maxVouchersPerBuy", this.maxVouchersPerBuy, n);
        this.maxVouchersPerBuy = n;
    }

    public BigDecimal _persistence_get_maxBuyAmountActualSum() {
        this._persistence_checkFetched("maxBuyAmountActualSum");
        return this.maxBuyAmountActualSum;
    }

    public void _persistence_set_maxBuyAmountActualSum(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("maxBuyAmountActualSum");
        this._persistence_propertyChange("maxBuyAmountActualSum", this.maxBuyAmountActualSum, bigDecimal);
        this.maxBuyAmountActualSum = bigDecimal;
    }

    public DatePeriod _persistence_get_maxBuyAmountActualPeriod() {
        this._persistence_checkFetched("maxBuyAmountActualPeriod");
        return this.maxBuyAmountActualPeriod;
    }

    public void _persistence_set_maxBuyAmountActualPeriod(DatePeriod datePeriod) {
        this._persistence_checkFetchedForSet("maxBuyAmountActualPeriod");
        this._persistence_propertyChange("maxBuyAmountActualPeriod", this.maxBuyAmountActualPeriod, datePeriod);
        this.maxBuyAmountActualPeriod = datePeriod;
    }

    public BigDecimal _persistence_get_minBuyAmount() {
        this._persistence_checkFetched("minBuyAmount");
        return this.minBuyAmount;
    }

    public void _persistence_set_minBuyAmount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("minBuyAmount");
        this._persistence_propertyChange("minBuyAmount", this.minBuyAmount, bigDecimal);
        this.minBuyAmount = bigDecimal;
    }

    public Boolean _persistence_get_allowBuying() {
        this._persistence_checkFetched("allowBuying");
        return this.allowBuying;
    }

    public void _persistence_set_allowBuying(Boolean bl) {
        this._persistence_checkFetchedForSet("allowBuying");
        this._persistence_propertyChange("allowBuying", this.allowBuying, bl);
        this.allowBuying = bl;
    }

    public String _persistence_get_voucherTitle() {
        this._persistence_checkFetched("voucherTitle");
        return this.voucherTitle;
    }

    public void _persistence_set_voucherTitle(String string) {
        this._persistence_checkFetchedForSet("voucherTitle");
        this._persistence_propertyChange("voucherTitle", this.voucherTitle, string);
        this.voucherTitle = string;
    }

    public Set _persistence_get_redeemAllowedGroups() {
        this._persistence_checkFetched("redeemAllowedGroups");
        return this.redeemAllowedGroups;
    }

    public void _persistence_set_redeemAllowedGroups(Set set) {
        this._persistence_checkFetchedForSet("redeemAllowedGroups");
        this._persistence_propertyChange("redeemAllowedGroups", this.redeemAllowedGroups, set);
        this.redeemAllowedGroups = set;
    }

    public TimeInterval _persistence_get_maxBuyAmountPeriod() {
        this._persistence_checkFetched("maxBuyAmountPeriod");
        return this.maxBuyAmountPeriod;
    }

    public void _persistence_set_maxBuyAmountPeriod(TimeInterval timeInterval) {
        this._persistence_checkFetchedForSet("maxBuyAmountPeriod");
        this._persistence_propertyChange("maxBuyAmountPeriod", this.maxBuyAmountPeriod, timeInterval);
        this.maxBuyAmountPeriod = timeInterval;
    }

    public Boolean _persistence_get_allowPartialRedeems() {
        this._persistence_checkFetched("allowPartialRedeems");
        return this.allowPartialRedeems;
    }

    public void _persistence_set_allowPartialRedeems(Boolean bl) {
        this._persistence_checkFetchedForSet("allowPartialRedeems");
        this._persistence_propertyChange("allowPartialRedeems", this.allowPartialRedeems, bl);
        this.allowPartialRedeems = bl;
    }

    protected void _persistence_initialize_paymentDestinationUser_vh() {
        if (this._persistence_paymentDestinationUser_vh == null) {
            this._persistence_paymentDestinationUser_vh = new ValueHolder((Object)this.paymentDestinationUser);
            this._persistence_paymentDestinationUser_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_paymentDestinationUser_vh() {
        User user;
        this._persistence_initialize_paymentDestinationUser_vh();
        if ((this._persistence_paymentDestinationUser_vh.isCoordinatedWithProperty() || this._persistence_paymentDestinationUser_vh.isNewlyWeavedValueHolder()) && (user = this._persistence_get_paymentDestinationUser()) != this._persistence_paymentDestinationUser_vh.getValue()) {
            this._persistence_set_paymentDestinationUser(user);
        }
        return this._persistence_paymentDestinationUser_vh;
    }

    public void _persistence_set_paymentDestinationUser_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_paymentDestinationUser_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            User user = this._persistence_get_paymentDestinationUser();
            if (user != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_paymentDestinationUser((User)object);
            }
        } else {
            this.paymentDestinationUser = null;
        }
    }

    public User _persistence_get_paymentDestinationUser() {
        this._persistence_checkFetched("paymentDestinationUser");
        this._persistence_initialize_paymentDestinationUser_vh();
        this.paymentDestinationUser = (User)this._persistence_paymentDestinationUser_vh.getValue();
        return this.paymentDestinationUser;
    }

    public void _persistence_set_paymentDestinationUser(User user) {
        this._persistence_checkFetchedForSet("paymentDestinationUser");
        this._persistence_initialize_paymentDestinationUser_vh();
        this.paymentDestinationUser = (User)this._persistence_paymentDestinationUser_vh.getValue();
        this._persistence_propertyChange("paymentDestinationUser", this.paymentDestinationUser, user);
        this.paymentDestinationUser = user;
        this._persistence_paymentDestinationUser_vh.setValue((Object)user);
    }

    protected void _persistence_initialize_category_vh() {
        if (this._persistence_category_vh == null) {
            this._persistence_category_vh = new ValueHolder((Object)this.category);
            this._persistence_category_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_category_vh() {
        VoucherCategory voucherCategory;
        this._persistence_initialize_category_vh();
        if ((this._persistence_category_vh.isCoordinatedWithProperty() || this._persistence_category_vh.isNewlyWeavedValueHolder()) && (voucherCategory = this._persistence_get_category()) != this._persistence_category_vh.getValue()) {
            this._persistence_set_category(voucherCategory);
        }
        return this._persistence_category_vh;
    }

    public void _persistence_set_category_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_category_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            VoucherCategory voucherCategory = this._persistence_get_category();
            if (voucherCategory != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_category((VoucherCategory)object);
            }
        } else {
            this.category = null;
        }
    }

    public VoucherCategory _persistence_get_category() {
        this._persistence_checkFetched("category");
        this._persistence_initialize_category_vh();
        this.category = (VoucherCategory)this._persistence_category_vh.getValue();
        return this.category;
    }

    public void _persistence_set_category(VoucherCategory voucherCategory) {
        this._persistence_checkFetchedForSet("category");
        this._persistence_initialize_category_vh();
        this.category = (VoucherCategory)this._persistence_category_vh.getValue();
        this._persistence_propertyChange("category", this.category, voucherCategory);
        this.category = voucherCategory;
        this._persistence_category_vh.setValue((Object)voucherCategory);
    }

    public String _persistence_get_redeemOnWeekDays() {
        this._persistence_checkFetched("redeemOnWeekDays");
        return this.redeemOnWeekDays;
    }

    public void _persistence_set_redeemOnWeekDays(String string) {
        this._persistence_checkFetchedForSet("redeemOnWeekDays");
        this._persistence_propertyChange("redeemOnWeekDays", this.redeemOnWeekDays, string);
        this.redeemOnWeekDays = string;
    }
}

