/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.CurrencyScale;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.HasCurrencyAmount;
import org.cyclos.entities.banking.InternalTransaction;
import org.cyclos.entities.banking.Voucher;
import org.cyclos.entities.banking.VoucherChargeback;
import org.cyclos.entities.banking.VoucherConfiguration;
import org.cyclos.entities.banking.VoucherPack;
import org.cyclos.entities.banking.VoucherTransactionAmountReservation;
import org.cyclos.entities.banking.VoucherType;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.model.banking.vouchers.VoucherTransactionNature;
import org.cyclos.utils.CollectionHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="voucher_transactions")
@DiscriminatorColumn(name="subclass")
public abstract class VoucherTransaction
extends NetworkedEntity
implements HasCurrencyAmount,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @Basic
    @Column(name="subclass", insertable=false, updatable=false)
    @Enumerated(value=EnumType.STRING)
    private VoucherTransactionNature nature;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="voucher_id", nullable=false)
    private Voucher voucher;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="date", nullable=false)
    private Date date;
    @Basic
    @Column(name="amount", nullable=false)
    @CurrencyScale
    private BigDecimal amount;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="transaction_id")
    private InternalTransaction transaction;
    @Basic
    @Column(name="transaction_id", insertable=false, updatable=false)
    private Long transactionId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id", nullable=false)
    private User user;
    @ManyToOne
    @JoinColumn(name="by_id")
    private BasicUser by;
    @ManyToOne
    @JoinColumn(name="charged_back_by_id")
    private VoucherChargeback chargedBackBy;
    @OneToMany(mappedBy="voucherTransaction")
    private Set<VoucherTransactionAmountReservation> amountReservations;
    static final long serialVersionUID = 8193576506465473624L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_voucher_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_user_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_transaction_vh;

    @CurrencyScale
    public BigDecimal getAmount() {
        return this._persistence_get_amount();
    }

    public VoucherTransactionAmountReservation getAmountReservation() {
        return (VoucherTransactionAmountReservation)CollectionHelper.first((Iterable)this._persistence_get_amountReservations());
    }

    public BasicUser getBy() {
        return this._persistence_get_by();
    }

    public VoucherChargeback getChargedBackBy() {
        return this._persistence_get_chargedBackBy();
    }

    public VoucherConfiguration getConfiguration() {
        return this._persistence_get_voucher().getConfiguration();
    }

    @Override
    public Currency getCurrency() {
        return this._persistence_get_voucher().getCurrency();
    }

    public Date getDate() {
        return this._persistence_get_date();
    }

    public abstract VoucherTransactionNature getNature();

    @Override
    public Network getNetwork() {
        return this._persistence_get_voucher().getNetwork();
    }

    public VoucherPack getPack() {
        return this._persistence_get_voucher().getPack();
    }

    public InternalTransaction getTransaction() {
        return this._persistence_get_transaction();
    }

    public VoucherType getType() {
        return this._persistence_get_voucher().getType();
    }

    public User getUser() {
        return this._persistence_get_user();
    }

    public Voucher getVoucher() {
        return this._persistence_get_voucher();
    }

    public void setAmount(BigDecimal bigDecimal) {
        this._persistence_set_amount(bigDecimal);
    }

    public void setAmountReservation(VoucherTransactionAmountReservation voucherTransactionAmountReservation) {
        this._persistence_set_amountReservations(CollectionHelper.asSet((Object[])new VoucherTransactionAmountReservation[]{voucherTransactionAmountReservation}));
    }

    public void setBy(BasicUser basicUser) {
        this._persistence_set_by(basicUser);
    }

    public void setChargedBackBy(VoucherChargeback voucherChargeback) {
        this._persistence_set_chargedBackBy(voucherChargeback);
    }

    public void setDate(Date date) {
        this._persistence_set_date(date);
    }

    public void setTransaction(InternalTransaction internalTransaction) {
        this._persistence_set_transaction(internalTransaction);
    }

    public void setUser(User user) {
        this._persistence_set_user(user);
    }

    public void setVoucher(Voucher voucher) {
        this._persistence_set_voucher(voucher);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_voucher_vh != null) {
            this._persistence_voucher_vh = (WeavedAttributeValueHolderInterface)this._persistence_voucher_vh.clone();
        }
        if (this._persistence_user_vh != null) {
            this._persistence_user_vh = (WeavedAttributeValueHolderInterface)this._persistence_user_vh.clone();
        }
        if (this._persistence_transaction_vh != null) {
            this._persistence_transaction_vh = (WeavedAttributeValueHolderInterface)this._persistence_transaction_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new VoucherTransaction();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "date") {
            return this.date;
        }
        if (string == "amount") {
            return this.amount;
        }
        if (string == "amountReservations") {
            return this.amountReservations;
        }
        if (string == "nature") {
            return this.nature;
        }
        if (string == "voucher") {
            return this.voucher;
        }
        if (string == "by") {
            return this.by;
        }
        if (string == "chargedBackBy") {
            return this.chargedBackBy;
        }
        if (string == "user") {
            return this.user;
        }
        if (string == "transactionId") {
            return this.transactionId;
        }
        if (string == "transaction") {
            return this.transaction;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "date") {
            this.date = (Date)object;
            return;
        }
        if (string == "amount") {
            this.amount = (BigDecimal)object;
            return;
        }
        if (string == "amountReservations") {
            this.amountReservations = (Set)object;
            return;
        }
        if (string == "nature") {
            this.nature = (VoucherTransactionNature)object;
            return;
        }
        if (string == "voucher") {
            this.voucher = (Voucher)object;
            return;
        }
        if (string == "by") {
            this.by = (BasicUser)object;
            return;
        }
        if (string == "chargedBackBy") {
            this.chargedBackBy = (VoucherChargeback)object;
            return;
        }
        if (string == "user") {
            this.user = (User)object;
            return;
        }
        if (string == "transactionId") {
            this.transactionId = (Long)object;
            return;
        }
        if (string == "transaction") {
            this.transaction = (InternalTransaction)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Date _persistence_get_date() {
        this._persistence_checkFetched("date");
        return this.date;
    }

    public void _persistence_set_date(Date date) {
        this._persistence_checkFetchedForSet("date");
        this._persistence_propertyChange("date", this.date, date);
        this.date = date;
    }

    public BigDecimal _persistence_get_amount() {
        this._persistence_checkFetched("amount");
        return this.amount;
    }

    public void _persistence_set_amount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amount");
        this._persistence_propertyChange("amount", this.amount, bigDecimal);
        this.amount = bigDecimal;
    }

    public Set _persistence_get_amountReservations() {
        this._persistence_checkFetched("amountReservations");
        return this.amountReservations;
    }

    public void _persistence_set_amountReservations(Set set) {
        this._persistence_checkFetchedForSet("amountReservations");
        this._persistence_propertyChange("amountReservations", this.amountReservations, set);
        this.amountReservations = set;
    }

    public VoucherTransactionNature _persistence_get_nature() {
        this._persistence_checkFetched("nature");
        return this.nature;
    }

    public void _persistence_set_nature(VoucherTransactionNature voucherTransactionNature) {
        this._persistence_checkFetchedForSet("nature");
        this._persistence_propertyChange("nature", this.nature, voucherTransactionNature);
        this.nature = voucherTransactionNature;
    }

    protected void _persistence_initialize_voucher_vh() {
        if (this._persistence_voucher_vh == null) {
            this._persistence_voucher_vh = new ValueHolder((Object)this.voucher);
            this._persistence_voucher_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_voucher_vh() {
        Voucher voucher;
        this._persistence_initialize_voucher_vh();
        if ((this._persistence_voucher_vh.isCoordinatedWithProperty() || this._persistence_voucher_vh.isNewlyWeavedValueHolder()) && (voucher = this._persistence_get_voucher()) != this._persistence_voucher_vh.getValue()) {
            this._persistence_set_voucher(voucher);
        }
        return this._persistence_voucher_vh;
    }

    public void _persistence_set_voucher_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_voucher_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Voucher voucher = this._persistence_get_voucher();
            if (voucher != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_voucher((Voucher)object);
            }
        } else {
            this.voucher = null;
        }
    }

    public Voucher _persistence_get_voucher() {
        this._persistence_checkFetched("voucher");
        this._persistence_initialize_voucher_vh();
        this.voucher = (Voucher)this._persistence_voucher_vh.getValue();
        return this.voucher;
    }

    public void _persistence_set_voucher(Voucher voucher) {
        this._persistence_checkFetchedForSet("voucher");
        this._persistence_initialize_voucher_vh();
        this.voucher = (Voucher)this._persistence_voucher_vh.getValue();
        this._persistence_propertyChange("voucher", this.voucher, voucher);
        this.voucher = voucher;
        this._persistence_voucher_vh.setValue((Object)voucher);
    }

    public BasicUser _persistence_get_by() {
        this._persistence_checkFetched("by");
        return this.by;
    }

    public void _persistence_set_by(BasicUser basicUser) {
        this._persistence_checkFetchedForSet("by");
        this._persistence_propertyChange("by", this.by, basicUser);
        this.by = basicUser;
    }

    public VoucherChargeback _persistence_get_chargedBackBy() {
        this._persistence_checkFetched("chargedBackBy");
        return this.chargedBackBy;
    }

    public void _persistence_set_chargedBackBy(VoucherChargeback voucherChargeback) {
        this._persistence_checkFetchedForSet("chargedBackBy");
        this._persistence_propertyChange("chargedBackBy", this.chargedBackBy, voucherChargeback);
        this.chargedBackBy = voucherChargeback;
    }

    protected void _persistence_initialize_user_vh() {
        if (this._persistence_user_vh == null) {
            this._persistence_user_vh = new ValueHolder((Object)this.user);
            this._persistence_user_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_user_vh() {
        User user;
        this._persistence_initialize_user_vh();
        if ((this._persistence_user_vh.isCoordinatedWithProperty() || this._persistence_user_vh.isNewlyWeavedValueHolder()) && (user = this._persistence_get_user()) != this._persistence_user_vh.getValue()) {
            this._persistence_set_user(user);
        }
        return this._persistence_user_vh;
    }

    public void _persistence_set_user_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_user_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            User user = this._persistence_get_user();
            if (user != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_user((User)object);
            }
        } else {
            this.user = null;
        }
    }

    public User _persistence_get_user() {
        this._persistence_checkFetched("user");
        this._persistence_initialize_user_vh();
        this.user = (User)this._persistence_user_vh.getValue();
        return this.user;
    }

    public void _persistence_set_user(User user) {
        this._persistence_checkFetchedForSet("user");
        this._persistence_initialize_user_vh();
        this.user = (User)this._persistence_user_vh.getValue();
        this._persistence_propertyChange("user", this.user, user);
        this.user = user;
        this._persistence_user_vh.setValue((Object)user);
    }

    public Long _persistence_get_transactionId() {
        this._persistence_checkFetched("transactionId");
        return this.transactionId;
    }

    public void _persistence_set_transactionId(Long l) {
        this._persistence_checkFetchedForSet("transactionId");
        this._persistence_propertyChange("transactionId", this.transactionId, l);
        this.transactionId = l;
    }

    protected void _persistence_initialize_transaction_vh() {
        if (this._persistence_transaction_vh == null) {
            this._persistence_transaction_vh = new ValueHolder((Object)this.transaction);
            this._persistence_transaction_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_transaction_vh() {
        InternalTransaction internalTransaction;
        this._persistence_initialize_transaction_vh();
        if ((this._persistence_transaction_vh.isCoordinatedWithProperty() || this._persistence_transaction_vh.isNewlyWeavedValueHolder()) && (internalTransaction = this._persistence_get_transaction()) != this._persistence_transaction_vh.getValue()) {
            this._persistence_set_transaction(internalTransaction);
        }
        return this._persistence_transaction_vh;
    }

    public void _persistence_set_transaction_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_transaction_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            InternalTransaction internalTransaction = this._persistence_get_transaction();
            if (internalTransaction != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_transaction((InternalTransaction)object);
            }
        } else {
            this.transaction = null;
        }
    }

    public InternalTransaction _persistence_get_transaction() {
        this._persistence_checkFetched("transaction");
        this._persistence_initialize_transaction_vh();
        this.transaction = (InternalTransaction)this._persistence_transaction_vh.getValue();
        return this.transaction;
    }

    public void _persistence_set_transaction(InternalTransaction internalTransaction) {
        this._persistence_checkFetchedForSet("transaction");
        this._persistence_initialize_transaction_vh();
        this.transaction = (InternalTransaction)this._persistence_transaction_vh.getValue();
        this._persistence_propertyChange("transaction", this.transaction, internalTransaction);
        this.transaction = internalTransaction;
        this._persistence_transaction_vh.setValue((Object)internalTransaction);
    }
}

