/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.CurrencyScale;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.HasCurrencyAmount;
import org.cyclos.entities.banking.Payment;
import org.cyclos.entities.banking.VoucherAmountReservation;
import org.cyclos.entities.banking.VoucherConfiguration;
import org.cyclos.entities.banking.VoucherCustomField;
import org.cyclos.entities.banking.VoucherCustomFieldPossibleValue;
import org.cyclos.entities.banking.VoucherCustomFieldPossibleValueCategory;
import org.cyclos.entities.banking.VoucherCustomFieldValue;
import org.cyclos.entities.banking.VoucherPack;
import org.cyclos.entities.banking.VoucherRedeem;
import org.cyclos.entities.banking.VoucherTemplate;
import org.cyclos.entities.banking.VoucherTopUp;
import org.cyclos.entities.banking.VoucherTransaction;
import org.cyclos.entities.banking.VoucherType;
import org.cyclos.entities.banking.VoucherUnblockAmountReservation;
import org.cyclos.entities.system.EntityWithCustomValues;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.CurrencyAmount;
import org.cyclos.model.banking.voucherconfigurations.VoucherPinUsage;
import org.cyclos.model.banking.vouchers.VoucherPinStatusForRedeem;
import org.cyclos.model.banking.vouchers.VoucherStatus;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="vouchers", indexes={@Index(name="ix_vouchers_status", columnList="status"), @Index(name="ix_vouchers_token", unique=true, columnList="token"), @Index(name="ix_vouchers_email", columnList="lower(email)"), @Index(name="ix_vouchers_mobile_phone", columnList="mobile_phone")})
public class Voucher
extends BaseEntity
implements HasCurrencyAmount,
EntityWithCustomValues<VoucherCustomField, VoucherCustomFieldPossibleValueCategory, VoucherCustomFieldPossibleValue, VoucherCustomFieldValue>,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="pack_id", nullable=false)
    private VoucherPack pack;
    @Basic
    @Column(name="balance", nullable=false)
    @CurrencyScale
    private BigDecimal balance;
    @Basic
    @Column(name="amount")
    @CurrencyScale
    private BigDecimal amount;
    @Basic
    @Column(name="expiration_notified")
    private Boolean expirationNotified;
    @Basic
    @Column(name="about_to_expire_notified")
    private Boolean aboutToExpireNotified;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="status", nullable=false)
    private VoucherStatus status;
    @Basic
    @Column(name="token", nullable=false)
    private String token;
    @Basic
    @Column(name="pin")
    private String pin;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="pin_blocked_until")
    private Date pinBlockedUntil;
    @OneToMany(mappedBy="voucher")
    private Set<VoucherAmountReservation> amountDereservations;
    @OneToMany(mappedBy="voucher")
    private Set<VoucherUnblockAmountReservation> unblockReservations;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="owner_id")
    private User owner;
    @OneToMany(mappedBy="voucher")
    @OrderBy
    private Set<VoucherTransaction> transactions = new HashSet<VoucherTransaction>();
    @Basic
    @Column(name="printed", nullable=false)
    private boolean printed;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="expiration_date")
    private Date expirationDate;
    @Basic
    @Lob
    @Column(name="expiration_date_comments")
    private String expirationDateComments;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="refund_id")
    private Payment refund;
    @OneToMany(mappedBy="owner", cascade={CascadeType.ALL})
    private Set<VoucherCustomFieldValue> customValues = new HashSet<VoucherCustomFieldValue>();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="activation_id")
    private VoucherTopUp activation;
    @Basic
    @Column(name="email")
    private String email;
    @Basic
    @Column(name="enable_notifications")
    private Boolean enableNotifications;
    @Basic
    @Column(name="mobile_phone")
    private String mobilePhone;
    static final long serialVersionUID = -3102126708777384777L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_owner_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_pack_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_activation_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_refund_vh;

    public VoucherTopUp getActivation() {
        return this._persistence_get_activation();
    }

    public Date getActualExpirationDate() {
        return (Date)ObjectHelper.defaultValue((Object)this.getExpirationDate(), (Object)this._persistence_get_pack().getExpirationDate());
    }

    public BigDecimal getAmount() {
        return (BigDecimal)ObjectHelper.defaultValue((Object)this._persistence_get_amount(), (Object)this._persistence_get_pack().getAmount());
    }

    @Deprecated
    public VoucherAmountReservation getAmountDereservation() {
        return (VoucherAmountReservation)CollectionHelper.first((Iterable)this._persistence_get_amountDereservations());
    }

    public Set<VoucherAmountReservation> getAmountDereservations() {
        return this._persistence_get_amountDereservations();
    }

    public BigDecimal getBalance() {
        return this._persistence_get_balance();
    }

    public CurrencyAmount getBalanceCurrencyAmount() {
        return this.withCurrency(this.getBalance());
    }

    public VoucherConfiguration getConfiguration() {
        return this._persistence_get_pack().getConfiguration();
    }

    @Override
    public Currency getCurrency() {
        return this._persistence_get_pack().getCurrency();
    }

    @Override
    public CurrencyAmount getCurrencyAmount() {
        return this.withCurrency(this.getAmount());
    }

    @Override
    public Class<VoucherCustomField> getCustomFieldClass() {
        return VoucherCustomField.class;
    }

    @Override
    public Class<VoucherCustomFieldValue> getCustomFieldValueClass() {
        return VoucherCustomFieldValue.class;
    }

    @Override
    public Set<VoucherCustomFieldValue> getCustomValues() {
        return this._persistence_get_customValues();
    }

    public String getEmail() {
        return this._persistence_get_email();
    }

    public Date getExpirationDate() {
        if (this._persistence_get_expirationDate() == null) {
            return this.getPack().getExpirationDate();
        }
        return this._persistence_get_expirationDate();
    }

    public String getExpirationDateComments() {
        return this._persistence_get_expirationDateComments();
    }

    public String getMobilePhone() {
        return this._persistence_get_mobilePhone();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_pack().getNetwork();
    }

    public User getOwner() {
        return this._persistence_get_owner();
    }

    public User getOwnerOrBuyer() {
        return (User)ObjectHelper.defaultValue((Object)this.getOwner(), (Object)this.getPack().getBuyer());
    }

    public VoucherPack getPack() {
        return this._persistence_get_pack();
    }

    public String getPin() {
        return this._persistence_get_pin();
    }

    public Date getPinBlockedUntil() {
        return this._persistence_get_pinBlockedUntil();
    }

    public VoucherPinStatusForRedeem getPinStatusForRedeem() {
        if (!this.isOpen()) {
            return VoucherPinStatusForRedeem.NOT_USED;
        }
        VoucherPinUsage voucherPinUsage = (VoucherPinUsage)ObjectHelper.defaultValue((Object)this.getConfiguration().getPinUsage(), (Object)VoucherPinUsage.NEVER);
        if (ObjectHelper.isOneOf((Object)voucherPinUsage, (Object[])new Object[]{VoucherPinUsage.NEVER, VoucherPinUsage.INFO}) || this.getPin() == null) {
            return VoucherPinStatusForRedeem.NOT_USED;
        }
        if (this.isPinBlocked()) {
            return VoucherPinStatusForRedeem.BLOCKED;
        }
        BigDecimal bigDecimal = this.getAmount();
        if (voucherPinUsage == VoucherPinUsage.SUBSEQUENT && bigDecimal != null && bigDecimal.equals(this.getBalance())) {
            return VoucherPinStatusForRedeem.SUBSEQUENT;
        }
        return VoucherPinStatusForRedeem.REQUIRED;
    }

    public Payment getRefund() {
        return this._persistence_get_refund();
    }

    public VoucherRedeem getSingleRedeem() {
        if (this.getType().isAllowPartialRedeems() || this.getStatus() != VoucherStatus.REDEEMED) {
            return null;
        }
        return CollectionHelper.orEmpty(this.getTransactions()).stream().filter(VoucherRedeem.class::isInstance).findFirst().orElse(null);
    }

    public VoucherStatus getStatus() {
        return this._persistence_get_status();
    }

    public VoucherTemplate getTemplate() {
        return this.getType().getTemplate();
    }

    public String getToken() {
        return this._persistence_get_token();
    }

    public Set<VoucherTransaction> getTransactions() {
        return this._persistence_get_transactions();
    }

    public VoucherType getType() {
        return this._persistence_get_pack().getType();
    }

    public VoucherUnblockAmountReservation getUnblockAmountReservation() {
        return (VoucherUnblockAmountReservation)CollectionHelper.first((Iterable)this._persistence_get_unblockReservations());
    }

    public boolean hasCustomExpirationDate() {
        return this._persistence_get_expirationDate() != null;
    }

    public boolean hasNotificationMedium() {
        return StringHelper.isNotBlank((Object)this._persistence_get_email()) || StringHelper.isNotBlank((Object)this._persistence_get_mobilePhone());
    }

    public boolean isAboutToExpireNotified() {
        return Boolean.TRUE.equals(this._persistence_get_aboutToExpireNotified());
    }

    public boolean isAssigned() {
        return this._persistence_get_owner() != null;
    }

    public boolean isBlocked() {
        return this._persistence_get_status() == VoucherStatus.BLOCKED;
    }

    public boolean isBlockedGift() {
        return Boolean.TRUE.equals(this._persistence_get_pack().getGift()) && this.getStatus() == VoucherStatus.BLOCKED;
    }

    public boolean isCanceled() {
        return this._persistence_get_status() == VoucherStatus.CANCELED;
    }

    public boolean isEnableNotifications() {
        return Boolean.TRUE.equals(this._persistence_get_enableNotifications());
    }

    public boolean isExpirationNotified() {
        return Boolean.TRUE.equals(this._persistence_get_expirationNotified());
    }

    public boolean isExpired() {
        return this._persistence_get_status() == VoucherStatus.EXPIRED;
    }

    public boolean isInactive() {
        return this._persistence_get_status() == VoucherStatus.INACTIVE;
    }

    public boolean isOpen() {
        return this._persistence_get_status() == VoucherStatus.OPEN;
    }

    public boolean isPending() {
        return this._persistence_get_status() == VoucherStatus.PENDING;
    }

    public boolean isPinBlocked() {
        return this._persistence_get_pinBlockedUntil() != null && this._persistence_get_pinBlockedUntil().after(new Date());
    }

    public boolean isPrinted() {
        return this._persistence_get_printed();
    }

    public boolean isRedeemed() {
        return this._persistence_get_status() == VoucherStatus.REDEEMED;
    }

    public void setAboutToExpireNotified(boolean bl) {
        this._persistence_set_aboutToExpireNotified(bl);
    }

    public void setActivation(VoucherTopUp voucherTopUp) {
        this._persistence_set_activation(voucherTopUp);
    }

    public void setAmount(BigDecimal bigDecimal) {
        this._persistence_set_amount(bigDecimal);
    }

    @Deprecated
    public void setAmountDereservation(VoucherAmountReservation voucherAmountReservation) {
        this._persistence_set_amountDereservations(CollectionHelper.asSet((Object[])new VoucherAmountReservation[]{voucherAmountReservation}));
    }

    public void setAmountDereservations(Set<VoucherAmountReservation> set) {
        this._persistence_set_amountDereservations(set);
    }

    public void setBalance(BigDecimal bigDecimal) {
        this._persistence_set_balance(bigDecimal);
    }

    public void setCustomValues(Set<VoucherCustomFieldValue> set) {
        this._persistence_set_customValues(set);
    }

    public void setEmail(String string) {
        this._persistence_set_email(string);
    }

    public void setEnableNotifications(boolean bl) {
        this._persistence_set_enableNotifications(bl);
    }

    public void setExpirationDate(Date date) {
        this._persistence_set_expirationDate(date);
    }

    public void setExpirationDateComments(String string) {
        this._persistence_set_expirationDateComments(string);
    }

    public void setExpirationNotified(boolean bl) {
        this._persistence_set_expirationNotified(bl);
    }

    public void setMobilePhone(String string) {
        this._persistence_set_mobilePhone(string);
    }

    public void setOwner(User user) {
        this._persistence_set_owner(user);
    }

    public void setPack(VoucherPack voucherPack) {
        this._persistence_set_pack(voucherPack);
    }

    public void setPin(String string) {
        this._persistence_set_pin(string);
    }

    public void setPinBlockedUntil(Date date) {
        this._persistence_set_pinBlockedUntil(date);
    }

    public void setPrinted(boolean bl) {
        this._persistence_set_printed(bl);
    }

    public void setRefund(Payment payment) {
        this._persistence_set_refund(payment);
    }

    public void setStatus(VoucherStatus voucherStatus) {
        this._persistence_set_status(voucherStatus);
    }

    public void setToken(String string) {
        this._persistence_set_token(string);
    }

    public void setTransactions(Set<VoucherTransaction> set) {
        this._persistence_set_transactions(set);
    }

    public void setUnblockAmountReservation(VoucherUnblockAmountReservation voucherUnblockAmountReservation) {
        this._persistence_set_unblockReservations(CollectionHelper.asSet((Object[])new VoucherUnblockAmountReservation[]{voucherUnblockAmountReservation}));
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_owner_vh != null) {
            this._persistence_owner_vh = (WeavedAttributeValueHolderInterface)this._persistence_owner_vh.clone();
        }
        if (this._persistence_pack_vh != null) {
            this._persistence_pack_vh = (WeavedAttributeValueHolderInterface)this._persistence_pack_vh.clone();
        }
        if (this._persistence_activation_vh != null) {
            this._persistence_activation_vh = (WeavedAttributeValueHolderInterface)this._persistence_activation_vh.clone();
        }
        if (this._persistence_refund_vh != null) {
            this._persistence_refund_vh = (WeavedAttributeValueHolderInterface)this._persistence_refund_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Voucher();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "owner") {
            return this.owner;
        }
        if (string == "amount") {
            return this.amount;
        }
        if (string == "enableNotifications") {
            return this.enableNotifications;
        }
        if (string == "expirationDateComments") {
            return this.expirationDateComments;
        }
        if (string == "amountDereservations") {
            return this.amountDereservations;
        }
        if (string == "expirationNotified") {
            return this.expirationNotified;
        }
        if (string == "aboutToExpireNotified") {
            return this.aboutToExpireNotified;
        }
        if (string == "transactions") {
            return this.transactions;
        }
        if (string == "pack") {
            return this.pack;
        }
        if (string == "token") {
            return this.token;
        }
        if (string == "printed") {
            return this.printed;
        }
        if (string == "unblockReservations") {
            return this.unblockReservations;
        }
        if (string == "balance") {
            return this.balance;
        }
        if (string == "pin") {
            return this.pin;
        }
        if (string == "pinBlockedUntil") {
            return this.pinBlockedUntil;
        }
        if (string == "mobilePhone") {
            return this.mobilePhone;
        }
        if (string == "activation") {
            return this.activation;
        }
        if (string == "email") {
            return this.email;
        }
        if (string == "status") {
            return this.status;
        }
        if (string == "expirationDate") {
            return this.expirationDate;
        }
        if (string == "refund") {
            return this.refund;
        }
        if (string == "customValues") {
            return this.customValues;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "owner") {
            this.owner = (User)object;
            return;
        }
        if (string == "amount") {
            this.amount = (BigDecimal)object;
            return;
        }
        if (string == "enableNotifications") {
            this.enableNotifications = (Boolean)object;
            return;
        }
        if (string == "expirationDateComments") {
            this.expirationDateComments = (String)object;
            return;
        }
        if (string == "amountDereservations") {
            this.amountDereservations = (Set)object;
            return;
        }
        if (string == "expirationNotified") {
            this.expirationNotified = (Boolean)object;
            return;
        }
        if (string == "aboutToExpireNotified") {
            this.aboutToExpireNotified = (Boolean)object;
            return;
        }
        if (string == "transactions") {
            this.transactions = (Set)object;
            return;
        }
        if (string == "pack") {
            this.pack = (VoucherPack)object;
            return;
        }
        if (string == "token") {
            this.token = (String)object;
            return;
        }
        if (string == "printed") {
            this.printed = (Boolean)object;
            return;
        }
        if (string == "unblockReservations") {
            this.unblockReservations = (Set)object;
            return;
        }
        if (string == "balance") {
            this.balance = (BigDecimal)object;
            return;
        }
        if (string == "pin") {
            this.pin = (String)object;
            return;
        }
        if (string == "pinBlockedUntil") {
            this.pinBlockedUntil = (Date)object;
            return;
        }
        if (string == "mobilePhone") {
            this.mobilePhone = (String)object;
            return;
        }
        if (string == "activation") {
            this.activation = (VoucherTopUp)object;
            return;
        }
        if (string == "email") {
            this.email = (String)object;
            return;
        }
        if (string == "status") {
            this.status = (VoucherStatus)object;
            return;
        }
        if (string == "expirationDate") {
            this.expirationDate = (Date)object;
            return;
        }
        if (string == "refund") {
            this.refund = (Payment)object;
            return;
        }
        if (string == "customValues") {
            this.customValues = (Set)object;
            return;
        }
        super._persistence_set(string, object);
    }

    protected void _persistence_initialize_owner_vh() {
        if (this._persistence_owner_vh == null) {
            this._persistence_owner_vh = new ValueHolder((Object)this.owner);
            this._persistence_owner_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_owner_vh() {
        User user;
        this._persistence_initialize_owner_vh();
        if ((this._persistence_owner_vh.isCoordinatedWithProperty() || this._persistence_owner_vh.isNewlyWeavedValueHolder()) && (user = this._persistence_get_owner()) != this._persistence_owner_vh.getValue()) {
            this._persistence_set_owner(user);
        }
        return this._persistence_owner_vh;
    }

    public void _persistence_set_owner_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_owner_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            User user = this._persistence_get_owner();
            if (user != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_owner((User)object);
            }
        } else {
            this.owner = null;
        }
    }

    public User _persistence_get_owner() {
        this._persistence_checkFetched("owner");
        this._persistence_initialize_owner_vh();
        this.owner = (User)this._persistence_owner_vh.getValue();
        return this.owner;
    }

    public void _persistence_set_owner(User user) {
        this._persistence_checkFetchedForSet("owner");
        this._persistence_initialize_owner_vh();
        this.owner = (User)this._persistence_owner_vh.getValue();
        this._persistence_propertyChange("owner", this.owner, user);
        this.owner = user;
        this._persistence_owner_vh.setValue((Object)user);
    }

    public BigDecimal _persistence_get_amount() {
        this._persistence_checkFetched("amount");
        return this.amount;
    }

    public void _persistence_set_amount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amount");
        this._persistence_propertyChange("amount", this.amount, bigDecimal);
        this.amount = bigDecimal;
    }

    public Boolean _persistence_get_enableNotifications() {
        this._persistence_checkFetched("enableNotifications");
        return this.enableNotifications;
    }

    public void _persistence_set_enableNotifications(Boolean bl) {
        this._persistence_checkFetchedForSet("enableNotifications");
        this._persistence_propertyChange("enableNotifications", this.enableNotifications, bl);
        this.enableNotifications = bl;
    }

    public String _persistence_get_expirationDateComments() {
        this._persistence_checkFetched("expirationDateComments");
        return this.expirationDateComments;
    }

    public void _persistence_set_expirationDateComments(String string) {
        this._persistence_checkFetchedForSet("expirationDateComments");
        this._persistence_propertyChange("expirationDateComments", this.expirationDateComments, string);
        this.expirationDateComments = string;
    }

    public Set _persistence_get_amountDereservations() {
        this._persistence_checkFetched("amountDereservations");
        return this.amountDereservations;
    }

    public void _persistence_set_amountDereservations(Set set) {
        this._persistence_checkFetchedForSet("amountDereservations");
        this._persistence_propertyChange("amountDereservations", this.amountDereservations, set);
        this.amountDereservations = set;
    }

    public Boolean _persistence_get_expirationNotified() {
        this._persistence_checkFetched("expirationNotified");
        return this.expirationNotified;
    }

    public void _persistence_set_expirationNotified(Boolean bl) {
        this._persistence_checkFetchedForSet("expirationNotified");
        this._persistence_propertyChange("expirationNotified", this.expirationNotified, bl);
        this.expirationNotified = bl;
    }

    public Boolean _persistence_get_aboutToExpireNotified() {
        this._persistence_checkFetched("aboutToExpireNotified");
        return this.aboutToExpireNotified;
    }

    public void _persistence_set_aboutToExpireNotified(Boolean bl) {
        this._persistence_checkFetchedForSet("aboutToExpireNotified");
        this._persistence_propertyChange("aboutToExpireNotified", this.aboutToExpireNotified, bl);
        this.aboutToExpireNotified = bl;
    }

    public Set _persistence_get_transactions() {
        this._persistence_checkFetched("transactions");
        return this.transactions;
    }

    public void _persistence_set_transactions(Set set) {
        this._persistence_checkFetchedForSet("transactions");
        this._persistence_propertyChange("transactions", this.transactions, set);
        this.transactions = set;
    }

    protected void _persistence_initialize_pack_vh() {
        if (this._persistence_pack_vh == null) {
            this._persistence_pack_vh = new ValueHolder((Object)this.pack);
            this._persistence_pack_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_pack_vh() {
        VoucherPack voucherPack;
        this._persistence_initialize_pack_vh();
        if ((this._persistence_pack_vh.isCoordinatedWithProperty() || this._persistence_pack_vh.isNewlyWeavedValueHolder()) && (voucherPack = this._persistence_get_pack()) != this._persistence_pack_vh.getValue()) {
            this._persistence_set_pack(voucherPack);
        }
        return this._persistence_pack_vh;
    }

    public void _persistence_set_pack_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_pack_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            VoucherPack voucherPack = this._persistence_get_pack();
            if (voucherPack != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_pack((VoucherPack)object);
            }
        } else {
            this.pack = null;
        }
    }

    public VoucherPack _persistence_get_pack() {
        this._persistence_checkFetched("pack");
        this._persistence_initialize_pack_vh();
        this.pack = (VoucherPack)this._persistence_pack_vh.getValue();
        return this.pack;
    }

    public void _persistence_set_pack(VoucherPack voucherPack) {
        this._persistence_checkFetchedForSet("pack");
        this._persistence_initialize_pack_vh();
        this.pack = (VoucherPack)this._persistence_pack_vh.getValue();
        this._persistence_propertyChange("pack", this.pack, voucherPack);
        this.pack = voucherPack;
        this._persistence_pack_vh.setValue((Object)voucherPack);
    }

    public String _persistence_get_token() {
        this._persistence_checkFetched("token");
        return this.token;
    }

    public void _persistence_set_token(String string) {
        this._persistence_checkFetchedForSet("token");
        this._persistence_propertyChange("token", this.token, string);
        this.token = string;
    }

    public boolean _persistence_get_printed() {
        this._persistence_checkFetched("printed");
        return this.printed;
    }

    public void _persistence_set_printed(boolean bl) {
        this._persistence_checkFetchedForSet("printed");
        this._persistence_propertyChange("printed", new Boolean(this.printed), new Boolean(bl));
        this.printed = bl;
    }

    public Set _persistence_get_unblockReservations() {
        this._persistence_checkFetched("unblockReservations");
        return this.unblockReservations;
    }

    public void _persistence_set_unblockReservations(Set set) {
        this._persistence_checkFetchedForSet("unblockReservations");
        this._persistence_propertyChange("unblockReservations", this.unblockReservations, set);
        this.unblockReservations = set;
    }

    public BigDecimal _persistence_get_balance() {
        this._persistence_checkFetched("balance");
        return this.balance;
    }

    public void _persistence_set_balance(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("balance");
        this._persistence_propertyChange("balance", this.balance, bigDecimal);
        this.balance = bigDecimal;
    }

    public String _persistence_get_pin() {
        this._persistence_checkFetched("pin");
        return this.pin;
    }

    public void _persistence_set_pin(String string) {
        this._persistence_checkFetchedForSet("pin");
        this._persistence_propertyChange("pin", this.pin, string);
        this.pin = string;
    }

    public Date _persistence_get_pinBlockedUntil() {
        this._persistence_checkFetched("pinBlockedUntil");
        return this.pinBlockedUntil;
    }

    public void _persistence_set_pinBlockedUntil(Date date) {
        this._persistence_checkFetchedForSet("pinBlockedUntil");
        this._persistence_propertyChange("pinBlockedUntil", this.pinBlockedUntil, date);
        this.pinBlockedUntil = date;
    }

    public String _persistence_get_mobilePhone() {
        this._persistence_checkFetched("mobilePhone");
        return this.mobilePhone;
    }

    public void _persistence_set_mobilePhone(String string) {
        this._persistence_checkFetchedForSet("mobilePhone");
        this._persistence_propertyChange("mobilePhone", this.mobilePhone, string);
        this.mobilePhone = string;
    }

    protected void _persistence_initialize_activation_vh() {
        if (this._persistence_activation_vh == null) {
            this._persistence_activation_vh = new ValueHolder((Object)this.activation);
            this._persistence_activation_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_activation_vh() {
        VoucherTopUp voucherTopUp;
        this._persistence_initialize_activation_vh();
        if ((this._persistence_activation_vh.isCoordinatedWithProperty() || this._persistence_activation_vh.isNewlyWeavedValueHolder()) && (voucherTopUp = this._persistence_get_activation()) != this._persistence_activation_vh.getValue()) {
            this._persistence_set_activation(voucherTopUp);
        }
        return this._persistence_activation_vh;
    }

    public void _persistence_set_activation_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_activation_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            VoucherTopUp voucherTopUp = this._persistence_get_activation();
            if (voucherTopUp != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_activation((VoucherTopUp)object);
            }
        } else {
            this.activation = null;
        }
    }

    public VoucherTopUp _persistence_get_activation() {
        this._persistence_checkFetched("activation");
        this._persistence_initialize_activation_vh();
        this.activation = (VoucherTopUp)this._persistence_activation_vh.getValue();
        return this.activation;
    }

    public void _persistence_set_activation(VoucherTopUp voucherTopUp) {
        this._persistence_checkFetchedForSet("activation");
        this._persistence_initialize_activation_vh();
        this.activation = (VoucherTopUp)this._persistence_activation_vh.getValue();
        this._persistence_propertyChange("activation", this.activation, voucherTopUp);
        this.activation = voucherTopUp;
        this._persistence_activation_vh.setValue((Object)voucherTopUp);
    }

    public String _persistence_get_email() {
        this._persistence_checkFetched("email");
        return this.email;
    }

    public void _persistence_set_email(String string) {
        this._persistence_checkFetchedForSet("email");
        this._persistence_propertyChange("email", this.email, string);
        this.email = string;
    }

    public VoucherStatus _persistence_get_status() {
        this._persistence_checkFetched("status");
        return this.status;
    }

    public void _persistence_set_status(VoucherStatus voucherStatus) {
        this._persistence_checkFetchedForSet("status");
        this._persistence_propertyChange("status", this.status, voucherStatus);
        this.status = voucherStatus;
    }

    public Date _persistence_get_expirationDate() {
        this._persistence_checkFetched("expirationDate");
        return this.expirationDate;
    }

    public void _persistence_set_expirationDate(Date date) {
        this._persistence_checkFetchedForSet("expirationDate");
        this._persistence_propertyChange("expirationDate", this.expirationDate, date);
        this.expirationDate = date;
    }

    protected void _persistence_initialize_refund_vh() {
        if (this._persistence_refund_vh == null) {
            this._persistence_refund_vh = new ValueHolder((Object)this.refund);
            this._persistence_refund_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_refund_vh() {
        Payment payment;
        this._persistence_initialize_refund_vh();
        if ((this._persistence_refund_vh.isCoordinatedWithProperty() || this._persistence_refund_vh.isNewlyWeavedValueHolder()) && (payment = this._persistence_get_refund()) != this._persistence_refund_vh.getValue()) {
            this._persistence_set_refund(payment);
        }
        return this._persistence_refund_vh;
    }

    public void _persistence_set_refund_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_refund_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Payment payment = this._persistence_get_refund();
            if (payment != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_refund((Payment)object);
            }
        } else {
            this.refund = null;
        }
    }

    public Payment _persistence_get_refund() {
        this._persistence_checkFetched("refund");
        this._persistence_initialize_refund_vh();
        this.refund = (Payment)this._persistence_refund_vh.getValue();
        return this.refund;
    }

    public void _persistence_set_refund(Payment payment) {
        this._persistence_checkFetchedForSet("refund");
        this._persistence_initialize_refund_vh();
        this.refund = (Payment)this._persistence_refund_vh.getValue();
        this._persistence_propertyChange("refund", this.refund, payment);
        this.refund = payment;
        this._persistence_refund_vh.setValue((Object)payment);
    }

    public Set _persistence_get_customValues() {
        this._persistence_checkFetched("customValues");
        return this.customValues;
    }

    public void _persistence_set_customValues(Set set) {
        this._persistence_checkFetchedForSet("customValues");
        this._persistence_propertyChange("customValues", this.customValues, set);
        this.customValues = set;
    }
}

