/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.cyclos.entities.banking.AccountFee;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.GeneratedTransferType;
import org.cyclos.entities.users.OperatorGroupAccountType;
import org.cyclos.entities.users.UserManagementProduct;
import org.cyclos.entities.utils.IntegerRange;
import org.cyclos.model.banking.accounttypes.AccountTypeLimitType;
import org.cyclos.model.banking.accounttypes.AccountTypeNature;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@DiscriminatorValue(value="USER")
public class UserAccountType
extends AccountType
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="min", column=@Column(name="default_yellow_balance_range_min")), @AttributeOverride(name="max", column=@Column(name="default_yellow_balance_range_max"))})
    private IntegerRange defaultYellowBalanceRange;
    @OneToMany(mappedBy="accountType", cascade={CascadeType.REMOVE})
    private Set<AccountFee> accountFees = new HashSet<AccountFee>();
    @OneToMany(mappedBy="accountType", cascade={CascadeType.REMOVE})
    private Set<OperatorGroupAccountType> operatorGroups;
    @ManyToMany(mappedBy="userAccountsAccess")
    private Set<UserManagementProduct> userAccountsAccessOnProducts;
    @ManyToOne
    @JoinColumn(name="dispose_positive_type_id")
    private GeneratedTransferType disposePositiveType;
    @ManyToOne
    @JoinColumn(name="dispose_negative_type_id")
    private GeneratedTransferType disposeNegativeType;
    static final long serialVersionUID = 3884552546470787855L;

    public Set<AccountFee> getAccountFees() {
        return this._persistence_get_accountFees();
    }

    public IntegerRange getDefaultYellowBalanceRange() {
        return this._persistence_get_defaultYellowBalanceRange();
    }

    public GeneratedTransferType getDisposeNegativeType() {
        return this._persistence_get_disposeNegativeType();
    }

    public GeneratedTransferType getDisposePositiveType() {
        return this._persistence_get_disposePositiveType();
    }

    @Override
    public AccountTypeLimitType getLimitType() {
        return AccountTypeLimitType.LIMITED;
    }

    @Override
    public AccountTypeNature getNature() {
        return AccountTypeNature.USER;
    }

    public void setAccountFees(Set<AccountFee> set) {
        this._persistence_set_accountFees(set);
    }

    public void setDefaultYellowBalanceRange(IntegerRange integerRange) {
        this._persistence_set_defaultYellowBalanceRange(integerRange);
    }

    public void setDisposeNegativeType(GeneratedTransferType generatedTransferType) {
        this._persistence_set_disposeNegativeType(generatedTransferType);
    }

    public void setDisposePositiveType(GeneratedTransferType generatedTransferType) {
        this._persistence_set_disposePositiveType(generatedTransferType);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new UserAccountType();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "accountFees") {
            return this.accountFees;
        }
        if (string == "disposePositiveType") {
            return this.disposePositiveType;
        }
        if (string == "operatorGroups") {
            return this.operatorGroups;
        }
        if (string == "disposeNegativeType") {
            return this.disposeNegativeType;
        }
        if (string == "userAccountsAccessOnProducts") {
            return this.userAccountsAccessOnProducts;
        }
        if (string == "defaultYellowBalanceRange") {
            return this.defaultYellowBalanceRange;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "accountFees") {
            this.accountFees = (Set)object;
            return;
        }
        if (string == "disposePositiveType") {
            this.disposePositiveType = (GeneratedTransferType)object;
            return;
        }
        if (string == "operatorGroups") {
            this.operatorGroups = (Set)object;
            return;
        }
        if (string == "disposeNegativeType") {
            this.disposeNegativeType = (GeneratedTransferType)object;
            return;
        }
        if (string == "userAccountsAccessOnProducts") {
            this.userAccountsAccessOnProducts = (Set)object;
            return;
        }
        if (string == "defaultYellowBalanceRange") {
            this.defaultYellowBalanceRange = (IntegerRange)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Set _persistence_get_accountFees() {
        this._persistence_checkFetched("accountFees");
        return this.accountFees;
    }

    public void _persistence_set_accountFees(Set set) {
        this._persistence_checkFetchedForSet("accountFees");
        this._persistence_propertyChange("accountFees", this.accountFees, set);
        this.accountFees = set;
    }

    public GeneratedTransferType _persistence_get_disposePositiveType() {
        this._persistence_checkFetched("disposePositiveType");
        return this.disposePositiveType;
    }

    public void _persistence_set_disposePositiveType(GeneratedTransferType generatedTransferType) {
        this._persistence_checkFetchedForSet("disposePositiveType");
        this._persistence_propertyChange("disposePositiveType", this.disposePositiveType, generatedTransferType);
        this.disposePositiveType = generatedTransferType;
    }

    public Set _persistence_get_operatorGroups() {
        this._persistence_checkFetched("operatorGroups");
        return this.operatorGroups;
    }

    public void _persistence_set_operatorGroups(Set set) {
        this._persistence_checkFetchedForSet("operatorGroups");
        this._persistence_propertyChange("operatorGroups", this.operatorGroups, set);
        this.operatorGroups = set;
    }

    public GeneratedTransferType _persistence_get_disposeNegativeType() {
        this._persistence_checkFetched("disposeNegativeType");
        return this.disposeNegativeType;
    }

    public void _persistence_set_disposeNegativeType(GeneratedTransferType generatedTransferType) {
        this._persistence_checkFetchedForSet("disposeNegativeType");
        this._persistence_propertyChange("disposeNegativeType", this.disposeNegativeType, generatedTransferType);
        this.disposeNegativeType = generatedTransferType;
    }

    public Set _persistence_get_userAccountsAccessOnProducts() {
        this._persistence_checkFetched("userAccountsAccessOnProducts");
        return this.userAccountsAccessOnProducts;
    }

    public void _persistence_set_userAccountsAccessOnProducts(Set set) {
        this._persistence_checkFetchedForSet("userAccountsAccessOnProducts");
        this._persistence_propertyChange("userAccountsAccessOnProducts", this.userAccountsAccessOnProducts, set);
        this.userAccountsAccessOnProducts = set;
    }

    public IntegerRange _persistence_get_defaultYellowBalanceRange() {
        this._persistence_checkFetched("defaultYellowBalanceRange");
        return this.defaultYellowBalanceRange;
    }

    public void _persistence_set_defaultYellowBalanceRange(IntegerRange integerRange) {
        this._persistence_checkFetchedForSet("defaultYellowBalanceRange");
        this._persistence_propertyChange("defaultYellowBalanceRange", this.defaultYellowBalanceRange, integerRange);
        this.defaultYellowBalanceRange = integerRange;
    }
}

