/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.ConfigurationEntity;
import org.cyclos.entities.OwnerEntity;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.DRateCreationValueForTransferType;
import org.cyclos.entities.banking.HasCurrency;
import org.cyclos.entities.banking.SystemAccountType;
import org.cyclos.entities.banking.TransferFee;
import org.cyclos.entities.banking.TransferFilter;
import org.cyclos.entities.banking.TransferStatus;
import org.cyclos.entities.banking.TransferStatusFlow;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.model.Availability;
import org.cyclos.model.banking.transfertypes.TransferTypeDirection;
import org.cyclos.model.banking.transfertypes.TransferTypeNature;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.cyclos.model.utils.TimeField;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Cacheable(value=true)
@Table(name="transfer_types")
@DiscriminatorColumn(name="subclass")
public abstract class TransferType
extends ConfigurationEntity
implements HasCurrency,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="subclass", insertable=false, updatable=false)
    private TransferTypeNature nature;
    @OneToMany(mappedBy="originalTransferType", cascade={CascadeType.REMOVE})
    private Set<TransferFee> transferFees = new HashSet<TransferFee>();
    @ManyToMany(mappedBy="transferTypes")
    private Set<TransferFilter> transferFilters;
    @OwnerEntity
    @ManyToOne(fetch=FetchType.LAZY)
    @ReadOnlyFromDTO(onInsert=false)
    @JoinColumn(name="from_account_type_id", updatable=false, nullable=false)
    private AccountType from;
    @ManyToOne(fetch=FetchType.LAZY)
    @ReadOnlyFromDTO(onInsert=false)
    @JoinColumn(name="to_account_type_id", updatable=false, nullable=false)
    private AccountType to;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @ReadOnlyFromDTO(onInsert=false)
    @Column(name="direction", updatable=false, nullable=false)
    private TransferTypeDirection direction;
    @Basic
    @Column(name="display_template")
    private String displayTemplate;
    @Basic
    @Column(name="notify_payment_received")
    private Boolean notifyPaymentReceived;
    @Basic
    @Column(name="ignore_account_limits")
    private Boolean ignoreAccountLimits;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="description_availability", nullable=false)
    private Availability descriptionAvailability = Availability.OPTIONAL;
    @Basic
    @Column(name="lock_from")
    private Boolean lockFrom;
    @Basic
    @Column(name="lock_to")
    private Boolean lockTo;
    @ManyToMany
    @JoinTable(name="transfer_types_status_flows", joinColumns={@JoinColumn(name="transfer_type_id")}, inverseJoinColumns={@JoinColumn(name="transfer_status_flow_id")})
    private Set<TransferStatusFlow> statusFlows = new HashSet<TransferStatusFlow>();
    @ManyToMany
    @JoinTable(name="transfer_types_initial_statuses", joinColumns={@JoinColumn(name="transfer_type_id")}, inverseJoinColumns={@JoinColumn(name="transfer_status_id")})
    private Set<TransferStatus> initialStatuses = new HashSet<TransferStatus>();
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="d_rate_creation_value_id")
    @ReadOnlyFromDTO
    private DRateCreationValueForTransferType dRateCreationValue;
    @Basic
    @Lob
    @Column(name="value_for_empty_description")
    private String valueForEmptyDescription;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="amount", column=@Column(name="max_chargeback_time_amount")), @AttributeOverride(name="field", column=@Column(name="max_chargeback_time_field"))})
    private TimeInterval maxChargebackTime = new TimeInterval(30, TimeField.DAYS);
    static final long serialVersionUID = 4429963155283571197L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_dRateCreationValue_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_from_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_to_vh;

    @Override
    public Currency getCurrency() {
        return this._persistence_get_from() == null ? null : this._persistence_get_from().getCurrency();
    }

    @Override
    public DataTranslationType getDataTranslationType() {
        return DataTranslationType.TRANSFER_TYPES;
    }

    public Availability getDescriptionAvailability() {
        return this._persistence_get_descriptionAvailability();
    }

    public TransferTypeDirection getDirection() {
        return this._persistence_get_direction();
    }

    public String getDisplayTemplate() {
        return this._persistence_get_displayTemplate();
    }

    public DRateCreationValueForTransferType getdRateCreationValue() {
        return this._persistence_get_dRateCreationValue();
    }

    public AccountType getFrom() {
        return this._persistence_get_from();
    }

    public Set<TransferStatus> getInitialStatuses() {
        return this._persistence_get_initialStatuses();
    }

    public TimeInterval getMaxChargebackTime() {
        return this._persistence_get_maxChargebackTime();
    }

    public abstract TransferTypeNature getNature();

    @Override
    public Network getNetwork() {
        return this._persistence_get_from().getNetwork();
    }

    public Set<TransferStatusFlow> getStatusFlows() {
        return this._persistence_get_statusFlows();
    }

    public AccountType getTo() {
        return this._persistence_get_to();
    }

    public Set<TransferFee> getTransferFees() {
        return this._persistence_get_transferFees();
    }

    public String getValueForEmptyDescription() {
        return this._persistence_get_valueForEmptyDescription();
    }

    public abstract boolean isEnabled();

    public boolean isFromSystem() {
        return this._persistence_get_from() instanceof SystemAccountType;
    }

    public boolean isFromUser() {
        return !this.isFromSystem();
    }

    public boolean isIgnoreAccountLimits() {
        return Boolean.TRUE.equals(this._persistence_get_ignoreAccountLimits());
    }

    public boolean isLockFrom() {
        return Boolean.TRUE.equals(this._persistence_get_lockFrom());
    }

    public boolean isLockTo() {
        return Boolean.TRUE.equals(this._persistence_get_lockTo());
    }

    public boolean isNotifyPaymentReceived() {
        return Boolean.TRUE.equals(this._persistence_get_notifyPaymentReceived());
    }

    public boolean isToSystem() {
        return this._persistence_get_to() instanceof SystemAccountType;
    }

    public boolean isToUser() {
        return !this.isToSystem();
    }

    public void setDescriptionAvailability(Availability availability) {
        this._persistence_set_descriptionAvailability(availability);
    }

    public void setDirection(TransferTypeDirection transferTypeDirection) {
        this._persistence_set_direction(transferTypeDirection);
    }

    public void setDisplayTemplate(String string) {
        this._persistence_set_displayTemplate(string);
    }

    public void setdRateCreationValue(DRateCreationValueForTransferType dRateCreationValueForTransferType) {
        this._persistence_set_dRateCreationValue(dRateCreationValueForTransferType);
    }

    public void setFrom(AccountType accountType) {
        this._persistence_set_from(accountType);
    }

    public void setIgnoreAccountLimits(Boolean bl) {
        this._persistence_set_ignoreAccountLimits(bl);
    }

    public void setInitialStatuses(Set<TransferStatus> set) {
        this._persistence_set_initialStatuses(set);
    }

    public void setLockFrom(boolean bl) {
        this._persistence_set_lockFrom(bl);
    }

    public void setLockTo(boolean bl) {
        this._persistence_set_lockTo(bl);
    }

    public void setMaxChargebackTime(TimeInterval timeInterval) {
        this._persistence_set_maxChargebackTime(timeInterval);
    }

    public void setNotifyPaymentReceived(boolean bl) {
        this._persistence_set_notifyPaymentReceived(bl);
    }

    public void setStatusFlows(Set<TransferStatusFlow> set) {
        this._persistence_set_statusFlows(set);
    }

    public void setTo(AccountType accountType) {
        this._persistence_set_to(accountType);
    }

    public void setTransferFees(Set<TransferFee> set) {
        this._persistence_set_transferFees(set);
    }

    public void setValueForEmptyDescription(String string) {
        this._persistence_set_valueForEmptyDescription(string);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_dRateCreationValue_vh != null) {
            this._persistence_dRateCreationValue_vh = (WeavedAttributeValueHolderInterface)this._persistence_dRateCreationValue_vh.clone();
        }
        if (this._persistence_from_vh != null) {
            this._persistence_from_vh = (WeavedAttributeValueHolderInterface)this._persistence_from_vh.clone();
        }
        if (this._persistence_to_vh != null) {
            this._persistence_to_vh = (WeavedAttributeValueHolderInterface)this._persistence_to_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new TransferType();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "valueForEmptyDescription") {
            return this.valueForEmptyDescription;
        }
        if (string == "displayTemplate") {
            return this.displayTemplate;
        }
        if (string == "nature") {
            return this.nature;
        }
        if (string == "transferFilters") {
            return this.transferFilters;
        }
        if (string == "descriptionAvailability") {
            return this.descriptionAvailability;
        }
        if (string == "statusFlows") {
            return this.statusFlows;
        }
        if (string == "transferFees") {
            return this.transferFees;
        }
        if (string == "lockTo") {
            return this.lockTo;
        }
        if (string == "lockFrom") {
            return this.lockFrom;
        }
        if (string == "dRateCreationValue") {
            return this.dRateCreationValue;
        }
        if (string == "notifyPaymentReceived") {
            return this.notifyPaymentReceived;
        }
        if (string == "from") {
            return this.from;
        }
        if (string == "to") {
            return this.to;
        }
        if (string == "maxChargebackTime") {
            return this.maxChargebackTime;
        }
        if (string == "ignoreAccountLimits") {
            return this.ignoreAccountLimits;
        }
        if (string == "direction") {
            return this.direction;
        }
        if (string == "initialStatuses") {
            return this.initialStatuses;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "valueForEmptyDescription") {
            this.valueForEmptyDescription = (String)object;
            return;
        }
        if (string == "displayTemplate") {
            this.displayTemplate = (String)object;
            return;
        }
        if (string == "nature") {
            this.nature = (TransferTypeNature)object;
            return;
        }
        if (string == "transferFilters") {
            this.transferFilters = (Set)object;
            return;
        }
        if (string == "descriptionAvailability") {
            this.descriptionAvailability = (Availability)object;
            return;
        }
        if (string == "statusFlows") {
            this.statusFlows = (Set)object;
            return;
        }
        if (string == "transferFees") {
            this.transferFees = (Set)object;
            return;
        }
        if (string == "lockTo") {
            this.lockTo = (Boolean)object;
            return;
        }
        if (string == "lockFrom") {
            this.lockFrom = (Boolean)object;
            return;
        }
        if (string == "dRateCreationValue") {
            this.dRateCreationValue = (DRateCreationValueForTransferType)object;
            return;
        }
        if (string == "notifyPaymentReceived") {
            this.notifyPaymentReceived = (Boolean)object;
            return;
        }
        if (string == "from") {
            this.from = (AccountType)object;
            return;
        }
        if (string == "to") {
            this.to = (AccountType)object;
            return;
        }
        if (string == "maxChargebackTime") {
            this.maxChargebackTime = (TimeInterval)object;
            return;
        }
        if (string == "ignoreAccountLimits") {
            this.ignoreAccountLimits = (Boolean)object;
            return;
        }
        if (string == "direction") {
            this.direction = (TransferTypeDirection)object;
            return;
        }
        if (string == "initialStatuses") {
            this.initialStatuses = (Set)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_valueForEmptyDescription() {
        this._persistence_checkFetched("valueForEmptyDescription");
        return this.valueForEmptyDescription;
    }

    public void _persistence_set_valueForEmptyDescription(String string) {
        this._persistence_checkFetchedForSet("valueForEmptyDescription");
        this._persistence_propertyChange("valueForEmptyDescription", this.valueForEmptyDescription, string);
        this.valueForEmptyDescription = string;
    }

    public String _persistence_get_displayTemplate() {
        this._persistence_checkFetched("displayTemplate");
        return this.displayTemplate;
    }

    public void _persistence_set_displayTemplate(String string) {
        this._persistence_checkFetchedForSet("displayTemplate");
        this._persistence_propertyChange("displayTemplate", this.displayTemplate, string);
        this.displayTemplate = string;
    }

    public TransferTypeNature _persistence_get_nature() {
        this._persistence_checkFetched("nature");
        return this.nature;
    }

    public void _persistence_set_nature(TransferTypeNature transferTypeNature) {
        this._persistence_checkFetchedForSet("nature");
        this._persistence_propertyChange("nature", this.nature, transferTypeNature);
        this.nature = transferTypeNature;
    }

    public Set _persistence_get_transferFilters() {
        this._persistence_checkFetched("transferFilters");
        return this.transferFilters;
    }

    public void _persistence_set_transferFilters(Set set) {
        this._persistence_checkFetchedForSet("transferFilters");
        this._persistence_propertyChange("transferFilters", this.transferFilters, set);
        this.transferFilters = set;
    }

    public Availability _persistence_get_descriptionAvailability() {
        this._persistence_checkFetched("descriptionAvailability");
        return this.descriptionAvailability;
    }

    public void _persistence_set_descriptionAvailability(Availability availability) {
        this._persistence_checkFetchedForSet("descriptionAvailability");
        this._persistence_propertyChange("descriptionAvailability", this.descriptionAvailability, availability);
        this.descriptionAvailability = availability;
    }

    public Set _persistence_get_statusFlows() {
        this._persistence_checkFetched("statusFlows");
        return this.statusFlows;
    }

    public void _persistence_set_statusFlows(Set set) {
        this._persistence_checkFetchedForSet("statusFlows");
        this._persistence_propertyChange("statusFlows", this.statusFlows, set);
        this.statusFlows = set;
    }

    public Set _persistence_get_transferFees() {
        this._persistence_checkFetched("transferFees");
        return this.transferFees;
    }

    public void _persistence_set_transferFees(Set set) {
        this._persistence_checkFetchedForSet("transferFees");
        this._persistence_propertyChange("transferFees", this.transferFees, set);
        this.transferFees = set;
    }

    public Boolean _persistence_get_lockTo() {
        this._persistence_checkFetched("lockTo");
        return this.lockTo;
    }

    public void _persistence_set_lockTo(Boolean bl) {
        this._persistence_checkFetchedForSet("lockTo");
        this._persistence_propertyChange("lockTo", this.lockTo, bl);
        this.lockTo = bl;
    }

    public Boolean _persistence_get_lockFrom() {
        this._persistence_checkFetched("lockFrom");
        return this.lockFrom;
    }

    public void _persistence_set_lockFrom(Boolean bl) {
        this._persistence_checkFetchedForSet("lockFrom");
        this._persistence_propertyChange("lockFrom", this.lockFrom, bl);
        this.lockFrom = bl;
    }

    protected void _persistence_initialize_dRateCreationValue_vh() {
        if (this._persistence_dRateCreationValue_vh == null) {
            this._persistence_dRateCreationValue_vh = new ValueHolder((Object)this.dRateCreationValue);
            this._persistence_dRateCreationValue_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_dRateCreationValue_vh() {
        DRateCreationValueForTransferType dRateCreationValueForTransferType;
        this._persistence_initialize_dRateCreationValue_vh();
        if ((this._persistence_dRateCreationValue_vh.isCoordinatedWithProperty() || this._persistence_dRateCreationValue_vh.isNewlyWeavedValueHolder()) && (dRateCreationValueForTransferType = this._persistence_get_dRateCreationValue()) != this._persistence_dRateCreationValue_vh.getValue()) {
            this._persistence_set_dRateCreationValue(dRateCreationValueForTransferType);
        }
        return this._persistence_dRateCreationValue_vh;
    }

    public void _persistence_set_dRateCreationValue_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_dRateCreationValue_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            DRateCreationValueForTransferType dRateCreationValueForTransferType = this._persistence_get_dRateCreationValue();
            if (dRateCreationValueForTransferType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_dRateCreationValue((DRateCreationValueForTransferType)object);
            }
        } else {
            this.dRateCreationValue = null;
        }
    }

    public DRateCreationValueForTransferType _persistence_get_dRateCreationValue() {
        this._persistence_checkFetched("dRateCreationValue");
        this._persistence_initialize_dRateCreationValue_vh();
        this.dRateCreationValue = (DRateCreationValueForTransferType)this._persistence_dRateCreationValue_vh.getValue();
        return this.dRateCreationValue;
    }

    public void _persistence_set_dRateCreationValue(DRateCreationValueForTransferType dRateCreationValueForTransferType) {
        this._persistence_checkFetchedForSet("dRateCreationValue");
        this._persistence_initialize_dRateCreationValue_vh();
        this.dRateCreationValue = (DRateCreationValueForTransferType)this._persistence_dRateCreationValue_vh.getValue();
        this._persistence_propertyChange("dRateCreationValue", this.dRateCreationValue, dRateCreationValueForTransferType);
        this.dRateCreationValue = dRateCreationValueForTransferType;
        this._persistence_dRateCreationValue_vh.setValue((Object)dRateCreationValueForTransferType);
    }

    public Boolean _persistence_get_notifyPaymentReceived() {
        this._persistence_checkFetched("notifyPaymentReceived");
        return this.notifyPaymentReceived;
    }

    public void _persistence_set_notifyPaymentReceived(Boolean bl) {
        this._persistence_checkFetchedForSet("notifyPaymentReceived");
        this._persistence_propertyChange("notifyPaymentReceived", this.notifyPaymentReceived, bl);
        this.notifyPaymentReceived = bl;
    }

    protected void _persistence_initialize_from_vh() {
        if (this._persistence_from_vh == null) {
            this._persistence_from_vh = new ValueHolder((Object)this.from);
            this._persistence_from_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_from_vh() {
        AccountType accountType;
        this._persistence_initialize_from_vh();
        if ((this._persistence_from_vh.isCoordinatedWithProperty() || this._persistence_from_vh.isNewlyWeavedValueHolder()) && (accountType = this._persistence_get_from()) != this._persistence_from_vh.getValue()) {
            this._persistence_set_from(accountType);
        }
        return this._persistence_from_vh;
    }

    public void _persistence_set_from_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_from_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            AccountType accountType = this._persistence_get_from();
            if (accountType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_from((AccountType)object);
            }
        } else {
            this.from = null;
        }
    }

    public AccountType _persistence_get_from() {
        this._persistence_checkFetched("from");
        this._persistence_initialize_from_vh();
        this.from = (AccountType)this._persistence_from_vh.getValue();
        return this.from;
    }

    public void _persistence_set_from(AccountType accountType) {
        this._persistence_checkFetchedForSet("from");
        this._persistence_initialize_from_vh();
        this.from = (AccountType)this._persistence_from_vh.getValue();
        this._persistence_propertyChange("from", this.from, accountType);
        this.from = accountType;
        this._persistence_from_vh.setValue((Object)accountType);
    }

    protected void _persistence_initialize_to_vh() {
        if (this._persistence_to_vh == null) {
            this._persistence_to_vh = new ValueHolder((Object)this.to);
            this._persistence_to_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_to_vh() {
        AccountType accountType;
        this._persistence_initialize_to_vh();
        if ((this._persistence_to_vh.isCoordinatedWithProperty() || this._persistence_to_vh.isNewlyWeavedValueHolder()) && (accountType = this._persistence_get_to()) != this._persistence_to_vh.getValue()) {
            this._persistence_set_to(accountType);
        }
        return this._persistence_to_vh;
    }

    public void _persistence_set_to_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_to_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            AccountType accountType = this._persistence_get_to();
            if (accountType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_to((AccountType)object);
            }
        } else {
            this.to = null;
        }
    }

    public AccountType _persistence_get_to() {
        this._persistence_checkFetched("to");
        this._persistence_initialize_to_vh();
        this.to = (AccountType)this._persistence_to_vh.getValue();
        return this.to;
    }

    public void _persistence_set_to(AccountType accountType) {
        this._persistence_checkFetchedForSet("to");
        this._persistence_initialize_to_vh();
        this.to = (AccountType)this._persistence_to_vh.getValue();
        this._persistence_propertyChange("to", this.to, accountType);
        this.to = accountType;
        this._persistence_to_vh.setValue((Object)accountType);
    }

    public TimeInterval _persistence_get_maxChargebackTime() {
        this._persistence_checkFetched("maxChargebackTime");
        return this.maxChargebackTime;
    }

    public void _persistence_set_maxChargebackTime(TimeInterval timeInterval) {
        this._persistence_checkFetchedForSet("maxChargebackTime");
        this._persistence_propertyChange("maxChargebackTime", this.maxChargebackTime, timeInterval);
        this.maxChargebackTime = timeInterval;
    }

    public Boolean _persistence_get_ignoreAccountLimits() {
        this._persistence_checkFetched("ignoreAccountLimits");
        return this.ignoreAccountLimits;
    }

    public void _persistence_set_ignoreAccountLimits(Boolean bl) {
        this._persistence_checkFetchedForSet("ignoreAccountLimits");
        this._persistence_propertyChange("ignoreAccountLimits", this.ignoreAccountLimits, bl);
        this.ignoreAccountLimits = bl;
    }

    public TransferTypeDirection _persistence_get_direction() {
        this._persistence_checkFetched("direction");
        return this.direction;
    }

    public void _persistence_set_direction(TransferTypeDirection transferTypeDirection) {
        this._persistence_checkFetchedForSet("direction");
        this._persistence_propertyChange("direction", this.direction, transferTypeDirection);
        this.direction = transferTypeDirection;
    }

    public Set _persistence_get_initialStatuses() {
        this._persistence_checkFetched("initialStatuses");
        return this.initialStatuses;
    }

    public void _persistence_set_initialStatuses(Set set) {
        this._persistence_checkFetchedForSet("initialStatuses");
        this._persistence_propertyChange("initialStatuses", this.initialStatuses, set);
        this.initialStatuses = set;
    }
}

