/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.util.List;
import org.cyclos.entities.banking.Installment;
import org.cyclos.entities.banking.Trans;
import org.cyclos.model.banking.transactions.InstallmentStatus;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;

public interface TransactionWithInstallments<I extends Installment>
extends Trans {
    public static boolean isProcessed(Installment installment) {
        return ObjectHelper.isOneOf((Object)installment.getStatus(), (Object[])new Object[]{InstallmentStatus.PROCESSED, InstallmentStatus.SETTLED, InstallmentStatus.FAILED});
    }

    default public I getFirstScheduledInstallment() {
        return (I)((Installment)CollectionHelper.orEmpty(this.getInstallments()).stream().filter(installment -> !installment.getStatus().isTerminal()).findFirst().orElse(null));
    }

    public List<I> getInstallments();

    default public Integer getInstallmentsCount() {
        return CollectionHelper.size(this.getInstallments());
    }

    default public I getLastProcessedInstallment() {
        Installment installment = null;
        for (Installment installment2 : this.getInstallments()) {
            if (!ObjectHelper.isOneOf((Object)installment2.getStatus(), (Object[])new Object[]{InstallmentStatus.PROCESSED, InstallmentStatus.SETTLED, InstallmentStatus.FAILED})) continue;
            installment = installment2;
        }
        return (I)installment;
    }

    default public int getProcessedInstallments() {
        return (int)this.getInstallments().stream().filter(TransactionWithInstallments::isProcessed).count();
    }

    default public String getScheduling() {
        return this.getScheduling(this.getProcessedInstallments());
    }

    default public String getScheduling(int n) {
        Integer n2 = this.getInstallmentsCount();
        return n2 == null ? String.valueOf(n) : n + " / " + n2;
    }
}

