/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.math.BigDecimal;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.SystemAccount;
import org.cyclos.entities.users.AdminProduct;
import org.cyclos.model.banking.accounttypes.AccountTypeLimitType;
import org.cyclos.model.banking.accounttypes.AccountTypeNature;
import org.cyclos.utils.CollectionHelper;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@DiscriminatorValue(value="SYSTEM")
public class SystemAccountType
extends AccountType
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @Basic
    @Column(name="system_limit_type")
    @Enumerated(value=EnumType.STRING)
    private AccountTypeLimitType limitType = AccountTypeLimitType.LIMITED;
    @Transient
    private BigDecimal creditLimit;
    @Transient
    private BigDecimal upperCreditLimit;
    @ManyToMany(mappedBy="systemAccounts")
    private Set<AdminProduct> visibleSystemAccountsOnProducts;
    @OneToMany(mappedBy="type", cascade={CascadeType.REMOVE})
    protected Set<SystemAccount> accounts;
    static final long serialVersionUID = -5289135515441123450L;

    public SystemAccount getAccount() {
        return (SystemAccount)CollectionHelper.first((Iterable)this._persistence_get_accounts());
    }

    public BigDecimal getCreditLimit() {
        return this.creditLimit;
    }

    @Override
    public AccountTypeLimitType getLimitType() {
        return this._persistence_get_limitType();
    }

    @Override
    public AccountTypeNature getNature() {
        return AccountTypeNature.SYSTEM;
    }

    public BigDecimal getUpperCreditLimit() {
        return this.upperCreditLimit;
    }

    public void setAccount(SystemAccount systemAccount) {
        this._persistence_set_accounts(CollectionHelper.asSet((Object[])new SystemAccount[]{systemAccount}));
    }

    public void setCreditLimit(BigDecimal bigDecimal) {
        this.creditLimit = bigDecimal;
    }

    public void setLimitType(AccountTypeLimitType accountTypeLimitType) {
        this._persistence_set_limitType(accountTypeLimitType);
    }

    public void setUpperCreditLimit(BigDecimal bigDecimal) {
        this.upperCreditLimit = bigDecimal;
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new SystemAccountType();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "visibleSystemAccountsOnProducts") {
            return this.visibleSystemAccountsOnProducts;
        }
        if (string == "accounts") {
            return this.accounts;
        }
        if (string == "limitType") {
            return this.limitType;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "visibleSystemAccountsOnProducts") {
            this.visibleSystemAccountsOnProducts = (Set)object;
            return;
        }
        if (string == "accounts") {
            this.accounts = (Set)object;
            return;
        }
        if (string == "limitType") {
            this.limitType = (AccountTypeLimitType)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Set _persistence_get_visibleSystemAccountsOnProducts() {
        this._persistence_checkFetched("visibleSystemAccountsOnProducts");
        return this.visibleSystemAccountsOnProducts;
    }

    public void _persistence_set_visibleSystemAccountsOnProducts(Set set) {
        this._persistence_checkFetchedForSet("visibleSystemAccountsOnProducts");
        this._persistence_propertyChange("visibleSystemAccountsOnProducts", this.visibleSystemAccountsOnProducts, set);
        this.visibleSystemAccountsOnProducts = set;
    }

    public Set _persistence_get_accounts() {
        this._persistence_checkFetched("accounts");
        return this.accounts;
    }

    public void _persistence_set_accounts(Set set) {
        this._persistence_checkFetchedForSet("accounts");
        this._persistence_propertyChange("accounts", this.accounts, set);
        this.accounts = set;
    }

    public AccountTypeLimitType _persistence_get_limitType() {
        this._persistence_checkFetched("limitType");
        return this.limitType;
    }

    public void _persistence_set_limitType(AccountTypeLimitType accountTypeLimitType) {
        this._persistence_checkFetchedForSet("limitType");
        this._persistence_propertyChange("limitType", this.limitType, accountTypeLimitType);
        this.limitType = accountTypeLimitType;
    }
}

