/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.SystemAccountType;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.banking.accounttypes.AccountTypeNature;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@DiscriminatorValue(value="SYSTEM")
public class SystemAccount
extends Account
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    static final long serialVersionUID = 8155778559820645982L;

    @Override
    public AccountTypeNature getNature() {
        return AccountTypeNature.SYSTEM;
    }

    public SystemAccountOwner getOwner() {
        return SystemAccountOwner.instance();
    }

    public SystemAccountType getSystemAccountType() {
        return (SystemAccountType)this.getType();
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void setType(AccountType accountType) {
        if (accountType != null && !(accountType instanceof SystemAccountType)) {
            throw new IllegalArgumentException("A SystemAccount may only have a SystemAccountType");
        }
        super.setType(accountType);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new SystemAccount();
    }

    @Override
    public Object _persistence_get(String string) {
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        super._persistence_set(string, object);
    }
}

