/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.math.BigDecimal;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.CurrencyScale;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.IUserAccount;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.User;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="pending_user_accounts", indexes={@Index(name="ix_pending_user_accounts_number", columnList="lower(number)"), @Index(name="ix_pending_user_accounts_type", unique=true, columnList="user_id, account_type_id")})
public class PendingUserAccount
extends NetworkedEntity
implements IUserAccount,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id")
    private User user;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="account_type_id")
    private UserAccountType type;
    @Basic
    @Column(name="number")
    private String number;
    @Basic
    @Column(name="credit_limit")
    @CurrencyScale
    private BigDecimal creditLimit;
    @Basic
    @Column(name="upper_credit_limit")
    @CurrencyScale
    private BigDecimal upperCreditLimit;
    @Basic
    @Column(name="upper_credit_limit_from_product")
    private Boolean upperCreditLimitFromProduct = true;
    @Basic
    @Column(name="active")
    private Boolean active;
    static final long serialVersionUID = -2957875794836094261L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_type_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_user_vh;

    public PendingUserAccount() {
    }

    public PendingUserAccount(Long l, User user, UserAccountType userAccountType, String string, boolean bl, BigDecimal bigDecimal, BigDecimal bigDecimal2, boolean bl2) {
        this.setId(l);
        this.setUser(user);
        this.setType(userAccountType);
        this.setNumber(string);
        this.setActive(bl);
        this.setCreditLimit(bigDecimal);
        this.setUpperCreditLimit(bigDecimal2);
        this.setUpperCreditLimitFromProduct(bl2);
    }

    public PendingUserAccount(User user, UserAccountType userAccountType) {
        this.setUser(user);
        this.setType(userAccountType);
    }

    public PendingUserAccount(User user, UserAccountType userAccountType, String string) {
        this(user, userAccountType);
        this.setNumber(string);
    }

    @Override
    public Long getAccountRatesId() {
        return null;
    }

    @Override
    public BigDecimal getCreditLimit() {
        return this._persistence_get_creditLimit();
    }

    @Override
    public Currency getCurrency() {
        return this._persistence_get_type().getCurrency();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_user().getNetwork();
    }

    @Override
    public String getNumber() {
        return this._persistence_get_number();
    }

    @Override
    public BigDecimal getPaymentAmountLimit() {
        return null;
    }

    @Override
    public BigDecimal getPaymentAmountPerDayLimit() {
        return null;
    }

    @Override
    public BigDecimal getPaymentAmountPerMonthLimit() {
        return null;
    }

    @Override
    public BigDecimal getPaymentAmountPerWeekLimit() {
        return null;
    }

    @Override
    public BigDecimal getPaymentAmountPerYearLimit() {
        return null;
    }

    @Override
    public UserAccountType getType() {
        return this._persistence_get_type();
    }

    @Override
    public BigDecimal getUpperCreditLimit() {
        return this._persistence_get_upperCreditLimit();
    }

    @Override
    public User getUser() {
        return this._persistence_get_user();
    }

    @Override
    public boolean isActive() {
        return this._persistence_get_active() == null || this._persistence_get_active() != false;
    }

    @Override
    public boolean isUpperCreditLimitFromProduct() {
        return Boolean.TRUE.equals(this._persistence_get_upperCreditLimitFromProduct());
    }

    @Override
    public void setAccountRatesId(Long l) {
    }

    @Override
    public void setActive(boolean bl) {
        this._persistence_set_active(bl);
    }

    @Override
    public void setCreditLimit(BigDecimal bigDecimal) {
        this._persistence_set_creditLimit(bigDecimal);
    }

    @Override
    public void setNumber(String string) {
        this._persistence_set_number(string);
    }

    public void setType(UserAccountType userAccountType) {
        this._persistence_set_type(userAccountType);
    }

    @Override
    public void setUpperCreditLimit(BigDecimal bigDecimal) {
        this._persistence_set_upperCreditLimit(bigDecimal);
    }

    public void setUpperCreditLimitFromProduct(boolean bl) {
        this._persistence_set_upperCreditLimitFromProduct(bl);
    }

    public void setUser(User user) {
        this._persistence_set_user(user);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_type_vh != null) {
            this._persistence_type_vh = (WeavedAttributeValueHolderInterface)this._persistence_type_vh.clone();
        }
        if (this._persistence_user_vh != null) {
            this._persistence_user_vh = (WeavedAttributeValueHolderInterface)this._persistence_user_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new PendingUserAccount();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "number") {
            return this.number;
        }
        if (string == "upperCreditLimit") {
            return this.upperCreditLimit;
        }
        if (string == "upperCreditLimitFromProduct") {
            return this.upperCreditLimitFromProduct;
        }
        if (string == "creditLimit") {
            return this.creditLimit;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "type") {
            return this.type;
        }
        if (string == "user") {
            return this.user;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "number") {
            this.number = (String)object;
            return;
        }
        if (string == "upperCreditLimit") {
            this.upperCreditLimit = (BigDecimal)object;
            return;
        }
        if (string == "upperCreditLimitFromProduct") {
            this.upperCreditLimitFromProduct = (Boolean)object;
            return;
        }
        if (string == "creditLimit") {
            this.creditLimit = (BigDecimal)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "type") {
            this.type = (UserAccountType)object;
            return;
        }
        if (string == "user") {
            this.user = (User)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_number() {
        this._persistence_checkFetched("number");
        return this.number;
    }

    public void _persistence_set_number(String string) {
        this._persistence_checkFetchedForSet("number");
        this._persistence_propertyChange("number", this.number, string);
        this.number = string;
    }

    public BigDecimal _persistence_get_upperCreditLimit() {
        this._persistence_checkFetched("upperCreditLimit");
        return this.upperCreditLimit;
    }

    public void _persistence_set_upperCreditLimit(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("upperCreditLimit");
        this._persistence_propertyChange("upperCreditLimit", this.upperCreditLimit, bigDecimal);
        this.upperCreditLimit = bigDecimal;
    }

    public Boolean _persistence_get_upperCreditLimitFromProduct() {
        this._persistence_checkFetched("upperCreditLimitFromProduct");
        return this.upperCreditLimitFromProduct;
    }

    public void _persistence_set_upperCreditLimitFromProduct(Boolean bl) {
        this._persistence_checkFetchedForSet("upperCreditLimitFromProduct");
        this._persistence_propertyChange("upperCreditLimitFromProduct", this.upperCreditLimitFromProduct, bl);
        this.upperCreditLimitFromProduct = bl;
    }

    public BigDecimal _persistence_get_creditLimit() {
        this._persistence_checkFetched("creditLimit");
        return this.creditLimit;
    }

    public void _persistence_set_creditLimit(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("creditLimit");
        this._persistence_propertyChange("creditLimit", this.creditLimit, bigDecimal);
        this.creditLimit = bigDecimal;
    }

    public Boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(Boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this._persistence_propertyChange("active", this.active, bl);
        this.active = bl;
    }

    protected void _persistence_initialize_type_vh() {
        if (this._persistence_type_vh == null) {
            this._persistence_type_vh = new ValueHolder((Object)this.type);
            this._persistence_type_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_type_vh() {
        UserAccountType userAccountType;
        this._persistence_initialize_type_vh();
        if ((this._persistence_type_vh.isCoordinatedWithProperty() || this._persistence_type_vh.isNewlyWeavedValueHolder()) && (userAccountType = this._persistence_get_type()) != this._persistence_type_vh.getValue()) {
            this._persistence_set_type(userAccountType);
        }
        return this._persistence_type_vh;
    }

    public void _persistence_set_type_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_type_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            UserAccountType userAccountType = this._persistence_get_type();
            if (userAccountType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_type((UserAccountType)object);
            }
        } else {
            this.type = null;
        }
    }

    public UserAccountType _persistence_get_type() {
        this._persistence_checkFetched("type");
        this._persistence_initialize_type_vh();
        this.type = (UserAccountType)this._persistence_type_vh.getValue();
        return this.type;
    }

    public void _persistence_set_type(UserAccountType userAccountType) {
        this._persistence_checkFetchedForSet("type");
        this._persistence_initialize_type_vh();
        this.type = (UserAccountType)this._persistence_type_vh.getValue();
        this._persistence_propertyChange("type", this.type, userAccountType);
        this.type = userAccountType;
        this._persistence_type_vh.setValue((Object)userAccountType);
    }

    protected void _persistence_initialize_user_vh() {
        if (this._persistence_user_vh == null) {
            this._persistence_user_vh = new ValueHolder((Object)this.user);
            this._persistence_user_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_user_vh() {
        User user;
        this._persistence_initialize_user_vh();
        if ((this._persistence_user_vh.isCoordinatedWithProperty() || this._persistence_user_vh.isNewlyWeavedValueHolder()) && (user = this._persistence_get_user()) != this._persistence_user_vh.getValue()) {
            this._persistence_set_user(user);
        }
        return this._persistence_user_vh;
    }

    public void _persistence_set_user_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_user_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            User user = this._persistence_get_user();
            if (user != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_user((User)object);
            }
        } else {
            this.user = null;
        }
    }

    public User _persistence_get_user() {
        this._persistence_checkFetched("user");
        this._persistence_initialize_user_vh();
        this.user = (User)this._persistence_user_vh.getValue();
        return this.user;
    }

    public void _persistence_set_user(User user) {
        this._persistence_checkFetchedForSet("user");
        this._persistence_initialize_user_vh();
        this.user = (User)this._persistence_user_vh.getValue();
        this._persistence_propertyChange("user", this.user, user);
        this.user = user;
        this._persistence_user_vh.setValue((Object)user);
    }
}

