/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.banking.ExternalPaymentAmountReservation;
import org.cyclos.entities.banking.HasExpirationDate;
import org.cyclos.entities.banking.Payment;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.ExternalAccountOwner;
import org.cyclos.model.banking.transactions.ExternalPaymentStatus;
import org.cyclos.model.banking.transactions.HasTransactionStatus;
import org.cyclos.model.banking.transactions.TransactionNature;
import org.cyclos.model.utils.Location;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@DiscriminatorValue(value="EXTERNAL_PAYMENT")
public class ExternalPayment
extends Transaction
implements HasTransactionStatus<ExternalPaymentStatus>,
HasExpirationDate,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @Basic
    @Column(name="external_principal_value")
    private String toPrincipalValue;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="external_principal_type_id")
    private PrincipalType toPrincipalType;
    @OneToMany(mappedBy="transaction")
    private Set<ExternalPaymentAmountReservation> amountReservations;
    @Basic
    @Lob
    @Column(name="comments")
    private String comments;
    @Basic
    @Column(name="token", length=32, unique=true)
    private String token;
    static final long serialVersionUID = -1131571489741901377L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_toPrincipalType_vh;

    public ExternalPaymentAmountReservation getAmountDereservation() {
        return CollectionHelper.orEmpty((Set)this._persistence_get_amountReservations()).stream().filter(externalPaymentAmountReservation -> BigDecimalHelper.isNegative((BigDecimal)externalPaymentAmountReservation.getAmount())).findFirst().orElse(null);
    }

    public ExternalPaymentAmountReservation getAmountReservation() {
        return CollectionHelper.orEmpty((Set)this._persistence_get_amountReservations()).stream().filter(externalPaymentAmountReservation -> BigDecimalHelper.isPositive((BigDecimal)externalPaymentAmountReservation.getAmount())).findFirst().orElse(null);
    }

    public Set<ExternalPaymentAmountReservation> getAmountReservations() {
        return this._persistence_get_amountReservations();
    }

    public String getComments() {
        return this._persistence_get_comments();
    }

    @Override
    public Date getExpirationDate() {
        return this._persistence_get_expirationDate();
    }

    @Override
    public Location getLocation() {
        return Location.EXTERNAL_PAYMENT;
    }

    @Override
    public TransactionNature getNature() {
        return TransactionNature.EXTERNAL_PAYMENT;
    }

    public Payment getPayment() {
        return (Payment)this._persistence_get_transaction();
    }

    @Override
    public Date getProcessDate() {
        return this._persistence_get_transaction() == null ? null : this._persistence_get_transaction().getDate();
    }

    public ExternalPaymentStatus getStatus() {
        return ExternalPaymentStatus.valueOf((String)this._persistence_get_status());
    }

    public String getToken() {
        return this._persistence_get_token();
    }

    @Override
    public AccountOwner getToOwner() {
        return ExternalAccountOwner.instance();
    }

    public PrincipalType getToPrincipalType() {
        return this._persistence_get_toPrincipalType();
    }

    public String getToPrincipalValue() {
        return this._persistence_get_toPrincipalValue();
    }

    public void setComments(String string) {
        this._persistence_set_comments(string);
    }

    @Override
    public void setExpirationDate(Date date) {
        this._persistence_set_expirationDate(date);
    }

    public void setPayment(Payment payment) {
        this._persistence_set_transaction(payment);
    }

    public void setStatus(ExternalPaymentStatus externalPaymentStatus) {
        this._persistence_set_status(externalPaymentStatus.name());
    }

    public void setToken(String string) {
        this._persistence_set_token(string);
    }

    public void setToPrincipalType(PrincipalType principalType) {
        this._persistence_set_toPrincipalType(principalType);
    }

    public void setToPrincipalValue(String string) {
        this._persistence_set_toPrincipalValue(string);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_toPrincipalType_vh != null) {
            this._persistence_toPrincipalType_vh = (WeavedAttributeValueHolderInterface)this._persistence_toPrincipalType_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ExternalPayment();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "toPrincipalType") {
            return this.toPrincipalType;
        }
        if (string == "comments") {
            return this.comments;
        }
        if (string == "amountReservations") {
            return this.amountReservations;
        }
        if (string == "toPrincipalValue") {
            return this.toPrincipalValue;
        }
        if (string == "token") {
            return this.token;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "toPrincipalType") {
            this.toPrincipalType = (PrincipalType)object;
            return;
        }
        if (string == "comments") {
            this.comments = (String)object;
            return;
        }
        if (string == "amountReservations") {
            this.amountReservations = (Set)object;
            return;
        }
        if (string == "toPrincipalValue") {
            this.toPrincipalValue = (String)object;
            return;
        }
        if (string == "token") {
            this.token = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    protected void _persistence_initialize_toPrincipalType_vh() {
        if (this._persistence_toPrincipalType_vh == null) {
            this._persistence_toPrincipalType_vh = new ValueHolder((Object)this.toPrincipalType);
            this._persistence_toPrincipalType_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_toPrincipalType_vh() {
        PrincipalType principalType;
        this._persistence_initialize_toPrincipalType_vh();
        if ((this._persistence_toPrincipalType_vh.isCoordinatedWithProperty() || this._persistence_toPrincipalType_vh.isNewlyWeavedValueHolder()) && (principalType = this._persistence_get_toPrincipalType()) != this._persistence_toPrincipalType_vh.getValue()) {
            this._persistence_set_toPrincipalType(principalType);
        }
        return this._persistence_toPrincipalType_vh;
    }

    public void _persistence_set_toPrincipalType_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_toPrincipalType_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            PrincipalType principalType = this._persistence_get_toPrincipalType();
            if (principalType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_toPrincipalType((PrincipalType)object);
            }
        } else {
            this.toPrincipalType = null;
        }
    }

    public PrincipalType _persistence_get_toPrincipalType() {
        this._persistence_checkFetched("toPrincipalType");
        this._persistence_initialize_toPrincipalType_vh();
        this.toPrincipalType = (PrincipalType)this._persistence_toPrincipalType_vh.getValue();
        return this.toPrincipalType;
    }

    public void _persistence_set_toPrincipalType(PrincipalType principalType) {
        this._persistence_checkFetchedForSet("toPrincipalType");
        this._persistence_initialize_toPrincipalType_vh();
        this.toPrincipalType = (PrincipalType)this._persistence_toPrincipalType_vh.getValue();
        this._persistence_propertyChange("toPrincipalType", this.toPrincipalType, principalType);
        this.toPrincipalType = principalType;
        this._persistence_toPrincipalType_vh.setValue((Object)principalType);
    }

    public String _persistence_get_comments() {
        this._persistence_checkFetched("comments");
        return this.comments;
    }

    public void _persistence_set_comments(String string) {
        this._persistence_checkFetchedForSet("comments");
        this._persistence_propertyChange("comments", this.comments, string);
        this.comments = string;
    }

    public Set _persistence_get_amountReservations() {
        this._persistence_checkFetched("amountReservations");
        return this.amountReservations;
    }

    public void _persistence_set_amountReservations(Set set) {
        this._persistence_checkFetchedForSet("amountReservations");
        this._persistence_propertyChange("amountReservations", this.amountReservations, set);
        this.amountReservations = set;
    }

    public String _persistence_get_toPrincipalValue() {
        this._persistence_checkFetched("toPrincipalValue");
        return this.toPrincipalValue;
    }

    public void _persistence_set_toPrincipalValue(String string) {
        this._persistence_checkFetchedForSet("toPrincipalValue");
        this._persistence_propertyChange("toPrincipalValue", this.toPrincipalValue, string);
        this.toPrincipalValue = string;
    }

    public String _persistence_get_token() {
        this._persistence_checkFetched("token");
        return this.token;
    }

    public void _persistence_set_token(String string) {
        this._persistence_checkFetchedForSet("token");
        this._persistence_propertyChange("token", this.token, string);
        this.token = string;
    }
}

