/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.ConfigurationEntity;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.banking.ARateParameters;
import org.cyclos.entities.banking.DRateParameters;
import org.cyclos.entities.system.DefinesNetwork;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.utils.NumberGeneration;
import org.cyclos.model.banking.currencies.ICurrency;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.cyclos.utils.StringHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Cacheable(value=true)
@Table(name="currencies")
public class Currency
extends ConfigurationEntity
implements ICurrency,
DefinesNetwork,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="network_id", nullable=true)
    private Network network;
    @Basic
    @Column(name="symbol")
    private String symbol;
    @Basic
    @Column(name="prefix")
    private String prefix;
    @Basic
    @Column(name="suffix")
    private String suffix;
    @Basic
    @Column(name="precision_value", nullable=false)
    private int precision = 2;
    @Basic
    @Column(name="display_template")
    private String displayTemplate;
    @Embedded
    private NumberGeneration transactionNumber;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="a_rate_parameters_id")
    @ReadOnlyFromDTO
    private ARateParameters aRateParameters;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="d_rate_parameters_id")
    @ReadOnlyFromDTO
    private DRateParameters dRateParameters;
    static final long serialVersionUID = -4941421527061268261L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_dRateParameters_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_network_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_aRateParameters_vh;

    public ARateParameters getaRateParameters() {
        return this._persistence_get_aRateParameters();
    }

    @Override
    public DataTranslationType getDataTranslationType() {
        return DataTranslationType.CURRENCIES;
    }

    public String getDisplayTemplate() {
        return this._persistence_get_displayTemplate();
    }

    public DRateParameters getdRateParameters() {
        return this._persistence_get_dRateParameters();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_network();
    }

    public int getPrecision() {
        return this._persistence_get_precision();
    }

    public String getPrefix() {
        return this._persistence_get_prefix();
    }

    public String getSuffix() {
        return this._persistence_get_suffix();
    }

    public String getSymbol() {
        return this._persistence_get_symbol();
    }

    public NumberGeneration getTransactionNumber() {
        return this._persistence_get_transactionNumber();
    }

    public String getTransactionNumberPattern() {
        if (this._persistence_get_transactionNumber() == null) {
            return null;
        }
        return StringHelper.getNumberGenerationPattern((String)this._persistence_get_transactionNumber().getPrefix(), (Integer)this._persistence_get_transactionNumber().getPadLength(), (String)this._persistence_get_transactionNumber().getSuffix());
    }

    public String getTransactionNumberPrefix() {
        return this._persistence_get_transactionNumber() != null ? this._persistence_get_transactionNumber().getPrefix() : null;
    }

    public String getTransactionNumberSuffix() {
        return this._persistence_get_transactionNumber() != null ? this._persistence_get_transactionNumber().getSuffix() : null;
    }

    public boolean isTransactionNumberEnabled() {
        return this._persistence_get_transactionNumber() != null && (this._persistence_get_transactionNumber().getPadLength() != null && this._persistence_get_transactionNumber().getPadLength() > 0 || this._persistence_get_transactionNumber().getPrefix() != null || this._persistence_get_transactionNumber().getSuffix() != null);
    }

    public void setaRateParameters(ARateParameters aRateParameters) throws IllegalArgumentException {
        this._persistence_set_aRateParameters(aRateParameters);
    }

    public void setDisplayTemplate(String string) {
        this._persistence_set_displayTemplate(string);
    }

    public void setdRateParameters(DRateParameters dRateParameters) {
        this._persistence_set_dRateParameters(dRateParameters);
    }

    @Override
    public void setNetwork(Network network) {
        this._persistence_set_network(network);
    }

    public void setPrecision(int n) {
        this._persistence_set_precision(n);
    }

    public void setPrefix(String string) {
        this._persistence_set_prefix(string);
    }

    public void setSuffix(String string) {
        this._persistence_set_suffix(string);
    }

    public void setSymbol(String string) {
        this._persistence_set_symbol(string);
    }

    public void setTransactionNumber(NumberGeneration numberGeneration) {
        this._persistence_set_transactionNumber(numberGeneration);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_dRateParameters_vh != null) {
            this._persistence_dRateParameters_vh = (WeavedAttributeValueHolderInterface)this._persistence_dRateParameters_vh.clone();
        }
        if (this._persistence_network_vh != null) {
            this._persistence_network_vh = (WeavedAttributeValueHolderInterface)this._persistence_network_vh.clone();
        }
        if (this._persistence_aRateParameters_vh != null) {
            this._persistence_aRateParameters_vh = (WeavedAttributeValueHolderInterface)this._persistence_aRateParameters_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Currency();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "symbol") {
            return this.symbol;
        }
        if (string == "displayTemplate") {
            return this.displayTemplate;
        }
        if (string == "prefix") {
            return this.prefix;
        }
        if (string == "dRateParameters") {
            return this.dRateParameters;
        }
        if (string == "precision") {
            return this.precision;
        }
        if (string == "transactionNumber") {
            return this.transactionNumber;
        }
        if (string == "suffix") {
            return this.suffix;
        }
        if (string == "network") {
            return this.network;
        }
        if (string == "aRateParameters") {
            return this.aRateParameters;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "symbol") {
            this.symbol = (String)object;
            return;
        }
        if (string == "displayTemplate") {
            this.displayTemplate = (String)object;
            return;
        }
        if (string == "prefix") {
            this.prefix = (String)object;
            return;
        }
        if (string == "dRateParameters") {
            this.dRateParameters = (DRateParameters)object;
            return;
        }
        if (string == "precision") {
            this.precision = (Integer)object;
            return;
        }
        if (string == "transactionNumber") {
            this.transactionNumber = (NumberGeneration)object;
            return;
        }
        if (string == "suffix") {
            this.suffix = (String)object;
            return;
        }
        if (string == "network") {
            this.network = (Network)object;
            return;
        }
        if (string == "aRateParameters") {
            this.aRateParameters = (ARateParameters)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_symbol() {
        this._persistence_checkFetched("symbol");
        return this.symbol;
    }

    public void _persistence_set_symbol(String string) {
        this._persistence_checkFetchedForSet("symbol");
        this._persistence_propertyChange("symbol", this.symbol, string);
        this.symbol = string;
    }

    public String _persistence_get_displayTemplate() {
        this._persistence_checkFetched("displayTemplate");
        return this.displayTemplate;
    }

    public void _persistence_set_displayTemplate(String string) {
        this._persistence_checkFetchedForSet("displayTemplate");
        this._persistence_propertyChange("displayTemplate", this.displayTemplate, string);
        this.displayTemplate = string;
    }

    public String _persistence_get_prefix() {
        this._persistence_checkFetched("prefix");
        return this.prefix;
    }

    public void _persistence_set_prefix(String string) {
        this._persistence_checkFetchedForSet("prefix");
        this._persistence_propertyChange("prefix", this.prefix, string);
        this.prefix = string;
    }

    protected void _persistence_initialize_dRateParameters_vh() {
        if (this._persistence_dRateParameters_vh == null) {
            this._persistence_dRateParameters_vh = new ValueHolder((Object)this.dRateParameters);
            this._persistence_dRateParameters_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_dRateParameters_vh() {
        DRateParameters dRateParameters;
        this._persistence_initialize_dRateParameters_vh();
        if ((this._persistence_dRateParameters_vh.isCoordinatedWithProperty() || this._persistence_dRateParameters_vh.isNewlyWeavedValueHolder()) && (dRateParameters = this._persistence_get_dRateParameters()) != this._persistence_dRateParameters_vh.getValue()) {
            this._persistence_set_dRateParameters(dRateParameters);
        }
        return this._persistence_dRateParameters_vh;
    }

    public void _persistence_set_dRateParameters_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_dRateParameters_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            DRateParameters dRateParameters = this._persistence_get_dRateParameters();
            if (dRateParameters != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_dRateParameters((DRateParameters)object);
            }
        } else {
            this.dRateParameters = null;
        }
    }

    public DRateParameters _persistence_get_dRateParameters() {
        this._persistence_checkFetched("dRateParameters");
        this._persistence_initialize_dRateParameters_vh();
        this.dRateParameters = (DRateParameters)this._persistence_dRateParameters_vh.getValue();
        return this.dRateParameters;
    }

    public void _persistence_set_dRateParameters(DRateParameters dRateParameters) {
        this._persistence_checkFetchedForSet("dRateParameters");
        this._persistence_initialize_dRateParameters_vh();
        this.dRateParameters = (DRateParameters)this._persistence_dRateParameters_vh.getValue();
        this._persistence_propertyChange("dRateParameters", this.dRateParameters, dRateParameters);
        this.dRateParameters = dRateParameters;
        this._persistence_dRateParameters_vh.setValue((Object)dRateParameters);
    }

    public int _persistence_get_precision() {
        this._persistence_checkFetched("precision");
        return this.precision;
    }

    public void _persistence_set_precision(int n) {
        this._persistence_checkFetchedForSet("precision");
        this._persistence_propertyChange("precision", new Integer(this.precision), new Integer(n));
        this.precision = n;
    }

    public NumberGeneration _persistence_get_transactionNumber() {
        this._persistence_checkFetched("transactionNumber");
        return this.transactionNumber;
    }

    public void _persistence_set_transactionNumber(NumberGeneration numberGeneration) {
        this._persistence_checkFetchedForSet("transactionNumber");
        this._persistence_propertyChange("transactionNumber", this.transactionNumber, numberGeneration);
        this.transactionNumber = numberGeneration;
    }

    public String _persistence_get_suffix() {
        this._persistence_checkFetched("suffix");
        return this.suffix;
    }

    public void _persistence_set_suffix(String string) {
        this._persistence_checkFetchedForSet("suffix");
        this._persistence_propertyChange("suffix", this.suffix, string);
        this.suffix = string;
    }

    protected void _persistence_initialize_network_vh() {
        if (this._persistence_network_vh == null) {
            this._persistence_network_vh = new ValueHolder((Object)this.network);
            this._persistence_network_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_network_vh() {
        Network network;
        this._persistence_initialize_network_vh();
        if ((this._persistence_network_vh.isCoordinatedWithProperty() || this._persistence_network_vh.isNewlyWeavedValueHolder()) && (network = this._persistence_get_network()) != this._persistence_network_vh.getValue()) {
            this._persistence_set_network(network);
        }
        return this._persistence_network_vh;
    }

    public void _persistence_set_network_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_network_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Network network = this._persistence_get_network();
            if (network != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_network((Network)object);
            }
        } else {
            this.network = null;
        }
    }

    public Network _persistence_get_network() {
        this._persistence_checkFetched("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        return this.network;
    }

    public void _persistence_set_network(Network network) {
        this._persistence_checkFetchedForSet("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        this._persistence_propertyChange("network", this.network, network);
        this.network = network;
        this._persistence_network_vh.setValue((Object)network);
    }

    protected void _persistence_initialize_aRateParameters_vh() {
        if (this._persistence_aRateParameters_vh == null) {
            this._persistence_aRateParameters_vh = new ValueHolder((Object)this.aRateParameters);
            this._persistence_aRateParameters_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_aRateParameters_vh() {
        ARateParameters aRateParameters;
        this._persistence_initialize_aRateParameters_vh();
        if ((this._persistence_aRateParameters_vh.isCoordinatedWithProperty() || this._persistence_aRateParameters_vh.isNewlyWeavedValueHolder()) && (aRateParameters = this._persistence_get_aRateParameters()) != this._persistence_aRateParameters_vh.getValue()) {
            this._persistence_set_aRateParameters(aRateParameters);
        }
        return this._persistence_aRateParameters_vh;
    }

    public void _persistence_set_aRateParameters_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_aRateParameters_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            ARateParameters aRateParameters = this._persistence_get_aRateParameters();
            if (aRateParameters != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_aRateParameters((ARateParameters)object);
            }
        } else {
            this.aRateParameters = null;
        }
    }

    public ARateParameters _persistence_get_aRateParameters() {
        this._persistence_checkFetched("aRateParameters");
        this._persistence_initialize_aRateParameters_vh();
        this.aRateParameters = (ARateParameters)this._persistence_aRateParameters_vh.getValue();
        return this.aRateParameters;
    }

    public void _persistence_set_aRateParameters(ARateParameters aRateParameters) {
        this._persistence_checkFetchedForSet("aRateParameters");
        this._persistence_initialize_aRateParameters_vh();
        this.aRateParameters = (ARateParameters)this._persistence_aRateParameters_vh.getValue();
        this._persistence_propertyChange("aRateParameters", this.aRateParameters, aRateParameters);
        this.aRateParameters = aRateParameters;
        this._persistence_aRateParameters_vh.setValue((Object)aRateParameters);
    }
}

