/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.CurrencyScale;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.HasCurrency;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.utils.RatedAccountEntity;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="account_rates", indexes={@Index(name="ix_account_rates_transfer_time", columnList="transfer_time")})
public class AccountRates
extends NetworkedEntity
implements RatedAccountEntity,
HasCurrency,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="emission_date", updatable=false)
    private Date emissionDate;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="expiration_date", updatable=false)
    private Date expirationDate;
    @Basic
    @Column(name="rate_balance_correction", updatable=false, nullable=false)
    @CurrencyScale
    private BigDecimal rateBalanceCorrection = BigDecimal.ZERO;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="account_id", updatable=false, nullable=false)
    private Account account;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="transfer_time", nullable=false)
    private Date time;
    static final long serialVersionUID = -7038342873423811613L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_account_vh;

    public Account getAccount() {
        return this._persistence_get_account();
    }

    @Override
    public Currency getCurrency() {
        return this._persistence_get_account().getCurrency();
    }

    @Override
    public Date getEmissionDate() {
        return this._persistence_get_emissionDate();
    }

    @Override
    public Date getExpirationDate() {
        return this._persistence_get_expirationDate();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_account().getNetwork();
    }

    @Override
    public BigDecimal getRateBalanceCorrection() {
        return this._persistence_get_rateBalanceCorrection();
    }

    public Date getTime() {
        return this._persistence_get_time();
    }

    public void setAccount(Account account) {
        this._persistence_set_account(account);
    }

    @Override
    public void setEmissionDate(Date date) {
        this._persistence_set_emissionDate(date);
    }

    @Override
    public void setExpirationDate(Date date) {
        this._persistence_set_expirationDate(date);
    }

    @Override
    public void setRateBalanceCorrection(BigDecimal bigDecimal) {
        this._persistence_set_rateBalanceCorrection(bigDecimal);
    }

    public void setTime(Date date) {
        this._persistence_set_time(date);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_account_vh != null) {
            this._persistence_account_vh = (WeavedAttributeValueHolderInterface)this._persistence_account_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new AccountRates();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "rateBalanceCorrection") {
            return this.rateBalanceCorrection;
        }
        if (string == "emissionDate") {
            return this.emissionDate;
        }
        if (string == "time") {
            return this.time;
        }
        if (string == "account") {
            return this.account;
        }
        if (string == "expirationDate") {
            return this.expirationDate;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "rateBalanceCorrection") {
            this.rateBalanceCorrection = (BigDecimal)object;
            return;
        }
        if (string == "emissionDate") {
            this.emissionDate = (Date)object;
            return;
        }
        if (string == "time") {
            this.time = (Date)object;
            return;
        }
        if (string == "account") {
            this.account = (Account)object;
            return;
        }
        if (string == "expirationDate") {
            this.expirationDate = (Date)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public BigDecimal _persistence_get_rateBalanceCorrection() {
        this._persistence_checkFetched("rateBalanceCorrection");
        return this.rateBalanceCorrection;
    }

    public void _persistence_set_rateBalanceCorrection(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("rateBalanceCorrection");
        this._persistence_propertyChange("rateBalanceCorrection", this.rateBalanceCorrection, bigDecimal);
        this.rateBalanceCorrection = bigDecimal;
    }

    public Date _persistence_get_emissionDate() {
        this._persistence_checkFetched("emissionDate");
        return this.emissionDate;
    }

    public void _persistence_set_emissionDate(Date date) {
        this._persistence_checkFetchedForSet("emissionDate");
        this._persistence_propertyChange("emissionDate", this.emissionDate, date);
        this.emissionDate = date;
    }

    public Date _persistence_get_time() {
        this._persistence_checkFetched("time");
        return this.time;
    }

    public void _persistence_set_time(Date date) {
        this._persistence_checkFetchedForSet("time");
        this._persistence_propertyChange("time", this.time, date);
        this.time = date;
    }

    protected void _persistence_initialize_account_vh() {
        if (this._persistence_account_vh == null) {
            this._persistence_account_vh = new ValueHolder((Object)this.account);
            this._persistence_account_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_account_vh() {
        Account account;
        this._persistence_initialize_account_vh();
        if ((this._persistence_account_vh.isCoordinatedWithProperty() || this._persistence_account_vh.isNewlyWeavedValueHolder()) && (account = this._persistence_get_account()) != this._persistence_account_vh.getValue()) {
            this._persistence_set_account(account);
        }
        return this._persistence_account_vh;
    }

    public void _persistence_set_account_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_account_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Account account = this._persistence_get_account();
            if (account != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_account((Account)object);
            }
        } else {
            this.account = null;
        }
    }

    public Account _persistence_get_account() {
        this._persistence_checkFetched("account");
        this._persistence_initialize_account_vh();
        this.account = (Account)this._persistence_account_vh.getValue();
        return this.account;
    }

    public void _persistence_set_account(Account account) {
        this._persistence_checkFetchedForSet("account");
        this._persistence_initialize_account_vh();
        this.account = (Account)this._persistence_account_vh.getValue();
        this._persistence_propertyChange("account", this.account, account);
        this.account = account;
        this._persistence_account_vh.setValue((Object)account);
    }

    public Date _persistence_get_expirationDate() {
        this._persistence_checkFetched("expirationDate");
        return this.expirationDate;
    }

    public void _persistence_set_expirationDate(Date date) {
        this._persistence_checkFetchedForSet("expirationDate");
        this._persistence_propertyChange("expirationDate", this.expirationDate, date);
        this.expirationDate = date;
    }
}

