/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.CurrencyScale;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.AccountBalance;
import org.cyclos.entities.banking.AccountBalanceLimitLog;
import org.cyclos.entities.banking.AccountRates;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.AmountReservation;
import org.cyclos.entities.banking.ClosedAccountBalance;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.IAccount;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.User;
import org.cyclos.model.banking.accounts.AccountVO;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.banking.accounttypes.AccountTypeNature;
import org.cyclos.model.banking.accounttypes.AccountTypeVO;
import org.cyclos.model.users.users.UserVO;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@DiscriminatorColumn(name="subclass")
@Table(name="accounts", indexes={@Index(name="ix_accounts_system", columnList="subclass"), @Index(name="ix_account_number", columnList="lower(number)"), @Index(name="ix_accounts_creation_date", columnList="creation_date"), @Index(name="ix_user_account_type", unique=true, columnList="user_id, account_type_id"), @Index(name="ix_accounts_archiving_date", columnList="archiving_date")})
public abstract class Account
extends NetworkedEntity
implements IAccount,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id", updatable=false)
    protected User user;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="account_type_id", updatable=false, nullable=false)
    private AccountType type;
    @Basic
    @Column(name="number")
    private String number;
    @Basic
    @Column(name="creation_date", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date creationDate;
    @Basic
    @Column(name="archiving_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date archivingDate;
    @Basic
    @Column(name="archived_balance")
    @CurrencyScale
    private BigDecimal archivedBalance;
    @Basic
    @Column(name="archived_reserved")
    @CurrencyScale
    private BigDecimal archivedReserved;
    @Basic
    @Column(name="negative_since")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date negativeSince;
    @Basic
    @Column(name="credit_limit")
    @CurrencyScale
    private BigDecimal creditLimit;
    @Basic
    @Column(name="upper_credit_limit")
    @CurrencyScale
    private BigDecimal upperCreditLimit;
    @OneToMany(mappedBy="account", cascade={CascadeType.REMOVE})
    @OrderBy(value="modifiedAt DESC")
    private List<AccountBalanceLimitLog> accountBalanceLimitLog = new ArrayList<AccountBalanceLimitLog>();
    @OneToMany(mappedBy="account", cascade={CascadeType.REMOVE})
    private Set<AccountRates> allAccountRates = new HashSet<AccountRates>();
    @OneToMany(mappedBy="account", cascade={CascadeType.REMOVE})
    private Set<AmountReservation> amountReservations = new HashSet<AmountReservation>();
    @OneToMany(mappedBy="account", cascade={CascadeType.REMOVE})
    private Set<ClosedAccountBalance> closedAccountBalances = new HashSet<ClosedAccountBalance>();
    @OneToMany(mappedBy="account", cascade={CascadeType.REMOVE})
    private Set<AccountBalance> accountBalances = new HashSet<AccountBalance>();
    @Basic
    @Column(name="account_rates_id", insertable=false, updatable=false)
    private Long accountRatesId;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="account_rates_id")
    private AccountRates accountRates;
    static final long serialVersionUID = -7905765256871638994L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_accountRates_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_type_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_user_vh;

    public List<AccountBalanceLimitLog> getAccountBalanceLimitLog() {
        return this._persistence_get_accountBalanceLimitLog();
    }

    public AccountRates getAccountRates() {
        return this._persistence_get_accountRates();
    }

    @Override
    public Long getAccountRatesId() {
        return this._persistence_get_accountRatesId();
    }

    public Set<AmountReservation> getAmountReservations() {
        return this._persistence_get_amountReservations();
    }

    public BigDecimal getArchivedBalance() {
        return this._persistence_get_archivedBalance();
    }

    public BigDecimal getArchivedReserved() {
        return this._persistence_get_archivedReserved();
    }

    public Date getArchivingDate() {
        return this._persistence_get_archivingDate();
    }

    public Set<ClosedAccountBalance> getClosedAccountBalances() {
        return this._persistence_get_closedAccountBalances();
    }

    public Date getCreationDate() {
        return this._persistence_get_creationDate();
    }

    @Override
    public BigDecimal getCreditLimit() {
        return this._persistence_get_creditLimit();
    }

    @Override
    public Currency getCurrency() {
        return this._persistence_get_type() == null ? null : this._persistence_get_type().getCurrency();
    }

    public abstract AccountTypeNature getNature();

    public Date getNegativeSince() {
        return this._persistence_get_negativeSince();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_type().getNetwork();
    }

    @Override
    public String getNumber() {
        return this._persistence_get_number();
    }

    @Override
    public AccountType getType() {
        return this._persistence_get_type();
    }

    @Override
    public BigDecimal getUpperCreditLimit() {
        return this._persistence_get_upperCreditLimit();
    }

    public abstract boolean isActive();

    public void setAccountRates(AccountRates accountRates) {
        this._persistence_set_accountRates(accountRates);
    }

    @Override
    public void setAccountRatesId(Long l) {
        this._persistence_set_accountRatesId(l);
    }

    public void setArchivedBalance(BigDecimal bigDecimal) {
        this._persistence_set_archivedBalance(bigDecimal);
    }

    public void setArchivedReserved(BigDecimal bigDecimal) {
        this._persistence_set_archivedReserved(bigDecimal);
    }

    public void setArchivingDate(Date date) {
        this._persistence_set_archivingDate(date);
    }

    public void setClosedAccountBalances(Set<ClosedAccountBalance> set) {
        this._persistence_set_closedAccountBalances(set);
    }

    public void setCreationDate(Date date) {
        this._persistence_set_creationDate(date);
    }

    @Override
    public void setCreditLimit(BigDecimal bigDecimal) {
        this._persistence_set_creditLimit(bigDecimal);
    }

    public void setNegativeSince(Date date) {
        this._persistence_set_negativeSince(date);
    }

    @Override
    public void setNumber(String string) {
        this._persistence_set_number(string);
    }

    public void setType(AccountType accountType) {
        this._persistence_set_type(accountType);
    }

    @Override
    public void setUpperCreditLimit(BigDecimal bigDecimal) {
        this._persistence_set_upperCreditLimit(bigDecimal);
    }

    public AccountVO toVORef() {
        AccountVO accountVO = new AccountVO();
        if (this.isTransient()) {
            accountVO.setType(new AccountTypeVO(this._persistence_get_type().getId()));
            InternalAccountOwner internalAccountOwner = this.getOwner();
            if (internalAccountOwner instanceof SystemAccountOwner) {
                accountVO.setOwner(internalAccountOwner);
            } else {
                accountVO.setOwner((InternalAccountOwner)new UserVO(SimpleEntity.id((SimpleEntity)internalAccountOwner)));
            }
        } else {
            accountVO.setId(this.getId());
        }
        return accountVO;
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_accountRates_vh != null) {
            this._persistence_accountRates_vh = (WeavedAttributeValueHolderInterface)this._persistence_accountRates_vh.clone();
        }
        if (this._persistence_type_vh != null) {
            this._persistence_type_vh = (WeavedAttributeValueHolderInterface)this._persistence_type_vh.clone();
        }
        if (this._persistence_user_vh != null) {
            this._persistence_user_vh = (WeavedAttributeValueHolderInterface)this._persistence_user_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Account();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "archivedBalance") {
            return this.archivedBalance;
        }
        if (string == "closedAccountBalances") {
            return this.closedAccountBalances;
        }
        if (string == "upperCreditLimit") {
            return this.upperCreditLimit;
        }
        if (string == "archivedReserved") {
            return this.archivedReserved;
        }
        if (string == "accountRatesId") {
            return this.accountRatesId;
        }
        if (string == "accountRates") {
            return this.accountRates;
        }
        if (string == "creationDate") {
            return this.creationDate;
        }
        if (string == "type") {
            return this.type;
        }
        if (string == "number") {
            return this.number;
        }
        if (string == "negativeSince") {
            return this.negativeSince;
        }
        if (string == "allAccountRates") {
            return this.allAccountRates;
        }
        if (string == "amountReservations") {
            return this.amountReservations;
        }
        if (string == "accountBalances") {
            return this.accountBalances;
        }
        if (string == "accountBalanceLimitLog") {
            return this.accountBalanceLimitLog;
        }
        if (string == "creditLimit") {
            return this.creditLimit;
        }
        if (string == "user") {
            return this.user;
        }
        if (string == "archivingDate") {
            return this.archivingDate;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "archivedBalance") {
            this.archivedBalance = (BigDecimal)object;
            return;
        }
        if (string == "closedAccountBalances") {
            this.closedAccountBalances = (Set)object;
            return;
        }
        if (string == "upperCreditLimit") {
            this.upperCreditLimit = (BigDecimal)object;
            return;
        }
        if (string == "archivedReserved") {
            this.archivedReserved = (BigDecimal)object;
            return;
        }
        if (string == "accountRatesId") {
            this.accountRatesId = (Long)object;
            return;
        }
        if (string == "accountRates") {
            this.accountRates = (AccountRates)object;
            return;
        }
        if (string == "creationDate") {
            this.creationDate = (Date)object;
            return;
        }
        if (string == "type") {
            this.type = (AccountType)object;
            return;
        }
        if (string == "number") {
            this.number = (String)object;
            return;
        }
        if (string == "negativeSince") {
            this.negativeSince = (Date)object;
            return;
        }
        if (string == "allAccountRates") {
            this.allAccountRates = (Set)object;
            return;
        }
        if (string == "amountReservations") {
            this.amountReservations = (Set)object;
            return;
        }
        if (string == "accountBalances") {
            this.accountBalances = (Set)object;
            return;
        }
        if (string == "accountBalanceLimitLog") {
            this.accountBalanceLimitLog = (List)object;
            return;
        }
        if (string == "creditLimit") {
            this.creditLimit = (BigDecimal)object;
            return;
        }
        if (string == "user") {
            this.user = (User)object;
            return;
        }
        if (string == "archivingDate") {
            this.archivingDate = (Date)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public BigDecimal _persistence_get_archivedBalance() {
        this._persistence_checkFetched("archivedBalance");
        return this.archivedBalance;
    }

    public void _persistence_set_archivedBalance(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("archivedBalance");
        this._persistence_propertyChange("archivedBalance", this.archivedBalance, bigDecimal);
        this.archivedBalance = bigDecimal;
    }

    public Set _persistence_get_closedAccountBalances() {
        this._persistence_checkFetched("closedAccountBalances");
        return this.closedAccountBalances;
    }

    public void _persistence_set_closedAccountBalances(Set set) {
        this._persistence_checkFetchedForSet("closedAccountBalances");
        this._persistence_propertyChange("closedAccountBalances", this.closedAccountBalances, set);
        this.closedAccountBalances = set;
    }

    public BigDecimal _persistence_get_upperCreditLimit() {
        this._persistence_checkFetched("upperCreditLimit");
        return this.upperCreditLimit;
    }

    public void _persistence_set_upperCreditLimit(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("upperCreditLimit");
        this._persistence_propertyChange("upperCreditLimit", this.upperCreditLimit, bigDecimal);
        this.upperCreditLimit = bigDecimal;
    }

    public BigDecimal _persistence_get_archivedReserved() {
        this._persistence_checkFetched("archivedReserved");
        return this.archivedReserved;
    }

    public void _persistence_set_archivedReserved(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("archivedReserved");
        this._persistence_propertyChange("archivedReserved", this.archivedReserved, bigDecimal);
        this.archivedReserved = bigDecimal;
    }

    public Long _persistence_get_accountRatesId() {
        this._persistence_checkFetched("accountRatesId");
        return this.accountRatesId;
    }

    public void _persistence_set_accountRatesId(Long l) {
        this._persistence_checkFetchedForSet("accountRatesId");
        this._persistence_propertyChange("accountRatesId", this.accountRatesId, l);
        this.accountRatesId = l;
    }

    protected void _persistence_initialize_accountRates_vh() {
        if (this._persistence_accountRates_vh == null) {
            this._persistence_accountRates_vh = new ValueHolder((Object)this.accountRates);
            this._persistence_accountRates_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_accountRates_vh() {
        AccountRates accountRates;
        this._persistence_initialize_accountRates_vh();
        if ((this._persistence_accountRates_vh.isCoordinatedWithProperty() || this._persistence_accountRates_vh.isNewlyWeavedValueHolder()) && (accountRates = this._persistence_get_accountRates()) != this._persistence_accountRates_vh.getValue()) {
            this._persistence_set_accountRates(accountRates);
        }
        return this._persistence_accountRates_vh;
    }

    public void _persistence_set_accountRates_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_accountRates_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            AccountRates accountRates = this._persistence_get_accountRates();
            if (accountRates != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_accountRates((AccountRates)object);
            }
        } else {
            this.accountRates = null;
        }
    }

    public AccountRates _persistence_get_accountRates() {
        this._persistence_checkFetched("accountRates");
        this._persistence_initialize_accountRates_vh();
        this.accountRates = (AccountRates)this._persistence_accountRates_vh.getValue();
        return this.accountRates;
    }

    public void _persistence_set_accountRates(AccountRates accountRates) {
        this._persistence_checkFetchedForSet("accountRates");
        this._persistence_initialize_accountRates_vh();
        this.accountRates = (AccountRates)this._persistence_accountRates_vh.getValue();
        this._persistence_propertyChange("accountRates", this.accountRates, accountRates);
        this.accountRates = accountRates;
        this._persistence_accountRates_vh.setValue((Object)accountRates);
    }

    public Date _persistence_get_creationDate() {
        this._persistence_checkFetched("creationDate");
        return this.creationDate;
    }

    public void _persistence_set_creationDate(Date date) {
        this._persistence_checkFetchedForSet("creationDate");
        this._persistence_propertyChange("creationDate", this.creationDate, date);
        this.creationDate = date;
    }

    protected void _persistence_initialize_type_vh() {
        if (this._persistence_type_vh == null) {
            this._persistence_type_vh = new ValueHolder((Object)this.type);
            this._persistence_type_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_type_vh() {
        AccountType accountType;
        this._persistence_initialize_type_vh();
        if ((this._persistence_type_vh.isCoordinatedWithProperty() || this._persistence_type_vh.isNewlyWeavedValueHolder()) && (accountType = this._persistence_get_type()) != this._persistence_type_vh.getValue()) {
            this._persistence_set_type(accountType);
        }
        return this._persistence_type_vh;
    }

    public void _persistence_set_type_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_type_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            AccountType accountType = this._persistence_get_type();
            if (accountType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_type((AccountType)object);
            }
        } else {
            this.type = null;
        }
    }

    public AccountType _persistence_get_type() {
        this._persistence_checkFetched("type");
        this._persistence_initialize_type_vh();
        this.type = (AccountType)this._persistence_type_vh.getValue();
        return this.type;
    }

    public void _persistence_set_type(AccountType accountType) {
        this._persistence_checkFetchedForSet("type");
        this._persistence_initialize_type_vh();
        this.type = (AccountType)this._persistence_type_vh.getValue();
        this._persistence_propertyChange("type", this.type, accountType);
        this.type = accountType;
        this._persistence_type_vh.setValue((Object)accountType);
    }

    public String _persistence_get_number() {
        this._persistence_checkFetched("number");
        return this.number;
    }

    public void _persistence_set_number(String string) {
        this._persistence_checkFetchedForSet("number");
        this._persistence_propertyChange("number", this.number, string);
        this.number = string;
    }

    public Date _persistence_get_negativeSince() {
        this._persistence_checkFetched("negativeSince");
        return this.negativeSince;
    }

    public void _persistence_set_negativeSince(Date date) {
        this._persistence_checkFetchedForSet("negativeSince");
        this._persistence_propertyChange("negativeSince", this.negativeSince, date);
        this.negativeSince = date;
    }

    public Set _persistence_get_allAccountRates() {
        this._persistence_checkFetched("allAccountRates");
        return this.allAccountRates;
    }

    public void _persistence_set_allAccountRates(Set set) {
        this._persistence_checkFetchedForSet("allAccountRates");
        this._persistence_propertyChange("allAccountRates", this.allAccountRates, set);
        this.allAccountRates = set;
    }

    public Set _persistence_get_amountReservations() {
        this._persistence_checkFetched("amountReservations");
        return this.amountReservations;
    }

    public void _persistence_set_amountReservations(Set set) {
        this._persistence_checkFetchedForSet("amountReservations");
        this._persistence_propertyChange("amountReservations", this.amountReservations, set);
        this.amountReservations = set;
    }

    public Set _persistence_get_accountBalances() {
        this._persistence_checkFetched("accountBalances");
        return this.accountBalances;
    }

    public void _persistence_set_accountBalances(Set set) {
        this._persistence_checkFetchedForSet("accountBalances");
        this._persistence_propertyChange("accountBalances", this.accountBalances, set);
        this.accountBalances = set;
    }

    public List _persistence_get_accountBalanceLimitLog() {
        this._persistence_checkFetched("accountBalanceLimitLog");
        return this.accountBalanceLimitLog;
    }

    public void _persistence_set_accountBalanceLimitLog(List list) {
        this._persistence_checkFetchedForSet("accountBalanceLimitLog");
        this._persistence_propertyChange("accountBalanceLimitLog", this.accountBalanceLimitLog, list);
        this.accountBalanceLimitLog = list;
    }

    public BigDecimal _persistence_get_creditLimit() {
        this._persistence_checkFetched("creditLimit");
        return this.creditLimit;
    }

    public void _persistence_set_creditLimit(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("creditLimit");
        this._persistence_propertyChange("creditLimit", this.creditLimit, bigDecimal);
        this.creditLimit = bigDecimal;
    }

    protected void _persistence_initialize_user_vh() {
        if (this._persistence_user_vh == null) {
            this._persistence_user_vh = new ValueHolder((Object)this.user);
            this._persistence_user_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_user_vh() {
        User user;
        this._persistence_initialize_user_vh();
        if ((this._persistence_user_vh.isCoordinatedWithProperty() || this._persistence_user_vh.isNewlyWeavedValueHolder()) && (user = this._persistence_get_user()) != this._persistence_user_vh.getValue()) {
            this._persistence_set_user(user);
        }
        return this._persistence_user_vh;
    }

    public void _persistence_set_user_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_user_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            User user = this._persistence_get_user();
            if (user != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_user((User)object);
            }
        } else {
            this.user = null;
        }
    }

    public User _persistence_get_user() {
        this._persistence_checkFetched("user");
        this._persistence_initialize_user_vh();
        this.user = (User)this._persistence_user_vh.getValue();
        return this.user;
    }

    public void _persistence_set_user(User user) {
        this._persistence_checkFetchedForSet("user");
        this._persistence_initialize_user_vh();
        this.user = (User)this._persistence_user_vh.getValue();
        this._persistence_propertyChange("user", this.user, user);
        this.user = user;
        this._persistence_user_vh.setValue((Object)user);
    }

    public Date _persistence_get_archivingDate() {
        this._persistence_checkFetched("archivingDate");
        return this.archivingDate;
    }

    public void _persistence_set_archivingDate(Date date) {
        this._persistence_checkFetchedForSet("archivingDate");
        this._persistence_propertyChange("archivingDate", this.archivingDate, date);
        this.archivingDate = date;
    }
}

