/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.access;

import java.util.Date;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.ConfigurationEntity;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.access.OidcAuthorization;
import org.cyclos.entities.system.DefinesNetwork;
import org.cyclos.entities.system.Network;
import org.cyclos.model.access.oidcclients.OidcClientNature;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Cacheable(value=true)
@DiscriminatorColumn(name="subclass")
@Table(name="oidc_clients", indexes={@Index(name="ix_oidc_clients_client_id", columnList="client_id")})
public abstract class BaseOidcClient
extends ConfigurationEntity
implements DefinesNetwork,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @Basic
    @Column(name="enabled")
    protected Boolean enabled = true;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @ReadOnlyFromDTO
    @Column(name="creation_date", nullable=false)
    private Date creationDate;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="network_id")
    private Network network;
    @Basic
    @Column(name="client_id", nullable=false)
    private String clientId;
    @Basic
    @Column(name="secret", nullable=false)
    private String secret;
    @Basic
    @Lob
    @Column(name="redirect_uris")
    private String redirectUris;
    @Basic
    @Column(name="website")
    private String website;
    @Basic
    @Column(name="privacy_policy_url")
    private String privacyPolicyUrl;
    @Basic
    @Column(name="terms_of_service_url")
    private String termsOfServiceUrl;
    @OneToMany(mappedBy="client", cascade={CascadeType.REMOVE})
    private Set<OidcAuthorization> authorizations;
    static final long serialVersionUID = 1456878036709446975L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_network_vh;

    public String getClientId() {
        return this._persistence_get_clientId();
    }

    public Date getCreationDate() {
        return this._persistence_get_creationDate();
    }

    public abstract OidcClientNature getNature();

    @Override
    public Network getNetwork() {
        return this._persistence_get_network();
    }

    public String getPrivacyPolicyUrl() {
        return this._persistence_get_privacyPolicyUrl();
    }

    public String getRedirectUris() {
        return this._persistence_get_redirectUris();
    }

    public String getSecret() {
        return this._persistence_get_secret();
    }

    public String getTermsOfServiceUrl() {
        return this._persistence_get_termsOfServiceUrl();
    }

    public String getWebsite() {
        return this._persistence_get_website();
    }

    public boolean isEnabled() {
        return Boolean.TRUE.equals(this._persistence_get_enabled());
    }

    public void setClientId(String string) {
        this._persistence_set_clientId(string);
    }

    public void setCreationDate(Date date) {
        this._persistence_set_creationDate(date);
    }

    public void setEnabled(boolean bl) {
        this._persistence_set_enabled(bl);
    }

    @Override
    public void setNetwork(Network network) {
        this._persistence_set_network(network);
    }

    public void setPrivacyPolicyUrl(String string) {
        this._persistence_set_privacyPolicyUrl(string);
    }

    public void setRedirectUris(String string) {
        this._persistence_set_redirectUris(string);
    }

    public void setSecret(String string) {
        this._persistence_set_secret(string);
    }

    public void setTermsOfServiceUrl(String string) {
        this._persistence_set_termsOfServiceUrl(string);
    }

    public void setWebsite(String string) {
        this._persistence_set_website(string);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_network_vh != null) {
            this._persistence_network_vh = (WeavedAttributeValueHolderInterface)this._persistence_network_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new BaseOidcClient();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "website") {
            return this.website;
        }
        if (string == "termsOfServiceUrl") {
            return this.termsOfServiceUrl;
        }
        if (string == "clientId") {
            return this.clientId;
        }
        if (string == "authorizations") {
            return this.authorizations;
        }
        if (string == "secret") {
            return this.secret;
        }
        if (string == "creationDate") {
            return this.creationDate;
        }
        if (string == "redirectUris") {
            return this.redirectUris;
        }
        if (string == "privacyPolicyUrl") {
            return this.privacyPolicyUrl;
        }
        if (string == "enabled") {
            return this.enabled;
        }
        if (string == "network") {
            return this.network;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "website") {
            this.website = (String)object;
            return;
        }
        if (string == "termsOfServiceUrl") {
            this.termsOfServiceUrl = (String)object;
            return;
        }
        if (string == "clientId") {
            this.clientId = (String)object;
            return;
        }
        if (string == "authorizations") {
            this.authorizations = (Set)object;
            return;
        }
        if (string == "secret") {
            this.secret = (String)object;
            return;
        }
        if (string == "creationDate") {
            this.creationDate = (Date)object;
            return;
        }
        if (string == "redirectUris") {
            this.redirectUris = (String)object;
            return;
        }
        if (string == "privacyPolicyUrl") {
            this.privacyPolicyUrl = (String)object;
            return;
        }
        if (string == "enabled") {
            this.enabled = (Boolean)object;
            return;
        }
        if (string == "network") {
            this.network = (Network)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_website() {
        this._persistence_checkFetched("website");
        return this.website;
    }

    public void _persistence_set_website(String string) {
        this._persistence_checkFetchedForSet("website");
        this._persistence_propertyChange("website", this.website, string);
        this.website = string;
    }

    public String _persistence_get_termsOfServiceUrl() {
        this._persistence_checkFetched("termsOfServiceUrl");
        return this.termsOfServiceUrl;
    }

    public void _persistence_set_termsOfServiceUrl(String string) {
        this._persistence_checkFetchedForSet("termsOfServiceUrl");
        this._persistence_propertyChange("termsOfServiceUrl", this.termsOfServiceUrl, string);
        this.termsOfServiceUrl = string;
    }

    public String _persistence_get_clientId() {
        this._persistence_checkFetched("clientId");
        return this.clientId;
    }

    public void _persistence_set_clientId(String string) {
        this._persistence_checkFetchedForSet("clientId");
        this._persistence_propertyChange("clientId", this.clientId, string);
        this.clientId = string;
    }

    public Set _persistence_get_authorizations() {
        this._persistence_checkFetched("authorizations");
        return this.authorizations;
    }

    public void _persistence_set_authorizations(Set set) {
        this._persistence_checkFetchedForSet("authorizations");
        this._persistence_propertyChange("authorizations", this.authorizations, set);
        this.authorizations = set;
    }

    public String _persistence_get_secret() {
        this._persistence_checkFetched("secret");
        return this.secret;
    }

    public void _persistence_set_secret(String string) {
        this._persistence_checkFetchedForSet("secret");
        this._persistence_propertyChange("secret", this.secret, string);
        this.secret = string;
    }

    public Date _persistence_get_creationDate() {
        this._persistence_checkFetched("creationDate");
        return this.creationDate;
    }

    public void _persistence_set_creationDate(Date date) {
        this._persistence_checkFetchedForSet("creationDate");
        this._persistence_propertyChange("creationDate", this.creationDate, date);
        this.creationDate = date;
    }

    public String _persistence_get_redirectUris() {
        this._persistence_checkFetched("redirectUris");
        return this.redirectUris;
    }

    public void _persistence_set_redirectUris(String string) {
        this._persistence_checkFetchedForSet("redirectUris");
        this._persistence_propertyChange("redirectUris", this.redirectUris, string);
        this.redirectUris = string;
    }

    public String _persistence_get_privacyPolicyUrl() {
        this._persistence_checkFetched("privacyPolicyUrl");
        return this.privacyPolicyUrl;
    }

    public void _persistence_set_privacyPolicyUrl(String string) {
        this._persistence_checkFetchedForSet("privacyPolicyUrl");
        this._persistence_propertyChange("privacyPolicyUrl", this.privacyPolicyUrl, string);
        this.privacyPolicyUrl = string;
    }

    public Boolean _persistence_get_enabled() {
        this._persistence_checkFetched("enabled");
        return this.enabled;
    }

    public void _persistence_set_enabled(Boolean bl) {
        this._persistence_checkFetchedForSet("enabled");
        this._persistence_propertyChange("enabled", this.enabled, bl);
        this.enabled = bl;
    }

    protected void _persistence_initialize_network_vh() {
        if (this._persistence_network_vh == null) {
            this._persistence_network_vh = new ValueHolder((Object)this.network);
            this._persistence_network_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_network_vh() {
        Network network;
        this._persistence_initialize_network_vh();
        if ((this._persistence_network_vh.isCoordinatedWithProperty() || this._persistence_network_vh.isNewlyWeavedValueHolder()) && (network = this._persistence_get_network()) != this._persistence_network_vh.getValue()) {
            this._persistence_set_network(network);
        }
        return this._persistence_network_vh;
    }

    public void _persistence_set_network_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_network_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Network network = this._persistence_get_network();
            if (network != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_network((Network)object);
            }
        } else {
            this.network = null;
        }
    }

    public Network _persistence_get_network() {
        this._persistence_checkFetched("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        return this.network;
    }

    public void _persistence_set_network(Network network) {
        this._persistence_checkFetchedForSet("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        this._persistence_propertyChange("network", this.network, network);
        this.network = network;
        this._persistence_network_vh.setValue((Object)network);
    }
}

