/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.cyclos.server.utils.NodeListElementIterator;
import org.cyclos.server.utils.NodeListIterator;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.coercion.CoercionHelper;
import org.springframework.beans.BeanWrapperImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlHelper {
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private static final DocumentBuilder DEFAULT_DOCUMENT_BUILDER;
    public static final int INDENT_AMOUNT = 4;

    public static Element createChild(Element element, String string, String string2) {
        Element element2 = element.getOwnerDocument().createElement(string);
        if ((string2 = StringHelper.trimToNull((Object)string2)) != null) {
            element2.setTextContent(string2);
        }
        element.appendChild(element2);
        return element2;
    }

    public static String export(Node node) {
        StringWriter stringWriter = new StringWriter();
        XmlHelper.export(node, stringWriter);
        return stringWriter.toString();
    }

    public static void export(Node node, Writer writer) {
        try {
            DOMSource dOMSource = new DOMSource(node);
            StreamResult streamResult = new StreamResult(writer);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("standalone", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            try {
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(4));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            transformer.transform(dOMSource, streamResult);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Error while exporting the xml", exception);
        }
    }

    public static boolean fillAttributes(Element element, Object object, String ... stringArray) {
        boolean bl = false;
        BeanWrapperImpl beanWrapperImpl = new BeanWrapperImpl(object);
        for (String string : stringArray) {
            Object object2 = beanWrapperImpl.getPropertyValue(string);
            String string2 = XmlHelper.propertyToTag(string);
            String string3 = StringHelper.trim((Object)object2);
            if (string3.length() <= 0) continue;
            bl = true;
            element.setAttribute(string2, string3);
        }
        return bl;
    }

    public static boolean fillPropertiesWithAttributes(Object object, Element element, String ... stringArray) {
        boolean bl = false;
        BeanWrapperImpl beanWrapperImpl = new BeanWrapperImpl(object);
        for (String string : stringArray) {
            if (!element.hasAttribute(string)) continue;
            String string2 = XmlHelper.propertyToTag(string);
            String string3 = StringHelper.trimToNull((Object)element.getAttribute(string2));
            if (string3 != null) {
                bl = true;
            }
            beanWrapperImpl.setPropertyValue(string, (Object)string3);
        }
        return bl;
    }

    public static boolean fillPropertiesWithSubElements(Object object, Element element, String ... stringArray) {
        boolean bl = false;
        BeanWrapperImpl beanWrapperImpl = new BeanWrapperImpl(object);
        for (String string : stringArray) {
            String string2 = XmlHelper.propertyToTag(string);
            String string3 = StringHelper.trimToNull((Object)XmlHelper.getText(element, string2));
            if (string3 != null) {
                bl = true;
            }
            beanWrapperImpl.setPropertyValue(string, (Object)string3);
        }
        return bl;
    }

    public static boolean fillSubElements(Element element, Object object, String ... stringArray) {
        boolean bl = false;
        BeanWrapperImpl beanWrapperImpl = new BeanWrapperImpl(object);
        for (String string : stringArray) {
            String string2 = XmlHelper.propertyToTag(string);
            Object object2 = beanWrapperImpl.getPropertyValue(string);
            String string3 = StringHelper.trim((Object)CoercionHelper.coerce(String.class, (Object)object2));
            if (!string3.isEmpty()) {
                bl = true;
            }
            XmlHelper.createChild(element, string2, string3);
        }
        return bl;
    }

    public static Element getFirst(Element element, String string) {
        if (element == null) {
            return null;
        }
        Iterator<Element> iterator = XmlHelper.iterate(element, string).iterator();
        if (iterator.hasNext()) {
            Element element2 = iterator.next();
            return element2;
        }
        return null;
    }

    public static String getText(Element element) {
        if (element == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node : XmlHelper.iterateChildren(element)) {
            switch (node.getNodeType()) {
                case 3: 
                case 4: {
                    stringBuilder.append(node.getNodeValue());
                }
            }
        }
        return StringHelper.trimToNull((Object)stringBuilder);
    }

    public static String getText(Element element, String string) {
        return XmlHelper.getText(XmlHelper.getFirst(element, string));
    }

    public static NodeListElementIterator iterate(Element element) {
        return new NodeListElementIterator(element.getChildNodes());
    }

    public static NodeListElementIterator iterate(Element element, String string) {
        return new NodeListElementIterator(element.getChildNodes(), string);
    }

    public static NodeListIterator iterateChildren(Element element) {
        return new NodeListIterator(element.getChildNodes());
    }

    public static Document newDocument() {
        return DEFAULT_DOCUMENT_BUILDER.newDocument();
    }

    public static void parse(DefaultHandler defaultHandler, InputSource inputSource) throws SAXException, IOException {
        SAXParser sAXParser;
        try {
            sAXParser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
        sAXParser.parse(inputSource, defaultHandler);
    }

    public static void parse(DefaultHandler defaultHandler, InputStream inputStream) throws SAXException, IOException {
        XmlHelper.parse(defaultHandler, new InputSource(inputStream));
    }

    public static void parse(DefaultHandler defaultHandler, String string) throws SAXException, IOException {
        XmlHelper.parse(defaultHandler, new InputSource(new StringReader(string)));
    }

    public static Document parse(InputStream inputStream) throws SAXException, IOException {
        return XmlHelper.parse(inputStream, null);
    }

    public static Document parse(InputStream inputStream, EntityResolver entityResolver) throws SAXException, IOException {
        return XmlHelper.normalize(XmlHelper.resolveDocumentBuilder(entityResolver).parse(inputStream));
    }

    public static Document parse(String string) throws SAXException, IOException {
        return XmlHelper.parse(string, null);
    }

    public static Document parse(String string, EntityResolver entityResolver) throws SAXException, IOException {
        StringReader stringReader = new StringReader(string);
        return XmlHelper.normalize(XmlHelper.resolveDocumentBuilder(entityResolver).parse(new InputSource(stringReader)));
    }

    public static String propertyToTag(String string) {
        return StringHelper.transformCase((String)string, (boolean)false, (char)'-');
    }

    private static Document normalize(Document document) {
        document.getDocumentElement().normalize();
        return document;
    }

    private static DocumentBuilder resolveDocumentBuilder(EntityResolver entityResolver) {
        DocumentBuilder documentBuilder;
        if (entityResolver == null) {
            documentBuilder = DEFAULT_DOCUMENT_BUILDER;
        } else {
            try {
                documentBuilder = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
                documentBuilder.setEntityResolver(entityResolver);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new IllegalStateException("Error creating a document builder", parserConfigurationException);
            }
        }
        return documentBuilder;
    }

    static {
        try {
            DOCUMENT_BUILDER_FACTORY.setNamespaceAware(true);
            DOCUMENT_BUILDER_FACTORY.setIgnoringComments(true);
            DOCUMENT_BUILDER_FACTORY.setIgnoringElementContentWhitespace(true);
            DEFAULT_DOCUMENT_BUILDER = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
        }
        catch (Exception exception) {
            throw new IllegalStateException("Error creating a document builder", exception);
        }
    }
}

