/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils;

import cn.danielw.fop.ObjectFactory;
import cn.danielw.fop.ObjectPool;
import cn.danielw.fop.PoolConfig;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.UserAgentAnalyzer;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.utils.RequestInfo;
import org.cyclos.model.utils.UserAgentInfo;
import org.cyclos.server.utils.FieldHelper;
import org.cyclos.server.utils.UserAgentHandler;
import org.cyclos.utils.CollectionHelper;
import org.springframework.stereotype.Component;

@Component
public class UserAgentHandlerImpl
implements UserAgentHandler {
    private ObjectPool<UserAgentAnalyzer> pool;

    @PreDestroy
    public void destroy() {
        try {
            this.pool.shutdown();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @PostConstruct
    public void initialize() {
        PoolConfig poolConfig = new PoolConfig();
        poolConfig.setPartitionSize(Runtime.getRuntime().availableProcessors());
        poolConfig.setMaxSize(10);
        poolConfig.setMinSize(0);
        poolConfig.setMaxIdleMilliseconds(3600000);
        poolConfig.setMaxWaitMilliseconds(60000);
        ObjectFactory<UserAgentAnalyzer> objectFactory = new ObjectFactory<UserAgentAnalyzer>(){

            public UserAgentAnalyzer create() {
                return (UserAgentAnalyzer)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)UserAgentAnalyzer.newBuilder().hideMatcherLoadStats()).withFields(new String[]{"DeviceClass"})).withFields(new String[]{"DeviceName"})).withFields(new String[]{"OperatingSystemName"})).withFields(new String[]{"AgentName"})).withCache(10000)).build();
            }

            public void destroy(UserAgentAnalyzer userAgentAnalyzer) {
                userAgentAnalyzer.destroy();
            }

            public boolean validate(UserAgentAnalyzer userAgentAnalyzer) {
                return true;
            }
        };
        this.pool = new ObjectPool(poolConfig, (ObjectFactory)objectFactory);
        try {
            Thread thread = (Thread)FieldHelper.get(this.pool, "scavenger");
            thread.setName("cy.user_agent_pool_scavenger");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public UserAgentInfo parse(RequestInfo requestInfo) {
        UserAgent.ImmutableUserAgent immutableUserAgent;
        Map<String, String> map = this.getUserAgentHeaders(requestInfo);
        if (CollectionHelper.isEmpty(map)) {
            return null;
        }
        try (Object object = this.pool.borrowObject(true);){
            immutableUserAgent = ((UserAgentAnalyzer)object.getObject()).parse(map);
        }
        object = immutableUserAgent.getValue("DeviceClass");
        if ("Hacker".equals(object)) {
            throw new IllegalActionException("Invalid user agent: " + String.valueOf(immutableUserAgent));
        }
        UserAgentInfo userAgentInfo = new UserAgentInfo();
        userAgentInfo.setDeviceType((String)object);
        userAgentInfo.setDevice(immutableUserAgent.getValue("DeviceName"));
        userAgentInfo.setOperatingSystem(immutableUserAgent.getValue("OperatingSystemName"));
        userAgentInfo.setAgent(immutableUserAgent.getValue("AgentName"));
        return userAgentInfo;
    }

    private Map<String, String> getUserAgentHeaders(RequestInfo requestInfo) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (requestInfo != null) {
            for (String string : CollectionHelper.iterable((Iterator)requestInfo.getHeaders().getNames())) {
                if (!"User-Agent".equalsIgnoreCase(string) && !StringUtils.startsWithIgnoreCase((CharSequence)string, (CharSequence)"CH-") && !StringUtils.startsWithIgnoreCase((CharSequence)string, (CharSequence)"Seq-CH-")) continue;
                hashMap.put(string, requestInfo.getHeader(string));
            }
        }
        return hashMap;
    }
}

