/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.model.Submodules;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.app.AppKeys;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.contentmanagement.ContentManagementKeys;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.marketplace.MarketplaceKeys;
import org.cyclos.model.messaging.MessagingKeys;
import org.cyclos.model.mobile.MobileKeys;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.Module;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.Submodule;

public class TranslationMapping {
    private static final Map<Module, Class<?>> HOLDER_CLASSES_BY_MODULE;
    private static final Map<Module, List<MessageKey>> BY_MODULE;
    private static final Map<Submodule, List<MessageKey>> BY_SUBMODULE;
    private static final List<MessageKey> ALL;

    public static List<MessageKey> getAll() {
        return ALL;
    }

    public static List<MessageKey> getByModule(Module module) {
        return BY_MODULE.get(module);
    }

    public static List<MessageKey> getBySubmodule(Submodule submodule) {
        return BY_SUBMODULE.get(submodule);
    }

    private static List<MessageKey> submoduleKeys(Submodule submodule) {
        Class<?> clazz;
        Field[] fieldArray;
        Module module = submodule.module();
        Class<?> clazz2 = HOLDER_CLASSES_BY_MODULE.get(module);
        if (clazz2 == null) {
            return Collections.emptyList();
        }
        try {
            fieldArray = StringUtils.capitalize((String)StringHelper.camelize((String)submodule.name()));
            clazz = Class.forName(clazz2.getName() + "$" + (String)fieldArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Collections.emptyList();
        }
        fieldArray = clazz.getDeclaredFields();
        ArrayList<MessageKey> arrayList = new ArrayList<MessageKey>(fieldArray.length);
        for (Field field : fieldArray) {
            MessageKey messageKey;
            if (!MessageKey.class.isAssignableFrom(field.getType()) || !Modifier.isStatic(field.getModifiers())) continue;
            try {
                messageKey = (MessageKey)field.get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                throw new IllegalStateException(exception);
            }
            if (messageKey == null) continue;
            arrayList.add(messageKey);
        }
        return arrayList;
    }

    static {
        AbstractMap abstractMap = new EnumMap<Module, Class>(Module.class);
        abstractMap.put((Module)Module.APP, AppKeys.class);
        abstractMap.put((Module)Module.ACCESS, AccessKeys.class);
        abstractMap.put((Module)Module.BANKING, BankingKeys.class);
        abstractMap.put((Module)Module.CONTENT_MANAGEMENT, ContentManagementKeys.class);
        abstractMap.put((Module)Module.GENERAL, GeneralKeys.class);
        abstractMap.put((Module)Module.MARKETPLACE, MarketplaceKeys.class);
        abstractMap.put((Module)Module.MESSAGING, MessagingKeys.class);
        abstractMap.put((Module)Module.SYSTEM, SystemKeys.class);
        abstractMap.put((Module)Module.USERS, UsersKeys.class);
        abstractMap.put((Module)Module.MOBILE, MobileKeys.class);
        if (abstractMap.size() != Module.values().length) {
            throw new IllegalStateException("Please check TranslationMapping class: there are missing modules in this class.");
        }
        HOLDER_CLASSES_BY_MODULE = Collections.unmodifiableMap(abstractMap);
        abstractMap = new HashMap();
        HashMap hashMap = new HashMap();
        LinkedList linkedList = new LinkedList();
        HOLDER_CLASSES_BY_MODULE.keySet().forEach(module -> {
            Class clazz = Submodules.getSubmoduleClassFor((Module)module);
            EnumSet enumSet = EnumSet.allOf(clazz);
            enumSet.forEach(submodule -> {
                List<MessageKey> list2 = TranslationMapping.submoduleKeys(submodule);
                abstractMap.computeIfAbsent(module, module -> new LinkedList()).addAll(list2);
                hashMap.put(submodule, list2);
                linkedList.addAll(list2);
            });
        });
        BY_MODULE = abstractMap.entrySet().stream().map(entry -> Pair.create((Object)((Module)entry.getKey()), Collections.unmodifiableList(CollectionHelper.sort(new ArrayList((Collection)entry.getValue()))))).collect(Collectors.toUnmodifiableMap(Pair::getFirst, Pair::getSecond));
        BY_SUBMODULE = hashMap.entrySet().stream().map(entry -> Pair.create((Object)((Submodule)entry.getKey()), Collections.unmodifiableList(CollectionHelper.sort(new ArrayList((Collection)entry.getValue()))))).collect(Collectors.toUnmodifiableMap(Pair::getFirst, Pair::getSecond));
        ALL = Collections.unmodifiableList(CollectionHelper.sort(new ArrayList(linkedList)));
    }
}

