/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils;

import java.nio.ByteBuffer;
import java.security.SecureRandom;

public class SecureRandomHelper {
    private static final String UPPER = "ABCDEFGFHIJKLMNOPQRSTUVWXYZ";
    private static final String LOWER = "ABCDEFGFHIJKLMNOPQRSTUVWXYZ".toLowerCase();
    private static final String LETTERS = "ABCDEFGFHIJKLMNOPQRSTUVWXYZ" + LOWER;
    private static final String NUMBERS = "1234567890";
    private static final String ALPHANUMERIC = LETTERS + "1234567890";
    private static SecureRandom random;
    private static long randomSince;

    public static String random(int n, String string) {
        if (n < 0 || string == null) {
            return null;
        }
        if (n == 0 || string.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        SecureRandom secureRandom = SecureRandomHelper.random();
        int n2 = string.length();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string.charAt(secureRandom.nextInt(n2)));
        }
        return stringBuilder.toString();
    }

    public static String randomAlphabetic(int n) {
        return SecureRandomHelper.random(n, LETTERS);
    }

    public static String randomAlphanumeric(int n) {
        return SecureRandomHelper.random(n, ALPHANUMERIC);
    }

    public static String randomNumeric(int n) {
        return SecureRandomHelper.random(n, NUMBERS);
    }

    public static String randomUppercase(int n) {
        return SecureRandomHelper.random(n, UPPER);
    }

    private static synchronized SecureRandom createRandom() {
        if (random == null) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(4);
            for (int i = 0; i < 4; ++i) {
                byteBuffer.put(i, (byte)(Math.random() * 255.0));
            }
            return new SecureRandom(byteBuffer.array());
        }
        return random;
    }

    private static SecureRandom random() {
        long l;
        if (random == null) {
            random = SecureRandomHelper.createRandom();
        }
        if ((l = System.currentTimeMillis()) - randomSince > 60000L) {
            random.setSeed(l);
            randomSince = l;
        }
        return random;
    }
}

