/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils;

import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeListElementIterator
implements Iterable<Element>,
Iterator<Element> {
    private final NodeList nodeList;
    private String tagName;
    private int index = -1;
    private Element next;
    private int length;

    public NodeListElementIterator(NodeList nodeList) {
        this(nodeList, null);
    }

    public NodeListElementIterator(NodeList nodeList, String string) {
        this.nodeList = nodeList;
        this.length = nodeList.getLength();
        this.tagName = string;
        this.next = this.nextElement();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Iterator<Element> iterator() {
        return this;
    }

    @Override
    public Element next() {
        Element element = this.next;
        this.next = this.nextElement();
        return element;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private Element nextElement() {
        Node node;
        if (this.length == 0 || this.index >= this.length) {
            return null;
        }
        if (!((node = this.nodeList.item(++this.index)) instanceof Element) || this.tagName != null && !((Element)node).getTagName().equals(this.tagName)) {
            return this.nextElement();
        }
        return (Element)node;
    }
}

