/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public class IOHelper {
    private static final Pattern FILE_SIZE_PATTERN = Pattern.compile("([\\d.]+)\\s*([GMK]B?)?");

    public static void close(Closeable ... closeableArray) {
        if (closeableArray != null) {
            for (Closeable closeable : closeableArray) {
                IOHelper.close(closeable);
            }
        }
    }

    public static void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void copyAndClose(InputStream inputStream, File file) throws IOException {
        IOHelper.copyAndClose(inputStream, new FileOutputStream(file));
    }

    public static void copyAndClose(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (Throwable throwable) {
            IOHelper.close(inputStream, outputStream);
            throw throwable;
        }
        IOHelper.close(inputStream, outputStream);
    }

    public static void copyAndClose(Reader reader, File file) throws IOException {
        IOHelper.copyAndClose(reader, new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
    }

    public static void copyAndClose(Reader reader, Writer writer) throws IOException {
        try {
            IOUtils.copy((Reader)reader, (Writer)writer);
        }
        catch (Throwable throwable) {
            IOHelper.close(reader, writer);
            throw throwable;
        }
        IOHelper.close(reader, writer);
    }

    public static long parseFileSize(String string) {
        Matcher matcher = FILE_SIZE_PATTERN.matcher(string);
        try {
            if (!matcher.find()) {
                throw new Exception();
            }
            double d = Double.parseDouble(matcher.group(1));
            String string2 = matcher.group(2);
            int n = string2.isEmpty() ? 66 : (int)string2.charAt(0);
            switch (n) {
                case 71: {
                    d *= 1024.0;
                }
                case 77: {
                    d *= 1024.0;
                }
                case 75: {
                    d *= 1024.0;
                }
            }
            return (long)d;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Couldn't parse '" + string + "' as a file size. Expected something like 0.5G, 5M, 2.3KB or 123549");
        }
    }

    public static byte[] readBytesAndClose(InputStream inputStream) throws IOException {
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
            return byArray;
        }
        finally {
            IOHelper.close((Closeable)inputStream);
        }
    }

    public static String readContentAndClose(Reader reader) throws IOException {
        if (reader == null) {
            return null;
        }
        try {
            char[] cArray = IOUtils.toCharArray((Reader)reader);
            String string = new String(cArray);
            return string;
        }
        finally {
            IOHelper.close((Closeable)reader);
        }
    }

    public static String readContentAsString(URL uRL) throws IOException {
        if (uRL == null) {
            throw new FileNotFoundException();
        }
        InputStream inputStream = uRL.openStream();
        try {
            String string = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            return string;
        }
        finally {
            IOHelper.close((Closeable)inputStream);
        }
    }
}

