/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils;

import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.cyclos.model.utils.DatePeriodDTO;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.model.utils.PeriodType;
import org.cyclos.model.utils.PredefinedPeriodData;
import org.cyclos.model.utils.TimeField;
import org.cyclos.model.utils.TimeIntervalDTO;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;

public class DateHelper {
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int SECONDS_PER_HOUR = 3600;
    public static final int SECONDS_PER_DAY = 86400;

    public static Date add(Date date, ITimeInterval iTimeInterval) {
        return DateHelper.add(date, iTimeInterval, TimeZone.getDefault());
    }

    public static Date add(Date date, ITimeInterval iTimeInterval, TimeZone timeZone) {
        TimeField timeField;
        Integer n = iTimeInterval == null ? null : iTimeInterval.getAmount();
        TimeField timeField2 = timeField = iTimeInterval == null ? null : iTimeInterval.getField();
        if (n == null || timeField == null) {
            return date;
        }
        return DateHelper.add(date, timeField, n, timeZone);
    }

    public static Date add(Date date, TimeField timeField, int n) {
        return DateHelper.add(date, timeField, n, TimeZone.getDefault());
    }

    public static Date add(Date date, TimeField timeField, int n, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        calendar.add(DateHelper.getCalendarField(timeField), n);
        return calendar.getTime();
    }

    public static Date addDecimal(Date date, TimeField timeField, double d) {
        long l = (long)((double)timeField.getMilliseconds() * d);
        long l2 = date.getTime();
        long l3 = l2 + l;
        Date date2 = new Date();
        date2.setTime(l3);
        return date2;
    }

    public static double convertField(TimeField timeField, int n, TimeField timeField2) {
        double d = DateHelper.millisIn(timeField2, n);
        double d2 = DateHelper.millisIn(timeField, 1);
        return d / d2;
    }

    public static Pair<Date, Date> createPeriod(PredefinedPeriodData predefinedPeriodData, TimeZone timeZone) {
        if (predefinedPeriodData == null || predefinedPeriodData.getType() == null || predefinedPeriodData.getYear() == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Calendar calendar2 = (Calendar)calendar.clone();
        PeriodType periodType = predefinedPeriodData.getType();
        int n = predefinedPeriodData.getYear();
        switch (periodType) {
            case YEAR: {
                calendar.set(n, 0, 1, 0, 0, 0);
                calendar2.set(n + 1, 0, 1, 0, 0, 0);
                break;
            }
            case QUARTER: {
                if (predefinedPeriodData.getQuarter() == null) {
                    return null;
                }
                int n2 = predefinedPeriodData.getQuarter();
                if (n2 < periodType.getLowerBoundary() || n2 > periodType.getUpperBoundary()) break;
                calendar.set(n, (n2 - 1) * 3, 1, 0, 0, 0);
                calendar2.set(n, n2 * 3, 1, 0, 0, 0);
                break;
            }
            case MONTH: {
                if (predefinedPeriodData.getMonth() == null) {
                    return null;
                }
                int n3 = predefinedPeriodData.getMonth();
                if (n3 < periodType.getLowerBoundary() || n3 > periodType.getUpperBoundary()) break;
                calendar.set(n, n3, 1, 0, 0, 0);
                calendar2.set(n, n3 + 1, 1, 0, 0, 0);
                break;
            }
            case MONTH_RANGE: {
                if (predefinedPeriodData.getMonth() == null) {
                    return null;
                }
                int n4 = predefinedPeriodData.getMonth();
                if (n4 < periodType.getLowerBoundary()) break;
                calendar.setTime(DateHelper.subtract(calendar.getTime(), TimeField.MONTHS, n4, timeZone));
                calendar2.setTime(DateHelper.shiftToNextDay(calendar2.getTime(), timeZone));
                break;
            }
            case WEEK_OF_YEAR: {
                if (predefinedPeriodData.getWeek() == null) {
                    return null;
                }
                int n5 = predefinedPeriodData.getWeek();
                if (n5 < periodType.getLowerBoundary() || n5 > periodType.getUpperBoundary()) break;
                calendar.clear();
                calendar.set(1, n);
                Long l = calendar.getTimeInMillis();
                calendar.set(3, n5);
                calendar2 = (Calendar)calendar.clone();
                calendar2.add(6, 7);
                break;
            }
            case CURRENT_DAY: {
                calendar2.add(5, 1);
                break;
            }
            case CURRENT_WEEK: {
                while (calendar.get(7) != 2) {
                    calendar.add(5, -1);
                }
                calendar2.add(5, 1);
                break;
            }
            case DAY: {
                if (predefinedPeriodData.getMonth() == null || predefinedPeriodData.getDay() == null) {
                    return null;
                }
                int n6 = predefinedPeriodData.getDay();
                int n7 = predefinedPeriodData.getDay();
                calendar.set(n, n6, n7, 0, 0, 0);
                calendar2 = (Calendar)calendar.clone();
                calendar2.add(5, 1);
            }
        }
        if (calendar == null || calendar2 == null) {
            return null;
        }
        calendar2.add(14, -1);
        return Pair.create((Object)calendar.getTime(), (Object)calendar2.getTime());
    }

    public static List<PredefinedPeriodData> createPeriodRange(PredefinedPeriodData predefinedPeriodData, int n) {
        if (n == 0) {
            return new ArrayList<PredefinedPeriodData>(0);
        }
        int n2 = Math.abs(n);
        boolean bl = n < 0;
        int n3 = predefinedPeriodData.getYear();
        PeriodType periodType = predefinedPeriodData.getType();
        ArrayList<PredefinedPeriodData> arrayList = new ArrayList<PredefinedPeriodData>(n2);
        if (n2 == 1) {
            return arrayList;
        }
        for (int i = 0; i < n2; ++i) {
            int n4 = bl ? -i : i;
            int n5 = n3;
            Integer n6 = null;
            Integer n7 = null;
            switch (periodType) {
                case YEAR: {
                    n5 = n3 + n4;
                    break;
                }
                case MONTH: {
                    n6 = predefinedPeriodData.getMonth() + n4;
                    while (n6 < 0) {
                        n6 = n6 + 12;
                        --n5;
                    }
                    while (n6 > 11) {
                        n6 = n6 - 12;
                        ++n5;
                    }
                    break;
                }
                case QUARTER: {
                    n7 = predefinedPeriodData.getQuarter() + n4;
                    while (n7 <= 0) {
                        n7 = n7 + 4;
                        --n5;
                    }
                    while (n7 > 4) {
                        n7 = n7 - 4;
                        ++n5;
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid type for this operation");
                }
            }
            PredefinedPeriodData predefinedPeriodData2 = new PredefinedPeriodData();
            predefinedPeriodData2.setType(periodType);
            predefinedPeriodData2.setYear(Integer.valueOf(n5));
            predefinedPeriodData2.setMonth(n6);
            predefinedPeriodData2.setQuarter(n7);
            arrayList.add(predefinedPeriodData2);
        }
        return arrayList;
    }

    public static double daysBetween(Date date, Date date2) {
        if (date == null || date2 == null) {
            return 0.0;
        }
        return (double)(date2.getTime() - date.getTime()) / 8.64E7;
    }

    public static Date earliest(Date ... dateArray) {
        Date date = null;
        for (Date date2 : dateArray) {
            if (date != null && (date2 == null || !date.after(date2))) continue;
            date = date2;
        }
        return date;
    }

    public static String formatDateTime(DateTime dateTime, String string) {
        if (dateTime == null) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, dateTime.getYear());
        calendar.set(2, dateTime.getMonth());
        calendar.set(5, dateTime.getDate());
        calendar.set(11, dateTime.getHours());
        calendar.set(12, dateTime.getMinutes());
        calendar.set(13, dateTime.getSeconds());
        calendar.set(14, dateTime.getMilliseconds());
        return simpleDateFormat.format(calendar.getTime());
    }

    public static String formatDuration(Long l) {
        if (l == null) {
            return "";
        }
        if (l < 1000L) {
            return DurationFormatUtils.formatDuration((long)l, (String)"S'ms'");
        }
        if (l < 60000L) {
            return DurationFormatUtils.formatDuration((long)l, (String)"s's'");
        }
        if (l < 3600000L) {
            return DurationFormatUtils.formatDuration((long)l, (String)"m:ss");
        }
        return DurationFormatUtils.formatDuration((long)l, (String)"H:mm:ss");
    }

    public static int getCalendarField(TimeField timeField) {
        switch (timeField) {
            case MILLIS: {
                return 14;
            }
            case SECONDS: {
                return 13;
            }
            case MINUTES: {
                return 12;
            }
            case HOURS: {
                return 10;
            }
            case DAYS: {
                return 5;
            }
            case WEEKS: {
                return 3;
            }
            case MONTHS: {
                return 2;
            }
            case YEARS: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Unknown time field: " + String.valueOf(timeField));
    }

    public static String getFormattedGMT(int n) {
        if (n == 0) {
            return "(GMT)";
        }
        int n2 = Math.abs(n / 3600000);
        int n3 = Math.abs(n / 60000 % 60);
        Object object = n2 < 10 ? "0" + n2 : String.valueOf(n2);
        Object object2 = n3 < 10 ? "0" + n3 : String.valueOf(n3);
        String string = n > 0 ? "+" : "-";
        String string2 = ":";
        return String.format("(GMT%s%s%s%s)", string, object, string2, object2);
    }

    public static String getFormattedGMT(TimeZone timeZone, Date date) {
        return DateHelper.getFormattedGMT(timeZone.getOffset(date.getTime()));
    }

    public static PredefinedPeriodData getLastCompletedPeriod(PeriodType periodType, TimeZone timeZone) {
        PredefinedPeriodData predefinedPeriodData = new PredefinedPeriodData();
        predefinedPeriodData.setType(periodType);
        Calendar calendar = Calendar.getInstance(timeZone);
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        switch (periodType) {
            case YEAR: {
                --n;
                break;
            }
            case QUARTER: {
                int n3 = n2 / 3;
                if (n3 == 0) {
                    n3 = 4;
                    --n;
                }
                predefinedPeriodData.setQuarter(Integer.valueOf(n3));
                break;
            }
            case MONTH: 
            case MONTH_RANGE: {
                if (n2 == periodType.getLowerBoundary()) {
                    n2 = periodType.getUpperBoundary();
                    --n;
                } else {
                    --n2;
                }
                predefinedPeriodData.setMonth(Integer.valueOf(n2));
                break;
            }
            case WEEK_OF_YEAR: 
            case CURRENT_WEEK: {
                Calendar calendar2 = (Calendar)calendar.clone();
                calendar2.add(6, -7);
                int n4 = calendar2.get(3);
                n = calendar2.get(1);
                predefinedPeriodData.setWeek(Integer.valueOf(n4));
                break;
            }
            case CURRENT_DAY: 
            case DAY: {
                calendar.add(5, -1);
                n = calendar.get(1);
                predefinedPeriodData.setMonth(Integer.valueOf(calendar.get(2)));
                predefinedPeriodData.setDay(Integer.valueOf(calendar.get(5)));
            }
        }
        predefinedPeriodData.setYear(Integer.valueOf(n));
        return predefinedPeriodData;
    }

    public static PredefinedPeriodData getLastMonthsRange(int n, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        PredefinedPeriodData predefinedPeriodData = new PredefinedPeriodData();
        predefinedPeriodData.setYear(Integer.valueOf(calendar.get(1)));
        predefinedPeriodData.setMonth(Integer.valueOf(n));
        predefinedPeriodData.setType(PeriodType.MONTH_RANGE);
        return predefinedPeriodData;
    }

    public static int getOffset(Date date, TimeZone timeZone) {
        TimeZone timeZone2 = TimeZone.getDefault();
        if (timeZone == null || timeZone2.equals(timeZone)) {
            return 0;
        }
        int n = timeZone2.getOffset(date.getTime());
        int n2 = timeZone.getOffset(date.getTime());
        return n - n2;
    }

    public static PredefinedPeriodData getPresentMonth(TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        PredefinedPeriodData predefinedPeriodData = new PredefinedPeriodData();
        predefinedPeriodData.setYear(Integer.valueOf(n));
        predefinedPeriodData.setMonth(Integer.valueOf(n2));
        predefinedPeriodData.setType(PeriodType.MONTH);
        return predefinedPeriodData;
    }

    public static PredefinedPeriodData getPresentYear(TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        int n = calendar.get(1);
        PredefinedPeriodData predefinedPeriodData = new PredefinedPeriodData();
        predefinedPeriodData.setYear(Integer.valueOf(n));
        predefinedPeriodData.setType(PeriodType.YEAR);
        return predefinedPeriodData;
    }

    public static TemporalUnit getTemporalUnit(TimeField timeField) {
        switch (timeField) {
            case MILLIS: {
                return ChronoUnit.MILLIS;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case DAYS: {
                return ChronoUnit.DAYS;
            }
            case WEEKS: {
                return ChronoUnit.WEEKS;
            }
            case MONTHS: {
                return ChronoUnit.MONTHS;
            }
            case YEARS: {
                return ChronoUnit.YEARS;
            }
        }
        throw new IllegalArgumentException("Unknown time field: " + String.valueOf(timeField));
    }

    public static PredefinedPeriodData getThisWeek(TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        while (calendar.get(7) != 2) {
            calendar.add(5, -1);
        }
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        PredefinedPeriodData predefinedPeriodData = new PredefinedPeriodData();
        predefinedPeriodData.setYear(Integer.valueOf(n));
        predefinedPeriodData.setMonth(Integer.valueOf(n2));
        predefinedPeriodData.setDay(Integer.valueOf(n3));
        predefinedPeriodData.setType(PeriodType.CURRENT_WEEK);
        return predefinedPeriodData;
    }

    public static long getTime(TimeIntervalDTO timeIntervalDTO) {
        if (timeIntervalDTO == null || timeIntervalDTO.getAmount() == null) {
            return 0L;
        }
        return (long)timeIntervalDTO.getAmount().intValue() * timeIntervalDTO.getField().getMilliseconds();
    }

    public static PredefinedPeriodData getToday(TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        PredefinedPeriodData predefinedPeriodData = new PredefinedPeriodData();
        predefinedPeriodData.setYear(Integer.valueOf(n));
        predefinedPeriodData.setMonth(Integer.valueOf(n2));
        predefinedPeriodData.setDay(Integer.valueOf(n3));
        predefinedPeriodData.setType(PeriodType.CURRENT_DAY);
        return predefinedPeriodData;
    }

    public static boolean includes(Date date, Date date2, Date date3, boolean bl) {
        Date date4 = new Date();
        if (date == null && date2 == null) {
            return bl;
        }
        if (date == null) {
            return !date4.after(date2);
        }
        if (date2 == null) {
            return !date4.before(date);
        }
        return !date4.before(date) && !date4.after(date2);
    }

    public static boolean isLessThanOneDayGap(Date date, Date date2) {
        if (date == null || date2 == null) {
            return false;
        }
        return Math.abs(date2.getTime() - date.getTime()) < 86400000L;
    }

    public static Date latest(Date ... dateArray) {
        Date date = null;
        for (Date date2 : dateArray) {
            if (date != null && (date2 == null || !date.before(date2))) continue;
            date = date2;
        }
        return date;
    }

    public static long millisIn(TimeField timeField, int n) {
        return (long)n * timeField.getMilliseconds();
    }

    public static Date now() {
        return new Date();
    }

    public static DatePeriodDTO period(DateTime dateTime, DateTime dateTime2) {
        DatePeriodDTO datePeriodDTO = new DatePeriodDTO();
        datePeriodDTO.setBegin(dateTime);
        datePeriodDTO.setEnd(dateTime2);
        return datePeriodDTO;
    }

    public static DatePeriodDTO periodBeginningAt(DateTime dateTime) {
        DatePeriodDTO datePeriodDTO = new DatePeriodDTO();
        datePeriodDTO.setBegin(dateTime);
        return datePeriodDTO;
    }

    public static DatePeriodDTO periodEndingAt(DateTime dateTime) {
        DatePeriodDTO datePeriodDTO = new DatePeriodDTO();
        datePeriodDTO.setEnd(dateTime);
        return datePeriodDTO;
    }

    public static Pair<Date, Date> periodIncluding(ITimeInterval iTimeInterval, TimeZone timeZone, Date date) {
        Date date2 = (Date)DateHelper.previousPeriod(iTimeInterval, timeZone, date).getSecond();
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date2);
        calendar.add(14, 1);
        return DateHelper.periodStartingAt(iTimeInterval, timeZone, calendar.getTime());
    }

    public static Pair<Date, Date> previousPeriod(ITimeInterval iTimeInterval, TimeZone timeZone, Date date) {
        Date date2 = DateHelper.truncate(date, timeZone, iTimeInterval.getField());
        return DateHelper.periodEndingAt(iTimeInterval, timeZone, date2);
    }

    public static boolean sameDay(TimeZone timeZone, Date date, Date date2) {
        if (date == null || date2 == null) {
            return false;
        }
        return DateHelper.shiftToBegin(date, timeZone).equals(DateHelper.shiftToBegin(date2, timeZone));
    }

    public static double secondsSince(long l) {
        return (double)(System.currentTimeMillis() - l) / 1000.0;
    }

    public static Date shiftToBegin(Date date, TimeZone timeZone) {
        return DateHelper.shiftToBegin(date, timeZone, false);
    }

    public static Date shiftToBegin(Date date, TimeZone timeZone, boolean bl) {
        Calendar calendar = Calendar.getInstance((TimeZone)ObjectHelper.defaultValue((Object)timeZone, (Object)TimeZone.getDefault()));
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        if (bl) {
            calendar.add(14, timeZone.getDSTSavings());
        }
        return calendar.getTime();
    }

    public static Date shiftToEnd(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance((TimeZone)ObjectHelper.defaultValue((Object)timeZone, (Object)TimeZone.getDefault()));
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date shiftToEnd(Date date, TimeZone timeZone, boolean bl) {
        Calendar calendar = Calendar.getInstance((TimeZone)ObjectHelper.defaultValue((Object)timeZone, (Object)TimeZone.getDefault()));
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        if (bl) {
            calendar.add(14, -timeZone.getDSTSavings());
        }
        return calendar.getTime();
    }

    public static Date shiftToNextDay(Date date, TimeZone timeZone) {
        Date date2 = DateHelper.shiftToEnd(date, timeZone);
        return new Date(date2.getTime() + 1L);
    }

    public static Date subtract(Date date, ITimeInterval iTimeInterval) {
        return DateHelper.subtract(date, iTimeInterval, TimeZone.getDefault());
    }

    public static Date subtract(Date date, ITimeInterval iTimeInterval, TimeZone timeZone) {
        TimeField timeField;
        Integer n = iTimeInterval == null ? null : iTimeInterval.getAmount();
        TimeField timeField2 = timeField = iTimeInterval == null ? null : iTimeInterval.getField();
        if (n == null || timeField == null) {
            return date;
        }
        return DateHelper.subtract(date, timeField, n, timeZone);
    }

    public static Date subtract(Date date, TimeField timeField, int n) {
        return DateHelper.add(date, timeField, -n, TimeZone.getDefault());
    }

    public static Date subtract(Date date, TimeField timeField, int n, TimeZone timeZone) {
        return DateHelper.add(date, timeField, -n, timeZone);
    }

    public static int toCalendarField(TimeField timeField) {
        switch (timeField) {
            case MILLIS: {
                return 14;
            }
            case SECONDS: {
                return 13;
            }
            case MINUTES: {
                return 12;
            }
            case HOURS: {
                return 11;
            }
            case DAYS: {
                return 5;
            }
            case WEEKS: {
                return 3;
            }
            case MONTHS: {
                return 2;
            }
            case YEARS: {
                return 1;
            }
        }
        throw new IllegalStateException("Unknown field: " + String.valueOf(timeField));
    }

    public static ZonedDateTime toZonedDateTime(Date date, TimeZone timeZone) {
        if (date == null) {
            return null;
        }
        ZoneId zoneId = ZoneId.of(timeZone.getID());
        Instant instant = Instant.ofEpochMilli(date.getTime());
        return ZonedDateTime.ofInstant(instant, zoneId);
    }

    private static Pair<Date, Date> periodEndingAt(ITimeInterval iTimeInterval, TimeZone timeZone, Date date) {
        Date date2 = DateHelper.subtract(date, iTimeInterval, timeZone);
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        calendar.add(14, -1);
        return Pair.create((Object)date2, (Object)calendar.getTime());
    }

    private static Pair<Date, Date> periodStartingAt(ITimeInterval iTimeInterval, TimeZone timeZone, Date date) {
        Date date2 = DateHelper.add(date, iTimeInterval, timeZone);
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date2);
        calendar.add(14, -1);
        return Pair.create((Object)date, (Object)calendar.getTime());
    }

    private static Date truncate(Date date, TimeZone timeZone, TimeField timeField) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(date.toInstant(), timeZone.toZoneId());
        switch (timeField) {
            case MILLIS: {
                return date;
            }
            case SECONDS: {
                zonedDateTime = zonedDateTime.withNano(0);
                break;
            }
            case MINUTES: {
                zonedDateTime = zonedDateTime.withNano(0).withSecond(0);
                break;
            }
            case HOURS: {
                zonedDateTime = zonedDateTime.withNano(0).withSecond(0).withMinute(0);
                break;
            }
            case DAYS: {
                zonedDateTime = zonedDateTime.withNano(0).withSecond(0).withMinute(0).withHour(0);
                break;
            }
            case WEEKS: {
                zonedDateTime = zonedDateTime.withNano(0).withSecond(0).withMinute(0).withHour(0);
                while (zonedDateTime.getDayOfWeek() != DayOfWeek.SUNDAY) {
                    zonedDateTime = zonedDateTime.minusDays(1L);
                }
                break;
            }
            case MONTHS: {
                zonedDateTime = zonedDateTime.withNano(0).withSecond(0).withMinute(0).withHour(0).withDayOfMonth(1);
                break;
            }
            case YEARS: {
                zonedDateTime = zonedDateTime.withNano(0).withSecond(0).withMinute(0).withHour(0).withDayOfYear(1);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown field: " + String.valueOf(timeField));
            }
        }
        return Date.from(zonedDateTime.toInstant());
    }
}

