/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils;

import com.google.common.cache.CacheBuilderSpec;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.server.utils.PropertiesHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.WeekDay;
import org.cyclos.utils.coercion.CoercionHelper;

public class CyclosProperties {
    private static final String[] ALLOWED_CACHE_PROPERTIES = new String[]{"concurrencyLevel", "maximumSize", "expireAfterAccess", "expireAfterWrite"};
    public static final String AUTO_CONFIGURING = "auto";
    public static final int AUTO_CONFIGURING_MAX_RECURRING_TASKS = 8;
    public static final int AUTO_CONFIGURING_MAX_POOL_SIZE = 150;
    public static final int AUTO_CONFIGURING_MIN_POOL_SIZE = 8;
    public static final String PROPERTY_PREFIX = "cyclos";
    public static final String CYCLOS_PROPERTIES = "cyclos.properties";
    public static final String DEVELOPMENT = "cyclos.development";
    public static final String DATASOURCE_PREFIX = "cyclos.datasource.";
    public static final String READONLY_DATASOURCE_PREFIX = "cyclos.datasource.readOnly.";
    public static final String DATASOURCE_PROVIDER_SUFFIX = "provider";
    public static final String C3P0_MAX_POOL_SIZE = "maxPoolSize";
    public static final String HIKARI_MAX_POOL_SIZE = "maximumPoolSize";
    public static final String C3P0_CONNECTION_TESTER_KEY = "connectionTesterClassName";
    public static final String C3P0_CONNECTION_TESTER_CLASS = "org.cyclos.db.ConnectionTester";
    public static final String ID_MASK = "cyclos.idMask";
    public static final String NFC_TOKEN_TYPE_KEY = "cyclos.nfcTokenTypeKey";
    public static final String MAX_BCRYPT_STRENGTH = "cyclos.maxBCryptStrength";
    public static final String DB_MANAGED = "cyclos.db.managed";
    public static final String DB_POPULATOR = "cyclos.db.populator";
    public static final String DB_QUERY_HANDLER = "cyclos.db.queryHandler";
    public static final String SEARCH_HANDLER = "cyclos.searchHandler";
    public static final String FORCE_FLUSH_ON_EVERY_TRANSACTION = "cyclos.db.forceFlushOnEveryTransaction";
    public static final String LICENSE_URL = "cyclos.license.url";
    public static final String LICENSE_IGNORE_ISSUE_REPORTS = "cyclos.license.ignoreIssueReports";
    public static final String CLUSTER_HANDLER = "cyclos.clusterHandler";
    public static final String STORED_FILE_CONTENT_MANAGER = "cyclos.storedFileContentManager";
    public static final String TEMP_DIR = "cyclos.tempDir";
    public static final String CACHE_PREFIX = "cyclos.cache.";
    public static final String LOG_SYNCHRONOUS = "cyclos.log.synchronous";
    public static final String LOG_PROVIDER = "cyclos.log";
    public static final String LOG_DIR = "cyclos.log.dir";
    public static final String LOG_MAX_FILES = "cyclos.log.maxFiles";
    public static final String LOG_MAX_FILE_SIZE = "cyclos.log.maxFileSize";
    public static final String LOG_DATASOURCE_PREFIX = "cyclos.log.datasource.";
    public static final String MAIL_SLEEP_SECONDS = "cyclos.mail.sleepSeconds";
    public static final String QUERY_CACHE = "cyclos.cache.queries";
    public static final String CORS_ORIGIN = "cyclos.cors.origin";
    public static final String REST_REFERENCE = "cyclos.rest.reference";
    public static final String MAX_BACKGROUND_TASKS = "cyclos.maxBackgroundTasks";
    public static final String MAX_RECURRING_TASKS = "cyclos.maxRecurringTasks";
    public static final String SKIP_INITIALIZATIONS = "cyclos.skipInitializations";
    public static final String DUMP_ALL_ERRORS = "cyclos.dumpAllErrors";
    public static final String SKIP_EMAILS = "cyclos.skipEmails";
    public static final String DISABLE_SEARCH_ENGINES_INDEXING = "cyclos.disableSearchEnginesIndexing";
    public static final String PURGE_MESSAGES_ON_TRASH_DAYS = "cyclos.purgeMessagesOnTrash.days";
    public static final String PURGE_NOTIFICATIONS_DAYS = "cyclos.purgeNotifications.days";
    public static final String PURGE_UNCONFIRMED_USERS_DAYS = "cyclos.purgeUnconfirmedUsers.days";
    public static final String PURGE_LOGIN_LOGS_DAYS = "cyclos.purgeLoginLogs.days";
    public static final String PURGE_SESSIONS_DAYS = "cyclos.purgeSessions.days";
    public static final String ARCHIVE_IMPORTS_DAYS = "cyclos.archiveImports.days";
    public static final String ARCHIVE_ACCOUNT_FEES_DAYS = "cyclos.archiveAccountFees.days";
    public static final String ARCHIVE_BULK_ACTIONS_DAYS = "cyclos.archiveBulkActions.days";
    public static final String EXPIRE_EXTERNAL_PAYMENTS_DAYS = "cyclos.expireExternalPayments.days";
    public static final String HEADER_REMOTE_ADDRESS = "cyclos.header.remoteAddress";
    public static final String HEADER_REMOTE_ADDRESS_INDEX = "cyclos.header.remoteAddress.index";
    public static final String HEADER_PROTOCOL = "cyclos.header.protocol";
    public static final String SESSIONS_ANY_ADDRESS = "cyclos.sessions.anyAddress";
    public static final String WEB_SERVICES_GZIP = "cyclos.ws.gzip";
    public static final String RATE_LIMIT_GLOBAL = "cyclos.rateLimit.global";
    public static final String RATE_LIMIT_IP = "cyclos.rateLimit.ip";
    public static final String RATE_LIMIT_WHITELIST = "cyclos.rateLimit.whitelist";
    public static final String RESPONSE_HEADERS_PREFIX = "cyclos.responseHeader.";
    public static final String PROFILING_MAX_ENTRIES = "cyclos.profiling.maxEntries";
    public static final String SASS_EXECUTABLE = "cyclos.sass.executable";
    public static final String ACCOUNTS_VERIFICATION_BALANCE_CHECK_DAYS = "cyclos.accountsVerification.balanceCheckDays";
    public static final String ARCHIVING_MONTHS = "cyclos.archiving.months";
    public static final String ARCHIVING_URL = "cyclos.archiving.url";
    public static final String ARCHIVING_USER = "cyclos.archiving.user";
    public static final String ARCHIVING_PASSWORD = "cyclos.archiving.password";
    public static final String ARCHIVING_TRUST_ALL_CERTS = "cyclos.archiving.trustAllCerts";
    public static final String ARCHIVING_WAIT_TIME_BETWEEN_DELETES_MILLIS = "cyclos.archiving.waitTimeBetweenDeletesMillis";
    public static final String ARCHIVING_DELETE_START_HOUR = "cyclos.archiving.deleteStartHour";
    public static final String ARCHIVING_DELETE_DURATION_MINUTES = "cyclos.archiving.deleteDurationMinutes";
    public static final String LICENSE_MAX_USERS_ALERT_PERCENTAGE = "cyclos.maxUsersAlertPercentage";
    public static final String NFC_TOKEN_TYPE_KEY_ZERO_VALUE = "zero";
    public static final String NFC_TOKEN_TYPE_KEY_RANDOM_VALUE = "random";
    public static final String DEFAULT_NFC_TOKEN_TYPE_KEY = "zero";
    public static final int DEFAULT_ARCHIVING_WAIT_TIME_BETWEEN_DELETES_MILLIS = 2000;
    public static final int DEFAULT_ARCHIVING_DELETE_START_HOUR = 0;
    public static final int DEFAULT_ARCHIVING_DELETE_DURATION_MINUTES = 240;
    public static final String DEFAULT_MAX_BACKGROUND_TASKS = "auto";
    public static final String DEFAULT_MAX_RECURRING_TASKS = "auto";
    public static final int DEFAULT_MAX_BCRYPT_STRENGTH = 10;
    public static final int DEFAULT_PURGE_MESSAGES_ON_TRASH_DAYS = 30;
    public static final int DEFAULT_PURGE_NOTIFICATIONS_DAYS = 30;
    public static final int DEFAULT_PURGE_UNCONFIRMED_USERS_DAYS = 7;
    public static final int DEFAULT_PURGE_LOGIN_LOGS_DAYS = 365;
    public static final int DEFAULT_EXPIRE_EXTERNAL_PAYMENTS_DAYS = 30;
    public static final int DEFAULT_ARCHIVE_IMPORTS_DAYS = 30;
    public static final int DEFAULT_ARCHIVE_ACCOUNT_FEES_DAYS = 0;
    public static final int DEFAULT_ARCHIVE_BULK_ACTIONS_DAYS = 0;
    public static final int DEFAULT_LOG_THREADS = 1;
    public static final String DEFAULT_LOG_DIR = "%t/cyclos4/logs";
    public static final int DEFAULT_MAX_LOG_FILES = 5;
    public static final String DEFAULT_MAX_LOG_FILE_SIZE = "1M";
    public static final int DEFAULT_PROFILING_MAX_ENTRIES = 10000;
    public static final String DEFAULT_CACHE_NAME = "default";
    private static final Map<String, String> QUERY_HANDLER_ALIASES = new HashMap<String, String>();
    private static final Map<String, String> SEARCH_HANDLER_ALIASES;
    private static final Map<String, String> CLUSTER_HANDLER_ALIASES;
    private static final String C3P0_PROVIDER_CLASS = "org.cyclos.bootstrap.C3P0DataSourceProvider";
    private static final String HIKARI_PROVIDER_CLASS = "org.cyclos.bootstrap.HikariDataSourceProvider";
    private static final Map<String, String> DATASOURCE_PROVIDER_ALIASES;
    private static final Map<String, String> ID_MASK_ALIASES;
    private static final Map<String, String> STORED_FILE_CONTENT_MANAGER_ALIASES;
    private static final Map<String, String> LOG_PROVIDER_ALIASES;
    private final Map<String, String> cyclosProperties;
    private final Properties properties;
    private final boolean development;
    private final String dataSourceProviderClass;
    private final Properties dataSourceProviderProperties;
    private final Properties readOnlyDataSourceProviderProperties;
    private final boolean useReadOnlyDataSource;
    private final boolean dbManaged;
    private final String dbPopulatorClass;
    private final String dbQueryHandlerClass;
    private final String searchHandlerClass;
    private final Properties searchHandlerProperties;
    private final String clusterHandlerClass;
    private final String storedFileContentManagerClass;
    private final Properties storedFileContentManagerProperties;
    private final File tempDir;
    private final File tempFilesDir;
    private final String idMaskClass;
    private final String nfcTokenTypeKey;
    private final int maxBCryptStrength;
    private final String licenseUrl;
    private final boolean licenseIgnoreIssueReports;
    private final Properties cacheSpecs;
    private final Properties defaultCacheSpecs;
    private final int mailSleepSeconds;
    private final int maxBackgroundTasks;
    private final int maxRecurringTasks;
    private final boolean dumpAllErrors;
    private final boolean skipEmails;
    private final List<String> corsOrigins;
    private final boolean restReference;
    private final boolean forceFlushOnEveryTransaction;
    private final boolean cacheQueries;
    private final boolean disableSearchEnginesIndexing;
    private final boolean webServicesGzip;
    private final boolean sessionsAnyAddress;
    private final int purgeMessagesOnTrashDays;
    private final int purgeNotificationsDays;
    private final int purgeUnconfirmedUsersDays;
    private final int purgeLoginLogsDays;
    private final int purgeSessionsDays;
    private final int expireExternalPaymentsDays;
    private final Set<WeekDay> accountsVerificationBalanceCheckDays;
    private final int archiveImportsDays;
    private final int archiveAccountFeesDays;
    private final int archiveBulkActionsDays;
    private final int archivingMonths;
    private final String archivingUrl;
    private final String archivingUser;
    private final String archivingPassword;
    private final boolean archivingTrustAllCerts;
    private final int archivingWaitTimeBetweenDeletesMillis;
    private final int archivingDeleteStartHour;
    private final int archivingDeleteDurationMinutes;
    private final boolean isSkipInitializations;
    private final String remoteAddressHeader;
    private final int remoteAddressHeaderIndex;
    private final String protocolHeader;
    private final int rateLimitGlobal;
    private final int rateLimitIp;
    private final String rateLimitWhitelist;
    private final String sassExecutable;
    private final Map<String, String> responseHeaders;
    private final boolean isTestingEnv;
    private final boolean synchronousLog;
    private final String logProviderClass;
    private final String logDir;
    private final int logMaxFiles;
    private final int logMaxFileSize;
    private final String logDataSourceProviderClass;
    private final Properties logDataSourceProviderProperties;
    private final int licenseMaxUsersAlertPercentage;
    private final int profilingMaxEntries;

    public static String getStoredFileContentManagerAlias(String string) {
        for (Map.Entry<String, String> entry : CyclosProperties.getStoredFileContentManagers().entrySet()) {
            if (!entry.getValue().equals(string)) continue;
            return entry.getKey();
        }
        throw new IllegalStateException(String.format("Alias not found for content manager implementation: %s", string));
    }

    public static Map<String, String> getStoredFileContentManagers() {
        return Collections.unmodifiableMap(STORED_FILE_CONTENT_MANAGER_ALIASES);
    }

    public static boolean isUsingOpenSearch(String string) {
        return "opensearch".equals(string) || SEARCH_HANDLER_ALIASES.get("opensearch").equals(string);
    }

    public CyclosProperties(Properties properties, Map<String, String> map) {
        this.properties = properties;
        properties.putAll((Map<?, ?>)System.getProperties());
        HashMap<String, String> hashMap = new HashMap<String, String>(System.getenv());
        for (int i = 0; i < 10; ++i) {
            hashMap.put(String.valueOf(i), "{" + i + "}");
        }
        this.postProcessTaskWorkers(properties);
        this.cyclosProperties = new TreeMap<String, String>();
        for (Map.Entry<Object, Object> object22 : properties.entrySet()) {
            String string = (String)object22.getKey();
            String string2 = (String)object22.getValue();
            string2 = StringHelper.replaceVariables((String)string2, hashMap);
            string2 = StringUtils.trimToEmpty((String)string2);
            properties.setProperty(string, string2);
            if (!string.startsWith(PROPERTY_PREFIX)) continue;
            this.cyclosProperties.put(string, string2);
        }
        this.development = this.getBoolean(properties, DEVELOPMENT);
        this.dataSourceProviderClass = this.getString(properties, "cyclos.datasource.provider", "hikari", DATASOURCE_PROVIDER_ALIASES);
        this.tempDir = this.getFile(properties, TEMP_DIR, "%w/WEB-INF/temp", map);
        this.tempFilesDir = new File(this.tempDir, "tempFiles");
        this.dbManaged = this.getBoolean(properties, DB_MANAGED);
        this.dbPopulatorClass = this.getString(properties, DB_POPULATOR, "org.cyclos.db.BasicPopulator", null);
        this.dbQueryHandlerClass = this.getString(properties, DB_QUERY_HANDLER, "postgresql", QUERY_HANDLER_ALIASES);
        this.searchHandlerClass = this.getString(properties, SEARCH_HANDLER, "db", SEARCH_HANDLER_ALIASES);
        if ("elasticsearch".equals(this.searchHandlerClass)) {
            throw new IllegalStateException("Since Cyclos 4.16, the search handler 'elasticsearch' is no longer supported. Change it to 'opensearch' instead, and adjust the connection parameters.");
        }
        this.searchHandlerProperties = PropertiesHelper.getSubProperties(properties, "cyclos.searchHandler.");
        this.clusterHandlerClass = this.getString(properties, CLUSTER_HANDLER, "none", CLUSTER_HANDLER_ALIASES);
        this.storedFileContentManagerClass = this.getString(properties, STORED_FILE_CONTENT_MANAGER, "db", STORED_FILE_CONTENT_MANAGER_ALIASES);
        this.storedFileContentManagerProperties = PropertiesHelper.getSubProperties(properties, "cyclos.storedFileContentManager.");
        this.storedFileContentManagerProperties.remove(STORED_FILE_CONTENT_MANAGER);
        this.idMaskClass = this.getString(properties, ID_MASK, "cipher", ID_MASK_ALIASES);
        this.nfcTokenTypeKey = this.getString(properties, NFC_TOKEN_TYPE_KEY, "zero");
        this.maxBCryptStrength = this.getInt(properties, MAX_BCRYPT_STRENGTH, 10);
        this.licenseUrl = this.getString(properties, LICENSE_URL, "https://license.cyclos.org");
        this.licenseIgnoreIssueReports = this.getBoolean(properties, LICENSE_IGNORE_ISSUE_REPORTS);
        this.cacheSpecs = PropertiesHelper.getSubProperties(properties, CACHE_PREFIX);
        this.defaultCacheSpecs = PropertiesHelper.getSubProperties(this.cacheSpecs, "default.");
        this.mailSleepSeconds = this.getInt(properties, MAIL_SLEEP_SECONDS);
        this.cacheQueries = this.getBoolean(properties, QUERY_CACHE);
        this.maxBackgroundTasks = this.getInt(properties, MAX_BACKGROUND_TASKS);
        this.maxRecurringTasks = this.getInt(properties, MAX_RECURRING_TASKS);
        this.dataSourceProviderProperties = PropertiesHelper.getSubProperties(properties, DATASOURCE_PREFIX);
        this.postProcessDataSource(this.dataSourceProviderClass, this.dataSourceProviderProperties, DATASOURCE_PREFIX);
        this.readOnlyDataSourceProviderProperties = new Properties();
        this.readOnlyDataSourceProviderProperties.putAll((Map<?, ?>)this.dataSourceProviderProperties);
        Properties properties2 = PropertiesHelper.getSubProperties(properties, READONLY_DATASOURCE_PREFIX);
        this.postProcessDataSource(this.dataSourceProviderClass, properties2, READONLY_DATASOURCE_PREFIX);
        this.readOnlyDataSourceProviderProperties.putAll((Map<?, ?>)properties2);
        this.useReadOnlyDataSource = !this.dataSourceProviderProperties.equals(this.readOnlyDataSourceProviderProperties);
        this.dumpAllErrors = this.getBoolean(properties, DUMP_ALL_ERRORS);
        this.skipEmails = this.getBoolean(properties, SKIP_EMAILS);
        this.corsOrigins = Collections.unmodifiableList(StringHelper.splitTrimming((String)this.getString(properties, CORS_ORIGIN, null), (String)","));
        this.restReference = this.getBoolean(properties, REST_REFERENCE, true);
        this.disableSearchEnginesIndexing = this.getBoolean(properties, DISABLE_SEARCH_ENGINES_INDEXING);
        this.webServicesGzip = this.getBoolean(properties, WEB_SERVICES_GZIP, true);
        this.purgeMessagesOnTrashDays = this.getInt(properties, PURGE_MESSAGES_ON_TRASH_DAYS, 30);
        this.purgeNotificationsDays = this.getInt(properties, PURGE_NOTIFICATIONS_DAYS, 30);
        this.purgeUnconfirmedUsersDays = this.getInt(properties, PURGE_UNCONFIRMED_USERS_DAYS, 7);
        this.purgeLoginLogsDays = this.getInt(properties, PURGE_LOGIN_LOGS_DAYS, 365);
        this.purgeSessionsDays = this.getInt(properties, PURGE_SESSIONS_DAYS);
        this.expireExternalPaymentsDays = this.getInt(properties, EXPIRE_EXTERNAL_PAYMENTS_DAYS, 30);
        this.accountsVerificationBalanceCheckDays = this.getBalanceCheckDays(properties);
        this.archiveImportsDays = this.getInt(properties, ARCHIVE_IMPORTS_DAYS, 30);
        this.archiveAccountFeesDays = this.getInt(properties, ARCHIVE_ACCOUNT_FEES_DAYS, 0);
        this.archiveBulkActionsDays = this.getInt(properties, ARCHIVE_BULK_ACTIONS_DAYS, 0);
        this.archivingMonths = this.getInt(properties, ARCHIVING_MONTHS, 0);
        this.archivingUrl = this.getString(properties, ARCHIVING_URL, null);
        if (!this.development && this.archivingMonths > 0 != (this.archivingUrl != null)) {
            throw new IllegalStateException(String.format("You must either set both or none of %s and %s", ARCHIVING_MONTHS, ARCHIVING_URL));
        }
        this.archivingUser = this.getString(properties, ARCHIVING_USER, null);
        this.archivingPassword = this.getString(properties, ARCHIVING_PASSWORD, null);
        this.archivingTrustAllCerts = this.getBoolean(properties, ARCHIVING_TRUST_ALL_CERTS);
        this.archivingWaitTimeBetweenDeletesMillis = this.getInt(properties, ARCHIVING_WAIT_TIME_BETWEEN_DELETES_MILLIS, 2000);
        this.archivingDeleteStartHour = this.getInt(properties, ARCHIVING_DELETE_START_HOUR, 0);
        if (this.archivingDeleteStartHour < 0 || this.archivingDeleteStartHour > 23) {
            throw new IllegalStateException("The archiving delete start hour (cyclos.archiving.deleteStartHour) must be between 0 and 23");
        }
        this.archivingDeleteDurationMinutes = this.getInt(properties, ARCHIVING_DELETE_DURATION_MINUTES, 240);
        if (this.archivingDeleteDurationMinutes < 1 || this.archivingDeleteDurationMinutes > 1440) {
            throw new IllegalStateException("The archiving delete duration minutes (cyclos.archiving.deleteDurationMinutes) must be between 1 and 1440 minutes");
        }
        this.remoteAddressHeader = this.getString(properties, HEADER_REMOTE_ADDRESS, null);
        this.remoteAddressHeaderIndex = this.getInt(properties, HEADER_REMOTE_ADDRESS_INDEX, 0);
        this.protocolHeader = this.getString(properties, HEADER_PROTOCOL, null);
        this.sessionsAnyAddress = this.getBoolean(properties, SESSIONS_ANY_ADDRESS, true);
        this.forceFlushOnEveryTransaction = this.getBoolean(properties, FORCE_FLUSH_ON_EVERY_TRANSACTION);
        this.synchronousLog = this.getBoolean(properties, LOG_SYNCHRONOUS);
        this.logProviderClass = this.getString(properties, LOG_PROVIDER, "file", LOG_PROVIDER_ALIASES);
        this.logDir = this.getString(properties, LOG_DIR, DEFAULT_LOG_DIR);
        this.logMaxFiles = this.getInt(properties, LOG_MAX_FILES, 5);
        this.logMaxFileSize = this.getFileSize(properties, LOG_MAX_FILE_SIZE, DEFAULT_MAX_LOG_FILE_SIZE);
        this.logDataSourceProviderClass = this.getString(properties, "cyclos.log.datasource.provider", "hikari", DATASOURCE_PROVIDER_ALIASES);
        this.logDataSourceProviderProperties = PropertiesHelper.getSubProperties(properties, LOG_DATASOURCE_PREFIX);
        this.postProcessDataSource(this.logDataSourceProviderClass, this.logDataSourceProviderProperties, LOG_DATASOURCE_PREFIX);
        this.isSkipInitializations = this.getBoolean(properties, SKIP_INITIALIZATIONS);
        this.sassExecutable = this.getString(properties, SASS_EXECUTABLE, null);
        this.rateLimitGlobal = this.getInt(properties, RATE_LIMIT_GLOBAL, 0);
        this.rateLimitIp = this.getInt(properties, RATE_LIMIT_IP, 0);
        this.rateLimitWhitelist = this.getString(properties, RATE_LIMIT_WHITELIST, null);
        this.licenseMaxUsersAlertPercentage = this.getInt(properties, LICENSE_MAX_USERS_ALERT_PERCENTAGE, 95);
        this.profilingMaxEntries = this.getInt(properties, PROFILING_MAX_ENTRIES, 10000);
        HashMap hashMap2 = new HashMap();
        PropertiesHelper.getSubProperties(properties, RESPONSE_HEADERS_PREFIX).forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(object, object2) -> hashMap2.put(StringHelper.trim((Object)object).toLowerCase(), StringHelper.trim((Object)object2))));
        this.responseHeaders = Collections.unmodifiableMap(hashMap2);
        this.isTestingEnv = "org.cyclos.db.TestPopulator".equals(this.dbPopulatorClass);
    }

    public Set<WeekDay> getAccountsVerificationBalanceCheckDays() {
        return this.accountsVerificationBalanceCheckDays;
    }

    public int getArchiveAccountFeesDays() {
        return this.archiveAccountFeesDays;
    }

    public int getArchiveBulkActionsDays() {
        return this.archiveBulkActionsDays;
    }

    public int getArchiveImportsDays() {
        return this.archiveImportsDays;
    }

    public int getArchivingDeleteDurationMinutes() {
        return this.archivingDeleteDurationMinutes;
    }

    public int getArchivingDeleteStartHour() {
        return this.archivingDeleteStartHour;
    }

    public int getArchivingMonths() {
        return this.archivingMonths;
    }

    public String getArchivingPassword() {
        return this.archivingPassword;
    }

    public String getArchivingUrl() {
        return this.archivingUrl;
    }

    public String getArchivingUser() {
        return this.archivingUser;
    }

    public int getArchivingWaitTimeBetweenDeletesMillis() {
        return this.archivingWaitTimeBetweenDeletesMillis;
    }

    @Nonnull
    public CacheBuilderSpec getCacheSpec(String string) {
        Properties properties = (Properties)this.defaultCacheSpecs.clone();
        Object[] objectArray = string.split("\\.");
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = StringUtils.join((Object[])objectArray, (String)".", (int)0, (int)(i + 1));
            Properties object = PropertiesHelper.getSubProperties(this.cacheSpecs, (String)string2 + ".");
            properties.putAll((Map<?, ?>)object);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : properties.entrySet()) {
            String string2 = StringHelper.trimToNull(entry.getKey());
            if (!ArrayUtils.contains((Object[])ALLOWED_CACHE_PROPERTIES, (Object)string2)) continue;
            String string3 = StringHelper.trimToNull(entry.getValue());
            if (string2 == null || string3 == null) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(string2).append('=').append(string3);
        }
        if (stringBuilder.length() == 0 || "0".equals(properties.get("maximumSize"))) {
            return CacheBuilderSpec.disableCaching();
        }
        return CacheBuilderSpec.parse((String)stringBuilder.toString());
    }

    @Nonnull
    public String getClusterHandlerClass() {
        return this.clusterHandlerClass;
    }

    @Nonnull
    public List<String> getCorsOrigins() {
        return this.corsOrigins;
    }

    @Nonnull
    public Map<String, String> getCyclosProperties() {
        return this.cyclosProperties;
    }

    @Nonnull
    public String getDataSourceProviderClass() {
        return this.dataSourceProviderClass;
    }

    @Nonnull
    public Properties getDataSourceProviderProperties() {
        return this.dataSourceProviderProperties;
    }

    @Nonnull
    public String getDbPopulatorClass() {
        return this.dbPopulatorClass;
    }

    @Nonnull
    public String getDbQueryHandlerClass() {
        return this.dbQueryHandlerClass;
    }

    @Nonnull
    public int getExpireExternalPaymentsDays() {
        return this.expireExternalPaymentsDays;
    }

    @Nonnull
    public String getIdMaskClass() {
        return this.idMaskClass;
    }

    public int getLicenseMaxUsersAlertPercentage() {
        return this.licenseMaxUsersAlertPercentage;
    }

    @Nonnull
    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    public String getLogDataSourceProviderClass() {
        return this.logDataSourceProviderClass;
    }

    public Properties getLogDataSourceProviderProperties() {
        return this.logDataSourceProviderProperties;
    }

    @Nonnull
    public String getLogDir() {
        return this.logDir;
    }

    public int getLogMaxFiles() {
        return this.logMaxFiles;
    }

    public int getLogMaxFileSize() {
        return this.logMaxFileSize;
    }

    public String getLogProviderClass() {
        return this.logProviderClass;
    }

    public int getMailSleepSeconds() {
        return this.mailSleepSeconds;
    }

    public int getMaxBackgroundTasks() {
        return this.maxBackgroundTasks;
    }

    public int getMaxBCryptStrength() {
        return this.maxBCryptStrength;
    }

    public Integer getMaxPoolSize() {
        Properties properties = this.getDataSourceProviderProperties();
        switch (this.dataSourceProviderClass) {
            case "org.cyclos.bootstrap.HikariDataSourceProvider": {
                return (Integer)CoercionHelper.coerce(Integer.class, (Object)properties.getProperty(HIKARI_MAX_POOL_SIZE));
            }
            case "org.cyclos.bootstrap.C3P0DataSourceProvider": {
                return (Integer)CoercionHelper.coerce(Integer.class, (Object)properties.getProperty(C3P0_MAX_POOL_SIZE));
            }
        }
        return null;
    }

    public int getMaxRecurringTasks() {
        return this.maxRecurringTasks;
    }

    @Nonnull
    public String getNFCTokenTypeKey() {
        return this.nfcTokenTypeKey;
    }

    public int getProfilingMaxEntries() {
        return this.profilingMaxEntries;
    }

    @Nonnull
    public Properties getProperties() {
        return this.properties;
    }

    public String getProtocolHeader() {
        return this.protocolHeader;
    }

    public int getPurgeLoginLogsDays() {
        return this.purgeLoginLogsDays;
    }

    public int getPurgeMessagesOnTrashDays() {
        return this.purgeMessagesOnTrashDays;
    }

    public int getPurgeNotificationsDays() {
        return this.purgeNotificationsDays;
    }

    public int getPurgeSessionsDays() {
        return this.purgeSessionsDays;
    }

    public int getPurgeUnconfirmedUsersDays() {
        return this.purgeUnconfirmedUsersDays;
    }

    public int getRateLimitGlobal() {
        return this.rateLimitGlobal;
    }

    public int getRateLimitIp() {
        return this.rateLimitIp;
    }

    public String getRateLimitWhitelist() {
        return this.rateLimitWhitelist;
    }

    @Nonnull
    public Properties getReadOnlyDataSourceProviderProperties() {
        return this.readOnlyDataSourceProviderProperties;
    }

    public String getRemoteAddressHeader() {
        return this.remoteAddressHeader;
    }

    public int getRemoteAddressHeaderIndex() {
        return this.remoteAddressHeaderIndex;
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getSassExecutable() {
        return this.sassExecutable;
    }

    @Nonnull
    public String getSearchHandlerClass() {
        return this.searchHandlerClass;
    }

    @Nonnull
    public Properties getSearchHandlerProperties() {
        return this.searchHandlerProperties;
    }

    @Nonnull
    public String getStoredFileContentManagerClass() {
        return this.storedFileContentManagerClass;
    }

    @Nonnull
    public Properties getStoredFileContentManagerProperties() {
        return this.storedFileContentManagerProperties;
    }

    @Nonnull
    public File getTempDir() {
        return this.tempDir;
    }

    public File getTempFilesDir() {
        return this.tempFilesDir;
    }

    public boolean isArchivingTrustAllCerts() {
        return this.archivingTrustAllCerts;
    }

    public boolean isCacheQueries() {
        return this.cacheQueries;
    }

    public boolean isDbManaged() {
        return this.dbManaged;
    }

    public boolean isDebuggableEnv() {
        return "org.cyclos.db.TestPopulator".equals(this.dbPopulatorClass) || "org.cyclos.db.development.DevelopmentPopulator".equals(this.dbPopulatorClass);
    }

    public boolean isDevelopment() {
        return this.development;
    }

    public boolean isDisableSearchEnginesIndexing() {
        return this.disableSearchEnginesIndexing;
    }

    public boolean isDumpAllErrors() {
        return this.dumpAllErrors;
    }

    public boolean isForceFlushOnEveryTransaction() {
        return this.forceFlushOnEveryTransaction;
    }

    public boolean isLicenseIgnoreIssueReports() {
        return this.licenseIgnoreIssueReports;
    }

    public boolean isRestReference() {
        return this.restReference;
    }

    public boolean isSessionsAnyAddress() {
        return this.sessionsAnyAddress;
    }

    public boolean isSkipEmails() {
        return this.skipEmails;
    }

    public boolean isSkipInitializations() {
        return this.isSkipInitializations;
    }

    public boolean isSynchronousLog() {
        return this.synchronousLog;
    }

    public boolean isTestingEnv() {
        return this.isTestingEnv;
    }

    public boolean isUseReadOnlyDataSource() {
        return this.useReadOnlyDataSource;
    }

    public boolean isUsingOpenSearch() {
        return CyclosProperties.isUsingOpenSearch(this.getSearchHandlerClass());
    }

    public boolean isWebServicesGzip() {
        return this.webServicesGzip;
    }

    public File newTempDir() {
        boolean bl;
        File file = this.newTempFile("temp", "dir");
        boolean bl2 = file.delete();
        boolean bl3 = bl = bl2 ? file.mkdirs() : false;
        if (!bl) {
            throw new IllegalStateException("Could not create temporary directory: " + String.valueOf(file));
        }
        return file;
    }

    public File newTempFile(String string, String string2) {
        try {
            return File.createTempFile(string, string2, this.tempFilesDir);
        }
        catch (IOException iOException) {
            if (!this.tempFilesDir.exists() && this.tempFilesDir.mkdirs()) {
                try {
                    return File.createTempFile(string, string2, this.tempFilesDir);
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            throw new UncheckedIOException(iOException);
        }
    }

    @Nonnull
    public File resolveFile(String string) {
        string = StringHelper.replace((String)string, (String)"%t", (String)System.getProperty("java.io.tmpdir"));
        return new File(string);
    }

    private void autoConfigureMaxPoolSize(String string, Properties properties) {
        if (this.isAutoConfiguring((String)properties.get(string))) {
            int n = Runtime.getRuntime().availableProcessors();
            properties.setProperty(string, String.valueOf(Math.max(8, Math.min(150, this.maxRecurringTasks + this.maxBackgroundTasks + n))));
        }
    }

    private Set<WeekDay> getBalanceCheckDays(Properties properties) {
        String string = this.getString(properties, ACCOUNTS_VERIFICATION_BALANCE_CHECK_DAYS, "always");
        if ("always".equals(string)) {
            return Collections.unmodifiableSet(new LinkedHashSet<WeekDay>(Arrays.asList(WeekDay.values())));
        }
        if ("never".equals(string)) {
            return Collections.emptySet();
        }
        try {
            return StringHelper.splitTrimming((String)string, (String)",").stream().mapToInt(Integer::parseInt).mapToObj(n -> WeekDay.values()[n]).collect(Collectors.toSet());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid value for cyclos.accountsVerification.balanceCheckDays: " + string);
        }
    }

    private boolean getBoolean(Properties properties, String string) {
        return this.getBoolean(properties, string, false);
    }

    private boolean getBoolean(Properties properties, String string, boolean bl) {
        String string2 = this.getString(properties, string, String.valueOf(bl));
        return Boolean.parseBoolean(string2);
    }

    private File getFile(Properties properties, String string, String string2, Map<String, String> map) {
        String string3 = this.getString(properties, string, string2);
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                string3 = string3.replace(entry.getKey(), entry.getValue());
            }
        }
        return this.resolveFile(string3);
    }

    private int getFileSize(Properties properties, String string, String string2) {
        int n;
        String string3 = this.getString(properties, string, string2).toLowerCase();
        int n2 = 1;
        if (string3 != null) {
            if (string3.endsWith("k") || string3.endsWith("kb")) {
                n2 = 1024;
                string3 = StringHelper.trimToNull((Object)StringUtils.substringBefore((String)string3, (String)"k"));
            } else if (string3.endsWith("m") || string3.endsWith("mb")) {
                n2 = 0x100000;
                string3 = StringHelper.trimToNull((Object)StringUtils.substringBefore((String)string3, (String)"m"));
            }
        }
        try {
            n = string3 == null ? 0 : Integer.parseInt(string3) * n2;
        }
        catch (Exception exception) {
            n = 0;
        }
        return n;
    }

    private int getInt(Properties properties, String string) {
        return this.getInt(properties, string, 0);
    }

    private int getInt(Properties properties, String string, int n) {
        long l = this.getLong(properties, string, n);
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    private long getLong(Properties properties, String string, long l) {
        String string2 = this.getString(properties, string, String.valueOf(l));
        try {
            return Long.parseLong(string2);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid value for '" + string + "' in cyclos.properties. Expected an integer, but was " + string2);
        }
    }

    private String getString(Properties properties, String string, String string2) {
        String string3 = StringHelper.trimToNull((Object)properties.get(string));
        return string3 == null ? string2 : string3;
    }

    private String getString(Properties properties, String string, String string2, Map<String, String> map) {
        String string3 = this.getString(properties, string, string2);
        String string4 = map == null ? null : map.get(string3);
        return (String)ObjectHelper.defaultValue((Object)string4, (Object)string3);
    }

    private boolean isAutoConfiguring(String string) {
        return "auto".equalsIgnoreCase(string);
    }

    private void postProcessDataSource(String string, Properties properties, String string2) {
        if (C3P0_PROVIDER_CLASS.equals(string)) {
            if (StringHelper.isBlank((Object)properties.get(C3P0_CONNECTION_TESTER_KEY))) {
                properties.put(C3P0_CONNECTION_TESTER_KEY, C3P0_CONNECTION_TESTER_CLASS);
            }
            this.autoConfigureMaxPoolSize(C3P0_MAX_POOL_SIZE, properties);
            if (properties.containsKey(C3P0_MAX_POOL_SIZE)) {
                this.cyclosProperties.put(string2 + C3P0_MAX_POOL_SIZE, (String)properties.get(C3P0_MAX_POOL_SIZE));
            }
        } else if (HIKARI_PROVIDER_CLASS.equals(string)) {
            this.autoConfigureMaxPoolSize(HIKARI_MAX_POOL_SIZE, properties);
            if (properties.containsKey(HIKARI_MAX_POOL_SIZE)) {
                this.cyclosProperties.put(string2 + HIKARI_MAX_POOL_SIZE, (String)properties.get(HIKARI_MAX_POOL_SIZE));
            }
        }
        properties.remove(DATASOURCE_PROVIDER_SUFFIX);
        properties.keySet().removeIf(object -> object.toString().startsWith("readOnly."));
    }

    private void postProcessTaskWorkers(Properties properties) {
        int n = Runtime.getRuntime().availableProcessors();
        boolean bl = false;
        String string = this.getString(properties, MAX_BACKGROUND_TASKS, "auto");
        if (this.isAutoConfiguring(string)) {
            properties.setProperty(MAX_BACKGROUND_TASKS, String.valueOf(n));
        } else if ("0".equals(string)) {
            bl = true;
        }
        string = this.getString(properties, MAX_RECURRING_TASKS, "auto");
        if (this.isAutoConfiguring(string)) {
            properties.setProperty(MAX_RECURRING_TASKS, String.valueOf(Math.min(8, (int)Math.ceil(n / 2))));
        } else if ("0".equals(string)) {
            bl = true;
        }
        if (bl) {
            properties.setProperty(MAX_BACKGROUND_TASKS, "0");
            properties.setProperty(MAX_RECURRING_TASKS, "0");
        }
    }

    static {
        QUERY_HANDLER_ALIASES.put("postgresql", "org.cyclos.impl.sql.postgresql.PostgresqlQueryHandlerImpl");
        SEARCH_HANDLER_ALIASES = new HashMap<String, String>();
        SEARCH_HANDLER_ALIASES.put("db", "org.cyclos.impl.search.DbSearchHandlerImpl");
        SEARCH_HANDLER_ALIASES.put("opensearch", "org.cyclos.impl.search.opensearch.OpenSearchHandlerImpl");
        CLUSTER_HANDLER_ALIASES = new HashMap<String, String>();
        CLUSTER_HANDLER_ALIASES.put("none", "org.cyclos.impl.utils.cluster.NoClusterHandlerImpl");
        CLUSTER_HANDLER_ALIASES.put("hazelcast", "org.cyclos.impl.utils.cluster.HazelcastClusterHandlerImpl");
        DATASOURCE_PROVIDER_ALIASES = new HashMap<String, String>();
        DATASOURCE_PROVIDER_ALIASES.put("hikari", HIKARI_PROVIDER_CLASS);
        DATASOURCE_PROVIDER_ALIASES.put("c3p0", C3P0_PROVIDER_CLASS);
        DATASOURCE_PROVIDER_ALIASES.put("jndi", "org.cyclos.bootstrap.JndiDataSourceProvider");
        ID_MASK_ALIASES = new HashMap<String, String>();
        ID_MASK_ALIASES.put("none", "org.cyclos.impl.utils.NoOpIdMask");
        ID_MASK_ALIASES.put("cipher", "org.cyclos.impl.utils.IdMaskCipher");
        STORED_FILE_CONTENT_MANAGER_ALIASES = new HashMap<String, String>();
        STORED_FILE_CONTENT_MANAGER_ALIASES.put("db", "org.cyclos.impl.storage.DbStoredFileContentManagerImpl");
        STORED_FILE_CONTENT_MANAGER_ALIASES.put("file", "org.cyclos.impl.storage.FsStoredFileContentManagerImpl");
        STORED_FILE_CONTENT_MANAGER_ALIASES.put("s3", "org.cyclos.impl.storage.AmazonS3StoredFileContentManagerImpl");
        STORED_FILE_CONTENT_MANAGER_ALIASES.put("gcs", "org.cyclos.impl.storage.GoogleCloudStoredFileContentManagerImpl");
        LOG_PROVIDER_ALIASES = new HashMap<String, String>();
        LOG_PROVIDER_ALIASES.put("console", "org.cyclos.impl.logging.ConsoleLogProvider");
        LOG_PROVIDER_ALIASES.put("file", "org.cyclos.impl.logging.FileLogProvider");
        LOG_PROVIDER_ALIASES.put("db", "org.cyclos.impl.logging.DatabaseLogProvider");
        LOG_PROVIDER_ALIASES.put("none", "org.cyclos.impl.logging.NoOpLogProvider");
    }
}

