/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils;

import com.mysema.commons.lang.CloseableIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.collections4.IteratorUtils;
import org.cyclos.server.utils.CloseableIteratorAdapter;
import org.cyclos.server.utils.DataIterator;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Pair;

public class CloseableIteratorHelper {
    private static final CloseableIterator<?> EMPTY = new CloseableIterator<Object>(){

        public void close() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }
    };

    public static <T> DataIterator<T> asDataIterator(CloseableIterator<T> closeableIterator) {
        return CloseableIteratorHelper.asDataIterator(closeableIterator, false);
    }

    public static <T> DataIterator<T> asDataIterator(final CloseableIterator<T> closeableIterator, final boolean bl) {
        return new DataIterator<T>(){

            public void close() {
                closeableIterator.close();
            }

            public boolean hasNext() {
                return closeableIterator.hasNext();
            }

            public boolean isPartialData() {
                return bl;
            }

            public T next() {
                return closeableIterator.next();
            }
        };
    }

    @Deprecated
    public static <T> Stream<T> asStream(CloseableIterator<T> closeableIterator) {
        return CollectionHelper.asStream(closeableIterator);
    }

    @SafeVarargs
    public static <T> CloseableIterator<T> chained(final CloseableIterator<? extends T> ... closeableIteratorArray) {
        if (CollectionHelper.isEmpty((Object[])closeableIteratorArray)) {
            return CloseableIteratorHelper.empty();
        }
        Iterator iterator = IteratorUtils.chainedIterator(closeableIteratorArray);
        return new CloseableIteratorAdapter<T>(iterator){

            @Override
            public void close() {
                ArrayList<Exception> arrayList = null;
                for (CloseableIterator closeableIterator : closeableIteratorArray) {
                    try {
                        closeableIterator.close();
                    }
                    catch (Exception exception) {
                        if (arrayList == null) {
                            arrayList = new ArrayList<Exception>();
                        }
                        arrayList.add(exception);
                    }
                }
                if (arrayList != null) {
                    RuntimeException runtimeException = new RuntimeException("Error closing a CloseableIterator. See suppressed exceptions");
                    arrayList.forEach(runtimeException::addSuppressed);
                    throw runtimeException;
                }
            }
        };
    }

    public static <T> CloseableIterator<T> empty() {
        return EMPTY;
    }

    public static <T> CloseableIterator<T> filtered(CloseableIterator<T> closeableIterator, Predicate<T> predicate) {
        return new FilteredCloseableIterator<T>(closeableIterator, predicate);
    }

    public static <T> CloseableIterator<T> lazy(Supplier<CloseableIterator<T>> supplier) {
        return new LazyCloseableIterator<T>(supplier);
    }

    public static <T> Pair<T, CloseableIterator<T>> peekFirst(CloseableIterator<T> closeableIterator) {
        if (closeableIterator == null || !closeableIterator.hasNext()) {
            return Pair.create(null, closeableIterator);
        }
        Object object = closeableIterator.next();
        CloseableIterator<T> closeableIterator2 = CloseableIteratorHelper.chained(CloseableIteratorHelper.singleton(object), closeableIterator);
        return Pair.create((Object)object, closeableIterator2);
    }

    public static <T> CloseableIterator<T> singleton(T t) {
        return new CloseableIteratorAdapter<T>(Collections.singleton(t).iterator());
    }

    private static class FilteredCloseableIterator<T>
    implements CloseableIterator<T> {
        private final CloseableIterator<T> iterator;
        private final Predicate<T> filter;
        private T next;

        public FilteredCloseableIterator(CloseableIterator<T> closeableIterator, Predicate<T> predicate) {
            this.iterator = closeableIterator;
            this.filter = predicate;
            this.advanceIterator();
        }

        public void close() {
            this.iterator.close();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public T next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            T t = this.next;
            this.advanceIterator();
            return t;
        }

        private void advanceIterator() {
            do {
                if (this.iterator.hasNext()) {
                    this.next = this.iterator.next();
                    if (this.filter.test(this.next)) continue;
                    this.next = null;
                    continue;
                }
                this.next = null;
            } while (this.next == null && this.iterator.hasNext());
        }
    }

    private static class LazyCloseableIterator<T>
    implements CloseableIterator<T> {
        private CloseableIterator<T> iterator;
        private final Supplier<CloseableIterator<T>> supplier;

        public LazyCloseableIterator(Supplier<CloseableIterator<T>> supplier) {
            this.supplier = supplier;
        }

        public void close() {
            if (this.iterator != null) {
                this.iterator.close();
            }
        }

        public boolean hasNext() {
            return this.iterator().hasNext();
        }

        public T next() {
            return (T)this.iterator().next();
        }

        private CloseableIterator<T> iterator() {
            if (this.iterator == null) {
                this.iterator = this.supplier.get();
            }
            return this.iterator;
        }
    }
}

