/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.utils.coercion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.coercion.BigDecimalCoercer;
import org.cyclos.utils.coercion.BigIntegerCoercer;
import org.cyclos.utils.coercion.BooleanCoercer;
import org.cyclos.utils.coercion.ByteCoercer;
import org.cyclos.utils.coercion.Coercer;
import org.cyclos.utils.coercion.CoercionException;
import org.cyclos.utils.coercion.DoubleCoercer;
import org.cyclos.utils.coercion.FloatCoercer;
import org.cyclos.utils.coercion.IntegerCoercer;
import org.cyclos.utils.coercion.LongCoercer;
import org.cyclos.utils.coercion.NumberCoercer;
import org.cyclos.utils.coercion.ShortCoercer;
import org.cyclos.utils.coercion.StringCoercer;

public class CoercionHelper {
    private static Map<Class<?>, Coercer<?>> COERCERS = new HashMap();
    private static final Map<Class<?>, Class<?>> PRIMITIVES = new HashMap();

    public static <T> T coerce(Class<T> object, Object comparable) throws CoercionException {
        Coercer<?> coercer;
        if ("".equals(comparable) && object != String.class) {
            comparable = null;
        }
        if (((Class)object).isPrimitive()) {
            coercer = PRIMITIVES.get(object);
            if (comparable == null) {
                comparable = object.equals(Boolean.TYPE) ? (Comparable<Boolean>)Boolean.valueOf(false) : (Comparable<Boolean>)Integer.valueOf(0);
            }
            object = coercer;
        }
        if (comparable == null) {
            return null;
        }
        coercer = COERCERS.get(object);
        if (coercer == null) {
            if (((Class)object).isEnum()) {
                String string = comparable instanceof Enum ? ((Enum)((Object)comparable)).name() : comparable.toString();
                try {
                    return Enum.valueOf(object, string);
                }
                catch (Exception exception) {
                    try {
                        String string2 = StringHelper.transformCase(string, true, '_');
                        return Enum.valueOf(object, string2);
                    }
                    catch (Exception exception2) {
                        throw new CoercionException(string, exception2);
                    }
                }
            }
            String string = ((Class)object).getName();
            if (CoercionHelper.isSet(string)) {
                return (T)CoercionHelper.coerceSet(Object.class, comparable);
            }
            if (CoercionHelper.isList(string) || CoercionHelper.isCollection(string)) {
                return (T)CoercionHelper.coerceList(Object.class, comparable);
            }
            return (T)comparable;
        }
        try {
            return (T)coercer.coerce(comparable);
        }
        catch (CoercionException coercionException) {
            if (coercionException.getValue() == null) {
                coercionException.setValue(comparable.toString());
            }
            throw coercionException;
        }
        catch (Exception exception) {
            throw new CoercionException(comparable.toString(), exception);
        }
    }

    public static <T> List<T> coerceList(Class<T> clazz, Object object) {
        ArrayList arrayList = new ArrayList();
        CoercionHelper.addToCollection(arrayList, clazz, object);
        return arrayList;
    }

    public static <K, V> Map<K, V> coerceMap(Class<K> clazz, Class<V> clazz2, Object object) {
        HashMap hashMap = new HashMap();
        CoercionHelper.addToMap(hashMap, clazz, clazz2, object);
        return hashMap;
    }

    public static <T> Page<T> coercePage(Class<T> clazz, Object object) {
        if (object instanceof PageImpl) {
            return (Page)object;
        }
        return CollectionHelper.asPage(CoercionHelper.coerceList(clazz, object));
    }

    public static <T> Set<T> coerceSet(Class<T> clazz, Object object) {
        HashSet hashSet = new HashSet();
        CoercionHelper.addToCollection(hashSet, clazz, object);
        return hashSet;
    }

    public static boolean isCollection(String string) {
        return string.equals("java.util.Collection");
    }

    public static boolean isList(String string) {
        return string.equals("java.util.List") || string.equals("java.util.ArrayList") || string.equals("java.util.LinkedList") || string.equals("org.cyclos.utils.Page") || string.equals("org.cyclos.utils.PageImpl");
    }

    public static boolean isSet(String string) {
        return string.equals("java.util.Set") || string.equals("java.util.HashSet") || string.equals("java.util.LinkedHashSet") || string.equals("java.util.TreeSet");
    }

    public static Iterator<?> toIterator(Object object) {
        if (object == null) {
            return Collections.emptySet().iterator();
        }
        if (object instanceof Collection) {
            return ((Collection)object).iterator();
        }
        if (object instanceof Object[]) {
            return Arrays.asList((Object[])object).iterator();
        }
        if (object instanceof Iterator) {
            return (Iterator)object;
        }
        if (object instanceof Map) {
            return ((Map)object).entrySet().iterator();
        }
        return Collections.singleton(object).iterator();
    }

    public static boolean understands(Class<?> clazz) {
        return clazz != null && (PRIMITIVES.containsKey(clazz) || COERCERS.containsKey(clazz) || clazz.isEnum());
    }

    public static Class<?> wrapperClass(Class<?> clazz) {
        return PRIMITIVES.get(clazz);
    }

    private static <T> void addToCollection(Collection<T> collection, Class<T> clazz, Object object) {
        Iterator<?> iterator = CoercionHelper.toIterator(object);
        while (iterator.hasNext()) {
            collection.add(CoercionHelper.coerce(clazz, iterator.next()));
        }
    }

    private static <K, V> void addToMap(Map<K, V> map, Class<K> clazz, Class<V> clazz2, Object object) {
        Iterator<?> iterator = CoercionHelper.toIterator(object);
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            map.put(CoercionHelper.coerce(clazz, entry.getKey()), CoercionHelper.coerce(clazz2, entry.getValue()));
        }
    }

    private static void register(Coercer<?> coercer) {
        COERCERS.put(coercer.getToType(), coercer);
    }

    static {
        PRIMITIVES.put(Boolean.TYPE, Boolean.class);
        PRIMITIVES.put(Byte.TYPE, Byte.class);
        PRIMITIVES.put(Short.TYPE, Short.class);
        PRIMITIVES.put(Integer.TYPE, Integer.class);
        PRIMITIVES.put(Long.TYPE, Long.class);
        PRIMITIVES.put(Float.TYPE, Float.class);
        PRIMITIVES.put(Double.TYPE, Double.class);
        PRIMITIVES.put(Character.TYPE, Character.class);
        CoercionHelper.register(new BigDecimalCoercer());
        CoercionHelper.register(new BigIntegerCoercer());
        CoercionHelper.register(new BooleanCoercer());
        CoercionHelper.register(new ByteCoercer());
        CoercionHelper.register(new DoubleCoercer());
        CoercionHelper.register(new FloatCoercer());
        CoercionHelper.register(new IntegerCoercer());
        CoercionHelper.register(new LongCoercer());
        CoercionHelper.register(new ShortCoercer());
        CoercionHelper.register(new NumberCoercer());
        CoercionHelper.register(new StringCoercer());
    }
}

