/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.utils;

import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.GwtIncompatible;

public class ObjectHelper {
    public static boolean anyIsNull(Object ... objectArray) {
        if (CollectionHelper.isEmpty(objectArray)) {
            return true;
        }
        for (Object object : objectArray) {
            if (object != null) continue;
            return true;
        }
        return false;
    }

    public static boolean areAllNulls(Object ... objectArray) {
        if (CollectionHelper.isEmpty(objectArray)) {
            return true;
        }
        for (Object object : objectArray) {
            if (object == null) continue;
            return false;
        }
        return true;
    }

    @SafeVarargs
    public static <T> T coalesce(T ... TArray) {
        for (T t : TArray) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public static <T, R> R defaultValue(R r, T t, Function<T, R> function) {
        return r == null ? function.apply(t) : r;
    }

    public static <T, U, R> R defaultValue(R r, T t, U u, BiFunction<T, U, R> biFunction) {
        return r == null ? biFunction.apply(t, u) : r;
    }

    public static <T> T defaultValue(T t, Supplier<T> supplier) {
        return t == null ? supplier.get() : t;
    }

    public static <T> T defaultValue(T t, T t2) {
        return t == null ? t2 : t;
    }

    public static Object emptyToNull(Object object) {
        return ObjectHelper.isEmpty(object) ? null : object;
    }

    @GwtIncompatible
    public static <T> T ifType(Object object, Class<T> clazz) {
        if (clazz.isInstance(object)) {
            return (T)object;
        }
        return null;
    }

    public static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String) {
            return ((String)object).isEmpty();
        }
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        if (object instanceof Object[]) {
            return ((Object[])object).length == 0;
        }
        return false;
    }

    public static boolean isNotEmpty(Object object) {
        return !ObjectHelper.isEmpty(object);
    }

    public static boolean isNotOneOf(Object object, Object ... objectArray) {
        return !ObjectHelper.isOneOf(object, objectArray);
    }

    public static boolean isOneOf(Object object, Object ... objectArray) {
        if (object == null || CollectionHelper.isEmpty(objectArray)) {
            return false;
        }
        for (Object object2 : objectArray) {
            if (!object.equals(object2)) continue;
            return true;
        }
        return false;
    }

    public static void requireOneOf(Object object, Object ... objectArray) throws IllegalArgumentException {
        ObjectHelper.requireOneOf(null, object, objectArray);
    }

    public static void requireOneOf(Supplier<String> supplier, Object object, Object ... objectArray) throws IllegalArgumentException {
        if (!ObjectHelper.isOneOf(object, objectArray)) {
            supplier = supplier == null ? () -> String.valueOf(object) + " is not one of the expected elements" : supplier;
            throw new IllegalArgumentException(supplier.get());
        }
    }

    public static <T> T with(Supplier<T> supplier, Consumer<T> consumer) {
        T t = supplier.get();
        consumer.accept(t);
        return t;
    }
}

