/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;

public class BigDecimalHelper {
    private static final BigDecimal POSITIVE_DELTA = new BigDecimal("0.000000001");
    private static final BigDecimal NEGATIVE_DELTA = POSITIVE_DELTA.negate();
    public static final BigDecimal ONE_HUNDRED = BigDecimal.TEN.multiply(BigDecimal.TEN);
    public static final int MAX_SCALE = POSITIVE_DELTA.scale();
    public static final MathContext MATH_CONTEXT = new MathContext(15 + MAX_SCALE, RoundingMode.HALF_UP);

    public static boolean areEquals(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        if (bigDecimal == null || bigDecimal2 == null) {
            return false;
        }
        if (BigDecimalHelper.isZero(bigDecimal) && BigDecimalHelper.isZero(bigDecimal2)) {
            return true;
        }
        return BigDecimalHelper.round(bigDecimal, MAX_SCALE).compareTo(BigDecimalHelper.round(bigDecimal2, MAX_SCALE)) == 0;
    }

    public static boolean areEqualsOrBothNull(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        if (bigDecimal == null && bigDecimal2 == null) {
            return true;
        }
        if (bigDecimal == null || bigDecimal2 == null) {
            return false;
        }
        if (BigDecimalHelper.isZero(bigDecimal) && BigDecimalHelper.isZero(bigDecimal2)) {
            return true;
        }
        return BigDecimalHelper.round(bigDecimal, MAX_SCALE).compareTo(BigDecimalHelper.round(bigDecimal2, MAX_SCALE)) == 0;
    }

    public static int compareTo(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        BigDecimal bigDecimal3 = bigDecimal.subtract(bigDecimal2);
        if (BigDecimalHelper.isZero(bigDecimal3)) {
            return 0;
        }
        return bigDecimal.compareTo(bigDecimal2);
    }

    public static int hashCode(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return 0;
        }
        return BigDecimalHelper.round(bigDecimal, MAX_SCALE).hashCode();
    }

    public static boolean isNegative(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return false;
        }
        return bigDecimal.compareTo(NEGATIVE_DELTA) <= 0;
    }

    public static boolean isNegativeOrZero(BigDecimal bigDecimal) {
        return BigDecimalHelper.isNegative(bigDecimal) || BigDecimalHelper.isZero(bigDecimal);
    }

    public static boolean isPositive(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return false;
        }
        return bigDecimal.compareTo(POSITIVE_DELTA) >= 0;
    }

    public static boolean isPositiveOrZero(BigDecimal bigDecimal) {
        return BigDecimalHelper.isPositive(bigDecimal) || BigDecimalHelper.isZero(bigDecimal);
    }

    public static boolean isZero(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return false;
        }
        return bigDecimal.compareTo(NEGATIVE_DELTA) > 0 && bigDecimal.compareTo(POSITIVE_DELTA) < 0;
    }

    public static BigDecimal max(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return BigDecimalHelper.compareTo(bigDecimal, bigDecimal2) >= 0 ? bigDecimal : bigDecimal2;
    }

    public static BigDecimal min(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return BigDecimalHelper.compareTo(bigDecimal, bigDecimal2) <= 0 ? bigDecimal : bigDecimal2;
    }

    public static BigDecimal negative(BigDecimal bigDecimal) {
        if (bigDecimal == null || BigDecimalHelper.isNegativeOrZero(bigDecimal)) {
            return bigDecimal;
        }
        return bigDecimal.negate();
    }

    public static BigDecimal positive(BigDecimal bigDecimal) {
        if (bigDecimal == null || BigDecimalHelper.isPositiveOrZero(bigDecimal)) {
            return bigDecimal;
        }
        return bigDecimal.negate();
    }

    public static BigDecimal round(BigDecimal bigDecimal, int n) {
        if (bigDecimal == null || bigDecimal.scale() == n) {
            return bigDecimal;
        }
        return bigDecimal.setScale(n, RoundingMode.HALF_UP);
    }

    public static BigDecimal toBigDecimal(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        int n = string2.length();
        return new BigDecimal(new BigInteger(string + string2), n);
    }

    public static BigDecimal zeroWhenNull(BigDecimal bigDecimal) {
        return bigDecimal == null ? BigDecimal.ZERO : bigDecimal;
    }
}

